/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.pfscext.api.aisino.BusiInvoiceIssueService;
import com.tydic.pfscext.api.aisino.bo.BusiInvoiceIssueReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiInvoiceIssueRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceMethod;
import com.tydic.pfscext.enums.PushStatus;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class PushTaxCenterElcConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(PushTaxCenterElcConsumer.class);
    @Autowired
    private BusiInvoiceIssueService busiInvoiceIssueService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        String content = message.getContent();
        log.info("\u7535\u7968\u63a8\u7a0e\u63a7\u63a5\u53d7\u6d88\u606f\u53c2\u6570:" + content);
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        List applyNoList = (List)jsonObject.get((Object)"applyNoList");
        if (!CollectionUtils.isEmpty((Collection)applyNoList)) {
            BusiInvoiceIssueReqBO reqBO = new BusiInvoiceIssueReqBO();
            for (String applyNo : applyNoList) {
                BillApplyInfo billApply = new BillApplyInfo();
                billApply.setApplyNo(applyNo);
                try {
                    reqBO.setApplyNo(applyNo);
                    BusiInvoiceIssueRspBO busiInvoiceIssueRspBO = this.busiInvoiceIssueService.invoiceIssue(reqBO);
                    log.info("[" + applyNo + "]\u5f00\u7968\u7533\u8bf7\u5355\u8c03\u7528\u63a8\u9001\u7a0e\u63a7\u63a5\u53e3\u8fd4\u56de\u503c" + JSON.toJSONString((Object)busiInvoiceIssueRspBO));
                    if (busiInvoiceIssueRspBO != null && "0000".equals(busiInvoiceIssueRspBO.getRespCode())) {
                        if (0 == busiInvoiceIssueRspBO.getSuccessCounts()) {
                            billApply.setPushStatus(PushStatus.PUSH_FAIL.getCode());
                        } else if (busiInvoiceIssueRspBO.getSuccessCounts() < busiInvoiceIssueRspBO.getTotalCounts()) {
                            billApply.setPushStatus(PushStatus.PARTIAL_PUSH.getCode());
                        } else if (busiInvoiceIssueRspBO.getSuccessCounts().equals(busiInvoiceIssueRspBO.getTotalCounts())) {
                            billApply.setPushStatus(PushStatus.PUSH_SUCCESS.getCode());
                            billApply.setBillStatus(BillStatus.SENDING_BILL.getCode());
                        }
                    }
                    billApply.setInvoiceMethod(InvoiceMethod.TAX.getCode());
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                }
                catch (Exception e) {
                    log.error("[" + applyNo + "]\u670d\u52a1\u5f02\u5e38" + e.getMessage());
                    billApply.setPushStatus(PushStatus.PUSH_FAIL.getCode());
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                }
            }
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

