/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import com.tydic.order.pec.ability.pay.UocPebUpdateBillStatusAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.aisino.BusiBillDownloadService;
import com.tydic.pfscext.api.aisino.bo.BusiBillDownloadReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiBillDownloadRspBO;
import com.tydic.pfscext.api.busi.BusiCreateOutstockInfoService;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillChildApplyInfoMapper;
import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.SaleBillInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyChildInfo;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.OutstockInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.OutstockInfoVO;
import com.tydic.pfscext.dao.vo.PayOrderInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.aisino.api.BillDownloadExternalService;
import com.tydic.pfscext.external.aisino.api.BillItemInfoDownloadExtService;
import com.tydic.pfscext.external.aisino.api.bo.BillDownloadExtReqBO;
import com.tydic.pfscext.external.aisino.api.bo.BillItemBO;
import com.tydic.pfscext.external.aisino.api.bo.BillItemInfoExtReqBO;
import com.tydic.pfscext.external.aisino.api.bo.BillItemInfoExtRspBO;
import com.tydic.pfscext.external.aisino.api.bo.FpkjxxFptxxNewBO;
import com.tydic.pfscext.external.aisino.api.bo.GlobalInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.BusiBillDownloadService"})
public class BusiBillDownloadServiceImpl
implements BusiBillDownloadService {
    private static final Logger log = LoggerFactory.getLogger(BusiBillDownloadServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private BillDownloadExternalService billDownloadExternalService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleBillInfoMapper saleBillInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillItemInfoDownloadExtService billItemInfoDownloadExtService;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Value(value="${authorizationCode}")
    private String authorizationCode;
    @Value(value="${taxCode}")
    private String taxCode;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillChildApplyInfoMapper billChildApplyInfoMapper;
    private boolean isBusy = false;
    @Autowired
    private UocPebUpdateBillStatusAbilityService uocPebUpdateBillStatusAbilityService;
    @Autowired
    private BusiCreateOutstockInfoService busiCreateOutstockInfoService;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;

    @PostMapping(value={"billDownloadExternal"})
    public BusiBillDownloadRspBO billDownloadExternal(@RequestBody BusiBillDownloadReqBO reqBO) {
        this.isBusy = true;
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString());
        }
        try {
            if (StringUtils.isEmpty((Object)reqBO.getApplyNo())) {
                BusiBillDownloadRspBO busiBillDownloadRspBO = this.process();
                return busiBillDownloadRspBO;
            }
            this.updateData(reqBO.getApplyNo());
            BusiBillDownloadRspBO busiBillDownloadRspBO = this.getInvoicesAgain(reqBO.getApplyNo());
            return busiBillDownloadRspBO;
        }
        finally {
            this.isBusy = false;
        }
    }

    private BusiBillDownloadRspBO process() {
        BusiBillDownloadRspBO rspBO = null;
        try {
            rspBO = new BusiBillDownloadRspBO();
            BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
            HashSet<String> BillStatusSet = new HashSet<String>();
            BillStatusSet.add("02");
            BillStatusSet.add("88");
            billApplyInfoVO.setBillStatusSet(BillStatusSet);
            billApplyInfoVO.setSource("1");
            billApplyInfoVO.setInvoiceType("1");
            List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getNeedApplyList(billApplyInfoVO);
            if (billApplyInfoList.isEmpty()) {
                log.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a02(\u5f00\u7968\u4e2d)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
                return rspBO;
            }
            if (billApplyInfoList != null && billApplyInfoList.size() > 0) {
                for (BillApplyInfo billApplyInfo : billApplyInfoList) {
                    this.dealInvoiceInfo(billApplyInfo);
                }
            }
        }
        catch (PfscExtBusinessException e) {
            log.error("\u65b0\u589e\u53d1\u7968\u548c\u53d1\u7968\u660e\u7ec6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u65b0\u589e\u53d1\u7968\u548c\u53d1\u7968\u660e\u7ec6\u5931\u8d25", e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void updateUocBillStatus(String applyNo, OrderStatus orderStatus) {
        List<SaleOrderInfo> orderInfos = this.saleOrderInfoMapper.getModelByApplyNo(applyNo);
        if (!CollectionUtils.isEmpty(orderInfos)) {
            for (SaleOrderInfo orderInfo : orderInfos) {
                UocPebUpdateBillStatusReqBO updateBillStatusReqBO = new UocPebUpdateBillStatusReqBO();
                updateBillStatusReqBO.setOrderId(orderInfo.getOrderId());
                updateBillStatusReqBO.setBillState(Integer.valueOf(orderStatus.getCode()));
                this.uocPebUpdateBillStatusAbilityService.updateBillStatus(updateBillStatusReqBO);
            }
        }
    }

    @PostMapping(value={"isBusy"})
    public boolean isBusy() {
        return this.isBusy;
    }

    private BusiBillDownloadRspBO getInvoicesAgain(String applyNo) {
        log.error("\u7535\u7968\u91cd\u65b0\u83b7\u53d6\u53d1\u7968\u7533\u8bf7\u5355\uff1a" + applyNo);
        BusiBillDownloadRspBO rspBO = new BusiBillDownloadRspBO();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo != null) {
            this.dealInvoiceInfo(billApplyInfo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealInvoiceInfo(BillApplyInfo billApplyInfo) {
        BillDownloadExtReqBO reqBO = new BillDownloadExtReqBO();
        GlobalInfoBO globalInfo = new GlobalInfoBO();
        globalInfo.setTerminalCode("0");
        if (billApplyInfo != null && "2".equals(billApplyInfo.getInvoiceType())) {
            globalInfo.setAppId("ZZS_PT_DZFP");
        } else {
            globalInfo.setAppId("DZFP");
        }
        BillApplyChildInfo childInfo = new BillApplyChildInfo();
        childInfo.setApplyNo(billApplyInfo.getApplyNo());
        childInfo.setStatus(0);
        int successCount = 0;
        List<BillApplyChildInfo> billApplyChildInfos = this.billChildApplyInfoMapper.selectChildList(childInfo);
        globalInfo.setTaxpayerId(this.taxCode);
        globalInfo.setAuthorizationCode(this.authorizationCode);
        if (billApplyChildInfos.size() > 0) {
            BillApplyInfo billApply;
            for (BillApplyChildInfo billApplyChildInfo : billApplyChildInfos) {
                BillApplyChildInfo billApplyChildInfo1;
                FpkjxxFptxxNewBO fpkjxxFptxxNew = new FpkjxxFptxxNewBO();
                fpkjxxFptxxNew.setDDH(billApplyChildInfo.getChildApplyNo());
                fpkjxxFptxxNew.setFPQQLSH(billApplyChildInfo.getChildApplyNo());
                fpkjxxFptxxNew.setNSRSBH(this.taxCode);
                fpkjxxFptxxNew.setPDF_XZFS("3");
                BillItemInfoExtReqBO billItemInfoExtReqBO = new BillItemInfoExtReqBO();
                billItemInfoExtReqBO.setFpkjxxFptxxNew(fpkjxxFptxxNew);
                billItemInfoExtReqBO.setGlobalInfo(globalInfo);
                BillItemInfoExtRspBO billItemInfoExtRspBO = this.billItemInfoDownloadExtService.billItemInfoExt(billItemInfoExtReqBO);
                if (billItemInfoExtRspBO != null && "0000".equals(billItemInfoExtRspBO.getRespCode())) {
                    billApplyChildInfo1 = new BillApplyChildInfo();
                    if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ() != null) {
                        SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
                        billApplyChildInfo1.setInvoiceCode(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_DM());
                        billApplyChildInfo1.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                        billApplyChildInfo1.setInvoiceDate(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPRQ());
                        saleInvoiceInfo.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                        saleInvoiceInfo.setInvoiceCode(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_DM());
                        saleInvoiceInfo.setInvoiceDate(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPRQ());
                        saleInvoiceInfo.setApplyNo(billApplyInfo.getApplyNo());
                        saleInvoiceInfo.setUntaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getHJBHSJE()));
                        saleInvoiceInfo.setTaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPHJSE()));
                        saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
                        saleInvoiceInfo.setInvoiceStatus("1");
                        saleInvoiceInfo.setElectronicInvoiceUrl(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getPDF_URL());
                        saleInvoiceInfo.setElectronicInvoiceName(billApplyChildInfo.getChildApplyNo() + "\u7535\u5b50\u53d1\u7968");
                        saleInvoiceInfo.setName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHFMC());
                        saleInvoiceInfo.setTaxNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_NSRSBH());
                        saleInvoiceInfo.setInvoiceType(InvoiceType.NORMAL.getCode());
                        saleInvoiceInfo.setAddress(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH());
                        if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH() != null && billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH().contains(" ")) {
                            saleInvoiceInfo.setAddress(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH().split(" ")[0]);
                        }
                        saleInvoiceInfo.setPhone(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_SJ());
                        saleInvoiceInfo.setBankAcNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH());
                        saleInvoiceInfo.setBankName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH());
                        if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH() != null && billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH().contains(" ")) {
                            saleInvoiceInfo.setBankAcNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH().split(" ")[1]);
                            saleInvoiceInfo.setBankName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH().split(" ")[0]);
                        }
                        if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKCE() != null) {
                            saleInvoiceInfo.setTaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPHJSE()));
                        }
                        this.saleInvoiceInfoMapper.deleteByPrimaryKey(saleInvoiceInfo.getInvoiceNo());
                        this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
                    }
                    List<SaleItemInfo> saleItemInfos = this.saleItemInfoMapper.selectByApplyNoAndOrderIdAndChild(null, null, null, billApplyChildInfo.getChildApplyNo());
                    HashMap<Long, String> map = new HashMap<Long, String>();
                    for (SaleItemInfo saleItemInfo : saleItemInfos) {
                        map.put(saleItemInfo.getSeq(), saleItemInfo.getSkuName());
                    }
                    if (billItemInfoExtRspBO != null && billItemInfoExtRspBO.getFPMXXZ_XMXXS() != null && billItemInfoExtRspBO.getFPMXXZ_XMXXS().size() > 0) {
                        for (BillItemBO fpmxxzXmxx : billItemInfoExtRspBO.getFPMXXZ_XMXXS()) {
                            SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
                            if (map.get(fpmxxzXmxx.getZXBM()) != null) {
                                saleInvoiceDetail.setItemName((String)map.get(fpmxxzXmxx.getZXBM()));
                            } else {
                                saleInvoiceDetail.setItemName(fpmxxzXmxx.getXMMC());
                            }
                            saleInvoiceDetail.setSpecModel(fpmxxzXmxx.getGGXH());
                            saleInvoiceDetail.setUnitName(fpmxxzXmxx.getXMDW());
                            if (fpmxxzXmxx.getZXBM() != null) {
                                saleInvoiceDetail.setItemSeq(Long.parseLong(fpmxxzXmxx.getZXBM()));
                            }
                            saleInvoiceDetail.setQuantity(new BigDecimal(fpmxxzXmxx.getXMSL()));
                            saleInvoiceDetail.setUntaxAmt(new BigDecimal(fpmxxzXmxx.getXMJE()));
                            saleInvoiceDetail.setTaxAmt(new BigDecimal(fpmxxzXmxx.getSE()));
                            saleInvoiceDetail.setAmount(saleInvoiceDetail.getUntaxAmt().add(saleInvoiceDetail.getTaxAmt()));
                            saleInvoiceDetail.setTaxRate(new BigDecimal(fpmxxzXmxx.getSL()));
                            saleInvoiceDetail.setTaxClassCode(fpmxxzXmxx.getSWBM());
                            saleInvoiceDetail.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                            saleInvoiceDetail.setSaleUnitPrice(new BigDecimal(fpmxxzXmxx.getXMDJ()));
                            this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
                        }
                    }
                    billApplyChildInfo1.setChildApplyNo(billApplyChildInfo.getChildApplyNo());
                    billApplyChildInfo1.setStatus(1);
                    this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo1);
                    ++successCount;
                    continue;
                }
                billApplyChildInfo1 = new BillApplyChildInfo();
                billApplyChildInfo1.setChildApplyNo(billApplyChildInfo.getChildApplyNo());
                billApplyChildInfo1.setStatus(0);
                billApplyChildInfo1.setSkMsg(billItemInfoExtRspBO.getRespDesc() == null ? " " : billItemInfoExtRspBO.getRespDesc());
                this.billChildApplyInfoMapper.updateByPrimaryKey(billApplyChildInfo1);
            }
            if (successCount == billApplyChildInfos.size()) {
                billApply = new BillApplyInfo();
                billApply.setApplyNo(billApplyInfo.getApplyNo());
                billApply.setBillStatus("03");
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                PayOrderInfoVO payOrderInfoVO = new PayOrderInfoVO();
                payOrderInfoVO.setPayOrderStatus("6");
                ArrayList<String> applyNoList = new ArrayList<String>();
                applyNoList.add(billApplyInfo.getApplyNo());
                payOrderInfoVO.setApplyNoList(applyNoList);
                this.payOrderInfoMapper.updateForBillApply(payOrderInfoVO);
                this.saleOrderInfoMapper.updateStatusByApplyNo(billApplyInfo.getApplyNo(), "02");
                BusiCreateOutstockInfoRspBO busiCreateOutstockInfoRspBO = null;
                try {
                    OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
                    outstockInfoVO.setApplyNo(billApplyInfo.getApplyNo());
                    OutstockInfo outstockInfo = this.outstockInfoMapper.selectSelective(outstockInfoVO);
                    if (outstockInfo == null) {
                        log.debug("\u51c6\u5907\u4ea7\u751f\u51fa\u5e93\u5355\u53f7,\u901a\u77e5\u5355\u53f7=" + billApplyInfo.getApplyNo());
                        BusiCreateOutstockInfoReqBO busiCreateOutstockInfoReqBO = new BusiCreateOutstockInfoReqBO();
                        busiCreateOutstockInfoReqBO.setApplyNo(billApplyInfo.getApplyNo());
                        busiCreateOutstockInfoReqBO.setWriteoffAmt(BigDecimal.ZERO);
                        busiCreateOutstockInfoReqBO.setUserId(billApplyInfo.getUserId());
                        busiCreateOutstockInfoRspBO = this.busiCreateOutstockInfoService.addOutstockInfo(busiCreateOutstockInfoReqBO);
                    }
                }
                catch (Exception e) {
                    log.error("\u4ea7\u751f\u51fa\u5e93\u5355\u5f02\u5e38\uff1a" + billApplyInfo.getApplyNo(), (Throwable)e);
                    throw new PfscExtBusinessException(busiCreateOutstockInfoRspBO.getRespCode(), busiCreateOutstockInfoRspBO.getRespDesc());
                }
                this.updateUocBillStatus(billApplyInfo.getApplyNo(), OrderStatus.SEND_BILL);
            } else if (successCount > 0) {
                billApply = new BillApplyInfo();
                billApply.setApplyNo(billApplyInfo.getApplyNo());
                billApply.setBillStatus("88");
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
            }
        } else {
            FpkjxxFptxxNewBO fpkjxxFptxxNew = new FpkjxxFptxxNewBO();
            fpkjxxFptxxNew.setDDH(billApplyInfo.getApplyNo());
            fpkjxxFptxxNew.setFPQQLSH(billApplyInfo.getApplyNo());
            fpkjxxFptxxNew.setNSRSBH(this.taxCode);
            fpkjxxFptxxNew.setPDF_XZFS("3");
            BillItemInfoExtReqBO billItemInfoExtReqBO = new BillItemInfoExtReqBO();
            billItemInfoExtReqBO.setFpkjxxFptxxNew(fpkjxxFptxxNew);
            billItemInfoExtReqBO.setGlobalInfo(globalInfo);
            BillItemInfoExtRspBO billItemInfoExtRspBO = this.billItemInfoDownloadExtService.billItemInfoExt(billItemInfoExtReqBO);
            log.error("\u65b0\u589e\u53d1\u7968\u548c\u53d1\u7968\u660e\u7ec6\u5931\u8d25" + billItemInfoExtRspBO);
            if (billItemInfoExtRspBO != null && "0000".equals(billItemInfoExtRspBO.getRespCode())) {
                if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ() != null) {
                    SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
                    saleInvoiceInfo.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                    saleInvoiceInfo.setInvoiceCode(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_DM());
                    saleInvoiceInfo.setInvoiceDate(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPRQ());
                    saleInvoiceInfo.setApplyNo(billApplyInfo.getApplyNo());
                    saleInvoiceInfo.setUntaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getHJBHSJE()));
                    saleInvoiceInfo.setTaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPHJSE()));
                    saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
                    saleInvoiceInfo.setInvoiceStatus("1");
                    saleInvoiceInfo.setElectronicInvoiceUrl(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getPDF_URL());
                    saleInvoiceInfo.setElectronicInvoiceName(billApplyInfo.getApplyNo() + "\u7535\u5b50\u53d1\u7968");
                    saleInvoiceInfo.setName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHFMC());
                    saleInvoiceInfo.setTaxNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_NSRSBH());
                    saleInvoiceInfo.setAddress(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH());
                    if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH() != null && billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH().contains(" ")) {
                        saleInvoiceInfo.setAddress(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_DZDH().split(" ")[0]);
                    }
                    saleInvoiceInfo.setPhone(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_SJ());
                    saleInvoiceInfo.setBankAcNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH());
                    saleInvoiceInfo.setBankName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH());
                    if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH() != null && billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH().contains(" ")) {
                        saleInvoiceInfo.setBankAcNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH().split(" ")[1]);
                        saleInvoiceInfo.setBankName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH().split(" ")[0]);
                    }
                    if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKCE() != null) {
                        saleInvoiceInfo.setTaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPHJSE()));
                    }
                    this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
                }
                List<SaleItemInfo> saleItemInfos = this.saleItemInfoMapper.selectByApplyNoAndOrderId(billApplyInfo.getApplyNo(), null, null);
                HashMap<Long, String> map = new HashMap<Long, String>();
                for (SaleItemInfo saleItemInfo : saleItemInfos) {
                    map.put(saleItemInfo.getSeq(), saleItemInfo.getSkuName());
                }
                if (billItemInfoExtRspBO != null && billItemInfoExtRspBO.getFPMXXZ_XMXXS() != null && billItemInfoExtRspBO.getFPMXXZ_XMXXS().size() > 0) {
                    for (BillItemBO fpmxxzXmxx : billItemInfoExtRspBO.getFPMXXZ_XMXXS()) {
                        SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
                        if (map.get(fpmxxzXmxx.getZXBM()) != null) {
                            saleInvoiceDetail.setItemName((String)map.get(fpmxxzXmxx.getZXBM()));
                        } else {
                            saleInvoiceDetail.setItemName(fpmxxzXmxx.getXMMC());
                        }
                        saleInvoiceDetail.setSpecModel(fpmxxzXmxx.getGGXH());
                        saleInvoiceDetail.setUnitName("\u4e2a");
                        if (fpmxxzXmxx.getZXBM() != null) {
                            saleInvoiceDetail.setItemSeq(Long.parseLong(fpmxxzXmxx.getZXBM()));
                        }
                        saleInvoiceDetail.setQuantity(new BigDecimal(fpmxxzXmxx.getXMSL()));
                        saleInvoiceDetail.setUntaxAmt(new BigDecimal(fpmxxzXmxx.getXMJE()));
                        saleInvoiceDetail.setTaxAmt(new BigDecimal(fpmxxzXmxx.getSE()));
                        saleInvoiceDetail.setAmount(saleInvoiceDetail.getUntaxAmt().add(saleInvoiceDetail.getTaxAmt()));
                        saleInvoiceDetail.setTaxRate(new BigDecimal(fpmxxzXmxx.getSL()));
                        saleInvoiceDetail.setTaxClassCode(fpmxxzXmxx.getSWBM());
                        saleInvoiceDetail.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                        saleInvoiceDetail.setSaleUnitPrice(new BigDecimal(fpmxxzXmxx.getXMDJ()));
                        this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
                    }
                }
                BillApplyInfo billApply = new BillApplyInfo();
                billApply.setApplyNo(billApplyInfo.getApplyNo());
                billApply.setBillStatus("03");
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                PayOrderInfoVO payOrderInfoVO = new PayOrderInfoVO();
                payOrderInfoVO.setPayOrderStatus("6");
                ArrayList<String> applyNoList = new ArrayList<String>();
                applyNoList.add(billApplyInfo.getApplyNo());
                payOrderInfoVO.setApplyNoList(applyNoList);
                this.payOrderInfoMapper.updateForBillApply(payOrderInfoVO);
                this.saleOrderInfoMapper.updateStatusByApplyNo(billApplyInfo.getApplyNo(), "02");
                BusiCreateOutstockInfoRspBO busiCreateOutstockInfoRspBO = null;
                try {
                    log.debug("\u51c6\u5907\u4ea7\u751f\u51fa\u5e93\u5355\u53f7,\u901a\u77e5\u5355\u53f7=" + billApplyInfo.getApplyNo());
                    BusiCreateOutstockInfoReqBO busiCreateOutstockInfoReqBO = new BusiCreateOutstockInfoReqBO();
                    busiCreateOutstockInfoReqBO.setApplyNo(billApplyInfo.getApplyNo());
                    busiCreateOutstockInfoReqBO.setWriteoffAmt(BigDecimal.ZERO);
                    busiCreateOutstockInfoReqBO.setUserId(billApplyInfo.getUserId());
                    busiCreateOutstockInfoRspBO = this.busiCreateOutstockInfoService.addOutstockInfo(busiCreateOutstockInfoReqBO);
                }
                catch (Exception e) {
                    log.error("\u4ea7\u751f\u51fa\u5e93\u5355\u5f02\u5e38\uff1a" + billApplyInfo.getApplyNo(), (Throwable)e);
                    throw new PfscExtBusinessException(busiCreateOutstockInfoRspBO.getRespCode(), busiCreateOutstockInfoRspBO.getRespDesc());
                }
                this.updateUocBillStatus(billApplyInfo.getApplyNo(), OrderStatus.SEND_BILL);
            } else {
                log.error("\u7533\u8bf7\u5355\u53f7[" + billApplyInfo.getApplyNo() + "]\u4e0b\u8f7d\u53d1\u7968\u5931\u8d25");
            }
        }
    }

    private void updateData(String applyNo) {
        List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectByApplyNoOrderBy(applyNo);
        if (!CollectionUtils.isEmpty(saleInvoiceInfoList)) {
            ArrayList<String> invoiceNos = new ArrayList<String>();
            for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
                invoiceNos.add(saleInvoiceInfo.getInvoiceNo());
            }
            this.saleInvoiceInfoMapper.deleteByApplyNo(applyNo);
            this.saleInvoiceDetailMapper.deleteByInvoiceNos(invoiceNos);
            this.billChildApplyInfoMapper.updateByApplyNo(applyNo);
        }
        BillApplyInfo billApply = new BillApplyInfo();
        billApply.setApplyNo(applyNo);
        billApply.setBillStatus(BillStatus.SENDING_BILL.getCode());
        int update = this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
        if (update < 1) {
            throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u5f02\u5e38");
        }
    }
}

