/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import com.tydic.pfscext.api.aisino.BusiBillManualObtainService;
import com.tydic.pfscext.api.aisino.bo.BusiBillManualObtainReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiBillManualObtainRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoApplyRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailBillApplyInfoItemRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillChildApplyInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyChildInfo;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BusiBillManualObtainServiceImpl
implements BusiBillManualObtainService {
    private static final Logger log = LoggerFactory.getLogger(BusiBillManualObtainServiceImpl.class);
    @Value(value="${authorizationCode}")
    private String authorizationCode;
    @Value(value="${taxCode}")
    private String taxCode;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillChildApplyInfoMapper billChildApplyInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;

    public BusiBillManualObtainRspBO manualObtainBill(BusiBillManualObtainReqBO reqBO) {
        BusiBillManualObtainRspBO busiBillManualObtainRspBO = new BusiBillManualObtainRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("0001", "\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(reqBO.getApplyNo());
        ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO> busiQueryDetailBillApplyInfoApplyRspBOS = new ArrayList<BusiQueryDetailBillApplyInfoApplyRspBO>();
        BillApplyChildInfo billApplyChildInfo = new BillApplyChildInfo();
        billApplyChildInfo.setApplyNo(billApplyInfo.getApplyNo());
        billApplyChildInfo.setStatus(0);
        List<BillApplyChildInfo> failureChildInfos = this.billChildApplyInfoMapper.selectChildList(billApplyChildInfo);
        for (BillApplyChildInfo info : failureChildInfos) {
            List<SaleItemInfo> saleItemInfos = this.saleItemInfoMapper.selectByApplyNoAndOrderIdAndChild(info.getApplyNo(), null, null, info.getChildApplyNo());
            List<BusiQueryDetailBillApplyInfoItemRspBO> itemList = this.getDetailBillApplyInfoItems(billApplyInfo, saleItemInfos);
            BusiQueryDetailBillApplyInfoApplyRspBO infoApplyRspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)infoApplyRspBO);
            infoApplyRspBO.setItemList(itemList);
            infoApplyRspBO.setApplyNo(info.getChildApplyNo());
            busiQueryDetailBillApplyInfoApplyRspBOS.add(infoApplyRspBO);
        }
        busiBillManualObtainRspBO.setBillApplyInfoApplyRspBOS(busiQueryDetailBillApplyInfoApplyRspBOS);
        busiBillManualObtainRspBO.setRespCode("0000");
        busiBillManualObtainRspBO.setRespDesc("\u6210\u529f");
        return busiBillManualObtainRspBO;
    }

    private List<BusiQueryDetailBillApplyInfoItemRspBO> getDetailBillApplyInfoItems(BillApplyInfo billApplyInfo, List<SaleItemInfo> saleItemInfoList) {
        ArrayList<Long> skuIds = new ArrayList<Long>();
        for (SaleItemInfo saleItemInfo : saleItemInfoList) {
            skuIds.add(saleItemInfo.getSkuId());
        }
        HashMap<Long, String> skuIdNameMap = new HashMap<Long, String>();
        List<PayInvoiceDetail> payInvoiceDetails = this.payInvoiceDetailMapper.getItemNameBySkuId(skuIds);
        for (PayInvoiceDetail payInvoiceDetail : payInvoiceDetails) {
            skuIdNameMap.put(payInvoiceDetail.getSkuId(), payInvoiceDetail.getItemName());
        }
        ArrayList<BusiQueryDetailBillApplyInfoItemRspBO> itemList = new ArrayList<BusiQueryDetailBillApplyInfoItemRspBO>();
        for (SaleItemInfo saleItemInfo : saleItemInfoList) {
            BusiQueryDetailBillApplyInfoItemRspBO item = new BusiQueryDetailBillApplyInfoItemRspBO();
            BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
            if (skuIdNameMap.get(saleItemInfo.getSkuId()) != null) {
                item.setSkuName((String)skuIdNameMap.get(saleItemInfo.getSkuId()));
            }
            if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                item.setAmountApply(saleItemInfo.getAmountApplied());
                item.setQuantityApply(saleItemInfo.getQuantityApplied());
            } else {
                item.setAmountApply(saleItemInfo.getAmount());
                item.setQuantityApply(saleItemInfo.getQuantity());
            }
            itemList.add(item);
        }
        return itemList;
    }
}

