/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.aisino.BusiPushTaxControlCenterService;
import com.tydic.pfscext.api.aisino.bo.BusiPushTaxControlCenterReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiPushTaxControlCenterRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.PushStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.BusiPushTaxControlCenterService"})
public class BusiPushTaxControlCenterServiceImpl
implements BusiPushTaxControlCenterService {
    private static final Logger log = LoggerFactory.getLogger(BusiPushTaxControlCenterServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Resource(name="fscPushTaxElcMsgProvider")
    private ProxyMessageProducer elcMessageProducer;
    @Resource(name="fscPushTaxPapMsgProvider")
    private ProxyMessageProducer papMessageProducer;
    private final String SEND_SUCCESS = "SEND_OK";
    @Value(value="${FSC_PUSH_TAX_TOPIC:FSC_ELC_TAX_TOPIC}")
    private String pushTaxCenterElcTopic;
    @Value(value="${FSC_PUSH_TAX_TOPIC:FSC_PAP_TAX_TOPIC}")
    private String pushTaxCenterPapTopic;
    @Value(value="${FSC_PUSH_TAX_ELC_TAG:*}")
    private String tag;

    @PostMapping(value={"busiPushTaxControlCenter"})
    public BusiPushTaxControlCenterRspBO busiPushTaxControlCenter(@RequestBody BusiPushTaxControlCenterReqBO reqBO) {
        BusiPushTaxControlCenterRspBO rspBO = new BusiPushTaxControlCenterRspBO();
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(reqBO.getApplyNoList());
        List<BillApplyInfo> applyInfos = this.billApplyInfoMapper.getList(billApplyInfoVO);
        ArrayList<String> updateList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(applyInfos)) {
            ArrayList<String> elcApplyInfos = new ArrayList<String>();
            ArrayList<String> papApplyInfos = new ArrayList<String>();
            for (BillApplyInfo applyInfo : applyInfos) {
                if (InvoiceType.NORMAL.getCode().toString().equals(applyInfo.getInvoiceType())) {
                    elcApplyInfos.add(applyInfo.getApplyNo());
                }
                if (!InvoiceType.SPECIAL.getCode().toString().equals(applyInfo.getInvoiceType())) continue;
                papApplyInfos.add(applyInfo.getApplyNo());
            }
            try {
                ProxySendResult sendResult;
                ProxyMessage message;
                String jsonString;
                HashMap<String, ArrayList<String>> map;
                if (!CollectionUtils.isEmpty(elcApplyInfos)) {
                    map = new HashMap<String, ArrayList<String>>();
                    map.put("applyNoList", elcApplyInfos);
                    jsonString = JSON.toJSONString(map);
                    message = new ProxyMessage(this.pushTaxCenterElcTopic, this.tag, jsonString);
                    sendResult = this.elcMessageProducer.send(message);
                    if ("SEND_OK".equals(sendResult.getStatus())) {
                        updateList.addAll(elcApplyInfos);
                        rspBO.setRespDesc("\u7535\u5b50\u53d1\u7968" + ((Object)elcApplyInfos).toString() + "\u63a8\u9001\u7a0e\u63a7\u4e2d");
                        rspBO.setRespCode("0000");
                    } else {
                        rspBO.setRespDesc("18000");
                        rspBO.setRespDesc("\u7535\u5b50\u53d1\u7968" + ((Object)elcApplyInfos).toString() + "\u63a8\u9001\u7a0e\u63a7\u5931\u8d25");
                    }
                }
                if (!CollectionUtils.isEmpty(papApplyInfos)) {
                    map = new HashMap();
                    map.put("applyNoList", papApplyInfos);
                    jsonString = JSON.toJSONString(map);
                    message = new ProxyMessage(this.pushTaxCenterPapTopic, this.tag, jsonString);
                    sendResult = this.papMessageProducer.send(message);
                    if ("SEND_OK".equals(sendResult.getStatus())) {
                        updateList.addAll(papApplyInfos);
                        rspBO.setRespCode("0000");
                        if (StringUtils.isEmpty((Object)rspBO.getRespDesc())) {
                            rspBO.setRespDesc("\u7eb8\u8d28\u53d1\u7968" + ((Object)papApplyInfos).toString() + "\u63a8\u9001\u7a0e\u63a7\u4e2d");
                        } else {
                            rspBO.setRespDesc(rspBO.getRespDesc() + "\uff1b\u7eb8\u8d28\u53d1\u7968" + ((Object)papApplyInfos).toString() + "\u63a8\u9001\u7a0e\u63a7\u4e2d");
                        }
                    } else if (StringUtils.isEmpty((Object)rspBO.getRespDesc())) {
                        rspBO.setRespDesc("\u7eb8\u8d28\u53d1\u7968" + ((Object)papApplyInfos).toString() + "\u63a8\u9001\u7a0e\u63a7\u5931\u8d25");
                    } else {
                        rspBO.setRespDesc(rspBO.getRespDesc() + "\uff1b\u7eb8\u8d28\u53d1\u7968" + ((Object)papApplyInfos).toString() + "\u63a8\u9001\u7a0e\u63a7\u5931\u8d25");
                    }
                }
                if (!CollectionUtils.isEmpty(updateList)) {
                    BillApplyInfoVO applyInfoVO = new BillApplyInfoVO();
                    applyInfoVO.setApplyNoList(updateList);
                    applyInfoVO.setPushStatus(PushStatus.PUSHING.getCode());
                    this.billApplyInfoMapper.updatePushStatus(applyInfoVO);
                }
            }
            catch (Exception e) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc(e.getMessage());
            }
        }
        return rspBO;
    }
}

