/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="payBillSNService")
public class BillSNService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BillSNService.class);
    @Resource(name="invoiceNotificationSeq")
    private OrderSequence invoiceNotificationSeq;
    @Resource(name="payableSeq")
    private OrderSequence payableSeq;
    @Resource(name="recvableSeq")
    private OrderSequence recvableSeq;
    @Resource(name="payApplicationSeq")
    private OrderSequence payApplicationSeq;
    @Resource(name="purchaseStorageSeq")
    private OrderSequence purchaseStorageSeq;
    @Resource(name="materialSeq")
    private OrderSequence materialSeq;
    @Resource(name="invoiceApplication")
    private OrderSequence invoiceApplication;
    @Resource(name="stockOutSeq")
    private OrderSequence stockOutSeq;
    @Resource(name="orderIdSeq")
    private OrderSequence orderIdSeq;
    @Resource(name="publicSeqNoService")
    private OrderSequence publicSeqNoService;
    @Resource(name="publicSeqNoService2")
    private OrderSequence publicSeqNoService2;
    @Resource(name="returnRegisterSeq")
    private OrderSequence returnRegisterSeq;
    @Resource(name="refundApplicationSeq")
    private OrderSequence refundApplicationSeq;

    public String getSnAsString(BillType billType) {
        Long sn = this.getSn(billType);
        if (billType != null) {
            if (billType == BillType.SERVICE_REQ_LOG) {
                return String.valueOf(sn);
            }
            return billType.getCode() + sn;
        }
        return "";
    }

    public Long getSn(BillType billType) {
        if (billType == null) {
            throw new PfscExtBusinessException("0001", "\u5355\u636e\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        long seqNo = 0L;
        OrderSequence service = null;
        if (billType == BillType.SERVICE_REQ_LOG) {
            service = this.publicSeqNoService;
            try {
                service.nextId();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new PfscExtBusinessException("18000", e.getMessage());
            }
        }
        if (billType == BillType.INVOICE_NOTIFYCATION) {
            service = this.invoiceNotificationSeq;
        } else if (billType == BillType.PAYABLE_ACCOUNT) {
            service = this.payableSeq;
        } else if (billType == BillType.RECVABLE_ACCOUNT) {
            service = this.recvableSeq;
        } else if (billType == BillType.PAY_APPLICATION) {
            service = this.payApplicationSeq;
        } else if (billType == BillType.PURCHASE_STORAGE) {
            service = this.purchaseStorageSeq;
        } else if (billType == BillType.MATERIAL_COLLECT) {
            service = this.materialSeq;
        } else if (billType == BillType.INVOICE_APPLICATION) {
            service = this.invoiceApplication;
        } else if (billType == BillType.STOCK_OUT) {
            service = this.stockOutSeq;
        } else if (billType == BillType.ORDER_ID) {
            service = this.orderIdSeq;
        } else if (billType == BillType.INCOME_CALC) {
            service = this.publicSeqNoService2;
        } else if (billType == BillType.INVOICE_RETURN) {
            service = this.publicSeqNoService2;
        } else if (billType == BillType.INVOICE_RETURN_REGISTER) {
            service = this.returnRegisterSeq;
        } else if (billType == BillType.REFUND_APPLICATION) {
            service = this.refundApplicationSeq;
        }
        try {
            if (service != null) {
                seqNo = billType == BillType.INVOICE_RETURN_REGISTER ? this.dateToLong() * 1000L + service.nextId() : this.dateToLong() * 1000000L + service.nextId();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u5e8f\u5217\u53f7\u5f02\u5e38" + e.getMessage());
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u5e8f\u5217\u53f7\u5f02\u5e38");
        }
        return seqNo;
    }

    private long dateToLong() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String dt = fmt.format(new Date());
        return Long.valueOf(dt);
    }
}

