/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.SplitApplyService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SplitApplyServiceImpl
implements SplitApplyService {
    private static final Logger log = LoggerFactory.getLogger(SplitApplyServiceImpl.class);
    private final String DEFULT = "0";
    private final String SINGLE = "1";
    private final String ACTIVITY = "2";

    @Override
    public List<List<SaleOrderInfo>> splitApply(List<SaleOrderInfo> orderInfoList, String groupWay) {
        if (CollectionUtils.isEmpty(orderInfoList) || StringUtils.isEmpty((Object)groupWay)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("\u6b64\u6b21\u5f00\u7968\u7533\u8bf7\u5355\u62c6\u5355\u65b9\u5f0f\u4e3a=========" + groupWay);
        List<List<SaleOrderInfo>> splitOrderInfos = "0".equals(groupWay) ? this.defaultSplitWay(orderInfoList) : ("1".equals(groupWay) ? this.singleSplitWay(orderInfoList) : this.activitySplitWay(orderInfoList));
        return splitOrderInfos;
    }

    private List<List<SaleOrderInfo>> activitySplitWay(List<SaleOrderInfo> orderInfoList) {
        LinkedList<List<SaleOrderInfo>> splitOrderInfos = new LinkedList<List<SaleOrderInfo>>();
        HashMap orderListMap = new HashMap();
        for (SaleOrderInfo saleOrderInfo : orderInfoList) {
            StringBuffer keyBuffer = new StringBuffer();
            keyBuffer.append(saleOrderInfo.getActivityId());
            String key = keyBuffer.toString();
            if (orderListMap.containsKey(key)) {
                ((List)orderListMap.get(key)).add(saleOrderInfo);
                continue;
            }
            LinkedList<SaleOrderInfo> orderList = new LinkedList<SaleOrderInfo>();
            orderList.add(saleOrderInfo);
            orderListMap.put(key, orderList);
        }
        for (Map.Entry entry : orderListMap.entrySet()) {
            List orderInfos = (List)entry.getValue();
            splitOrderInfos.add(orderInfos);
        }
        return splitOrderInfos;
    }

    private List<List<SaleOrderInfo>> singleSplitWay(List<SaleOrderInfo> orderInfoList) {
        LinkedList<List<SaleOrderInfo>> splitOrderInfos = new LinkedList<List<SaleOrderInfo>>();
        for (SaleOrderInfo saleOrderInfo : orderInfoList) {
            ArrayList<SaleOrderInfo> singleList = new ArrayList<SaleOrderInfo>();
            singleList.add(saleOrderInfo);
            splitOrderInfos.add(singleList);
        }
        return splitOrderInfos;
    }

    private List<List<SaleOrderInfo>> defaultSplitWay(List<SaleOrderInfo> orderInfoList) {
        LinkedList<List<SaleOrderInfo>> splitOrderInfos = new LinkedList<List<SaleOrderInfo>>();
        HashMap orderListMap = new HashMap();
        for (SaleOrderInfo saleOrderInfo : orderInfoList) {
            StringBuffer keyBuffer = new StringBuffer();
            keyBuffer.append(saleOrderInfo.getPayType());
            String key = keyBuffer.toString();
            if (orderListMap.containsKey(key)) {
                ((List)orderListMap.get(key)).add(saleOrderInfo);
                continue;
            }
            LinkedList<SaleOrderInfo> orderList = new LinkedList<SaleOrderInfo>();
            orderList.add(saleOrderInfo);
            orderListMap.put(key, orderList);
        }
        for (Map.Entry entry : orderListMap.entrySet()) {
            List orderInfos = (List)entry.getValue();
            splitOrderInfos.add(orderInfos);
        }
        return splitOrderInfos;
    }
}

