/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiAddPayAbleService;
import com.tydic.pfscext.api.busi.FscCreatePayableNoService;
import com.tydic.pfscext.api.busi.bo.BusiAddPayAbleReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddPayAbleRspBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiAddPayAbleService"})
public class BusiAddPayAbleServiceImpl
implements BusiAddPayAbleService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddPayAbleServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private FscCreatePayableNoService fscCreatePayableNoService;

    @PostMapping(value={"createPayAble"})
    public BusiAddPayAbleRspBO createPayAble(@RequestBody BusiAddPayAbleReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u5e94\u4ed8\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getSource() == null || "".equals(reqBO.getSource())) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayType() || "".equals(reqBO.getPayType())) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayableType()) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayableAmt()) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaserId()) {
            throw new PfscExtBusinessException("0001", "\u4e0b\u5355\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getPaymentType())) {
            throw new PfscExtBusinessException("0001", "\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBusiModel()) {
            throw new PfscExtBusinessException("0001", "\u7ed3\u7b97\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiAddPayAbleRspBO rspBO = new BusiAddPayAbleRspBO();
        try {
            PayableDetailPO po = new PayableDetailPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            if (reqBO.getPayBusiType() != null && !"".equals(reqBO.getPayBusiType())) {
                if ("4".equals(reqBO.getPayBusiType())) {
                    po.setPayBusiType("7");
                } else if ("5".equals(reqBO.getPayBusiType())) {
                    po.setPayBusiType("8");
                }
            }
            String snNo = this.fscCreatePayableNoService.createPayableNoByType(po.getPayableType());
            po.setPayableNo(snNo);
            po.setPayType(PayablePayType.PAY.getCode());
            po.setPaidAmt(BigDecimal.ZERO);
            po.setPendingAmt(BigDecimal.ZERO);
            po.setNeedAgainstAmt(BigDecimal.ZERO);
            Integer days = 0;
            if (null != po.getPaymentDays()) {
                days = po.getPaymentDays();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, days);
            if (PayableType.EXPIRE.getCode().equals(po.getPayableType().toString())) {
                po.setPaidDate(calendar.getTime());
            }
            po.setSendGoodsNo(reqBO.getSendGoodsNo());
            po.setPaymentType(reqBO.getPaymentType());
            this.payableDetailMapper.insert(po);
            rspBO.setPayableNo(snNo);
        }
        catch (Exception e) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u65b0\u589e\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25:" + e.toString());
            logger.error("\u65b0\u589e\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25:", (Throwable)e);
            throw new PfscExtBusinessException("0001", "\u65b0\u589e\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        return rspBO;
    }
}

