/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.supplier.bo.QueryContractSupplierInfoReqBO;
import com.tydic.contract.api.supplier.bo.QueryContractSupplierInfoRspBO;
import com.tydic.contract.api.supplier.service.QueryContractSupplierService;
import com.tydic.order.extend.ability.order.PebExtFscPayResultAbilityService;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.pfscext.api.busi.BusiAddCreditLineService;
import com.tydic.pfscext.api.busi.BusiApplyPayService;
import com.tydic.pfscext.api.busi.bo.AddCreditLineFscReqBo;
import com.tydic.pfscext.api.busi.bo.ApplyPayBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceRspBO;
import com.tydic.pfscext.api.notify.SendPayResultService;
import com.tydic.pfscext.api.notify.bo.FscRemindReqBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.ApplyDetailVO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayFlowPayType;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.FscWfStartAtomService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.PayableService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.umc.ability.bo.UmcQryOrgNameBySupplierIdOrOrgIdServiceReqBO;
import com.tydic.umc.ability.bo.UmcQryOrgNameBySupplierIdOrOrgIdServiceRspBO;
import com.tydic.umc.ability.org.UmcQryOrgNameBySupplierIdOrOrgIdAbilityService;
import com.tydic.umcext.ability.bank.UmcPublicBankInfoAbilityService;
import com.tydic.umcext.ability.bank.bo.UmcPublicBankInfoQueryDetailAbilityReqBO;
import com.tydic.umcext.ability.bank.bo.UmcPublicBankInfoQueryDetailAbilityRspBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiApplyPayService"})
public class BusiApplyPayServiceImpl
implements BusiApplyPayService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyPayServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayableService payableService;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BusiAddCreditLineService busiAddCreditLineService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private QueryContractSupplierService queryContractSupplierService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private SendPayResultService sendPayResultService;
    @Autowired
    private UmcQryOrgNameBySupplierIdOrOrgIdAbilityService umcQryOrgNameService;
    @Autowired
    private PebExtFscPayResultAbilityService pebExtFscPayResultAbilityService;
    @Autowired
    private UserInfoService userInfoService;
    private static final Integer TRADE_MODEL = 0;
    private static final Integer INVOIC_PAYABLE_TYPE = 1;
    private static final Integer NOTIFICATION = 1;
    private static final String SUCCESS = "03";
    private static final String PAYMENT_SUCCESS = "SUCCESS";
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private UmcPublicBankInfoAbilityService umcPublicBankInfoBusiService;

    @PostMapping(value={"applyPay"})
    public BusiApplyPayServiceRspBO applyPay(final @RequestBody BusiApplyPayServiceReqBO reqBO) {
        BusiApplyPayServiceRspBO rspBO = new BusiApplyPayServiceRspBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getSupplierId() == null) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyPayBOList())) {
            throw new PfscExtBusinessException("18000", "\u6765\u6e90\u3001\u5f00\u7968\u7f16\u53f7\u3001\u4ed8\u6b3e\u91d1\u989d\u548c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u7ec4\u6210\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("7".equals(reqBO.getPayChannel()) && !StringUtils.hasText((String)reqBO.getPayVoucher())) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long payno = this.billSNService.getSn(BillType.PAY_APPLICATION);
        logger.info("\u6d41\u6c34\u53f7\uff1a" + payno);
        ArrayList<String> payableNoList = new ArrayList<String>();
        ArrayList<String> sourceList = new ArrayList<String>();
        List applyPayBOList = reqBO.getApplyPayBOList();
        for (Object applyPayBO : applyPayBOList) {
            if (!StringUtils.hasText((String)applyPayBO.getPayableNo())) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (applyPayBO.getPayAmt() == null) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (applyPayBO.getPayAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6");
            }
            if (!StringUtils.hasText((String)applyPayBO.getSource())) {
                throw new PfscExtBusinessException("18000", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            payableNoList.add(applyPayBO.getPayableNo());
            sourceList.add(applyPayBO.getSource());
        }
        String firstSource = (String)sourceList.get(0);
        for (String source : sourceList) {
            if (firstSource.compareTo(source) == 0) continue;
            throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u6765\u6e90\u4e0d\u80fd\u4e00\u8d77\u6c47\u603b");
        }
        PayableDetailVO payableDetailVO = new PayableDetailVO();
        payableDetailVO.setPayableNos(payableNoList);
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
        UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
        umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(reqBO.getSupplierId());
        UmcPublicBankInfoQueryDetailAbilityReqBO umcPublicBankInfoQueryDetailBusiReqBO = new UmcPublicBankInfoQueryDetailAbilityReqBO();
        umcPublicBankInfoQueryDetailBusiReqBO.setContactId(payableDetailPOs.get(0).getOperatorId());
        logger.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQrySupplierInfoDetailAbilityReqBO));
        UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
        if (!INVOIC_PAYABLE_TYPE.equals(payableDetailPOs.get(0).getPayableType()) && TRADE_MODEL.equals(payableDetailPOs.get(0).getBusiModel())) {
            UmcPublicBankInfoQueryDetailAbilityRspBO mcPublicBankInfoQueryDetailBusiRspBO = this.umcPublicBankInfoBusiService.queryBankInfoDetail(umcPublicBankInfoQueryDetailBusiReqBO);
            logger.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u51fa\u53c2\uff1a\u94f6\u884c\u8d26\u6237:" + mcPublicBankInfoQueryDetailBusiRspBO.getBankAccount());
            reqBO.setReceiptAcctNo(mcPublicBankInfoQueryDetailBusiRspBO.getBankAccount());
            reqBO.setRecAcctName(mcPublicBankInfoQueryDetailBusiRspBO.getBankAccountName());
            reqBO.setOpenBankName(mcPublicBankInfoQueryDetailBusiRspBO.getBankName());
            reqBO.setReceiptCompany(payableDetailPOs.get(0).getOperatorId());
        } else {
            logger.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u51fa\u53c2\uff1a\u94f6\u884c\u8d26\u6237:" + umcQrySupplierInfoDetailAbilityRspBO.getBankAccount());
            reqBO.setReceiptCompany(reqBO.getSupplierId());
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)umcQrySupplierInfoDetailAbilityRspBO.getBankAccount())) {
                reqBO.setReceiptAcctNo(umcQrySupplierInfoDetailAbilityRspBO.getBankAccount());
                reqBO.setRecAcctName(umcQrySupplierInfoDetailAbilityRspBO.getBankAccountName());
                reqBO.setOpenBankName(umcQrySupplierInfoDetailAbilityRspBO.getBankName());
            } else {
                UmcPublicBankInfoQueryDetailAbilityReqBO umcPublicBankInfoQueryDetailBusiReqBO1 = new UmcPublicBankInfoQueryDetailAbilityReqBO();
                umcPublicBankInfoQueryDetailBusiReqBO1.setContactId(reqBO.getSupplierId());
                UmcPublicBankInfoQueryDetailAbilityRspBO mcPublicBankInfoQueryDetailBusiRspBO = this.umcPublicBankInfoBusiService.queryBankInfoDetail(umcPublicBankInfoQueryDetailBusiReqBO1);
                reqBO.setReceiptAcctNo(mcPublicBankInfoQueryDetailBusiRspBO.getBankAccount());
                reqBO.setRecAcctName(mcPublicBankInfoQueryDetailBusiRspBO.getBankAccountName());
                reqBO.setOpenBankName(mcPublicBankInfoQueryDetailBusiRspBO.getBankName());
            }
        }
        Long branchCompany = null;
        Long receiptOrgId = null;
        HashMap<String, Integer> payableTypeMap = new HashMap<String, Integer>(payableDetailPOs.size());
        boolean orderCodeFlag = true;
        String orderCode = null;
        for (PayableDetailPO payableDetailPO : payableDetailPOs) {
            if (null != payableDetailPO.getPurchaseOrderCode()) {
                if (orderCode == null) {
                    orderCode = payableDetailPO.getPurchaseOrderCode();
                } else if (!orderCode.equals(payableDetailPO.getPurchaseOrderCode())) {
                    orderCodeFlag = false;
                }
            } else {
                orderCodeFlag = false;
            }
            payableTypeMap.put(payableDetailPO.getPayableNo(), payableDetailPO.getPayableType());
            if (!INVOIC_PAYABLE_TYPE.equals(payableDetailPO.getPayableType()) && TRADE_MODEL.equals(payableDetailPO.getBusiModel())) {
                if (receiptOrgId == null) {
                    receiptOrgId = payableDetailPO.getOperatorId();
                } else if (!receiptOrgId.equals(payableDetailPO.getOperatorId())) {
                    throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u5fc5\u987b\u76f8\u540c");
                }
            } else if (receiptOrgId == null) {
                receiptOrgId = payableDetailPO.getSupplierId();
            } else if (!receiptOrgId.equals(payableDetailPO.getSupplierId())) {
                throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u5fc5\u987b\u76f8\u540c");
            }
            if (null != payableDetailPO.getPendingAmt() && payableDetailPO.getPendingAmt().compareTo(BigDecimal.ZERO) > 0) {
                if (NOTIFICATION.equals(payableDetailPO.getPayableType())) {
                    List<ApplyDetail> list = this.applyDetailMapper.selectListByPayableNo(payableDetailPO.getPayableNo());
                    if (!CollectionUtils.isEmpty(list)) {
                        list.forEach(applyDetail -> {
                            if (applyDetail.getPayableNo().equals(payableDetailPO.getPayableNo())) {
                                PayableDetailPO payableDetailPO1 = new PayableDetailPO();
                                payableDetailPO1.setPayableNo(payableDetailPO.getPayableNo());
                                payableDetailPO1.setPendingAmt(payableDetailPO.getPendingAmt().subtract(applyDetail.getAmt()));
                                this.payableDetailMapper.updateByPayableNo(payableDetailPO1);
                            }
                            this.applyDetailMapper.deleteByPrimaryKey(applyDetail.getApplyNo(), applyDetail.getPayableNo());
                            this.applyPayInfoMapper.deleteById(applyDetail.getApplyNo());
                        });
                    }
                } else {
                    String string = this.checkApplyNo(payableNoList);
                    if (null != string) {
                        if ("7".equals(reqBO.getPayChannel())) {
                            List<ApplyDetail> applyDetails = this.applyDetailMapper.selectListByPayableNo(payableDetailPO.getPayableNo());
                            if (!CollectionUtils.isEmpty(applyDetails)) {
                                applyDetails.forEach(applyDetail -> {
                                    if (applyDetail.getPayableNo().equals(payableDetailPO.getPayableNo())) {
                                        PayableDetailPO payableDetailPO1 = new PayableDetailPO();
                                        payableDetailPO1.setPendingAmt(payableDetailPO.getPendingAmt().subtract(applyDetail.getAmt()));
                                        payableDetailPO1.setPayableNo(payableDetailPO.getPayableNo());
                                        this.payableDetailMapper.updateByPayableNo(payableDetailPO1);
                                    }
                                    this.applyDetailMapper.deleteByPrimaryKey(applyDetail.getApplyNo(), applyDetail.getPayableNo());
                                    this.applyPayInfoMapper.deleteById(applyDetail.getApplyNo());
                                });
                            }
                        } else {
                            rspBO.setPayNo(string);
                            return rspBO;
                        }
                    }
                }
            }
            if (branchCompany != null) continue;
            branchCompany = payableDetailPO.getBranchCompany();
        }
        if (OrderSource.ELECTRIC_AREA.getCode().equals(firstSource) || OrderSource.CONSULT_PRICE.getCode().equals(firstSource) || OrderSource.COAL_AREA.getCode().equals(firstSource) || OrderSource.PRICE_FRAME.getCode().equals(firstSource)) {
            HashSet<Long> orders = new HashSet<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                orders.add(payableDetailPO.getOrderId());
            }
            if (orders.size() > 1) {
                ArrayList<Long> arrayList = new ArrayList<Long>(orders);
                payableDetailVO = new PayableDetailVO();
                payableDetailVO.setOrderIdList(arrayList);
                payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
                for (PayableDetailPO payableDetailPO4 : payableDetailPOs) {
                    String payType = payableDetailPO4.getPayType();
                    if (!PayablePayType.PREPAY.getCode().equals(payType)) continue;
                    throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff08\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\uff1a" + payableDetailPO4.getPurchaseOrderCode() + "\uff09\u6709" + PayablePayType.getInstance(payType).getDescr() + "\uff0c\u4e0d\u80fd\u548c\u5176\u4ed6\u8ba2\u5355\u5408\u5e76\u4ed8\u6b3e");
                }
            }
        }
        String status = "01";
        if ("7".equals(reqBO.getPayChannel())) {
            status = PayResultStatus.PAY_CONFIRMED.getCode();
        }
        PayableDetailPO payableDetailPO = new PayableDetailPO();
        payableDetailPO.setOperatorId(reqBO.getOrgId());
        payableDetailPO.setSupplierId(reqBO.getSupplierId());
        LinkedList<PayableDetailPO> linkedList = this.payableDetailMapper.getNegativeByPurchaserId(payableDetailPO);
        BigDecimal payAmtCount = new BigDecimal(0);
        HashMap<String, BigDecimal> applyMap = new HashMap<String, BigDecimal>();
        for (final ApplyPayBO applyPayBO : applyPayBOList) {
            PayableDetailPO payable = this.checkParamter(applyPayBO.getPayableNo(), applyPayBO.getPayAmt());
            applyMap.put(applyPayBO.getPayableNo(), applyPayBO.getPayAmt());
            if (("0".equals(reqBO.getIsProfessionalOrgExt()) || NOTIFICATION.equals(payableTypeMap.get(applyPayBO.getPayableNo()))) && !CollectionUtils.isEmpty(linkedList) && !"7".equals(reqBO.getPayChannel())) {
                this.deduction(linkedList, applyPayBO, reqBO);
            }
            PayableDetailPO forUpdate = new PayableDetailPO();
            forUpdate.setPendingAmt(applyPayBO.getPayAmt());
            forUpdate.setPaidAmt(((BigDecimal)applyMap.get(applyPayBO.getPayableNo())).subtract(applyPayBO.getPayAmt()));
            if (forUpdate.getPaidAmt().compareTo(BigDecimal.ZERO) > 0) {
                forUpdate.setPayableStatus(PayableStatus.PAYING.getCode());
            }
            if (payable.getPayableAmt().subtract(forUpdate.getPaidAmt()).subtract(payable.getPaidAmt()).compareTo(BigDecimal.ZERO) == 0) {
                forUpdate.setPayableStatus(PayableStatus.SUCCESS.getCode());
            }
            forUpdate.setPayableAmt(payable.getPendingAmt());
            forUpdate.setPayableNo(applyPayBO.getPayableNo());
            int cnt = this.payableDetailMapper.updateAmount(forUpdate);
            payAmtCount = applyPayBO.getPayAmt().add(payAmtCount);
            ApplyDetail applyDetail2 = new ApplyDetail();
            applyDetail2.setApplyNo(payno.toString());
            applyDetail2.setPayableNo(applyPayBO.getPayableNo());
            applyDetail2.setOperatorId(reqBO.getUserId());
            applyDetail2.setSource(applyPayBO.getSource());
            applyDetail2.setSupplierId(reqBO.getSupplierId());
            applyDetail2.setStatus(status);
            applyDetail2.setAmt(applyPayBO.getPayAmt());
            applyDetail2.setCompanyId(reqBO.getCompanyId());
            if (applyDetail2.getAmt().compareTo(BigDecimal.ZERO) > 0) {
                this.applyDetailMapper.insert(applyDetail2);
            }
            new Thread(){

                @Override
                public void run() {
                    FscRemindReqBO fscRemindReqBO = new FscRemindReqBO();
                    fscRemindReqBO.setNotificationNo(applyPayBO.getNotificationNo());
                    fscRemindReqBO.setUserId(reqBO.getUserId());
                    fscRemindReqBO.setSupplierNo(reqBO.getSupplierId());
                    logger.info("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3,\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f\u670d\u52a1,\u8fdb\u5165\u7ebf\u7a0b\u6210\u529f \u5165\u53c2" + JSON.toJSONString((Object)fscRemindReqBO));
                    BusiApplyPayServiceImpl.this.sendPayResultService.send(fscRemindReqBO);
                }
            }.start();
        }
        if (payAmtCount.compareTo(BigDecimal.ZERO) > 0) {
            rspBO.setPayNo(payno.toString());
            Date applyDate = new Date();
            Long contractId = payableDetailPOs.get(0).getContractId();
            QueryContractSupplierInfoReqBO queryContractSupplierInfoReqBO = new QueryContractSupplierInfoReqBO();
            queryContractSupplierInfoReqBO.setContractId(contractId);
            QueryContractSupplierInfoRspBO queryContractSupplierInfoRspBO = this.queryContractSupplierService.queryContratSupplierByContractId(queryContractSupplierInfoReqBO);
            ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)applyPayInfoPO);
            if (queryContractSupplierInfoRspBO != null && "0000".equals(queryContractSupplierInfoRspBO.getCode()) && null != queryContractSupplierInfoRspBO.getContractCode()) {
                applyPayInfoPO.setContactNo(queryContractSupplierInfoRspBO.getContractCode());
            }
            applyPayInfoPO.setPayAmt(payAmtCount);
            applyPayInfoPO.setPayno(payno.toString());
            applyPayInfoPO.setSource(firstSource);
            applyPayInfoPO.setApplyDate(applyDate);
            applyPayInfoPO.setOperatorId(reqBO.getUserId());
            applyPayInfoPO.setOperatorName(reqBO.getName());
            applyPayInfoPO.setPayStatus(status);
            applyPayInfoPO.setBranchCompany(branchCompany);
            applyPayInfoPO.setPayVoucher(reqBO.getPayVoucher());
            applyPayInfoPO.setPayVoucherName(reqBO.getPayVoucherName());
            applyPayInfoPO.setCompanyId(reqBO.getCompanyId());
            applyPayInfoPO.setCompanyName(reqBO.getCompanyName());
            if ("7".equals(reqBO.getPayChannel())) {
                applyPayInfoPO.setPayMathod(PayMethod.XXZF.getCode());
                applyPayInfoPO.setPayChannel(reqBO.getPayChannel());
            } else {
                applyPayInfoPO.setPayChannel(null);
            }
            if (applyPayInfoPO.getSupplierName() == null && applyPayInfoPO.getSupplierId() != null) {
                applyPayInfoPO.setSupplierName(this.organizationInfoService.querySupplierName(applyPayInfoPO.getSupplierId()));
            }
            this.applyPayInfoMapper.insert(applyPayInfoPO);
            if ("7".equals(reqBO.getPayChannel())) {
                OrgMerchantConfigPO orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId);
                if (null == orgMerchantConfigPO) {
                    rspBO.setRespDesc("\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
                    throw new PfscExtBusinessException("18000", "\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
                }
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                StringBuilder payOrderNo = new StringBuilder();
                payOrderNo.append("PAYMENT-").append(payno);
                paymentFlowInfo.setOutOrderId(payOrderNo.toString());
                paymentFlowInfo.setMerchantId(orgMerchantConfigPO.getMerchantId());
                paymentFlowInfo.setOrgId(reqBO.getOrgId());
                paymentFlowInfo.setOrderAmt(payAmtCount);
                paymentFlowInfo.setPayOrgNo(reqBO.getOrgId());
                paymentFlowInfo.setRecOrgNo(orgMerchantConfigPO.getOrgId());
                paymentFlowInfo.setOrderDesc("\u8ba2\u5355\u4ed8\u6b3e");
                paymentFlowInfo.setPayChannel(reqBO.getPayChannel());
                paymentFlowInfo.setCreateUserId(reqBO.getUserId());
                paymentFlowInfo.setCreateUserName(reqBO.getName());
                paymentFlowInfo.setCreateTime(new Date());
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getMemUserType())) {
                    paymentFlowInfo.setFlowType(Integer.parseInt(reqBO.getMemUserType()));
                }
                if (orderCodeFlag) {
                    paymentFlowInfo.setOrderCode(orderCode);
                }
                UmcQryOrgNameBySupplierIdOrOrgIdServiceReqBO orgIdServiceReqBO = new UmcQryOrgNameBySupplierIdOrOrgIdServiceReqBO();
                orgIdServiceReqBO.setId(reqBO.getOrgId());
                UmcQryOrgNameBySupplierIdOrOrgIdServiceRspBO idServiceRspBO = this.umcQryOrgNameService.qryOrgNameBySupplierIdOrOrgId(orgIdServiceReqBO);
                if (idServiceRspBO == null) {
                    logger.error("\u67e5\u65e0\u6b64\u673a\u6784\u6216\u4f9b\u5e94\u5546\uff0cid\u4e3a\uff1a" + orgIdServiceReqBO.getId());
                } else {
                    paymentFlowInfo.setPayName(idServiceRspBO.getName());
                }
                orgIdServiceReqBO.setId(orgMerchantConfigPO.getOrgId());
                UmcQryOrgNameBySupplierIdOrOrgIdServiceRspBO serviceRspBO = this.umcQryOrgNameService.qryOrgNameBySupplierIdOrOrgId(orgIdServiceReqBO);
                if (serviceRspBO == null) {
                    logger.error("\u67e5\u65e0\u6b64\u673a\u6784\u6216\u4f9b\u5e94\u5546\uff0cid\u4e3a\uff1a" + orgIdServiceReqBO.getId());
                } else {
                    paymentFlowInfo.setRecName(serviceRspBO.getName());
                }
                paymentFlowInfo.setFlowFlag("00");
                paymentFlowInfo.setPayAttche(reqBO.getPayVoucher());
                paymentFlowInfo.setPayAcctName(reqBO.getPayVoucherName());
                this.paymentFlowInfoMapper.insert(paymentFlowInfo);
            }
        } else {
            rspBO.setPayFlag("1");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u552e\u540e\u5e94\u4ed8\u62b5\u6263\u652f\u4ed8\u6210\u529f\uff01");
        }
        return rspBO;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"applyExpetionPay"})
    public BusiApplyPayServiceRspBO applyExpetionPay(@RequestBody BusiApplyPayServiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)reqBO.getSupplierName())) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getReceiptAcctNo())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getRecAcctName())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyPayBOList())) {
            throw new PfscExtBusinessException("18000", "\u6765\u6e90\u3001\u5f00\u7968\u7f16\u53f7\u3001\u4ed8\u6b3e\u91d1\u989d\u548c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u7ec4\u6210\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long payno = this.billSNService.getSn(BillType.PAY_APPLICATION);
        logger.info("\u6d41\u6c34\u53f7\uff1a" + payno);
        ArrayList<String> payableNoList = new ArrayList<String>();
        ArrayList<String> sourceList = new ArrayList<String>();
        List applyPayBOList = reqBO.getApplyPayBOList();
        for (Object applyPayBO : applyPayBOList) {
            if (!StringUtils.hasText((String)applyPayBO.getPayableNo())) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (applyPayBO.getPayAmt() == null) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)applyPayBO.getSource())) {
                throw new PfscExtBusinessException("18000", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            payableNoList.add(applyPayBO.getPayableNo());
            sourceList.add(applyPayBO.getSource());
        }
        String firstSource = (String)sourceList.get(0);
        for (String source : sourceList) {
            if (firstSource.compareTo(source) == 0) continue;
            throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u6765\u6e90\u4e0d\u80fd\u4e00\u8d77\u6c47\u603b");
        }
        PayableDetailVO payableDetailVO = new PayableDetailVO();
        payableDetailVO.setPayableNos(payableNoList);
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
        Long branchCompany = null;
        Long supplierId = null;
        for (PayableDetailPO payableDetailPO : payableDetailPOs) {
            if (supplierId == null) {
                supplierId = payableDetailPO.getSupplierId();
            } else if (!supplierId.equals(payableDetailPO.getSupplierId())) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e00\u8d77\u4ed8\u6b3e");
            }
            if (branchCompany != null) continue;
            branchCompany = payableDetailPO.getBranchCompany();
        }
        for (PayableDetailPO payableDetailPO : payableDetailPOs) {
            AddCreditLineFscReqBo addCreditLineFscReqBo = new AddCreditLineFscReqBo();
            addCreditLineFscReqBo.setChangeType("3");
            addCreditLineFscReqBo.setChangeInfo(((ApplyPayBO)reqBO.getApplyPayBOList().get(0)).getPayAmt());
            addCreditLineFscReqBo.setPayApplyCode(String.valueOf(payno));
            if (payableDetailPO.getPayableType() == 1 && 1 == payableDetailPO.getBusiModel()) {
                String notificationNo = payableDetailPO.getNotificationNo();
                List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
                for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                    addCreditLineFscReqBo.setOrderCode(String.valueOf(payPurchaseOrderInfo.getPurchaseOrderCode()));
                    this.busiAddCreditLineService.addCreditLine(addCreditLineFscReqBo);
                }
            } else if (payableDetailPO.getPayableType() == 6) {
                String applyNo = payableDetailPO.getApplyNo();
                List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    addCreditLineFscReqBo.setOrderCode(String.valueOf(saleOrderInfo.getSaleOrderCode()));
                    this.busiAddCreditLineService.addCreditLine(addCreditLineFscReqBo);
                }
            } else if (payableDetailPO.getPayableType() == 2 || payableDetailPO.getPayableType() == 3 || payableDetailPO.getPayableType() == 5) {
                addCreditLineFscReqBo.setOrderCode(payableDetailPO.getPurchaseOrderCode());
                this.busiAddCreditLineService.addCreditLine(addCreditLineFscReqBo);
            }
            logger.error("##############################\uff1a" + addCreditLineFscReqBo.toString());
        }
        if (OrderSource.ELECTRIC_AREA.getCode().equals(firstSource) || OrderSource.CONSULT_PRICE.getCode().equals(firstSource) || OrderSource.COAL_AREA.getCode().equals(firstSource) || OrderSource.PRICE_FRAME.getCode().equals(firstSource)) {
            HashSet<Long> orders = new HashSet<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                orders.add(payableDetailPO.getOrderId());
            }
            if (orders.size() > 1) {
                if (OrderSource.ELECTRIC_AREA.getCode().equals(firstSource) || OrderSource.COAL_AREA.getCode().equals(firstSource) || OrderSource.PRICE_FRAME.getCode().equals(firstSource)) {
                    Object var12_16 = null;
                    for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                        void var12_17;
                        if (!StringUtils.hasText((String)payableDetailPO.getPlaAgreementCode())) {
                            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff08\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\uff1a" + payableDetailPO.getPurchaseOrderCode() + "\uff09\u7684\u5e94\u4ed8\u8bb0\u5f55\u4e0a\u6ca1\u6709\u8bb0\u5f55\u91c7\u8d2d\u5408\u540c\u7f16\u53f7\uff0c\u4e0d\u80fd\u4ed8\u6b3e");
                        }
                        if (var12_17 == null) {
                            String string = payableDetailPO.getPlaAgreementCode();
                            continue;
                        }
                        if (var12_17.equals(payableDetailPO.getPlaAgreementCode())) continue;
                        throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5408\u540c\u7f16\u53f7\u4e0d\u540c\u7684\u8ba2\u5355\u4e0d\u80fd\u5408\u5e76\u4ed8\u6b3e");
                    }
                }
                ArrayList<Long> arrayList = new ArrayList<Long>(orders);
                payableDetailVO = new PayableDetailVO();
                payableDetailVO.setOrderIdList(arrayList);
                payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
                for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                    String payType = payableDetailPO.getPayType();
                    if (!PayablePayType.PREPAY.getCode().equals(payType)) continue;
                    throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff08\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\uff1a" + payableDetailPO.getPurchaseOrderCode() + "\uff09\u6709" + PayablePayType.getInstance(payType).getDescr() + "\uff0c\u4e0d\u80fd\u548c\u5176\u4ed6\u8ba2\u5355\u5408\u5e76\u4ed8\u6b3e");
                }
            }
        }
        BigDecimal payAmtCount = new BigDecimal(0);
        for (ApplyPayBO applyPayBO : applyPayBOList) {
            payAmtCount = applyPayBO.getPayAmt().add(payAmtCount);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payno.toString());
            applyDetail.setPayableNo(applyPayBO.getPayableNo());
            applyDetail.setOperatorId(reqBO.getUserId());
            applyDetail.setSource(applyPayBO.getSource());
            applyDetail.setSupplierId(reqBO.getSupplierId());
            applyDetail.setStatus(PayResultStatus.SUCCESS.getCode());
            applyDetail.setAmt(applyPayBO.getPayAmt());
            applyDetail.setCompanyId(reqBO.getCompanyId());
            this.applyDetailMapper.insert(applyDetail);
            PayableDetailPO payable = this.checkParamter(applyPayBO.getPayableNo(), applyPayBO.getPayAmt());
            PayableDetailPO forUpdate = new PayableDetailPO();
            forUpdate.setPendingAmt(applyPayBO.getPayAmt());
            if (payable.getPaidAmt().add(applyPayBO.getPayAmt()).compareTo(payable.getPayableAmt()) > -1) {
                forUpdate.setPayableStatus(PayableStatus.SUCCESS.getCode());
            } else {
                forUpdate.setPayableStatus(PayableStatus.PAYING.getCode());
            }
            forUpdate.setPayableAmt(payable.getPendingAmt());
            forUpdate.setPayableNo(applyPayBO.getPayableNo());
            int saleOrderInfo = this.payableDetailMapper.updateAmount(forUpdate);
        }
        Date date = new Date();
        Long l = payableDetailPOs.get(0).getContractId();
        QueryContractSupplierInfoReqBO queryContractSupplierInfoReqBO = new QueryContractSupplierInfoReqBO();
        queryContractSupplierInfoReqBO.setContractId(l);
        QueryContractSupplierInfoRspBO queryContractSupplierInfoRspBO = this.queryContractSupplierService.queryContratSupplierByContractId(queryContractSupplierInfoReqBO);
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)applyPayInfoPO);
        if (queryContractSupplierInfoRspBO != null && "0000".equals(queryContractSupplierInfoRspBO.getCode()) && null != queryContractSupplierInfoRspBO.getContractCode()) {
            applyPayInfoPO.setContactNo(queryContractSupplierInfoRspBO.getContractCode());
        }
        applyPayInfoPO.setPayAmt(payAmtCount);
        applyPayInfoPO.setPayno(payno.toString());
        applyPayInfoPO.setSource(firstSource);
        applyPayInfoPO.setApplyDate(date);
        applyPayInfoPO.setOperatorId(reqBO.getUserId());
        applyPayInfoPO.setOperatorName(reqBO.getName());
        applyPayInfoPO.setPayStatus(PayResultStatus.SUCCESS.getCode());
        applyPayInfoPO.setBranchCompany(branchCompany);
        applyPayInfoPO.setPayChannel("1");
        applyPayInfoPO.setPayVoucher(reqBO.getPayVoucher());
        applyPayInfoPO.setPayVoucherName(reqBO.getPayVoucherName());
        applyPayInfoPO.setCompanyId(reqBO.getCompanyId());
        applyPayInfoPO.setCompanyName(reqBO.getCompanyName());
        if (applyPayInfoPO.getSupplierName() == null && applyPayInfoPO.getSupplierId() != null) {
            applyPayInfoPO.setSupplierName(this.organizationInfoService.querySupplierName(applyPayInfoPO.getSupplierId()));
        }
        this.applyPayInfoMapper.insert(applyPayInfoPO);
        try {
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListPageByNotifNo(payableDetailPO.getNotificationNo(), (Page<Map<String, Object>>)new Page(), null);
                if (CollectionUtils.isEmpty(payPurchaseOrderInfos)) continue;
                for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                    if (payPurchaseOrderInfo == null || payPurchaseOrderInfo.getOrderId() == null) continue;
                    PebExtPayResultReqBO pebExtPayResultReqBO = new PebExtPayResultReqBO();
                    pebExtPayResultReqBO.setOrderId(payPurchaseOrderInfo.getOrderId().toString());
                    pebExtPayResultReqBO.setPayMethod(PayMethod.XXZF.getCode());
                    this.pebExtFscPayResultAbilityService.dealPayResult(pebExtPayResultReqBO);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
        }
        BusiApplyPayServiceRspBO rspBO = new BusiApplyPayServiceRspBO();
        rspBO.setPayNo(payno.toString());
        return rspBO;
    }

    private PayableDetailPO checkParamter(String payableNo, BigDecimal amount) {
        if (!StringUtils.hasText((String)payableNo)) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u6d89\u53ca\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        PayableDetailPO payable = null;
        try {
            payable = this.payableDetailMapper.getModelById(payableNo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo, (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25" + e.getMessage());
        }
        if (payable == null) {
            logger.debug("\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728,\u5e94\u4ed8\u5355=" + payableNo);
            throw new PfscExtBusinessException("18001", "\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728");
        }
        return payable;
    }

    private String checkApplyNo(List<String> payableNoList) {
        String ApplyNos = null;
        ApplyDetailVO applyDetailVO = new ApplyDetailVO();
        for (String payableNo : payableNoList) {
            applyDetailVO.setPayableNo(payableNo);
            List<ApplyDetail> applyDetails = this.applyDetailMapper.selectListByPayableNo(payableNo);
            if (CollectionUtils.isEmpty(applyDetails)) continue;
            if (null == ApplyNos) {
                ApplyNos = applyDetails.get(0).getApplyNo();
                continue;
            }
            if (applyDetails.get(0).getApplyNo().equals(ApplyNos)) continue;
            throw new PfscExtBusinessException("18000", "\u518d\u4ed8\u4ed8\u6b3e\u65f6,\u6240\u9009\u5e94\u4ed8\u5355\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4ed8\u6b3e\u5355");
        }
        return ApplyNos;
    }

    private void deduction(LinkedList<PayableDetailPO> negativePayableDetailList, ApplyPayBO applyPayBO, BusiApplyPayServiceReqBO reqBO) {
        PayableDetailPO payablePO = negativePayableDetailList.getFirst();
        BigDecimal finalAmt = applyPayBO.getPayAmt().add(payablePO.getPayableAmt().subtract(payablePO.getPaidAmt()));
        if (finalAmt.compareTo(BigDecimal.ZERO) > 0) {
            applyPayBO.setPayAmt(finalAmt);
            payablePO.setPaidAmt(payablePO.getPayableAmt());
            payablePO.setPayableStatus(SUCCESS);
            this.payableDetailMapper.updateById(payablePO);
            this.createPaymentFlow(payablePO.getPayableAmt(), payablePO, reqBO, applyPayBO);
            if (negativePayableDetailList.size() >= 1) {
                negativePayableDetailList.removeFirst();
            } else {
                negativePayableDetailList.clear();
            }
            if (negativePayableDetailList.size() > 0) {
                this.deduction(negativePayableDetailList, applyPayBO, reqBO);
            }
        } else if (finalAmt.compareTo(BigDecimal.ZERO) == 0) {
            applyPayBO.setPayAmt(BigDecimal.ZERO);
            if (negativePayableDetailList.size() >= 1) {
                negativePayableDetailList.removeFirst();
            } else {
                negativePayableDetailList.clear();
            }
            payablePO.setPayableStatus(SUCCESS);
            payablePO.setPaidAmt(payablePO.getPayableAmt());
            this.payableDetailMapper.updateById(payablePO);
            this.createPaymentFlow(payablePO.getPayableAmt(), payablePO, reqBO, applyPayBO);
        } else if (finalAmt.compareTo(BigDecimal.ZERO) < 0) {
            negativePayableDetailList.getFirst().setPaidAmt(applyPayBO.getPayAmt());
            payablePO.setPaidAmt(applyPayBO.getPayAmt().negate());
            this.payableDetailMapper.updateById(payablePO);
            this.createPaymentFlow(applyPayBO.getPayAmt(), payablePO, reqBO, applyPayBO);
            applyPayBO.setPayAmt(BigDecimal.ZERO);
        }
    }

    private void createPaymentFlow(BigDecimal amt, PayableDetailPO payableDetailPO, BusiApplyPayServiceReqBO reqBo, ApplyPayBO applyPayBO) {
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        Long payno = this.billSNService.getSn(BillType.PAY_APPLICATION);
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("DEDUCTION-").append(payno);
        paymentFlowInfo.setOutOrderId(payOrderNo.toString());
        paymentFlowInfo.setReturnOutOrderId(payableDetailPO.getPayableNo());
        paymentFlowInfo.setExtJson(applyPayBO.getPayableNo());
        paymentFlowInfo.setOrderAmt(amt);
        paymentFlowInfo.setOrderDesc("\u5e94\u4ed8\u5355\u62b5\u6263");
        paymentFlowInfo.setCreateUserId(reqBo.getUserId());
        paymentFlowInfo.setCreateUserName(reqBo.getName());
        paymentFlowInfo.setOrderCode(payableDetailPO.getPurchaseOrderCode());
        paymentFlowInfo.setFlowFlag(FlowFlag.ORDER_PAY.getCode());
        paymentFlowInfo.setPayType(PayFlowPayType.PAY_TYPE_200.getCode());
        paymentFlowInfo.setPayTime(new Date());
        paymentFlowInfo.setCreateTime(new Date());
        paymentFlowInfo.setPaymentStatus(PAYMENT_SUCCESS);
        paymentFlowInfo.setOrgId(payableDetailPO.getOperatorId());
        this.paymentFlowInfoMapper.insert(paymentFlowInfo);
        AddCreditLineFscReqBo creditLineFscReqBo = new AddCreditLineFscReqBo();
        creditLineFscReqBo.setChangeType("3");
        creditLineFscReqBo.setChangeInfo(amt.abs());
        creditLineFscReqBo.setPayApplyCode(String.valueOf(payno));
        String notificationNo = applyPayBO.getNotificationNo();
        List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
            creditLineFscReqBo.setOrderCode(String.valueOf(payPurchaseOrderInfo.getPurchaseOrderCode()));
            this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
        }
    }
}

