/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiExportOutstockTotalOrderService;
import com.tydic.pfscext.api.busi.bo.BusiExportOutstockTotalOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryOutstockTotalShowRspBO;
import com.tydic.pfscext.api.busi.bo.OutstockTotalOrderBO;
import com.tydic.pfscext.api.busi.vo.SaleInvoiceVO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.AmountUtils;
import com.tydic.pfscext.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportOutstockTotalOrderServiceimpl
implements BusiExportOutstockTotalOrderService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportOutstockTotalOrderServiceimpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public BusiExportOutstockTotalOrderRspBO export(List<BusiQueryOutstockTotalShowRspBO> outstockTotalInfoBOS) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u5e93\u6c47\u603b\u5355\u5bfc\u51fa\u8ba2\u5355\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + outstockTotalInfoBOS);
        }
        BusiExportOutstockTotalOrderRspBO resp = new BusiExportOutstockTotalOrderRspBO();
        ArrayList<OutstockTotalOrderBO> rows = new ArrayList<OutstockTotalOrderBO>();
        List<SaleOrderInfo> saleOrderInfolList = null;
        BigDecimal nottaxAmtSum = BigDecimal.ZERO;
        BigDecimal taxAmtSum = BigDecimal.ZERO;
        BigDecimal amtSum = BigDecimal.ZERO;
        ArrayList<String> totalNoList = new ArrayList<String>();
        for (BusiQueryOutstockTotalShowRspBO outstockTotalInfoBO : outstockTotalInfoBOS) {
            totalNoList.add(outstockTotalInfoBO.getTotalNo());
        }
        List<BillApplyInfoVO> billApplyInfoList = this.billApplyInfoMapper.getListByTotalNoList(totalNoList);
        for (BillApplyInfoVO billApplyInfo : billApplyInfoList) {
            OutstockTotalOrderBO outstockTotalOrderBO = new OutstockTotalOrderBO();
            outstockTotalOrderBO.setTotalNo(billApplyInfo.getTotalNo());
            saleOrderInfolList = OrderSource.ELECTRIC_MARKET.getCode().equals(billApplyInfo.getSource()) ? this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(billApplyInfo.getApplyNo()) : this.saleOrderInfoMapper.getSaleOrderListByApplyNo(billApplyInfo.getApplyNo());
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < saleOrderInfolList.size(); ++i) {
                String purchaseName = this.organizationInfoService.queryProjectName(saleOrderInfolList.get(i).getPurchaseProjectId()).getAccountName();
                map.put(saleOrderInfolList.get(i).getSaleOrderCode(), purchaseName);
            }
            ArrayList<String> saleOrderCodes = new ArrayList<String>();
            ArrayList<String> purchaseNames = new ArrayList<String>();
            for (String code : map.keySet()) {
                saleOrderCodes.add(code);
                purchaseNames.add((String)map.get(code));
            }
            String purchaseName = FscStringUtils.list2String(purchaseNames, ",");
            String saleOrderCode = FscStringUtils.list2String(saleOrderCodes, ",");
            outstockTotalOrderBO.setPurchaseName(purchaseName);
            outstockTotalOrderBO.setSaleOrderCode(saleOrderCode);
            if (null != saleOrderInfolList && !saleOrderInfolList.isEmpty()) {
                outstockTotalOrderBO.setSupplierName(saleOrderInfolList.get(0).getSupplierName());
            }
            List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectByApplyNo(billApplyInfo.getApplyNo());
            ArrayList<SaleInvoiceVO> voList = new ArrayList<SaleInvoiceVO>();
            for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
                SaleInvoiceVO saleInvoiceVO = new SaleInvoiceVO();
                saleInvoiceVO.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                saleInvoiceVO.setAmt(AmountUtils.format(saleInvoiceInfo.getAmt()));
                saleInvoiceVO.setUntaxAmt(AmountUtils.format(saleInvoiceInfo.getUntaxAmt()));
                saleInvoiceVO.setTaxAmt(AmountUtils.format(saleInvoiceInfo.getTaxAmt()));
                saleInvoiceVO.setTaxRate(FscStringUtils.valueOf(AmountUtils.calcTaxRate(saleInvoiceInfo.getTaxAmt(), saleInvoiceInfo.getUntaxAmt())));
                voList.add(saleInvoiceVO);
                nottaxAmtSum = nottaxAmtSum.add(saleInvoiceInfo.getUntaxAmt());
                taxAmtSum = taxAmtSum.add(saleInvoiceInfo.getTaxAmt());
                amtSum = amtSum.add(saleInvoiceInfo.getAmt());
            }
            InvoiceType vt = InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()));
            if (vt != null) {
                outstockTotalOrderBO.setInvoiceTypeDescr(vt.getDescr());
            }
            outstockTotalOrderBO.setSaleInvoiceVOs(voList);
            rows.add(outstockTotalOrderBO);
        }
        resp.setRows(rows);
        resp.setAmtSum(AmountUtils.format(amtSum));
        resp.setNotTaxAmtSum(AmountUtils.format(nottaxAmtSum));
        resp.setTaxAmtSum(AmountUtils.format(taxAmtSum));
        return resp;
    }
}

