/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.pec.ability.pay.UocPebUpdateBillStatusAbilityService;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.PushStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.BusiGenerateApplyService;
import com.tydic.pfscext.service.busi.bo.BusiGenerateApplyReqBO;
import com.tydic.pfscext.service.busi.bo.BusiGenerateApplyRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiGenerateApplyServiceImpl
implements BusiGenerateApplyService {
    private static final Logger log = LoggerFactory.getLogger(BusiGenerateApplyServiceImpl.class);
    @Autowired
    private UocPebUpdateBillStatusAbilityService uocPebUpdateBillStatusAbilityService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    @Override
    public BusiGenerateApplyRspBO busiGenerateApply(BusiGenerateApplyReqBO reqBO) {
        log.info("\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355\u5165\u53c2\uff1a" + JSON.toJSONString((Object)((Object)reqBO)));
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceInfo() == null) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getMailAddrInfo() == null) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getSaleOrderInfoList())) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiGenerateApplyRspBO rspBO = new BusiGenerateApplyRspBO();
        InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
        InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
        List<SaleOrderInfo> saleOrderInfoList = reqBO.getSaleOrderInfoList();
        SaleOrderInfo orderInfo = saleOrderInfoList.get(0);
        BigDecimal totalAmt = BigDecimal.ZERO;
        LinkedList<Long> orderIdList = new LinkedList<Long>();
        LinkedList<Long> inspectionIdList = new LinkedList<Long>();
        HashSet<Long> purchaserIdSet = new HashSet<Long>();
        HashSet<String> supplierNoSet = new HashSet<String>();
        HashSet<String> supplierNameSet = new HashSet<String>();
        try {
            String s;
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                totalAmt = totalAmt.add(saleOrderInfo.getOrderAmt());
                orderIdList.add(saleOrderInfo.getOrderId());
                inspectionIdList.add(saleOrderInfo.getInspectionId());
                purchaserIdSet.add(saleOrderInfo.getPurchaserId());
                supplierNoSet.add(saleOrderInfo.getSupplierNo().toString());
                supplierNameSet.add(saleOrderInfo.getSupplierName());
            }
            String applyNo = this.getBillApplyNo();
            billApplyInfo.setApplyNo(applyNo);
            billApplyInfo.setApplyDate(new Date());
            billApplyInfo.setOperUnitNo(orderInfo.getOperUnitNo());
            billApplyInfo.setOperUnitName(orderInfo.getOperUnitName());
            billApplyInfo.setSubUserName(reqBO.getName());
            billApplyInfo.setUserId(reqBO.getUserId());
            billApplyInfo.setApplyType(ApplyType.APPLY_TYPE_ORDER.getCode());
            billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
            billApplyInfo.setPushStatus(PushStatus.NOT_PUSH.getCode());
            billApplyInfo.setAmt(totalAmt);
            billApplyInfo.setPurchaseNo(orderInfo.getPurchaseNo());
            billApplyInfo.setPurchaseName(orderInfo.getPurchaseName());
            billApplyInfo.setPurchaseProjectId(orderInfo.getPurchaseProjectId());
            if (!CollectionUtils.isEmpty(purchaserIdSet)) {
                s = ((Object)purchaserIdSet).toString();
                billApplyInfo.setPurchaserIdJson(s.substring(1, s.length() - 1));
            }
            if (!CollectionUtils.isEmpty(supplierNoSet)) {
                s = ((Object)supplierNoSet).toString();
                billApplyInfo.setSupplierNoList(s.substring(1, s.length() - 1));
            }
            if (!CollectionUtils.isEmpty(supplierNameSet)) {
                s = ((Object)supplierNameSet).toString();
                billApplyInfo.setSupplierName(s.substring(1, s.length() - 1));
            }
            billApplyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
            billApplyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
            billApplyInfo.setPhone(invoiceInfo.getPhone());
            billApplyInfo.setBankName(invoiceInfo.getBank());
            billApplyInfo.setBankAcctNo(invoiceInfo.getAccount());
            billApplyInfo.setAddr(invoiceInfo.getAddress());
            if (invoiceInfo.getInvoiceType() != null) {
                Integer invType;
                Integer n = invType = invoiceInfo.getInvoiceType() == 0 ? InvoiceType.SPECIAL.getCode() : InvoiceType.NORMAL.getCode();
                if (invType != null) {
                    billApplyInfo.setInvoiceType(invType.toString());
                }
                String invClass = invoiceInfo.getInvoiceType() == 2 ? InvoiceClasses.ELECTRONIC_INVOICE.getCode() : InvoiceClasses.PAPER_INVOICE.getCode();
                billApplyInfo.setInvoiceClasses(invClass);
            }
            billApplyInfo.setTel(mailAddrInfo.getTel());
            billApplyInfo.setMobile(mailAddrInfo.getSpecialPlane());
            billApplyInfo.setReceiveInvoicePhone(mailAddrInfo.getReceiveInvoicePhone());
            billApplyInfo.setReceiveInvoiceEmail(mailAddrInfo.getReceiveInvoiceEmail());
            billApplyInfo.setAddr(mailAddrInfo.getAddrDesc());
            billApplyInfo.setName(mailAddrInfo.getName());
            billApplyInfo.setProvince(mailAddrInfo.getProvince());
            billApplyInfo.setCity(mailAddrInfo.getCity());
            billApplyInfo.setCounty(mailAddrInfo.getCounty());
            billApplyInfo.setTown(mailAddrInfo.getTown());
            billApplyInfo.setProvId(mailAddrInfo.getProvId());
            billApplyInfo.setCityId(mailAddrInfo.getCityId());
            billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
            billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
            int i = this.billApplyInfoMapper.insertSelective(billApplyInfo);
            if (i > 0) {
                SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setOrderIdList(orderIdList);
                saleOrderInfoVO.setInspectionIdList(inspectionIdList);
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setOrderStatus(OrderStatus.APPLIED.getCode());
                saleOrderInfo.setApplyNo(applyNo);
                this.saleOrderInfoMapper.updateByCondition(saleOrderInfoVO, saleOrderInfo);
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setApplyNo(applyNo);
                saleItemInfoVO.setInspectionIdList(inspectionIdList);
                saleItemInfoVO.setOrderIdList(orderIdList);
                this.saleItemInfoMapper.updateByCondition(saleItemInfoVO, saleItemInfo);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25\uff1a" + e);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        return rspBO;
    }

    private String getBillApplyNo() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String dateL = Long.valueOf(df.format(new Date())).toString();
        String prefix = "KPSQ";
        String maxNum = this.billApplyInfoMapper.selectMaxPayNoNum(prefix + dateL);
        String num = "000001";
        if (maxNum != null && !"".equals(maxNum)) {
            num = String.format("%06d", Integer.parseInt(maxNum) + 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(dateL).append(num);
        return sb.toString();
    }
}

