/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.order.pec.ability.pay.UocPebUpdateBillStatusAbilityService;
import com.tydic.pfscext.api.busi.NotificationSendRequestService;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfoExt;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.busi.BusiGenerateNotificationService;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationReqBO;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationRspBO;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgQueryAbilityReqBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiGenerateNotificationServiceImpl
implements BusiGenerateNotificationService {
    private static final Logger log = LoggerFactory.getLogger(BusiGenerateNotificationServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private NotificationSendRequestService notificationSendRequestService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private UocPebUpdateBillStatusAbilityService uocPebUpdateBillStatusAbilityService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Resource(name="billNotificationBatchNoSeq")
    private OrderSequence billNotificationBatchNoSeq;

    @Override
    public BusiGenerateNotificationRspBO generateNotification(BusiGenerateNotificationReqBO reqBO) {
        if (reqBO == null || CollectionUtils.isEmpty(reqBO.getOrderInfoList())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfo() || !StringUtils.hasText((String)reqBO.getInvoiceInfo().getInvoiceTitle())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (null == reqBO.getMailAddrInfo() || !StringUtils.hasText((String)reqBO.getMailAddrInfo().getName())) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        BusiGenerateNotificationRspBO rspBO = new BusiGenerateNotificationRspBO();
        log.info("\u5f00\u7968\u901a\u77e5\u5355\u751f\u6210\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)((Object)reqBO)));
        try {
            int updateResult;
            List<PayPurchaseOrderInfo> orderInfoList = reqBO.getOrderInfoList();
            PayPurchaseOrderInfo purchaseOrderInfo = orderInfoList.get(0);
            InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
            InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
            String batchNo = this.generateSeqNoFormated(new SimpleDateFormat("yyyyMMdd").format(new Date()));
            String notifyNo = this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION);
            BigDecimal sumAmt = BigDecimal.ZERO;
            for (PayPurchaseOrderInfo orderInfo : orderInfoList) {
                sumAmt = sumAmt.add(orderInfo.getOrderAmt());
            }
            BillNotificationInfoExt notifyInfo = new BillNotificationInfoExt();
            notifyInfo.setNotificationNo(notifyNo);
            notifyInfo.setAmt(sumAmt);
            notifyInfo.setApplyDate(new Date());
            notifyInfo.setIsApply(reqBO.getIsApply());
            notifyInfo.setSource(purchaseOrderInfo.getSource());
            notifyInfo.setIsPay(1);
            notifyInfo.setSupplierNo(purchaseOrderInfo.getSupplierNo());
            notifyInfo.setUserId(reqBO.getUserId());
            notifyInfo.setDrawerId(reqBO.getUserId());
            notifyInfo.setDrawerName(reqBO.getUsername());
            notifyInfo.setBatchNo(batchNo);
            notifyInfo.setPurchaseSaleType(purchaseOrderInfo.getPurchaseSaleType());
            notifyInfo.setNoAgreeOrderCategory(purchaseOrderInfo.getNoAgreeOrderCategory());
            notifyInfo.setIsApply(reqBO.getIsApply());
            notifyInfo.setBillNotificationType(0);
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(purchaseOrderInfo.getSource())) {
                notifyInfo.setInvoiceStatus(NotificationInvoiceStatus.NO_SUBMITED.getCode());
            } else {
                notifyInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
            }
            if (reqBO.getOrgId() != null) {
                notifyInfo.setStartOrgId(String.valueOf(reqBO.getOrgId()));
            }
            if ("0".equals(purchaseOrderInfo.getBusiModel())) {
                notifyInfo.setOperNo(purchaseOrderInfo.getOperUnitNo());
                notifyInfo.setOperName(purchaseOrderInfo.getOperUnitName());
            } else {
                notifyInfo.setOperNo(purchaseOrderInfo.getPurchaseNo());
                notifyInfo.setOperName(purchaseOrderInfo.getPurchaseName());
            }
            notifyInfo.setAddr(invoiceInfo.getAddress());
            notifyInfo.setBankAccNo(invoiceInfo.getAccount());
            notifyInfo.setBankName(invoiceInfo.getBank());
            notifyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
            notifyInfo.setInvoceType(invoiceInfo.getInvoiceType() == 0 ? InvoiceType.SPECIAL.getCode() : InvoiceType.NORMAL.getCode());
            notifyInfo.setPhone(invoiceInfo.getPhone());
            notifyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
            notifyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
            notifyInfo.setProvince(mailAddrInfo.getProvince());
            notifyInfo.setCity(mailAddrInfo.getCity());
            notifyInfo.setCounty(mailAddrInfo.getCounty());
            notifyInfo.setTown(mailAddrInfo.getTown());
            notifyInfo.setProvId(mailAddrInfo.getProvId());
            notifyInfo.setCityId(mailAddrInfo.getCityId());
            notifyInfo.setCountyId(mailAddrInfo.getCountyId());
            notifyInfo.setTownId(mailAddrInfo.getTownId());
            notifyInfo.setCompany(mailAddrInfo.getCompany());
            notifyInfo.setMobile(mailAddrInfo.getTel());
            notifyInfo.setTel(mailAddrInfo.getSpecialPlane());
            notifyInfo.setName(mailAddrInfo.getName());
            notifyInfo.setPostCode(mailAddrInfo.getPostCode());
            notifyInfo.setFailCount(0);
            int insert = this.billNotificationInfoMapper.insert(notifyInfo);
            if (insert < 1) {
                throw new PfscExtBusinessException("18000", "\u751f\u6210\u5f00\u7968\u901a\u77e5\u4fe1\u606f\u5f02\u5e38");
            }
            PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
            vo.setNotificationNo(notifyInfo.getNotificationNo());
            vo.setPayPurchaseOrderInfos(orderInfoList);
            UmcZhEnterpriseOrgQueryAbilityReqBO umcZhEnterpriseOrgQueryAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
            umcZhEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(reqBO.getOrgId());
            UmcZhEnterpriseOrgDetailAbilityRspBO abilityRspBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcZhEnterpriseOrgQueryAbilityReqBO);
            if (abilityRspBO != null && abilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
                vo.setPayModel(abilityRspBO.getUmcEnterpriseOrgAbilityBO().getSettleModel());
            }
            if ((updateResult = this.payPurchaseOrderInfoMapper.updateStatusAndNotifyNoBatch(vo)) < orderInfoList.size()) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
            }
            PayItemInfoVO item = new PayItemInfoVO();
            item.setNotificationNo(notifyInfo.getNotificationNo());
            item.setPayPurchaseOrderInfos(orderInfoList);
            int updCount = this.payItemInfoMapper.updateStatusAndNotifyNoBatch(item);
            if (updCount == 0) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
            }
            rspBO.setBillNotificationInfoExt(notifyInfo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        return rspBO;
    }

    private String generateSeqNoFormated(String prefix) {
        String withoutPrefix;
        prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        int lengthWithoutPrefix = 12 - prefix.length();
        try {
            withoutPrefix = String.format("%0" + lengthWithoutPrefix + "d", this.billNotificationBatchNoSeq.nextId());
        }
        catch (SQLException e) {
            log.error("\u751f\u6210\u5e8f\u5217\u53f7\u5f02\u5e38" + e);
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u6279\u6b21\u53f7\u5f02\u5e38");
        }
        return prefix + withoutPrefix;
    }
}

