/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.pec.ability.pay.UocPebUpdateBillStatusAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.constants.FscCommonConstants;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SupplierInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfoExt;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SupplierInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiApplyInvoiceService;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceRspBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.busi.BusiNotifyEcommerceInvoiceService;
import com.tydic.pfscext.service.busi.bo.BusiNotifyEcommerceInvoiceServiceReqBo;
import com.tydic.pfscext.service.busi.bo.BusiNotifyEcommerceInvoiceServiceRspBo;
import com.tydic.pfscext.utils.FscCommonUtils;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiNotifyEcommerceInvoiceServiceImpl
implements BusiNotifyEcommerceInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(BusiNotifyEcommerceInvoiceServiceImpl.class);
    @Autowired
    private BusiApplyInvoiceService busiApplyInvoiceService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private UocPebUpdateBillStatusAbilityService uocPebUpdateBillStatusAbilityService;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private EnumsService enumsService;
    private static final Long SUPPLIER_ID = 100055L;
    @Value(value="${FAIL_COUNT}")
    private String failCountStr;

    @Override
    public BusiNotifyEcommerceInvoiceServiceRspBo notifyEcommerceForInvoice(BusiNotifyEcommerceInvoiceServiceReqBo reqBO) {
        if (reqBO.getBillNotificationInfoExt() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiNotifyEcommerceInvoiceServiceRspBo rspBO = new BusiNotifyEcommerceInvoiceServiceRspBo();
        BillNotificationInfoExt notifyInfo = reqBO.getBillNotificationInfoExt();
        List<PayPurchaseOrderInfo> orderInfoList = reqBO.getPayPurchaseOrderInfoList();
        if (CollectionUtils.isEmpty(orderInfoList)) {
            PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setNotificationNo(notifyInfo.getNotificationNo());
            orderInfoList = this.payPurchaseOrderInfoMapper.getListByCondition(payPurchaseOrderInfo);
        }
        log.info("\u672c\u6b21\u5f00\u7968\u901a\u77e5\u7535\u5546\u901a\u77e5\u5355\u4e3a=================" + notifyInfo);
        BusiApplyInvoiceReqBO applyInvoiceReqBO = new BusiApplyInvoiceReqBO();
        LinkedList<String> orderIdCombStr = new LinkedList<String>();
        LinkedList<String> eorderIds = new LinkedList<String>();
        LinkedList<BigDecimal> orderAmt = new LinkedList<BigDecimal>();
        BusiApplyInvoiceRspBO busiApplyInvoiceRspBO = new BusiApplyInvoiceRspBO();
        try {
            applyInvoiceReqBO.setSupplierId(notifyInfo.getSupplierNo());
            if (BusiModel.MATCH_UP_MODEL.getCode().equals(orderInfoList.get(0).getBusiModel()) && SUPPLIER_ID.equals(notifyInfo.getSupplierNo())) {
                applyInvoiceReqBO.setJdOrgId(orderInfoList.get(0).getJdOrgId());
            }
            for (PayPurchaseOrderInfo orderInfo : orderInfoList) {
                orderIdCombStr.add(orderInfo.getExtOrderId());
                eorderIds.add(orderInfo.getPurchaseOrderCode());
                orderAmt.add(orderInfo.getOrderAmt());
            }
            applyInvoiceReqBO.setSupplierOrder(orderIdCombStr);
            applyInvoiceReqBO.setEorderId(eorderIds);
            applyInvoiceReqBO.setSettleAmt(orderAmt);
            applyInvoiceReqBO.setMarkId(notifyInfo.getNotificationNo());
            applyInvoiceReqBO.setSettlementId(notifyInfo.getNotificationNo());
            String curBatchStr = notifyInfo.getNotificationNo();
            String regEx = "[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(curBatchStr);
            curBatchStr = m.replaceAll("").trim();
            curBatchStr = curBatchStr.substring(curBatchStr.length() - 6, curBatchStr.length());
            applyInvoiceReqBO.setCurrentBatch(curBatchStr);
            SimpleDateFormat sfWithSlash = new SimpleDateFormat("yyyy-MM-dd");
            String dateWithSlashStr = sfWithSlash.format(new Date());
            applyInvoiceReqBO.setInvoiceDate(dateWithSlashStr);
            applyInvoiceReqBO.setInvoiceNum(Integer.valueOf(orderIdCombStr.size()));
            applyInvoiceReqBO.setTotalBatch(FscCommonConstants.BASIC_INVOICE_BATCH_NUM);
            if (notifyInfo.getInvoceType() == 1) {
                applyInvoiceReqBO.setInvoiceType(Integer.valueOf(3));
            } else {
                applyInvoiceReqBO.setInvoiceType(notifyInfo.getInvoceType());
            }
            SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(notifyInfo.getSupplierNo());
            if (supplierInfo == null) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u5f00\u7968\u9650\u989d\u914d\u7f6e\u8868\uff0c\u4f9b\u5e94\u5546ID:" + String.valueOf(notifyInfo.getSupplierNo()) + "\u627e\u4e0d\u5230\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f");
            }
            String invoiceOrgSetting = supplierInfo.getBillOrg();
            applyInvoiceReqBO.setInvoiceOrg(invoiceOrgSetting);
            applyInvoiceReqBO.setTitle(notifyInfo.getInvoceName());
            applyInvoiceReqBO.setBizInvoiceContent(Integer.valueOf(1));
            applyInvoiceReqBO.setInvoicePrice(notifyInfo.getAmt());
            applyInvoiceReqBO.setTotalBatchInvoiceAmount(notifyInfo.getAmt());
            applyInvoiceReqBO.setEnterpriseTaxpayer(notifyInfo.getTaxNo());
            String accountStr = notifyInfo.getBankAccNo();
            accountStr = accountStr.replaceAll("\\s*", "");
            if (SUPPLIER_ID.equals(notifyInfo.getSupplierNo())) {
                applyInvoiceReqBO.setEnterpriseRegAddress(notifyInfo.getAddr());
                applyInvoiceReqBO.setEnterpriseRegPhone(notifyInfo.getPhone());
                applyInvoiceReqBO.setEnterpriseBankName(notifyInfo.getBankName());
                applyInvoiceReqBO.setEnterpriseBankAccount(accountStr);
            } else {
                applyInvoiceReqBO.setAddress(notifyInfo.getAddr());
                applyInvoiceReqBO.setTel(notifyInfo.getPhone());
                applyInvoiceReqBO.setBank(notifyInfo.getBankName());
                applyInvoiceReqBO.setAccount(accountStr);
            }
            applyInvoiceReqBO.setBillToParty(notifyInfo.getCompany());
            applyInvoiceReqBO.setBillToer(notifyInfo.getName());
            applyInvoiceReqBO.setBillToContact(notifyInfo.getMobile());
            applyInvoiceReqBO.setBillToProvince(FscCommonUtils.long2Integer((Long)notifyInfo.getProvId()));
            applyInvoiceReqBO.setBillToCity(FscCommonUtils.long2Integer((Long)notifyInfo.getCityId()));
            applyInvoiceReqBO.setBillToCounty(Integer.valueOf(FscCommonUtils.long2Integer((Long)notifyInfo.getCountyId()) == null ? 0 : FscCommonUtils.long2Integer((Long)notifyInfo.getCountyId())));
            applyInvoiceReqBO.setBillToTown(Integer.valueOf(FscCommonUtils.long2Integer((Long)notifyInfo.getTownId()) == null ? 0 : FscCommonUtils.long2Integer((Long)notifyInfo.getTownId())));
            applyInvoiceReqBO.setBillToAddress(notifyInfo.getAddrDesc());
            applyInvoiceReqBO.setOpenSwitch(this.enumsService.queryOpenSwitch(applyInvoiceReqBO.getSupplierId()));
            busiApplyInvoiceRspBO = this.busiApplyInvoiceService.applyInvoice(applyInvoiceReqBO);
        }
        catch (Exception e) {
            log.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u51fa\u9519:" + e.getMessage());
            this.returnFail(reqBO, e.getMessage());
            rspBO.setRespCode("18000");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        if (busiApplyInvoiceRspBO == null || !busiApplyInvoiceRspBO.getSuccess().booleanValue()) {
            log.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u7535\u5546\u8fd4\u56de\u7ed3\u679c\u5931\u8d25:" + busiApplyInvoiceRspBO.getResultMessage());
            this.returnFail(reqBO, busiApplyInvoiceRspBO.getResultMessage());
            rspBO.setRespCode("18000");
            rspBO.setRespDesc(busiApplyInvoiceRspBO.getResultMessage());
        } else {
            this.returnSuccess(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void returnSuccess(BusiNotifyEcommerceInvoiceServiceReqBo reqBO) {
        BillNotificationInfoExt notifyInfo = reqBO.getBillNotificationInfoExt();
        List<PayPurchaseOrderInfo> orderInfoList = reqBO.getPayPurchaseOrderInfoList();
        BillNotificationInfo updateBill = new BillNotificationInfo();
        updateBill.setNotificationNo(notifyInfo.getNotificationNo());
        updateBill.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        this.billNotificationInfoMapper.updateByPrimaryKeySelective(updateBill);
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        vo.setNotificationNo(notifyInfo.getNotificationNo());
        vo.setOrderStatus(OrderStatus.APPLIED.getCode());
        int updateResult = this.payPurchaseOrderInfoMapper.updateStatusBatchByNoti(vo);
        if (updateResult < orderInfoList.size()) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
        }
        PayItemInfoVO item = new PayItemInfoVO();
        item.setNotificationNo(notifyInfo.getNotificationNo());
        item.setItemStatus(OrderStatus.APPLIED.getCode());
        int updCount = this.payItemInfoMapper.updateStatusByNotifyNoBatch(item);
        if (updCount == 0) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
        }
        LinkedList<Long> orderIds = new LinkedList<Long>();
        for (int i = 0; i < orderInfoList.size(); ++i) {
            orderIds.add(orderInfoList.get(i).getOrderId());
            if (orderIds.size() != 500 && i != orderInfoList.size() - 1) continue;
            try {
                UocPebUpdateBillStatusReqBO ubsreqBO = new UocPebUpdateBillStatusReqBO();
                ubsreqBO.setOrderIds(orderIds);
                ubsreqBO.setBillState(Integer.valueOf(OrderStatus.APPLIED.getCode()));
                log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5165\u53c2\uff1a" + JSON.toJSONString((Object)ubsreqBO));
                this.uocPebUpdateBillStatusAbilityService.updateBillStatus(ubsreqBO);
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            }
            orderIds.clear();
        }
    }

    private void returnFail(BusiNotifyEcommerceInvoiceServiceReqBo reqBO, String resultMessage) {
        BillNotificationInfoExt notifyInfo = reqBO.getBillNotificationInfoExt();
        Integer failCount = Integer.valueOf(this.failCountStr);
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(notifyInfo.getNotificationNo());
        if (failCount > billNotificationInfo.getFailCount()) {
            BillNotificationInfo notificationInfo = new BillNotificationInfo();
            notificationInfo.setFailCount(1);
            notificationInfo.setNotificationNo(billNotificationInfo.getNotificationNo());
            notificationInfo.setInvoiceResult(resultMessage);
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(notificationInfo);
        } else {
            BillNotificationInfo notificationInfo = new BillNotificationInfo();
            notificationInfo.setNotificationNo(billNotificationInfo.getNotificationNo());
            notificationInfo.setInvoiceStatus(NotificationInvoiceStatus.REJECT.getCode());
            notificationInfo.setInvoiceResult(resultMessage);
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(notificationInfo);
            PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
            vo.setNotificationNo(billNotificationInfo.getNotificationNo());
            vo.setOrderStatus(OrderStatus.AUTO_HANG_UP.getCode());
            this.payPurchaseOrderInfoMapper.updateStatusAndNotifyNoBatch(vo);
        }
    }
}

