/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.ActQryActiveListAbilityService;
import com.tydic.active.app.ability.bo.ActQryActiveListAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQryActiveListAbilityRspBO;
import com.tydic.active.app.common.bo.ActivitiesBO;
import com.tydic.pfscext.api.busi.BusiPayPurchaseOrderInfoYgflVersionTwoService;
import com.tydic.pfscext.api.busi.bo.BusiTabNumbersQryBO;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoAwaitReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoRspBO;
import com.tydic.pfscext.api.busi.vo.PayItemInfoExtVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.bo.BillNotificationInfoTab;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.NotificationStatusCountVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderSumVO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.enums.Source;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.GetStateListOfConfTabAtomService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import com.tydic.pfscext.utils.FscCommonUtils;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountListAbilityService;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiPayPurchaseOrderInfoYgflVersionTwoService"})
public class BusiPayPurchaseOrderInfoYgflVersionTwoServiceImpl
implements BusiPayPurchaseOrderInfoYgflVersionTwoService {
    private static final Logger log = LoggerFactory.getLogger(BusiPayPurchaseOrderInfoYgflVersionTwoServiceImpl.class);
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;
    @Autowired
    private ActQryActiveListAbilityService actQryActiveListAbilityService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private GetStateListOfConfTabAtomService getStateListOfConfTabAtomService;

    @PostMapping(value={"querySettlementListPage"})
    public QueryPayPurchaseOrderInfoRspBO querySettlementListPage(@RequestBody QueryPayPurchaseOrderInfoAwaitReqBO reqBO) {
        PayPurchaseOrderSumVO sumVO;
        String orderBy;
        if (StringUtils.isEmpty((CharSequence)reqBO.getIsProfessionalOrgExt())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7/\u5f00\u7968\u901a\u77e5\u5f85\u53d1\u8d77-\u8ba2\u5355\u5217\u8868\u67e5\u8be2-\u516c\u53f8\u7c7b\u578b[isProfessionalOrgExt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPayPurchaseOrderInfoRspBO rspBO = new QueryPayPurchaseOrderInfoRspBO();
        String isProfessionalOrgExt = reqBO.getIsProfessionalOrgExt();
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSupplierNo())) {
            vo.setSupplierNo(Long.valueOf(reqBO.getSupplierNo()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPurchaseNo())) {
            vo.setPurchaseNo(Long.valueOf(reqBO.getPurchaseNo()));
        }
        if ("0".equals(isProfessionalOrgExt)) {
            vo.setPurchaseNo(null);
        } else if (!"1".equals(isProfessionalOrgExt) && "2".equals(isProfessionalOrgExt)) {
            vo.setPurchaseNo(null);
            vo.setSupplierNo(reqBO.getSupId());
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPurchaseProjectId())) {
            vo.setPurchaseProjectId(Long.valueOf(reqBO.getPurchaseProjectId()));
        }
        ArrayList orderStatusCodes = Lists.newArrayList();
        if (!StringUtils.isEmpty((CharSequence)reqBO.getHandUpStatus())) {
            orderStatusCodes.add(reqBO.getHandUpStatus());
        } else if (!StringUtils.isEmpty((CharSequence)reqBO.getTabId())) {
            ConfTabStatePO confTabStatePO = this.confTabStateMapper.selectByTabId(Integer.valueOf(reqBO.getTabId()));
            Collections.addAll(orderStatusCodes, confTabStatePO.getStatusCode().split(","));
        } else {
            orderStatusCodes.add(OrderStatus.NO_APPLY.getCode());
            orderStatusCodes.add(OrderStatus.HANGING.getCode());
            orderStatusCodes.add(OrderStatus.AUTO_HANG_UP.getCode());
            orderStatusCodes.add(OrderStatus.SENDING.getCode());
        }
        vo.setOrderStatusCodes(orderStatusCodes);
        vo.setPurchaseOrderCode(reqBO.getPurchaseOrderCode());
        vo.setExtOrderId(reqBO.getExtOrderId());
        vo.setOrderDateStart(reqBO.getOrderDateStart());
        vo.setOrderDateEnd(reqBO.getOrderDateEnd());
        vo.setPayType(reqBO.getPayType());
        if (!StringUtils.isEmpty((CharSequence)reqBO.getInspectionId())) {
            vo.setInspectionId(Long.valueOf(reqBO.getInspectionId()));
        }
        vo.setPurchaserName(reqBO.getPurchaserName());
        vo.setSource(reqBO.getSource());
        vo.setReconciliationStatus(reqBO.getReconciliationStatus());
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getActivityId())) {
            vo.setActivityId(Long.parseLong(reqBO.getActivityId()));
        }
        vo.setNoAgreeOrderCategory(reqBO.getNoAgreeOrderCategory());
        Long excludeOrg = null;
        if ("0".equals(isProfessionalOrgExt)) {
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getPurchaseNo())) {
                vo.setPurchaseNo(Long.valueOf(reqBO.getPurchaseNo()));
            } else {
                excludeOrg = reqBO.getCompanyId();
            }
        }
        vo.setExcludeOrg(excludeOrg);
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                log.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = "a.ORDER_DATE DESC";
        }
        vo.setOrderBy(orderBy);
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        LinkedList<PayPurchaseOrderInfoBO> boList = new LinkedList<PayPurchaseOrderInfoBO>();
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getPurchaseOrderListPage(vo, (Page<Map<String, Object>>)page);
        ArrayList activityIds = new ArrayList();
        ArrayList<Long> inspectionIds = new ArrayList<Long>();
        ArrayList accountIds = new ArrayList();
        if (!CollectionUtils.isEmpty(payPurchaseOrderInfoPOs)) {
            List<PayItemInfo> payItemInfos;
            payPurchaseOrderInfoPOs.forEach(payPurOrderInfo -> {
                inspectionIds.add(payPurOrderInfo.getInspectionId());
                accountIds.add(payPurOrderInfo.getPurchaseProjectId());
                activityIds.add(payPurOrderInfo.getActivityId());
            });
            HashMap itemMap = new HashMap();
            HashMap accountMap = new HashMap();
            if (!CollectionUtils.isEmpty(inspectionIds) && !CollectionUtils.isEmpty(payItemInfos = this.payItemInfoMapper.selectByInspectionIds(inspectionIds))) {
                for (PayItemInfo payItemInfo : payItemInfos) {
                    PayItemInfoExtVO sinleItemVO = new PayItemInfoExtVO();
                    BeanUtils.copyProperties((Object)payItemInfo, (Object)sinleItemVO);
                    sinleItemVO.setSeq(FscCommonUtils.long2String((Long)payItemInfo.getSeq()));
                    sinleItemVO.setQuantity(null == payItemInfo.getQuantity() ? null : payItemInfo.getQuantity().stripTrailingZeros());
                    sinleItemVO.setQuantitySale(null == payItemInfo.getQuantitySale() ? null : payItemInfo.getQuantitySale().stripTrailingZeros());
                    if (null == itemMap.get(payItemInfo.getInspectionId())) {
                        ArrayList<Object> payItemInfoExtVOS = new ArrayList<Object>();
                        payItemInfoExtVOS.add(sinleItemVO);
                        itemMap.put(payItemInfo.getInspectionId(), payItemInfoExtVOS);
                        continue;
                    }
                    ((List)itemMap.get(payItemInfo.getInspectionId())).add(sinleItemVO);
                }
            }
            if (!CollectionUtils.isEmpty(accountIds)) {
                UmcQryEnterpriseAccountListNoPageAbilityReqBO umcQryEnterpriseAccountListNoPageAbilityReqBO = new UmcQryEnterpriseAccountListNoPageAbilityReqBO();
                umcQryEnterpriseAccountListNoPageAbilityReqBO.setInAccountIds(accountIds);
                UmcQryEnterpriseAccountListNoPageAbilityRspBO umcQryEnterpriseAccountListNoPageAbilityRspBO = this.umcQryEnterpriseAccountListAbilityService.qryEnterpriseAccountListNoPage(umcQryEnterpriseAccountListNoPageAbilityReqBO);
                if (!CollectionUtils.isEmpty((Collection)umcQryEnterpriseAccountListNoPageAbilityRspBO.getRows())) {
                    umcQryEnterpriseAccountListNoPageAbilityRspBO.getRows().forEach(umcEnterpriseAccountAbilityBO -> accountMap.put(umcEnterpriseAccountAbilityBO.getAccountId(), umcEnterpriseAccountAbilityBO.getAccountName()));
                }
            }
            HashMap<Long, String> activityMap = new HashMap<Long, String>();
            if (!CollectionUtils.isEmpty(activityIds)) {
                ActQryActiveListAbilityReqBO actQryActiveListAbilityReqBO = new ActQryActiveListAbilityReqBO();
                actQryActiveListAbilityReqBO.setActiveIds(activityIds);
                ActQryActiveListAbilityRspBO actQryActiveListAbilityRspBO = this.actQryActiveListAbilityService.qryActiveList(actQryActiveListAbilityReqBO);
                if (actQryActiveListAbilityRspBO != null && !CollectionUtils.isEmpty((Collection)actQryActiveListAbilityRspBO.getRows())) {
                    for (ActivitiesBO activitiesBO : actQryActiveListAbilityRspBO.getRows()) {
                        activityMap.put(activitiesBO.getActiveId(), activitiesBO.getActiveCode());
                    }
                }
            }
            for (PayPurchaseOrderInfo singlePO : payPurchaseOrderInfoPOs) {
                PayPurchaseOrderInfoBO singleBO = new PayPurchaseOrderInfoBO();
                BeanUtils.copyProperties((Object)singlePO, (Object)singleBO);
                singleBO.setParentOrderId(FscCommonUtils.long2String((Long)singlePO.getParentOrderId()));
                singleBO.setOrderId(FscCommonUtils.long2String((Long)singlePO.getOrderId()));
                singleBO.setInspectionId(FscCommonUtils.long2String((Long)singlePO.getInspectionId()));
                singleBO.setItemInfos((List)itemMap.get(singlePO.getInspectionId()));
                singleBO.setPurchaseProjectName((String)accountMap.get(singlePO.getPurchaseProjectId()));
                OrderStatus orderStatusEnum = OrderStatus.getInstance(singlePO.getOrderStatus());
                singleBO.setOrderStatusStr(this.enumsService.getDescr(orderStatusEnum));
                ReconciliationStatus reconciliationStatus = ReconciliationStatus.getInstance(singlePO.getReconcilitionStatus());
                singleBO.setReconcilitionStatusStr(this.enumsService.getDescr(reconciliationStatus));
                if (singleBO.getPurchaseProjectId() != null) {
                    singleBO.setPurchaseProjectName((String)accountMap.get(singlePO.getPurchaseProjectId()));
                }
                if (StringUtils.isNotEmpty((CharSequence)singlePO.getPayType())) {
                    singleBO.setPayTypeStr(SaleOrderPayType.getInstance(singlePO.getPayType()).getDescr());
                }
                if ("purchaser".equals(singlePO.getPayModel())) {
                    singleBO.setPayModelStr("\u91c7\u8d2d\u5458\u6a21\u5f0f");
                } else if ("settle".equals(singlePO.getPayModel())) {
                    singleBO.setPayModelStr("\u7ed3\u7b97\u5458\u6a21\u5f0f");
                }
                singleBO.setSourceDescr(Source.getInstance(singlePO.getSource()).getDescr());
                singleBO.setRecvName(singlePO.getRecvName());
                if ("00".equals(singlePO.getPayStatus())) {
                    singleBO.setPayStatusStr("\u672a\u4ed8\u6b3e");
                } else {
                    singleBO.setPayStatusStr(PayResultStatus.getInstance(singlePO.getPayStatus()).getCodeDescr());
                }
                if (singlePO.getActivityId() != null && activityMap.containsKey(singlePO.getActivityId())) {
                    singleBO.setActivityCode((String)activityMap.get(singlePO.getActivityId()));
                }
                boList.add(singleBO);
            }
        }
        if (null != (sumVO = this.payPurchaseOrderInfoMapper.sumPurchaseOrderInfo(vo))) {
            rspBO.setTotalAmt(sumVO.getOrderAmtCount());
        }
        vo.setReconciliationStatus("1");
        Integer reconOkCount = this.payPurchaseOrderInfoMapper.sumPurchaseOrderByReconciliation(vo);
        if (reconOkCount != null) {
            rspBO.setReconOkCount(reconOkCount);
        }
        vo.setReconciliationStatus("2");
        Integer reconDiffCount = this.payPurchaseOrderInfoMapper.sumPurchaseOrderByReconciliation(vo);
        if (reconDiffCount != null) {
            rspBO.setReconDiffCount(reconDiffCount);
        }
        vo.setReconciliationStatus("0");
        Integer reconFailCount = this.payPurchaseOrderInfoMapper.sumPurchaseOrderByReconciliation(vo);
        if (reconFailCount != null) {
            rspBO.setReconFailCount(reconFailCount);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTabIdList())) {
            BillNotificationInfoTab billNotificationInfoTab = new BillNotificationInfoTab();
            List<NotificationStatusCountVO> notificationStatusCountVOS = this.billNotificationInfoMapper.selectForPageAndTabCount(billNotificationInfoTab);
            HashMap<String, Integer> notificationStatusCountMap = new HashMap();
            if (!CollectionUtils.isEmpty(notificationStatusCountVOS)) {
                notificationStatusCountMap = notificationStatusCountVOS.stream().collect(Collectors.toMap(NotificationStatusCountVO::getNotificationStatus, NotificationStatusCountVO::getNum));
            }
            Map<String, ConfTabStatePO> tabInfoMap = this.getStateListOfConfTabAtomService.getStateList(reqBO.getTabIdList());
            Map<String, BusiTabNumbersQryBO> tabCountMap = this.transOrderTabInfo(notificationStatusCountMap, tabInfoMap);
            if (reqBO.getTabIdList().contains("5001")) {
                this.qryYyNotifyOrderCount("5001", tabCountMap, tabInfoMap, reqBO);
            } else if (reqBO.getTabIdList().contains(reqBO.getTabId())) {
                this.qryPurchaseCountOfFq(reqBO.getTabId(), tabCountMap, tabInfoMap, reqBO);
            }
            rspBO.setTabCountList(tabCountMap.values().stream().collect(Collectors.toList()));
        }
        rspBO.setRows(boList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    private Map<String, BusiTabNumbersQryBO> transOrderTabInfo(Map<String, Integer> notificationStatusCountMap, Map<String, ConfTabStatePO> tabInfoMap) {
        HashMap<String, BusiTabNumbersQryBO> tabCountMap = new HashMap<String, BusiTabNumbersQryBO>();
        for (Map.Entry<String, ConfTabStatePO> next : tabInfoMap.entrySet()) {
            if (next.getKey().equals("0")) continue;
            ConfTabStatePO tabOrdStatePO = next.getValue();
            BusiTabNumbersQryBO tabsNumberQueryBO = new BusiTabNumbersQryBO();
            tabsNumberQueryBO.setTabId(tabOrdStatePO.getTabId());
            tabsNumberQueryBO.setTabName(tabOrdStatePO.getTabName());
            int tabsCount = 0;
            for (String statue : tabOrdStatePO.getStatueList()) {
                Integer tabMapCounts = notificationStatusCountMap.get(String.valueOf(statue));
                if (tabMapCounts == null) continue;
                tabsCount += tabMapCounts.intValue();
            }
            tabsNumberQueryBO.setTabsCount(Integer.valueOf(tabsCount));
            tabCountMap.put(tabOrdStatePO.getTabId(), tabsNumberQueryBO);
        }
        return tabCountMap;
    }

    private void qryPurchaseCountOfFq(String tabId, Map<String, BusiTabNumbersQryBO> tabCountMap, Map<String, ConfTabStatePO> tabInfoMap, QueryPayPurchaseOrderInfoAwaitReqBO reqBO) {
        PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
        payPurchaseOrderInfoVO.setBusiModel("1");
        payPurchaseOrderInfoVO.setOrderStatusCodes(tabInfoMap.get(tabId).getStatueList());
        Integer orderCount = this.payPurchaseOrderInfoMapper.getPurchaseChCount(payPurchaseOrderInfoVO);
        BusiTabNumbersQryBO busiTabNumbersQryBO = new BusiTabNumbersQryBO();
        busiTabNumbersQryBO.setTabId(tabInfoMap.get(tabId).getTabId());
        busiTabNumbersQryBO.setTabName(tabInfoMap.get(tabId).getTabName());
        busiTabNumbersQryBO.setTabsCount(orderCount);
        tabCountMap.put(tabId, busiTabNumbersQryBO);
    }

    private void qryYyNotifyOrderCount(String tabId, Map<String, BusiTabNumbersQryBO> tabCountMap, Map<String, ConfTabStatePO> tabInfoMap, QueryPayPurchaseOrderInfoAwaitReqBO reqBO) {
        PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        payPurchaseOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
        payPurchaseOrderInfoVO.setBusiModel("0");
        payPurchaseOrderInfoVO.setOrderStatusCodes(tabInfoMap.get(tabId).getStatueList());
        Integer orderCount = this.payPurchaseOrderInfoMapper.getPurchaseChCount(payPurchaseOrderInfoVO);
        BusiTabNumbersQryBO busiTabNumbersQryBO = new BusiTabNumbersQryBO();
        busiTabNumbersQryBO.setTabId(tabInfoMap.get(tabId).getTabId());
        busiTabNumbersQryBO.setTabName(tabInfoMap.get(tabId).getTabName());
        busiTabNumbersQryBO.setTabsCount(orderCount);
        tabCountMap.put(tabId, busiTabNumbersQryBO);
    }
}

