/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.extend.ability.order.PebExtFscPayResultAbilityService;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.order.pec.ability.pay.UocPebUpdatePayStatusAbilityService;
import com.tydic.pfscext.api.busi.BusiAddCreditLineService;
import com.tydic.pfscext.api.busi.BusiPayResultModifyService;
import com.tydic.pfscext.api.busi.FscOrderPayStatusUpdateService;
import com.tydic.pfscext.api.busi.bo.AddCreditLineFscReqBo;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyRspBO;
import com.tydic.pfscext.api.busi.bo.FscOrderPayStatusUpdateReqBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiPayOfflineNotifyService;
import com.tydic.pfscext.service.notify.SSLClient;
import com.tydic.pfscext.utils.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiPayResultModifyService"})
public class BusiPayResultModifyServiceImpl
implements BusiPayResultModifyService {
    private static final Logger logger = LoggerFactory.getLogger(BusiPayResultModifyServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private UocPebUpdatePayStatusAbilityService uocPebUpdatePayStatusAbilityService;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PebExtFscPayResultAbilityService pebExtFscPayResultAbilityService;
    @Autowired
    private FscOrderPayStatusUpdateService fscOrderPayStatusUpdateService;
    @Autowired
    private BusiPayOfflineNotifyService busiPayOfflineNotifyService;
    @Autowired
    private BusiAddCreditLineService busiAddCreditLineService;
    @Value(value="${WRITE_OFF_TIME_STR}")
    private String writeOffTimeStr;
    private static final String SUCCESS = "SUCCESS";
    @Value(value="${PAY_OFFLINE_NOTIFY_URL}")
    private String offlineNotifyUrl;

    @PostMapping(value={"modifyResult"})
    public BusiPayResultModifyRspBO modifyResult(@RequestBody BusiPayResultModifyReqBO busiPayResultModifyReqBO) {
        logger.info("\u4ed8\u6b3e\u67e5\u8be2-\u786e\u8ba4\u7f34\u8d39\u72b6\u6001BO=" + busiPayResultModifyReqBO);
        BusiPayResultModifyRspBO resp = new BusiPayResultModifyRspBO();
        List payNos = busiPayResultModifyReqBO.getPayNos();
        if (payNos == null || payNos.size() == 0) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u5fc5\u987b\u8f93\u5165");
        }
        List statuss = busiPayResultModifyReqBO.getStatuss();
        for (String status : statuss) {
            PayResultStatus newStatus = PayResultStatus.getInstance(status);
            if (newStatus == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7ed3\u679c\u72b6\u6001\u4e0d\u5408\u6cd5");
            }
            if (newStatus == PayResultStatus.PAY_CONFIRMED) continue;
            throw new PfscExtBusinessException("0001", "\u53ea\u6709\uff1a" + PayResultStatus.PAY_CONFIRMED.getDescr() + "\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u624d\u80fd\uff0c\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e3a\uff1a" + newStatus.getDescr());
        }
        Date writeOffDate = DateUtil.strToDate(this.writeOffTimeStr, "yyyy-MM-dd HH:mm:ss");
        for (String payNo : payNos) {
            ApplyPayInfoPO applyPay = this.applyPayInfoMapper.getModelById(payNo);
            if (applyPay == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355" + payNo + "\u4e0d\u5b58\u5728");
            }
            List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payNo);
            int size = details.size();
            if (size == 0) {
                throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
            }
            logger.info("\u4ed8\u6b3e\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u7ed3\u679c,\u6d89\u53ca\u5e94\u4ed8\u5355\u6570\u91cf=" + size + ",\u4ed8\u6b3e\u5355\u53f7=" + payNo);
            ArrayList<String> payableNos = new ArrayList<String>();
            for (ApplyDetail applyDetail : details) {
                payableNos.add(applyDetail.getPayableNo());
            }
            Map<String, BigDecimal> amtMap = details.stream().collect(Collectors.toMap(ApplyDetail::getPayableNo, ApplyDetail::getAmt, (key1, key2) -> key2));
            if (!"0".equals(busiPayResultModifyReqBO.getSuccessOrFail())) {
                StringBuffer payNotifyTransId = new StringBuffer();
                payNotifyTransId.append(DateUtil.dateToStr(new Date(), "yyyyMMddHHmmss")).append(System.currentTimeMillis()).append((int)((Math.random() * 9.0 + 1.0) * Math.pow(10.0, 7.0)));
                applyPay.setPayStatus(PayResultStatus.SUCCESS.getCode());
                applyPay.setRemark(busiPayResultModifyReqBO.getRemark());
                applyPay.setPayChannel("3");
                applyPay.setSsn(payNotifyTransId.toString());
                this.applyPayInfoMapper.updateStatus(applyPay);
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                StringBuilder payOrderNo = new StringBuilder();
                payOrderNo.append("PAYMENT-").append(applyPay.getPayno());
                paymentFlowInfo.setOutOrderId(payOrderNo.toString());
                paymentFlowInfo.setPayTime(new Date());
                paymentFlowInfo.setPaymentStatus(SUCCESS);
                this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
                ApplyDetail applyDetail = new ApplyDetail();
                applyDetail.setApplyNo(payNo);
                applyDetail.setStatus(PayResultStatus.SUCCESS.getCode());
                this.applyDetailMapper.updateByApplyNo(applyDetail);
                PayableDetailVO payableDetailVO = new PayableDetailVO();
                payableDetailVO.setPayableNos(payableNos);
                List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectList(payableDetailVO);
                for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                    List<SaleOrderInfo> list;
                    PebExtPayResultRspBO pebExtPayResultRspBO;
                    PebExtPayResultReqBO pebExtPayResultReqBO;
                    ArrayList<String> nopId = new ArrayList<String>();
                    ArrayList orderIds = new ArrayList();
                    if (null != payableDetailPO) {
                        List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(payableDetailPO.getNotificationNo());
                        if (null != payPurchaseOrderInfoList && payPurchaseOrderInfoList.size() > 0) {
                            for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
                                payPurchaseOrderInfo.setPayType("01");
                                this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo);
                                if (!nopId.contains(payPurchaseOrderInfo.getNotificationNo())) {
                                    nopId.add(payPurchaseOrderInfo.getNotificationNo());
                                }
                                if (!"1".equals(payPurchaseOrderInfo.getBusiModel())) continue;
                                pebExtPayResultReqBO = new PebExtPayResultReqBO();
                                pebExtPayResultReqBO.setOrderId(payPurchaseOrderInfo.getOrderId().toString());
                                if (PayChannel.OFFLINE.getCode().equals(applyPay.getPayChannel())) {
                                    pebExtPayResultReqBO.setPayMethod("7");
                                } else {
                                    pebExtPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                                }
                                logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)pebExtPayResultReqBO));
                                pebExtPayResultRspBO = this.pebExtFscPayResultAbilityService.dealPayResult(pebExtPayResultReqBO);
                                if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                                logger.error("\u5e94\u4ed8\u5355\u56de\u8c03\u8ba2\u5355\u9519\u8bef,\u8ba2\u5355id:" + payPurchaseOrderInfo.getOrderId() + ",\u9519\u8bef\u4fe1\u606f" + pebExtPayResultRspBO.getResultMsg());
                            }
                        }
                        if (applyPay.getApplyDate().compareTo(writeOffDate) > 0) {
                            BigDecimal changeInfo;
                            AddCreditLineFscReqBo creditLineFscReqBo = new AddCreditLineFscReqBo();
                            creditLineFscReqBo.setChangeType("3");
                            BigDecimal bigDecimal = changeInfo = amtMap.get(payableDetailPO.getPayableNo()) == null ? BigDecimal.ZERO : amtMap.get(payableDetailPO.getPayableNo());
                            if (payableDetailPO.getOverduePenalty() != null && payableDetailPO.getApproveResult() != null && 1 != payableDetailPO.getApproveResult()) {
                                changeInfo = changeInfo.subtract(payableDetailPO.getOverduePenalty());
                            }
                            creditLineFscReqBo.setChangeInfo(changeInfo);
                            creditLineFscReqBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
                            if (payableDetailPO.getPayableType() == 1 && 1 == payableDetailPO.getBusiModel()) {
                                String notificationNo = payableDetailPO.getNotificationNo();
                                List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
                                for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                                    creditLineFscReqBo.setOrderCode(String.valueOf(payPurchaseOrderInfo.getPurchaseOrderCode()));
                                    this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
                                }
                            } else if (payableDetailPO.getPayableType() == 6) {
                                String applyNo = payableDetailPO.getApplyNo();
                                List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
                                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                                    creditLineFscReqBo.setOrderCode(String.valueOf(saleOrderInfo.getSaleOrderCode()));
                                    this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
                                }
                            } else if (payableDetailPO.getPayableType() == 2 || payableDetailPO.getPayableType() == 3 || payableDetailPO.getPayableType() == 5) {
                                creditLineFscReqBo.setOrderCode(payableDetailPO.getPurchaseOrderCode());
                                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
                            }
                        }
                    }
                    if (null != payableDetailPO.getApplyNo() && !"".equals(payableDetailPO.getApplyNo()) && null != (list = this.saleOrderInfoMapper.getSaleOrderListByApplyNo(payableDetailPO.getApplyNo())) && !list.isEmpty()) {
                        for (SaleOrderInfo saleOrderInfo : list) {
                            pebExtPayResultReqBO = new PebExtPayResultReqBO();
                            pebExtPayResultReqBO.setOrderId(saleOrderInfo.getOrderId().toString());
                            if (PayChannel.OFFLINE.getCode().equals(applyPay.getPayChannel())) {
                                pebExtPayResultReqBO.setPayMethod("7");
                            } else {
                                pebExtPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                            }
                            logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)pebExtPayResultReqBO));
                            pebExtPayResultRspBO = this.pebExtFscPayResultAbilityService.dealPayResult(pebExtPayResultReqBO);
                            if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                            logger.error("\u5e94\u4ed8\u5355\u56de\u8c03\u8ba2\u5355\u9519\u8bef,\u8ba2\u5355id\uff1a" + saleOrderInfo.getOrderId() + ",\u9519\u8bef\u4fe1\u606f" + pebExtPayResultRspBO.getResultMsg());
                        }
                        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                        saleOrderInfo.setApplyNo(payableDetailPO.getApplyNo());
                        saleOrderInfo.setPayStatus(PayableStatus.SUCCESS.getCode());
                        this.saleOrderInfoMapper.updateByApplyNo(saleOrderInfo);
                    }
                    if (null != payableDetailPO && StringUtils.isBlank((CharSequence)payableDetailPO.getApplyNo()) && StringUtils.isBlank((CharSequence)payableDetailPO.getNotificationNo())) {
                        PebExtPayResultReqBO extPayResultReqBO = new PebExtPayResultReqBO();
                        extPayResultReqBO.setPayableNos(payableNos);
                        ArrayList orders = new ArrayList();
                        orders.add(payableDetailPO.getOrderId());
                        payableDetailPO.setOrderIdList(orders);
                        List<PayableDetailPO> payableDetailPOS1 = this.payableDetailMapper.querysumAmtByOrderId(payableDetailPO);
                        PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByOrderCodeRefund(payableDetailPO.getPurchaseOrderCode());
                        logger.info("\u8ba1\u7b97\u9000\u6b3e" + paymentFlowInfo1);
                        logger.info("\u6253\u5370payableAmt=" + payableDetailPOS1.get(0).getPayableAmt());
                        logger.info("totalFee" + extPayResultReqBO.getTotalFee());
                        extPayResultReqBO.setTotalFee(payableDetailPOS1.get(0).getPayableAmt().subtract(paymentFlowInfo1 == null ? BigDecimal.ZERO : paymentFlowInfo1.getOrderAmt()).toString());
                        logger.info("totalFee\u8bbe\u7f6e\u4ee5\u540e" + extPayResultReqBO.getTotalFee());
                        extPayResultReqBO.setOrderId(null != payableDetailPO.getOrderId() ? payableDetailPO.getOrderId().toString() : null);
                        if (PayChannel.OFFLINE.getCode().equals(applyPay.getPayChannel())) {
                            extPayResultReqBO.setPayMethod("7");
                        } else {
                            extPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                        }
                        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO);
                        pebExtPayResultRspBO = this.pebExtFscPayResultAbilityService.dealPayResult(extPayResultReqBO);
                        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                        if (pebExtPayResultRspBO == null || !SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) {
                            logger.error("\u5e94\u4ed8\u5355\u56de\u8c03\u8ba2\u5355\u9519\u8bef,\u8ba2\u5355id:" + payableDetailPO.getOrderId() + ",\u9519\u8bef\u4fe1\u606f" + pebExtPayResultRspBO.getResultMsg());
                        }
                    }
                    if (!nopId.isEmpty()) {
                        this.billNotificationInfoMapper.updatePayStatus(nopId, 2);
                    }
                    ArrayList<String> payAbleNos = new ArrayList<String>();
                    for (ApplyDetail apply : details) {
                        payAbleNos.add(apply.getPayableNo());
                    }
                    if (!payAbleNos.isEmpty()) {
                        String status = PayableStatus.PAYING.getCode();
                        BigDecimal ingAmt = payableDetailPO.getPendingAmt();
                        if (payableDetailPO.getPaidAmt() != null) {
                            ingAmt = payableDetailPO.getPaidAmt().add(payableDetailPO.getPendingAmt());
                        }
                        if (ingAmt.compareTo(payableDetailPO.getPayableAmt()) >= 0) {
                            status = PayableStatus.SUCCESS.getCode();
                        }
                        this.payableDetailMapper.updateAmtByNOs(payAbleNos, status);
                    }
                    if (null == payableDetailPO.getOrderId()) continue;
                    FscOrderPayStatusUpdateReqBO reqBO = new FscOrderPayStatusUpdateReqBO();
                    reqBO.setOrderId(payableDetailPO.getOrderId());
                    this.fscOrderPayStatusUpdateService.updateOrderPayStatus(reqBO);
                }
                PaymentFlowInfo paymentFlowInfoQry = this.paymentFlowInfoMapper.selectByOutOrderId("PAYMENT-" + payNo);
                if (paymentFlowInfoQry != null && !StringUtils.isEmpty((CharSequence)paymentFlowInfoQry.getPayOrderId())) {
                    String transDate = DateUtil.dateToStr(new Date(), "yyyyMMddHHmmss");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("tradeTime", transDate);
                    map.put("payNotifyTransId", payNotifyTransId.toString());
                    map.put("payOrderId", paymentFlowInfoQry.getPayOrderId());
                    try {
                        logger.info("\u7ebf\u4e0b\u652f\u4ed8\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString(map) + ",\u8c03\u7528\u5730\u5740\uff1a" + this.offlineNotifyUrl);
                        String returnStr = SSLClient.doPost(this.offlineNotifyUrl, map, null);
                        logger.info("\u7ebf\u4e0b\u652f\u4ed8\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u51fa\u53c2\uff1a" + returnStr);
                    }
                    catch (Exception e) {
                        logger.error("\u7ebf\u4e0b\u652f\u4ed8\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            if (!"0".equals(busiPayResultModifyReqBO.getSuccessOrFail())) continue;
            applyPay.setPayStatus(PayResultStatus.PAY_FAILED.getCode());
            if (StringUtils.isEmpty((CharSequence)busiPayResultModifyReqBO.getRejectReason().trim())) {
                throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546\u6838\u9500\u5931\u8d25\uff0c\u9000\u56de\u539f\u56e0\u5fc5\u586b");
            }
            applyPay.setRejectReason(busiPayResultModifyReqBO.getRejectReason());
            this.applyPayInfoMapper.updateStatus(applyPay);
            PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
            StringBuilder payOrderNo = new StringBuilder();
            payOrderNo.append("PAYMENT-").append(applyPay.getPayno());
            paymentFlowInfo.setOutOrderId(payOrderNo.toString());
            paymentFlowInfo.setPayTime(new Date());
            paymentFlowInfo.setPaymentStatus("PAY_FAILED");
            this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payNo);
            applyDetail.setStatus(PayResultStatus.PAY_FAILED.getCode());
            this.applyDetailMapper.updateByApplyNo(applyDetail);
            for (ApplyDetail detail : details) {
                PayableDetailPO payableDetailPO = new PayableDetailPO();
                payableDetailPO.setPayableNo(detail.getPayableNo());
                payableDetailPO.setPendingAmt(detail.getAmt());
                this.payableDetailMapper.updatePayModifyFailed(payableDetailPO);
            }
            if (applyPay.getApplyDate().compareTo(writeOffDate) >= 0) continue;
            PayableDetailVO payableDetailVO = new PayableDetailVO();
            payableDetailVO.setPayableNos(payableNos);
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectList(payableDetailVO);
            for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                BigDecimal changeInfo;
                AddCreditLineFscReqBo creditLineFscReqBo = new AddCreditLineFscReqBo();
                creditLineFscReqBo.setChangeType("4");
                BigDecimal bigDecimal = changeInfo = amtMap.get(payableDetailPO.getPayableNo()) == null ? BigDecimal.ZERO : amtMap.get(payableDetailPO.getPayableNo());
                if (payableDetailPO.getOverduePenalty() != null && payableDetailPO.getApproveResult() != null && 1 != payableDetailPO.getApproveResult()) {
                    changeInfo = changeInfo.subtract(payableDetailPO.getOverduePenalty());
                }
                creditLineFscReqBo.setChangeInfo(changeInfo);
                creditLineFscReqBo.setPayApplyCode(String.valueOf(applyPay.getPayno()));
                if (payableDetailPO.getPayableType() == 1 && 1 == payableDetailPO.getBusiModel()) {
                    String notificationNo = payableDetailPO.getNotificationNo();
                    List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
                    for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                        creditLineFscReqBo.setOrderCode(String.valueOf(payPurchaseOrderInfo.getPurchaseOrderCode()));
                        this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
                    }
                    continue;
                }
                if (payableDetailPO.getPayableType() == 6) {
                    String applyNo = payableDetailPO.getApplyNo();
                    List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
                    for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                        creditLineFscReqBo.setOrderCode(String.valueOf(saleOrderInfo.getSaleOrderCode()));
                        this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
                    }
                    continue;
                }
                if (payableDetailPO.getPayableType() != 2 && payableDetailPO.getPayableType() != 3 && payableDetailPO.getPayableType() != 5) continue;
                creditLineFscReqBo.setOrderCode(payableDetailPO.getPurchaseOrderCode());
                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
            }
        }
        resp.setRespCode("0000");
        return resp;
    }
}

