/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.ActQryActiveListAbilityService;
import com.tydic.active.app.ability.bo.ActQryActiveListAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQryActiveListAbilityRspBO;
import com.tydic.active.app.common.bo.ActivitiesBO;
import com.tydic.pfscext.api.busi.BusiQrySupNotificationInfoListService;
import com.tydic.pfscext.api.busi.bo.BusiQrySupNotificationInfoListReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQrySupNotificationInfoListRspBO;
import com.tydic.pfscext.api.busi.bo.BusiTabNumbersQryBO;
import com.tydic.pfscext.api.busi.vo.ActivityInfoVO;
import com.tydic.pfscext.api.busi.vo.NotificationInfoTabVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.bo.BillNotificationInfoTab;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.vo.NotificationStatusCountVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.Source;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.GetStateListOfConfTabAtomService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.BusinessUtils;
import com.tydic.umc.ability.bo.UmcQryOrgNameBySupplierIdOrOrgIdServiceReqBO;
import com.tydic.umc.ability.bo.UmcQryOrgNameBySupplierIdOrOrgIdServiceRspBO;
import com.tydic.umc.ability.org.UmcQryOrgNameBySupplierIdOrOrgIdAbilityService;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgQueryAbilityReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQrySupNotificationInfoListService"})
public class BusiQrySupNotificationInfoListServiceImpl
implements BusiQrySupNotificationInfoListService {
    private static final Logger log = LoggerFactory.getLogger(BusiQrySupNotificationInfoListServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private GetStateListOfConfTabAtomService getStateListOfConfTabAtomService;
    @Autowired
    private ActQryActiveListAbilityService actQryActiveListAbilityService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UmcQryOrgNameBySupplierIdOrOrgIdAbilityService umcQryOrgNameService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @PostMapping(value={"qryTabNotificationList"})
    public BusiQrySupNotificationInfoListRspBO qryTabNotificationList(@RequestBody BusiQrySupNotificationInfoListReqBO reqBO) {
        BusiQrySupNotificationInfoListRspBO rspBO = new BusiQrySupNotificationInfoListRspBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5217\u8868\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getTabId())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5217\u8868\u670d\u52a1\u5165\u53c2[TabId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getTabIdList())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5217\u8868\u670d\u52a1\u5165\u53c2[TabIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBO.getSupId()) {
            reqBO.setOperUnitNo(null);
        } else {
            Long operUnitNo = reqBO.getOperUnitNo();
            operUnitNo = BusinessUtils.judgeOperUnitNo(operUnitNo, reqBO.getCompanyId(), false);
            reqBO.setOperUnitNo(operUnitNo);
        }
        Long purchaserId = null;
        if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
            JSONObject json;
            String settleModel;
            String extJson;
            UmcZhEnterpriseOrgQueryAbilityReqBO umcZhEnterpriseOrgQueryAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
            umcZhEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(reqBO.getCompanyId());
            UmcZhEnterpriseOrgDetailAbilityRspBO umcZhEnterpriseOrgDetailAbilityRspBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcZhEnterpriseOrgQueryAbilityReqBO);
            if ("0000".equals(umcZhEnterpriseOrgDetailAbilityRspBO.getRespCode()) && null != umcZhEnterpriseOrgDetailAbilityRspBO && null != umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO() && null != (extJson = umcZhEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO().getExtJson()) && !"".equals(extJson) && "purchaser".equals(settleModel = (json = JSON.parseObject((String)extJson)).getString("settleModel"))) {
                purchaserId = reqBO.getUserId();
            }
            if (reqBO.getTicketUserId() == null) {
                reqBO.setTicketUserId(purchaserId);
            }
        }
        if ("2".equals(reqBO.getQryFlag()) && null == reqBO.getSupplierNo()) {
            reqBO.setSupplierNo(reqBO.getCompanyId());
            reqBO.setOperUnitNo(null);
            reqBO.setTicketUserId(null);
        }
        BillNotificationInfoTab billNotificationInfoTab = new BillNotificationInfoTab();
        BeanUtils.copyProperties((Object)reqBO, (Object)billNotificationInfoTab);
        billNotificationInfoTab.setInvoiceStatusList(this.getStateListOfConfTabAtomService.getStateList(Collections.singletonList(reqBO.getTabId())).get(reqBO.getTabId()).getStatueList());
        String orderBy = " APPLY_DATE desc,NOTIFICATION_NO desc";
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        List<NotificationInfoTabVO> notificationInfoTabVOS = this.billNotificationInfoMapper.selectForPageAndTab(billNotificationInfoTab, (Page<Map<String, Object>>)page, orderBy);
        ArrayList activityIds = new ArrayList();
        for (NotificationInfoTabVO info : notificationInfoTabVOS) {
            List<ActivityInfoVO> activityList;
            if (StringUtils.isEmpty((CharSequence)info.getOrderId()) || CollectionUtils.isEmpty(activityList = this.billNotificationInfoMapper.getListActivity(info.getOrderId()))) continue;
            info.setActivityList(activityList);
            activityList.forEach(item -> {
                if (item.getActivityId() != null) {
                    activityIds.add(item.getActivityId());
                }
            });
        }
        HashMap<Long, String> activityMap = new HashMap<Long, String>();
        if (!CollectionUtils.isEmpty(activityIds)) {
            ActQryActiveListAbilityReqBO actQryActiveListAbilityReqBO = new ActQryActiveListAbilityReqBO();
            actQryActiveListAbilityReqBO.setActiveIds(activityIds);
            ActQryActiveListAbilityRspBO actQryActiveListAbilityRspBO = this.actQryActiveListAbilityService.qryActiveList(actQryActiveListAbilityReqBO);
            if (actQryActiveListAbilityRspBO != null && !CollectionUtils.isEmpty((Collection)actQryActiveListAbilityRspBO.getRows())) {
                for (ActivitiesBO activitiesBO : actQryActiveListAbilityRspBO.getRows()) {
                    activityMap.put(activitiesBO.getActiveId(), activitiesBO.getActiveCode());
                }
            }
        }
        for (NotificationInfoTabVO notifyInfo : notificationInfoTabVOS) {
            NotificationInvoiceStatus notifInvoiceEnum = NotificationInvoiceStatus.getInstance(notifyInfo.getInvoiceStatus());
            if (notifInvoiceEnum != null) {
                notifyInfo.setInvoiceStatusDescr(this.enumsService.getDescr(notifInvoiceEnum));
            } else {
                notifyInfo.setInvoiceStatusDescr(notifyInfo.getInvoiceStatus());
            }
            InvoiceType invoiceTypeEnum = InvoiceType.getInstance(notifyInfo.getInvoceType());
            notifyInfo.setInvoceTypeStr(this.enumsService.getDescr(invoiceTypeEnum));
            if (!StringUtils.isEmpty((CharSequence)notifyInfo.getSource())) {
                Source source = Source.getInstance(notifyInfo.getSource());
                notifyInfo.setSourceDescr(this.enumsService.getDescr(source));
            }
            if (null != notifyInfo.getSource() && !"".equals(notifyInfo.getSource()) && "3".equals(notifyInfo.getSource())) {
                UmcQryOrgNameBySupplierIdOrOrgIdServiceReqBO umcReqBO = new UmcQryOrgNameBySupplierIdOrOrgIdServiceReqBO();
                umcReqBO.setId(notifyInfo.getSupplierNo());
                UmcQryOrgNameBySupplierIdOrOrgIdServiceRspBO umcRspBo = this.umcQryOrgNameService.qryOrgNameBySupplierIdOrOrgId(umcReqBO);
                log.info("\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u673a\u6784\u6216\u4f9b\u5e94\u5546\u540d\u79f0\u51fa\u53c2:" + JSON.toJSONString((Object)umcRspBo));
                notifyInfo.setSupplierName(umcRspBo.getName());
            } else {
                String supplierStr = this.organizationInfoService.querySupplierName(notifyInfo.getSupplierNo());
                notifyInfo.setSupplierName(supplierStr);
            }
            if (!CollectionUtils.isEmpty((Collection)notifyInfo.getActivityList())) {
                notifyInfo.getActivityList().forEach(item -> {
                    if (activityMap.containsKey(item.getActivityId())) {
                        item.setActivityCode((String)activityMap.get(item.getActivityId()));
                    }
                });
                notifyInfo.setActivityList(notifyInfo.getActivityList());
                continue;
            }
            notifyInfo.setActivityList(new ArrayList());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTabIdList())) {
            billNotificationInfoTab.setInvoiceStatusList(null);
            List<NotificationStatusCountVO> notificationStatusCountVOS = this.billNotificationInfoMapper.selectForPageAndTabCount(billNotificationInfoTab);
            HashMap<String, Integer> notificationStatusCountMap = new HashMap();
            if (!CollectionUtils.isEmpty(notificationStatusCountVOS)) {
                notificationStatusCountMap = notificationStatusCountVOS.stream().collect(Collectors.toMap(NotificationStatusCountVO::getNotificationStatus, NotificationStatusCountVO::getNum));
            }
            Map<String, ConfTabStatePO> tabInfoMap = this.getStateListOfConfTabAtomService.getStateList(reqBO.getTabIdList());
            Map<String, BusiTabNumbersQryBO> tabCountMap = this.transOrderTabInfo(notificationStatusCountMap, tabInfoMap);
            if (reqBO.getTabIdList().contains("1001")) {
                this.qryPurchaseCountOfFq("1001", tabCountMap, tabInfoMap, reqBO);
            } else if (reqBO.getTabIdList().contains("4001")) {
                this.qryRywzCgOrderCount("4001", tabCountMap, tabInfoMap, reqBO);
            } else if (reqBO.getTabIdList().contains("4002")) {
                this.qryRywzCzOrderCount("4002", tabCountMap, tabInfoMap, reqBO);
            } else if (reqBO.getTabIdList().contains("5001")) {
                this.qryYyNotifyOrderCount("5001", tabCountMap, tabInfoMap, reqBO);
            }
            rspBO.setTabCountList(tabCountMap.values().stream().collect(Collectors.toList()));
        }
        rspBO.setRows(notificationInfoTabVOS);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u6210\u529f");
        return rspBO;
    }

    private Map<String, BusiTabNumbersQryBO> transOrderTabInfo(Map<String, Integer> notificationStatusCountMap, Map<String, ConfTabStatePO> tabInfoMap) {
        HashMap<String, BusiTabNumbersQryBO> tabCountMap = new HashMap<String, BusiTabNumbersQryBO>();
        for (Map.Entry<String, ConfTabStatePO> next : tabInfoMap.entrySet()) {
            if (next.getKey().equals("0")) continue;
            ConfTabStatePO tabOrdStatePO = next.getValue();
            BusiTabNumbersQryBO tabsNumberQueryBO = new BusiTabNumbersQryBO();
            tabsNumberQueryBO.setTabId(tabOrdStatePO.getTabId());
            tabsNumberQueryBO.setTabName(tabOrdStatePO.getTabName());
            int tabsCount = 0;
            for (String statue : tabOrdStatePO.getStatueList()) {
                Integer tabMapCounts = notificationStatusCountMap.get(String.valueOf(statue));
                if (tabMapCounts == null) continue;
                tabsCount += tabMapCounts.intValue();
            }
            tabsNumberQueryBO.setTabsCount(Integer.valueOf(tabsCount));
            tabCountMap.put(tabOrdStatePO.getTabId(), tabsNumberQueryBO);
        }
        return tabCountMap;
    }

    private void qryPurchaseCountOfFq(String tabId, Map<String, BusiTabNumbersQryBO> tabCountMap, Map<String, ConfTabStatePO> tabInfoMap, BusiQrySupNotificationInfoListReqBO reqBO) {
        PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
        payPurchaseOrderInfoVO.setBusiModel("1");
        payPurchaseOrderInfoVO.setOrderStatusCodes(tabInfoMap.get(tabId).getStatueList());
        Integer orderCount = this.payPurchaseOrderInfoMapper.getPurchaseChCount(payPurchaseOrderInfoVO);
        BusiTabNumbersQryBO busiTabNumbersQryBO = new BusiTabNumbersQryBO();
        busiTabNumbersQryBO.setTabId(tabInfoMap.get(tabId).getTabId());
        busiTabNumbersQryBO.setTabName(tabInfoMap.get(tabId).getTabName());
        busiTabNumbersQryBO.setTabsCount(orderCount);
        tabCountMap.put(tabId, busiTabNumbersQryBO);
    }

    private void qryRywzCgOrderCount(String tabId, Map<String, BusiTabNumbersQryBO> tabCountMap, Map<String, ConfTabStatePO> tabInfoMap, BusiQrySupNotificationInfoListReqBO reqBO) {
        PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
        payPurchaseOrderInfoVO.setBusiModel("1");
        payPurchaseOrderInfoVO.setSource("3");
        payPurchaseOrderInfoVO.setOrderStatusCodes(tabInfoMap.get(tabId).getStatueList());
        Integer orderCount = this.payPurchaseOrderInfoMapper.getPurchaseChCount(payPurchaseOrderInfoVO);
        BusiTabNumbersQryBO busiTabNumbersQryBO = new BusiTabNumbersQryBO();
        busiTabNumbersQryBO.setTabId(tabInfoMap.get(tabId).getTabId());
        busiTabNumbersQryBO.setTabName(tabInfoMap.get(tabId).getTabName());
        busiTabNumbersQryBO.setTabsCount(orderCount);
        tabCountMap.put(tabId, busiTabNumbersQryBO);
    }

    private void qryRywzCzOrderCount(String tabId, Map<String, BusiTabNumbersQryBO> tabCountMap, Map<String, ConfTabStatePO> tabInfoMap, BusiQrySupNotificationInfoListReqBO reqBO) {
        PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        payPurchaseOrderInfoVO.setSupplierNo(reqBO.getCompanyId());
        payPurchaseOrderInfoVO.setBusiModel("1");
        payPurchaseOrderInfoVO.setSource("3");
        payPurchaseOrderInfoVO.setOrderStatusCodes(tabInfoMap.get(tabId).getStatueList());
        Integer orderCount = this.payPurchaseOrderInfoMapper.getPurchaseChCount(payPurchaseOrderInfoVO);
        BusiTabNumbersQryBO busiTabNumbersQryBO = new BusiTabNumbersQryBO();
        busiTabNumbersQryBO.setTabId(tabInfoMap.get(tabId).getTabId());
        busiTabNumbersQryBO.setTabName(tabInfoMap.get(tabId).getTabName());
        busiTabNumbersQryBO.setTabsCount(orderCount);
        tabCountMap.put(tabId, busiTabNumbersQryBO);
    }

    private void qryYyNotifyOrderCount(String tabId, Map<String, BusiTabNumbersQryBO> tabCountMap, Map<String, ConfTabStatePO> tabInfoMap, BusiQrySupNotificationInfoListReqBO reqBO) {
        PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        payPurchaseOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
        payPurchaseOrderInfoVO.setBusiModel("0");
        payPurchaseOrderInfoVO.setOrderStatusCodes(tabInfoMap.get(tabId).getStatueList());
        Integer orderCount = this.payPurchaseOrderInfoMapper.getPurchaseChCount(payPurchaseOrderInfoVO);
        BusiTabNumbersQryBO busiTabNumbersQryBO = new BusiTabNumbersQryBO();
        busiTabNumbersQryBO.setTabId(tabInfoMap.get(tabId).getTabId());
        busiTabNumbersQryBO.setTabName(tabInfoMap.get(tabId).getTabName());
        busiTabNumbersQryBO.setTabsCount(orderCount);
        tabCountMap.put(tabId, busiTabNumbersQryBO);
    }
}

