/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.aisino.BusiBillDownloadService;
import com.tydic.pfscext.api.aisino.BusiBillDownloadZPService;
import com.tydic.pfscext.api.aisino.bo.BusiBillDownloadReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiBillDownloadRspBO;
import com.tydic.pfscext.api.busi.BusiReGetApplyInvoiceService;
import com.tydic.pfscext.api.busi.bo.BusiRegetApplyInvoiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiRegetApplyInvoiceRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillChildApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiReGetApplyInvoiceService"})
public class BusiReGetApplyInvoiceServiceImpl
implements BusiReGetApplyInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(BusiReGetApplyInvoiceServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private BillChildApplyInfoMapper billChildApplyInfoMapper;
    @Autowired
    private BusiBillDownloadService busiBillDownloadService;
    @Autowired
    private BusiBillDownloadZPService busiBillDownloadZPService;

    @PostMapping(value={"updateGetInvoice"})
    public BusiRegetApplyInvoiceRspBO updateGetInvoice(@RequestBody BusiRegetApplyInvoiceReqBO reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getApplyNos())) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55");
        }
        List applyNos = reqBo.getApplyNos();
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNos);
        List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getList(billApplyInfoVO);
        if (!CollectionUtils.isEmpty(billApplyInfoList)) {
            for (BillApplyInfo billApplyInfo : billApplyInfoList) {
                if (BillStatus.SEND_BILL.getCode().equals(billApplyInfo.getBillStatus()) || BillStatus.SENDING_BILL.getCode().equals(billApplyInfo.getBillStatus()) || BillStatus.PART_BILL.getCode().equals(billApplyInfo.getBillStatus())) continue;
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u7684\u72b6\u6001\u5fc5\u987b\u662f\u5f00\u7968\u4e2d\u3001\u5df2\u5f00\u7968\u6216\u90e8\u5206\u5f00\u7968");
            }
        }
        for (BillApplyInfo billApplyInfo : billApplyInfoList) {
            BusiBillDownloadRspBO busiBillDownloadRspBO;
            BusiBillDownloadReqBO busiBillDownloadReqBO;
            if ("1".equals(billApplyInfo.getInvoiceType())) {
                busiBillDownloadReqBO = new BusiBillDownloadReqBO();
                busiBillDownloadReqBO.setApplyNo(billApplyInfo.getApplyNo());
                busiBillDownloadRspBO = this.busiBillDownloadService.billDownloadExternal(busiBillDownloadReqBO);
                if ("0000".equals(busiBillDownloadRspBO.getRespCode())) continue;
                log.error("\u4e0b\u6e38\u7535\u7968\u91cd\u65b0\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff0c\u7533\u8bf7\u5355\u53f7[" + billApplyInfo.getApplyNo() + "], \u5f02\u5e38\uff1a" + busiBillDownloadRspBO.getRespDesc());
                continue;
            }
            if (!"2".equals(billApplyInfo.getInvoiceType())) continue;
            busiBillDownloadReqBO = new BusiBillDownloadReqBO();
            busiBillDownloadReqBO.setApplyNo(billApplyInfo.getApplyNo());
            busiBillDownloadRspBO = this.busiBillDownloadZPService.billDownloadExternal(busiBillDownloadReqBO);
            if ("0000".equals(busiBillDownloadRspBO.getRespCode())) continue;
            log.error("\u4e0b\u6e38\u7eb8\u7968\u91cd\u65b0\u83b7\u53d6\u53d1\u7968\u5931\u8d25\uff0c\u7533\u8bf7\u5355\u53f7[" + billApplyInfo.getApplyNo() + "], \u5f02\u5e38\uff1a" + busiBillDownloadRspBO.getRespDesc());
        }
        BusiRegetApplyInvoiceRspBO rspBO = new BusiRegetApplyInvoiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u91cd\u65b0\u83b7\u53d6\u5f00\u7968\u6570\u636e\u6210\u529f");
        return rspBO;
    }
}

