/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.extend.ability.order.PebExtPayFscRefundAbilityService;
import com.tydic.order.extend.bo.order.PebExtPayRefundReqBO;
import com.tydic.order.extend.bo.order.PebExtPayRefundRspBO;
import com.tydic.pfscext.api.busi.BusiUpdateRefundFlowService;
import com.tydic.pfscext.api.busi.bo.BusiRefundFlowRepBO;
import com.tydic.pfscext.api.busi.bo.BusiRefundFlowRsqBO;
import com.tydic.pfscext.api.busi.bo.PaymentFlowInfoExtJsonBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.enums.PayFlowPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiUpdateRefundFlowService"})
public class BusiUpdateRefundFlowServiceImpl
implements BusiUpdateRefundFlowService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiUpdateRefundFlowServiceImpl.class);
    private static final String PAYMENT_STATUS = "SUCCESS";
    private static final String SUCCESS_STATUS = "SUCCESS";
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PebExtPayFscRefundAbilityService pebExtPayFscRefundAbilityService;

    @PostMapping(value={"updateRefundFlow"})
    public BusiRefundFlowRsqBO updateRefundFlow(@RequestBody BusiRefundFlowRepBO reqBO) {
        BusiRefundFlowRsqBO busiRefundFlowRsqBO = new BusiRefundFlowRsqBO();
        if (null == reqBO) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getRefundFlowNo())) {
            throw new PfscExtBusinessException("18000", "\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSeq()) {
            throw new PfscExtBusinessException("18000", "\u5728\u7ebf\u652f\u4ed8\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setSeq(reqBO.getSeq());
        paymentFlowInfo.setPaymentFlowId(reqBO.getRefundFlowNo());
        paymentFlowInfo.setPayTime(new Date());
        paymentFlowInfo.setPaymentStatus("SUCCESS");
        int i = this.paymentFlowInfoMapper.updateByPrimaryKeySelective(paymentFlowInfo);
        if (i < 1) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u5728\u7ebf\u652f\u4ed8\u6d41\u6c34\u5931\u8d25");
        }
        PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByPrimaryKey(reqBO.getSeq());
        PaymentFlowInfoExtJsonBO paymentFlowInfoExtJsonBO = (PaymentFlowInfoExtJsonBO)JSON.parseObject((String)paymentFlowInfo1.getExtJson(), PaymentFlowInfoExtJsonBO.class);
        PaymentFlowInfo flowInfo = this.paymentFlowInfoMapper.selectRefundAmtBySn(paymentFlowInfoExtJsonBO.getOutRefundOrderSn());
        if (flowInfo.getOrderAmt().compareTo(paymentFlowInfoExtJsonBO.getRefundAmt()) == 0) {
            PebExtPayRefundReqBO pebExtPayRefundReqBO = new PebExtPayRefundReqBO();
            BeanUtils.copyProperties((Object)paymentFlowInfo1, (Object)pebExtPayRefundReqBO);
            pebExtPayRefundReqBO.setResultCode("SUCCESS");
            pebExtPayRefundReqBO.setPayMethod(PayFlowPayType.PAY_TYPE_30.getCode());
            pebExtPayRefundReqBO.setRealFee(flowInfo.getOrderAmt().toString());
            pebExtPayRefundReqBO.setTotalFee(flowInfo.getOrderAmt().toString());
            pebExtPayRefundReqBO.setTradeTime(DateUtil.dateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
            List<ApplyDetail> applyDetails = this.applyDetailMapper.getListByOutRefundOrderSn(paymentFlowInfoExtJsonBO.getOutRefundOrderSn());
            ArrayList payableNos = new ArrayList();
            applyDetails.forEach(apply -> payableNos.add(apply.getPayableNo()));
            pebExtPayRefundReqBO.setPayableNos(payableNos);
            pebExtPayRefundReqBO.setOutOrderId(paymentFlowInfoExtJsonBO.getOutRefundOrderSn());
            LOGGER.info("\u8c03\u7528\u8ba2\u5355\u9000\u6b3e\u5b8c\u6210\u4e2d\u5fc3\u670d\u52a1\uff1a \u5165\u53c2" + pebExtPayRefundReqBO);
            PebExtPayRefundRspBO pebExtPayRefundRspBO = this.pebExtPayFscRefundAbilityService.dealPayResult(pebExtPayRefundReqBO);
            LOGGER.info("\u8c03\u7528\u8ba2\u5355\u9000\u6b3e\u5b8c\u6210\u4e2d\u5fc3\u670d\u52a1\uff1a \u51fa\u53c2" + pebExtPayRefundRspBO);
            if (pebExtPayRefundRspBO != null && "SUCCESS".equals(pebExtPayRefundRspBO.getResultCode())) {
                busiRefundFlowRsqBO.setRespCode("SUCCESS");
            } else {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u8bb0");
            }
        }
        return busiRefundFlowRsqBO;
    }
}

