/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryPayPurchaseOrderInfoTradeService;
import com.tydic.pfscext.api.busi.bo.BusiTabNumbersQryBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoAwaitReqBO;
import com.tydic.pfscext.api.busi.bo.QuerySaleOrderInfoAwaitRspBO;
import com.tydic.pfscext.api.busi.bo.SaleOrderInfoBO;
import com.tydic.pfscext.api.busi.vo.PayItemInfoExtVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.bo.BillNotificationInfoTab;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.NotificationStatusCountVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderSumVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoQueryVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.enums.Source;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.GetStateListOfConfTabAtomService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import com.tydic.pfscext.utils.FscCommonUtils;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountListAbilityService;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryPayPurchaseOrderInfoTradeService"})
public class QueryPayPurchaseOrderInfoTradeServiceImpl
implements QueryPayPurchaseOrderInfoTradeService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayPurchaseOrderInfoTradeServiceImpl.class);
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private GetStateListOfConfTabAtomService getStateListOfConfTabAtomService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;

    @PostMapping(value={"queryTradeAwaitListPage"})
    public QuerySaleOrderInfoAwaitRspBO queryTradeAwaitListPage(@RequestBody QueryPayPurchaseOrderInfoAwaitReqBO reqBO) {
        PayPurchaseOrderSumVO sumVO;
        String orderBy;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7edf\u7b7e\u7ed3\u7b97\u5f85\u53d1\u8d77\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u7edf\u7b7e\u7ed3\u7b97\u5f85\u53d1\u8d77\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u8fd0\u8425\u5546\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getIsProfessionalOrgExt())) {
            throw new PfscExtBusinessException("0001", "\u7edf\u7b7e\u7ed3\u7b97\u5f85\u53d1\u8d77\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u7f16\u53f7[isProfessionalOrgExt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QuerySaleOrderInfoAwaitRspBO rspBO = new QuerySaleOrderInfoAwaitRspBO();
        String isProfessionalOrgExt = reqBO.getIsProfessionalOrgExt();
        SaleOrderInfoQueryVO vo = new SaleOrderInfoQueryVO();
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getPurchaseNo())) {
            vo.setPurchaseNo(Long.valueOf(reqBO.getPurchaseNo()));
        }
        Long excludeOrg = null;
        if ("0".equals(isProfessionalOrgExt)) {
            vo.setOperUnitNo(reqBO.getCompanyId());
            vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getPurchaseNo())) {
                vo.setPurchaseNo(Long.valueOf(reqBO.getPurchaseNo()));
            } else {
                excludeOrg = reqBO.getCompanyId();
            }
            vo.setExcludeOrg(excludeOrg);
        } else if ("1".equals(isProfessionalOrgExt)) {
            vo.setPurchaseNo(reqBO.getCompanyId());
            vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        } else if ("2".equals(isProfessionalOrgExt)) {
            vo.setSupplierNo(reqBO.getSupId());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getPurchaseProjectId())) {
            vo.setPurchaseProjectId(Long.valueOf(reqBO.getPurchaseProjectId()));
        }
        ArrayList orderStatusCodes = Lists.newArrayList();
        if (!StringUtils.isEmpty((CharSequence)reqBO.getHandUpStatus())) {
            orderStatusCodes.add(reqBO.getHandUpStatus());
        } else if (!StringUtils.isEmpty((CharSequence)reqBO.getTabId())) {
            ConfTabStatePO confTabStatePO = this.confTabStateMapper.selectByTabId(Integer.valueOf(reqBO.getTabId()));
            Collections.addAll(orderStatusCodes, confTabStatePO.getStatusCode().split(","));
        } else {
            orderStatusCodes.add(OrderStatus.NO_APPLY.getCode());
            orderStatusCodes.add(OrderStatus.HANGING.getCode());
            orderStatusCodes.add(OrderStatus.AUTO_HANG_UP.getCode());
            orderStatusCodes.add(OrderStatus.SENDING.getCode());
        }
        vo.setOrderStatusCodes(orderStatusCodes);
        vo.setOrderCode(reqBO.getSaleOrderCode());
        vo.setExtOrderId(reqBO.getExtOrderId());
        vo.setOrderDateStart(reqBO.getOrderDateStart());
        vo.setOrderDateEnd(reqBO.getOrderDateEnd());
        vo.setPayType(reqBO.getPayType());
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getInspectionId())) {
            vo.setInspectionId(Long.valueOf(reqBO.getInspectionId()));
        }
        vo.setPurchaserName(reqBO.getPurchaserName());
        vo.setSource(reqBO.getSource());
        vo.setReconciliationStatus(reqBO.getReconciliationStatus());
        if ("1".equals(reqBO.getIsActivity())) {
            vo.setOrderCategory("1");
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getActivityId())) {
                vo.setActivityId(Long.parseLong(reqBO.getActivityId()));
            }
        } else {
            vo.setIsNotActivity("0");
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = "a.ORDER_DATE DESC";
        }
        vo.setOrderBy(orderBy);
        logger.debug("\u7edf\u7b7e\u7ed3\u7b97\u5f85\u53d1\u8d77\u67e5\u8be2\u5165\u53c2\uff1a" + vo.toString());
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        LinkedList<SaleOrderInfoBO> boList = new LinkedList<SaleOrderInfoBO>();
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getSaleOrderListPage(vo, (Page<Map<String, Object>>)page);
        ArrayList<Long> inspectionIds = new ArrayList<Long>();
        ArrayList accountIds = new ArrayList();
        if (!CollectionUtils.isEmpty(saleOrderInfoList)) {
            List<PayItemInfo> payItemInfos;
            saleOrderInfoList.forEach(payPurOrderInfo -> {
                inspectionIds.add(payPurOrderInfo.getInspectionId());
                accountIds.add(payPurOrderInfo.getPurchaseProjectId());
            });
            HashMap itemMap = new HashMap();
            HashMap accountMap = new HashMap();
            if (!CollectionUtils.isEmpty(inspectionIds) && !CollectionUtils.isEmpty(payItemInfos = this.payItemInfoMapper.selectByInspectionIds(inspectionIds))) {
                for (PayItemInfo payItemInfo : payItemInfos) {
                    PayItemInfoExtVO sinleItemVO = new PayItemInfoExtVO();
                    BeanUtils.copyProperties((Object)payItemInfo, (Object)sinleItemVO);
                    sinleItemVO.setSeq(FscCommonUtils.long2String((Long)payItemInfo.getSeq()));
                    sinleItemVO.setQuantity(null == payItemInfo.getQuantity() ? null : payItemInfo.getQuantity().stripTrailingZeros());
                    sinleItemVO.setQuantitySale(null == payItemInfo.getQuantitySale() ? null : payItemInfo.getQuantitySale().stripTrailingZeros());
                    if (null == itemMap.get(payItemInfo.getInspectionId())) {
                        ArrayList<PayItemInfoExtVO> payItemInfoExtVOS = new ArrayList<PayItemInfoExtVO>();
                        payItemInfoExtVOS.add(sinleItemVO);
                        itemMap.put(payItemInfo.getInspectionId(), payItemInfoExtVOS);
                        continue;
                    }
                    ((List)itemMap.get(payItemInfo.getInspectionId())).add(sinleItemVO);
                }
            }
            if (!CollectionUtils.isEmpty(accountIds)) {
                UmcQryEnterpriseAccountListNoPageAbilityReqBO umcQryEnterpriseAccountListNoPageAbilityReqBO = new UmcQryEnterpriseAccountListNoPageAbilityReqBO();
                umcQryEnterpriseAccountListNoPageAbilityReqBO.setInAccountIds(accountIds);
                UmcQryEnterpriseAccountListNoPageAbilityRspBO umcQryEnterpriseAccountListNoPageAbilityRspBO = this.umcQryEnterpriseAccountListAbilityService.qryEnterpriseAccountListNoPage(umcQryEnterpriseAccountListNoPageAbilityReqBO);
                if (!CollectionUtils.isEmpty((Collection)umcQryEnterpriseAccountListNoPageAbilityRspBO.getRows())) {
                    umcQryEnterpriseAccountListNoPageAbilityRspBO.getRows().forEach(umcEnterpriseAccountAbilityBO -> accountMap.put(umcEnterpriseAccountAbilityBO.getAccountId(), umcEnterpriseAccountAbilityBO.getAccountName()));
                }
            }
            for (SaleOrderInfo info : saleOrderInfoList) {
                SaleOrderInfoBO bo = new SaleOrderInfoBO();
                BeanUtils.copyProperties((Object)info, (Object)bo);
                bo.setParentOrderId(FscCommonUtils.long2String((Long)info.getParentOrderId()));
                bo.setOrderId(FscCommonUtils.long2String((Long)info.getOrderId()));
                bo.setInspectionId(FscCommonUtils.long2String((Long)info.getInspectionId()));
                bo.setItemInfos((List)itemMap.get(bo.getInspectionId()));
                bo.setPurchaseProjectName((String)accountMap.get(bo.getPurchaseProjectId()));
                OrderStatus orderStatusEnum = OrderStatus.getInstance(bo.getOrderStatus());
                bo.setOrderStatusStr(this.enumsService.getDescr(orderStatusEnum));
                ReconciliationStatus reconciliationStatus = ReconciliationStatus.getInstance(info.getReconciliationStatus());
                bo.setReconciliationStatus(this.enumsService.getDescr(reconciliationStatus));
                if (info.getPurchaseProjectId() != null) {
                    bo.setPurchaseProjectName(this.organizationInfoService.queryProjectName(info.getPurchaseProjectId()).getAccountName());
                }
                if (StringUtils.isNotEmpty((CharSequence)info.getPayType())) {
                    bo.setPayTypeStr(SaleOrderPayType.getInstance(info.getPayType()).getDescr());
                }
                if ("purchaser".equals(info.getPayModel())) {
                    bo.setPayModelStr("\u91c7\u8d2d\u5458\u6a21\u5f0f");
                } else if ("settle".equals(info.getPayModel())) {
                    bo.setPayModelStr("\u7ed3\u7b97\u5458\u6a21\u5f0f");
                }
                bo.setSourceDescr(Source.getInstance(info.getSource()).getDescr());
                if ("00".equals(info.getPayStatus())) {
                    bo.setPayStatusStr("\u672a\u4ed8\u6b3e");
                } else {
                    bo.setPayStatusStr(PayResultStatus.getInstance(info.getPayStatus()).getCodeDescr());
                }
                boList.add(bo);
            }
        }
        if (null != (sumVO = this.saleOrderInfoMapper.sumSaleOrderInfo(vo))) {
            rspBO.setTotalAmt(sumVO.getOrderAmtCount());
        }
        vo.setReconciliationStatus("1");
        Integer reconOkCount = this.saleOrderInfoMapper.sumSaleOrderByReconciliation(vo);
        if (reconOkCount != null) {
            rspBO.setReconOkCount(reconOkCount);
        }
        vo.setReconciliationStatus("2");
        Integer reconDiffCount = this.saleOrderInfoMapper.sumSaleOrderByReconciliation(vo);
        if (reconDiffCount != null) {
            rspBO.setReconDiffCount(reconDiffCount);
        }
        vo.setReconciliationStatus("0");
        Integer reconFailCount = this.saleOrderInfoMapper.sumSaleOrderByReconciliation(vo);
        if (reconFailCount != null) {
            rspBO.setReconFailCount(reconFailCount);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTabIdList())) {
            BillNotificationInfoTab billNotificationInfoTab = new BillNotificationInfoTab();
            List<NotificationStatusCountVO> notificationStatusCountVOS = this.billNotificationInfoMapper.selectForPageAndTabCount(billNotificationInfoTab);
            HashMap<String, Integer> notificationStatusCountMap = new HashMap();
            if (!CollectionUtils.isEmpty(notificationStatusCountVOS)) {
                notificationStatusCountMap = notificationStatusCountVOS.stream().collect(Collectors.toMap(NotificationStatusCountVO::getNotificationStatus, NotificationStatusCountVO::getNum));
            }
            Map<String, ConfTabStatePO> tabInfoMap = this.getStateListOfConfTabAtomService.getStateList(reqBO.getTabIdList());
            Map<String, BusiTabNumbersQryBO> tabCountMap = this.transOrderTabInfo(notificationStatusCountMap, tabInfoMap);
            if (reqBO.getTabIdList().contains("2001")) {
                this.qryPurchaseCountOfFq("2001", tabCountMap, tabInfoMap, reqBO);
            }
            rspBO.setTabCountList(tabCountMap.values().stream().collect(Collectors.toList()));
        }
        rspBO.setRows(boList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    private Map<String, BusiTabNumbersQryBO> transOrderTabInfo(Map<String, Integer> notificationStatusCountMap, Map<String, ConfTabStatePO> tabInfoMap) {
        HashMap<String, BusiTabNumbersQryBO> tabCountMap = new HashMap<String, BusiTabNumbersQryBO>();
        for (Map.Entry<String, ConfTabStatePO> next : tabInfoMap.entrySet()) {
            if (next.getKey().equals("0")) continue;
            ConfTabStatePO tabOrdStatePO = next.getValue();
            BusiTabNumbersQryBO tabsNumberQueryBO = new BusiTabNumbersQryBO();
            tabsNumberQueryBO.setTabId(tabOrdStatePO.getTabId());
            tabsNumberQueryBO.setTabName(tabOrdStatePO.getTabName());
            int tabsCount = 0;
            for (String statue : tabOrdStatePO.getStatueList()) {
                Integer tabMapCounts = notificationStatusCountMap.get(String.valueOf(statue));
                if (tabMapCounts == null) continue;
                tabsCount += tabMapCounts.intValue();
            }
            tabsNumberQueryBO.setTabsCount(Integer.valueOf(tabsCount));
            tabCountMap.put(tabOrdStatePO.getTabId(), tabsNumberQueryBO);
        }
        return tabCountMap;
    }

    private void qryPurchaseCountOfFq(String tabId, Map<String, BusiTabNumbersQryBO> tabCountMap, Map<String, ConfTabStatePO> tabInfoMap, QueryPayPurchaseOrderInfoAwaitReqBO reqBO) {
        PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
        payPurchaseOrderInfoVO.setBusiModel("1");
        payPurchaseOrderInfoVO.setOrderStatusCodes(tabInfoMap.get(tabId).getStatueList());
        Integer orderCount = this.payPurchaseOrderInfoMapper.getPurchaseChCount(payPurchaseOrderInfoVO);
        BusiTabNumbersQryBO busiTabNumbersQryBO = new BusiTabNumbersQryBO();
        busiTabNumbersQryBO.setTabId(tabInfoMap.get(tabId).getTabId());
        busiTabNumbersQryBO.setTabName(tabInfoMap.get(tabId).getTabName());
        busiTabNumbersQryBO.setTabsCount(orderCount);
        tabCountMap.put(tabId, busiTabNumbersQryBO);
    }
}

