/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.VerifyPurchaseOrderInfoService;
import com.tydic.pfscext.api.busi.bo.PurchaseOrderVerifyReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoAwaitReqBO;
import com.tydic.pfscext.api.busi.bo.VerifyPurchaseOrderRspBO;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.VerifyPurchaseOrderInfoService"})
public class VerifyPurchaseOrderInfoServiceImpl
implements VerifyPurchaseOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(VerifyPurchaseOrderInfoServiceImpl.class);
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"purchaseOrderVerify"})
    public VerifyPurchaseOrderRspBO purchaseOrderVerify(@RequestBody PurchaseOrderVerifyReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u8fd0\u8425\u5546\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VerifyPurchaseOrderRspBO rspBO = new VerifyPurchaseOrderRspBO();
        String isProfessionalOrgExt = reqBO.getIsProfessionalOrgExt();
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        if ("0".equals(isProfessionalOrgExt)) {
            vo.setOperUnitNo(reqBO.getCompanyId());
            vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        } else if ("1".equals(isProfessionalOrgExt)) {
            vo.setPurchaseNo(reqBO.getCompanyId());
            vo.setBusiModel(BusiModel.MATCH_UP_MODEL.getCode());
        } else if ("2".equals(isProfessionalOrgExt)) {
            vo.setSupplierNo(reqBO.getSupId());
            vo.setPurchaseId(null);
        }
        List<Object> payPurchaseOrderInfoList = new ArrayList();
        if ("0".equals(reqBO.getIsSelectOrder())) {
            void var9_17;
            void var8_11;
            QueryPayPurchaseOrderInfoAwaitReqBO pageReqBO = reqBO.getQueryPayPurchaseOrderInfoAwaitReqBO();
            if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaseNo())) {
                vo.setPurchaseNo(Long.valueOf(pageReqBO.getPurchaseNo()));
            }
            if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaseProjectId())) {
                vo.setPurchaseProjectId(Long.valueOf(pageReqBO.getPurchaseProjectId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getSupplierNo())) {
                vo.setSupplierNo(Long.valueOf(pageReqBO.getSupplierNo()));
            }
            ArrayList orderStatusCodes = Lists.newArrayList();
            if (!StringUtils.isEmpty((CharSequence)pageReqBO.getHandUpStatus())) {
                orderStatusCodes.add(pageReqBO.getHandUpStatus());
            } else if (!StringUtils.isEmpty((CharSequence)pageReqBO.getTabId())) {
                ConfTabStatePO confTabStatePO = this.confTabStateMapper.selectByTabId(Integer.valueOf(pageReqBO.getTabId()));
                Collections.addAll(orderStatusCodes, confTabStatePO.getStatusCode().split(","));
            } else {
                orderStatusCodes.add(OrderStatus.NO_APPLY.getCode());
                orderStatusCodes.add(OrderStatus.HANGING.getCode());
                orderStatusCodes.add(OrderStatus.AUTO_HANG_UP.getCode());
                orderStatusCodes.add(OrderStatus.SENDING.getCode());
            }
            vo.setOrderStatusCodes(orderStatusCodes);
            vo.setPurchaseOrderCode(pageReqBO.getPurchaseOrderCode());
            vo.setExtOrderId(pageReqBO.getExtOrderId());
            vo.setOrderDateStart(pageReqBO.getOrderDateStart());
            vo.setOrderDateEnd(pageReqBO.getOrderDateEnd());
            vo.setPayType(pageReqBO.getPayType());
            if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getInspectionId())) {
                vo.setInspectionId(Long.valueOf(pageReqBO.getInspectionId()));
            }
            vo.setPurchaserName(pageReqBO.getPurchaserName());
            vo.setSource(pageReqBO.getSource());
            vo.setReconciliationStatus(pageReqBO.getReconciliationStatus());
            Object var8_9 = null;
            if ("0".equals(isProfessionalOrgExt)) {
                if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaseNo())) {
                    vo.setPurchaseNo(Long.valueOf(pageReqBO.getPurchaseNo()));
                } else {
                    Long l = reqBO.getCompanyId();
                }
            }
            vo.setExcludeOrg((Long)var8_11);
            if (!StringUtils.isEmpty((CharSequence)pageReqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)pageReqBO.getSortOrder())) {
                if (AntiSqlInjectionManage.sqlValidate(pageReqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(pageReqBO.getSortOrder())) {
                    logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                    throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                }
                String string = pageReqBO.getSortName() + " " + pageReqBO.getSortOrder();
            } else {
                String string = "t.ORDER_DATE DESC";
            }
            vo.setOrderBy((String)var9_17);
            payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.getPurchaseOrderListPage(vo, (Page<Map<String, Object>>)new Page());
        } else if ("1".equals(reqBO.getIsSelectOrder())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getOrderIdList())) {
                throw new PfscExtBusinessException("0001", "\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u52fe\u9009\u8ba2\u5355\u5217\u8868[orderIdList]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList orderIds = Lists.newArrayList();
            reqBO.getOrderIdList().stream().forEach(orderIdStr -> orderIds.add(Long.valueOf(orderIdStr)));
            payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.getListPurchaseOrderInfo(orderIds);
        } else {
            throw new PfscExtBusinessException("0001", "\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u662f\u5426\u52fe\u9009\u8ba2\u5355[isSelectOrder]\u4e0d\u6b63\u786e");
        }
        for (Object info : payPurchaseOrderInfoList) {
            if (OrderStatus.NO_APPLY.getCode().equals(((PayPurchaseOrderInfo)info).getOrderStatus())) continue;
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("1001");
            return rspBO;
        }
        HashSet<Long> purchaseNoSet = new HashSet<Long>();
        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
            purchaseNoSet.add(payPurchaseOrderInfo.getPurchaseNo());
        }
        if (purchaseNoSet.size() != 1) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("1002");
            return rspBO;
        }
        HashSet<Long> purchaseProjectIdSet = new HashSet<Long>();
        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
            purchaseProjectIdSet.add(payPurchaseOrderInfo.getPurchaseProjectId());
        }
        if (purchaseProjectIdSet.size() != 1) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("1003");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6821\u9a8c\u901a\u8fc7\uff01");
        return rspBO;
    }
}

