/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.VerifyPushTaxParamAtomService;
import com.tydic.pfscext.api.busi.bo.VerifyPushTaxParamAtomReqBO;
import com.tydic.pfscext.api.busi.bo.VerifyPushTaxParamAtomRspBO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.VerifyPushTaxParamAtomService"})
public class VerifyPushTaxParamAtomServiceImpl
implements VerifyPushTaxParamAtomService {
    private static final Logger log = LoggerFactory.getLogger(VerifyPushTaxParamAtomServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    @PostMapping(value={"verifyParam"})
    public VerifyPushTaxParamAtomRspBO verifyParam(@RequestBody VerifyPushTaxParamAtomReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyNoList())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u7a0e\u63a7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        VerifyPushTaxParamAtomRspBO rspBO = new VerifyPushTaxParamAtomRspBO();
        int count = this.saleOrderInfoMapper.checkOrderStatus(reqBO.getApplyNoList());
        if (count > 0) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4e0a\u6e38\u5b58\u5728\u672a\u83b7\u53d6\u53d1\u7968\u7684\u8ba2\u5355");
            return rspBO;
        }
        if (!"1".equals(reqBO.getZeroTaxConfirm())) {
            ArrayList<String> zeroTaxApplyNos = new ArrayList<String>();
            for (String applyNo : reqBO.getApplyNoList()) {
                int zeroTaxItemCount = this.saleItemInfoMapper.getZeroTaxItemByApply(applyNo);
                if (zeroTaxItemCount <= 0) continue;
                zeroTaxApplyNos.add(applyNo);
            }
            if (!CollectionUtils.isEmpty(zeroTaxApplyNos)) {
                log.error(reqBO.getApplyNoList().toString() + "\u5b58\u57280\u7a05\u7387\u5546\u54c1\uff0c\u8fd4\u56de\u524d\u7aef\u5f85\u7528\u6237\u786e\u8ba4");
                rspBO.setZeroTaxConfirm("0");
                rspBO.setRespCode("0000");
                rspBO.setZeroTaxApplyNos(zeroTaxApplyNos);
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

