/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.tydic.pfscext.api.busi.BusiGetInvoiceService;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceRspBO;
import com.tydic.pfscext.api.comb.FscTimedTaskGetInvoiceCombService;
import com.tydic.pfscext.api.comb.bo.FscTimedTaskGetInvoiceServiceCombReqBO;
import com.tydic.pfscext.api.comb.bo.FscTimedTaskGetInvoiceServiceCombRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.comb.FscTimedTaskGetInvoiceCombService"})
public class FscTimedTaskGetInvoiceCombServiceImpl
implements FscTimedTaskGetInvoiceCombService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BusiGetInvoiceService busiGetInvoiceService;
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;

    @PostMapping(value={"toGetInvoice"})
    public FscTimedTaskGetInvoiceServiceCombRspBO toGetInvoice(@RequestBody FscTimedTaskGetInvoiceServiceCombReqBO reqBO) {
        this.LOGGER.info("\u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6\u53d1\u7968comb\u670d\u52a1 \u5165\u53c2:" + reqBO);
        FscTimedTaskGetInvoiceServiceCombRspBO rspBO = new FscTimedTaskGetInvoiceServiceCombRspBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        List<BillNotificationInfo> billNotificationInfos = this.notificationInfomapper.selectList(billNotificationInfo);
        if (CollectionUtils.isEmpty(billNotificationInfos)) {
            this.LOGGER.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a01(\u5df2\u63d0\u4ea4)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        Integer success = 0;
        Integer fail = 0;
        for (BillNotificationInfo notificationInfo : billNotificationInfos) {
            Integer n;
            if (null == notificationInfo) continue;
            BusiGetInvoiceServiceReqBO busiGetInvoiceServiceReqBO = new BusiGetInvoiceServiceReqBO();
            ArrayList<String> notificationNos = new ArrayList<String>();
            notificationNos.add(notificationInfo.getNotificationNo());
            busiGetInvoiceServiceReqBO.setNotificationNos(notificationNos);
            try {
                BusiGetInvoiceServiceRspBO invoiceServiceRspBO = this.busiGetInvoiceService.dealInvoice(busiGetInvoiceServiceReqBO);
                if ("0000".equals(invoiceServiceRspBO.getRespCode())) {
                    n = success;
                    success = success + 1;
                    continue;
                }
                n = fail;
                fail = fail + 1;
            }
            catch (Exception e) {
                this.LOGGER.error("\u901a\u77e5\u5355\u53f7" + notificationInfo.getNotificationNo() + "\u4e0a\u6e38\u83b7\u53d6\u53d1\u7968\u5931\u8d25:" + e.getMessage());
                n = fail;
                fail = fail + 1;
            }
        }
        this.LOGGER.info("\u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6\u53d1\u7968\u6210\u529f" + success + "\u6761,\u5931\u8d25" + fail + "\u6761");
        return rspBO;
    }
}

