/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.pfscext.api.deal.QuerySaleOrderInfoCreditListService;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoCreditMapper;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountDetailAbilityService;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountListAbilityService;
import com.tydic.umcext.ability.account.bo.UmcEnterpriseAccountAbilityBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QuerySaleOrderInfoCreditListService"})
public class QuerySaleOrderInfoCreditListServiceImpl
implements QuerySaleOrderInfoCreditListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerySaleOrderInfoCreditListServiceImpl.class);
    @Autowired
    private SaleOrderInfoCreditMapper saleOrderInfoCreditMapper;
    @Autowired
    private UmcQryEnterpriseAccountDetailAbilityService umcQryEnterpriseAccountDetailAbilityService;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;

    @PostMapping(value={"querySaleOrderInfoCreditList"})
    public PfscExtRspPageBaseBO<BusiQuerySaleOrderInfoOrderRspBO> querySaleOrderInfoCreditList(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscExtRspPageBaseBO rapPage = new PfscExtRspPageBaseBO();
        try {
            PayOrderInfoPO payOrderInfoPO;
            if (null != reqBO.getPayOrderId() && null != (payOrderInfoPO = this.payOrderInfoMapper.selectByPrimaryKey(reqBO.getPayOrderId())) && "1".equals(payOrderInfoPO.getPayOrderType())) {
                Long payId = reqBO.getPayOrderId();
                reqBO.setPayOrderIdYear(payId);
                reqBO.setPayOrderId(null);
            }
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
            saleOrderInfoVO.setSaleOrderCodeLike(reqBO.getSaleOrderCode());
            saleOrderInfoVO.setOrderBy("ORDER_DATE DESC");
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoCreditMapper.getListPage(saleOrderInfoVO, (Page<Map<String, Object>>)page);
            ArrayList<Long> inAccountIds = new ArrayList<Long>();
            for (SaleOrderInfo saleOrderInfo2 : saleOrderInfoList) {
                if (inAccountIds.contains(saleOrderInfo2.getPurchaseProjectId())) continue;
                inAccountIds.add(saleOrderInfo2.getPurchaseProjectId());
            }
            HashMap<Long, String> map = new HashMap<Long, String>();
            UmcQryEnterpriseAccountListNoPageAbilityReqBO umcQryEnterpriseAccountListNoPageAbilityReqBO = new UmcQryEnterpriseAccountListNoPageAbilityReqBO();
            umcQryEnterpriseAccountListNoPageAbilityReqBO.setInAccountIds(inAccountIds);
            UmcQryEnterpriseAccountListNoPageAbilityRspBO rspBo = this.umcQryEnterpriseAccountListAbilityService.qryEnterpriseAccountListNoPage(umcQryEnterpriseAccountListNoPageAbilityReqBO);
            if (rspBo != null & rspBo.getRows() != null && rspBo.getRows().size() > 0) {
                for (UmcEnterpriseAccountAbilityBO umcEnterpriseAccountAbilityBO : rspBo.getRows()) {
                    map.put(umcEnterpriseAccountAbilityBO.getAccountId(), umcEnterpriseAccountAbilityBO.getAccountName());
                }
            }
            List busiQuerySaleOrderInfoOrderRspBOs = saleOrderInfoList.stream().map(saleOrderInfo -> {
                BusiQuerySaleOrderInfoOrderRspBO busiQuerySaleOrderInfoOrderRspBO = new BusiQuerySaleOrderInfoOrderRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQuerySaleOrderInfoOrderRspBO);
                busiQuerySaleOrderInfoOrderRspBO.setOrderStatusDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus()).getDescr());
                busiQuerySaleOrderInfoOrderRspBO.setOrderId(saleOrderInfo.getOrderId().toString());
                busiQuerySaleOrderInfoOrderRspBO.setPurchaseProjectName((String)map.get(saleOrderInfo.getPurchaseProjectId()));
                if (null != reqBO.getDays()) {
                    busiQuerySaleOrderInfoOrderRspBO.setPaidDate(new Date(saleOrderInfo.getOrderDate().getTime() + reqBO.getDays() * 24L * 60L * 60L * 1000L));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\u5e94\u4ed8\u65e5\u671f\uff1a" + busiQuerySaleOrderInfoOrderRspBO.getPaidDate());
                    }
                }
                if (saleOrderInfo.getInspectionId() != null) {
                    busiQuerySaleOrderInfoOrderRspBO.setInspectionId(saleOrderInfo.getInspectionId().toString());
                }
                return busiQuerySaleOrderInfoOrderRspBO;
            }).collect(Collectors.toList());
            rapPage.setRows(busiQuerySaleOrderInfoOrderRspBOs);
            rapPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rapPage.setTotal(Integer.valueOf(page.getTotalPages()));
            rapPage.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25");
        }
        return rapPage;
    }
}

