/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.notify.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jd.open.api.sdk.internal.util.StringUtil;
import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.pfscext.api.notify.FscRemindBusiService;
import com.tydic.pfscext.api.notify.bo.FscRemindReqBO;
import com.tydic.pfscext.api.notify.bo.FscRemindRspBO;
import com.tydic.pfscext.constants.FscCommonConstants;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import com.tydic.pfscext.service.notify.PropertiesUtils;
import com.tydic.pfscext.service.notify.SSLClient;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.notify.FscRemindBusiService"})
public class FscRemindBusiServiceImpl
implements FscRemindBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscRemindBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    @PostMapping(value={"dealFscRemind"})
    public FscRemindRspBO dealFscRemind(@RequestBody FscRemindReqBO reqBO) {
        FscRemindRspBO rspBO;
        String token = reqBO.getToken();
        if (reqBO.getSendType().equals(FscCommonConstants.ORDER_SEND_MESSAGE)) {
            String requestJsonStr = this.initRequestMessageJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = null == reqBO.getTemplateId() || 0L == reqBO.getTemplateId() ? this.sendFrom(requestJsonStr, PropertiesUtils.getProperty("SEND_INNER_MESSAGE_URL"), token) : this.sendFrom(requestJsonStr, PropertiesUtils.getProperty("SEND_INNER_SYSMESSAGE_URL"), token);
        } else if (reqBO.getSendType().equals(FscCommonConstants.ORDER_SEND_EMIL)) {
            String requestJsonStr = this.initRequestEmailJsonStr(reqBO);
            if (null == reqBO.getMailFileBOS()) {
                LOGGER.debug("\u53d1\u9001\u90ae\u4ef6\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
                rspBO = this.doUrlPostRequest(requestJsonStr, "NOTIFY_SEND_MAIL_URL", token);
            } else {
                LOGGER.debug("\u53d1\u9001\u90ae\u4ef6(\u5305\u542b\u9644\u4ef6)\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
                rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_MAIL_CONTAIN_ANNEX", token);
            }
        } else if (reqBO.getSendType().equals(FscCommonConstants.ORDER_SEND_MOBILE)) {
            String requestJsonStr = this.initRequestMobileJsonStr(reqBO);
            LOGGER.debug("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = this.doUrlPostRequest(requestJsonStr, "SEND_ONLY_SMS_MESSAGE_URL", "");
        } else if (reqBO.getSendType().equals(FscCommonConstants.ORDER_SEND_WX)) {
            rspBO = new FscRemindRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5fae\u4fe1\u901a\u77e5\u6682\u65f6\u6ca1\u6709\u5f00\u653e");
        } else {
            rspBO = new FscRemindRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u77e5\u901a\u77e5\u7c7b\u578b");
        }
        return rspBO;
    }

    private FscRemindRspBO sendFrom(String requestJsonStr, String url, String token) {
        FscRemindRspBO rspBO = new FscRemindRspBO();
        Map map = (Map)JSONObject.parseObject((String)requestJsonStr, Map.class);
        HashMap<String, String> param = new HashMap<String, String>(map.size());
        for (Map.Entry elem : map.entrySet()) {
            if (elem.getValue() == null) continue;
            param.put((String)elem.getKey(), elem.getValue().toString());
        }
        try {
            HashMap<String, String> header = null;
            if (token != null) {
                header = new HashMap<String, String>(1);
                header.put("auth-token", token);
            }
            String rsp = SSLClient.doPost(url, param, header);
            LOGGER.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a" + rsp);
            rspBO = this.resolveRsp(rsp);
        }
        catch (Exception var9) {
            LOGGER.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!", (Throwable)var9);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private FscRemindRspBO doUrlPostRequest(String requestJsonStr, String url, String token) {
        FscRemindRspBO rspBO = new FscRemindRspBO();
        try {
            HttpRetBean httpRetBean;
            Header[] headers = HSNHttpHeader.getRequestHeaders((String)"json");
            if (StringUtils.isNotBlank((CharSequence)token)) {
                Header[] header = new Header[headers.length + 1];
                System.arraycopy(headers, 0, header, 0, headers.length);
                header[headers.length] = new BasicHeader("auth-token", token);
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtils.getProperty(url)), (Header[])header, (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            } else {
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtils.getProperty(url)), (Header[])headers, (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            }
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtils.getProperty(url) + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new BusinessException("2001", "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    private String initRequestEmailJsonStr(FscRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("to", (Object)reqBO.getEmail());
        jsonObject.put("content", (Object)reqBO.getText());
        jsonObject.put("subject", (Object)reqBO.getSubject());
        if (null != reqBO.getMailFileBOS() && reqBO.getMailFileBOS().size() > 0) {
            jsonObject.put("mailFileList", (Object)reqBO.getMailFileBOS());
        }
        if (!StringUtil.isEmpty((String)reqBO.getFrom())) {
            jsonObject.put("from", (Object)reqBO.getFrom());
        }
        return jsonObject.toJSONString();
    }

    private String initRequestMobileJsonStr(FscRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("mobile", (Object)reqBO.getMobile());
        jsonObject.put("content", (Object)reqBO.getText());
        return jsonObject.toJSONString();
    }

    private String initRequestMessageJsonStr(FscRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sendid", (Object)reqBO.getUserId());
        jsonObject.put("recid", (Object)reqBO.getReceiveId());
        jsonObject.put("appid", (Object)PropertiesUtils.getProperty("APP_ID"));
        jsonObject.put("titel", (Object)reqBO.getTitel());
        jsonObject.put("text", (Object)reqBO.getText());
        jsonObject.put("token", (Object)reqBO.getToken());
        if (null != reqBO.getTemplateId() && reqBO.getTemplateId() != 0L) {
            jsonObject.put("templateId", (Object)reqBO.getTemplateId());
            jsonObject.put("templateParam", (Object)JSON.toJSONString((Object)reqBO.getTemplateParam()));
        }
        return jsonObject.toJSONString();
    }

    private String initRequestWXJsonStr(FscRemindReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)reqBO.getReceiveId());
        jsonObject.put("templateId", (Object)reqBO.getTemplateId());
        JSONObject data = new JSONObject();
        data.put("title", (Object)reqBO.getTitel());
        data.put("text", (Object)reqBO.getText());
        jsonObject.put("data", (Object)data);
        return jsonObject.toJSONString();
    }

    private FscRemindRspBO resolveRsp(String returnString) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        }
        FscRemindRspBO rspBO = new FscRemindRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u6210\u529f!");
        return rspBO;
    }

    public static String getDate(Date date1) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        String date = sd.format(calendar.getTime());
        return date;
    }
}

