/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.notify.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.role.bo.HasUserListBO;
import com.ohaotian.authority.role.bo.SelectAlreadyAndNorUsersReqBO;
import com.ohaotian.authority.role.bo.UserBO;
import com.ohaotian.authority.role.service.SelectAlreadyUser;
import com.tydic.order.extend.constant.PebExtConstant;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.pfscext.api.notify.FscSendMessageService;
import com.tydic.pfscext.api.notify.bo.FscPebExtSendMessageReqBO;
import com.tydic.pfscext.api.notify.bo.MemDetailInfoBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.umc.ability.UmcMemDetailQueryAbilityService;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityRspBO;
import com.tydic.umc.ability.bo.UmcQrySupMemAbilityPageReqBO;
import com.tydic.umc.ability.user.UmcQrySupMemByPageAbilityService;
import com.tydic.umc.base.bo.UmcRspPageBO;
import com.tydic.umc.common.UmcSupMemberInfoBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.notify.FscSendMessageService"})
public class FscSendMessageServiceImpl
implements FscSendMessageService {
    private static final Logger log = LoggerFactory.getLogger(FscSendMessageServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private SelectAlreadyUser selectAlreadyUser;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private UmcQrySupMemByPageAbilityService umcQrySupMemByPageAbilityService;

    @PostMapping(value={"getMemDetailInfo"})
    public List<MemDetailInfoBO> getMemDetailInfo(@RequestBody FscPebExtSendMessageReqBO reqBO, @RequestBody Integer value) {
        ArrayList<MemDetailInfoBO> menList = new ArrayList<MemDetailInfoBO>();
        log.debug("\u4f20\u5165\u7684\u8ba2\u5355\u53f7:" + reqBO.getOrderId());
        Long OrgId = 0L;
        Long SupplierNo = 0L;
        Long operNo = 0L;
        List<Object> payPurchaseOrderInfos = new ArrayList();
        menList.clear();
        if (reqBO.getSupId() != null || reqBO.getOrgId() != null || reqBO.getOperNo() != null) {
            if (reqBO.getSupId() != null) {
                SupplierNo = reqBO.getSupId();
            }
            if (reqBO.getOrgId() != null) {
                OrgId = reqBO.getOrgId();
            }
            if (reqBO.getOperNo() != null) {
                operNo = reqBO.getOperNo();
            }
        }
        if (reqBO.getOrderId() != null) {
            payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByOrderId(reqBO.getOrderId());
            if (OrgId == 0L || OrgId == null) {
                OrgId = ((PayPurchaseOrderInfo)payPurchaseOrderInfos.get(0)).getPurchaseNo();
            }
            if (SupplierNo == 0L || SupplierNo == null) {
                SupplierNo = ((PayPurchaseOrderInfo)payPurchaseOrderInfos.get(0)).getSupplierNo();
            }
        }
        if (value.equals(PebExtConstant.NOTIFY_RECEIVE_ROLE.CGY)) {
            Long CGYID = 469954648318189568L;
            log.debug("\u67e5\u627e\u91c7\u8d2d\u65b9\u91c7\u8d2d\u5458 orgID" + OrgId + "roleID:" + CGYID);
            this.getReceiver(menList, OrgId, CGYID);
        } else if (value.equals(PebExtConstant.NOTIFY_RECEIVE_ROLE.CGF_CWZFG)) {
            Long id = 473178099007184896L;
            log.debug("\u67e5\u627e\u91c7\u8d2d\u65b9_\u4f01\u4e1a\u7ed3\u7b97\u5458 orgID" + OrgId + "roleID:" + id);
            this.getReceiver(menList, OrgId, id);
        } else if (value.equals(PebExtConstant.NOTIFY_RECEIVE_ROLE.CGF_QYJSY)) {
            Long CGF_QYJSY = 469955367435804672L;
            log.debug("\u67e5\u627e\u91c7\u8d2d\u65b9_\u4f01\u4e1a\u7ed3\u7b97\u5458 orgID" + OrgId + "roleID:" + CGF_QYJSY);
            this.getReceiver(menList, OrgId, CGF_QYJSY);
        } else if (value.equals(PebExtConstant.NOTIFY_RECEIVE_ROLE.GYS_JSGLY)) {
            Long GYS_JSGLY = 434396441209397248L;
            log.debug("\u67e5\u8be2\u4f9b\u5e94\u5546\u7ba1\u7406\u5458\u7684\u53c2\u6570\u4fe1\u606f\u4e3a: \u4f9b\u5e94\u5546ID" + SupplierNo + "roleId\uff1a" + GYS_JSGLY + "menList\uff1a" + ((Object)menList).toString());
            this.getSupplierRoleListInfo(SupplierNo, GYS_JSGLY, menList);
        } else if (value.equals(PebExtConstant.NOTIFY_RECEIVE_ROLE.YYF_JSZZ)) {
            Long YYF_JSZZ = 469955800564801536L;
            if (operNo == 0L && payPurchaseOrderInfos.size() > 0 && ((PayPurchaseOrderInfo)payPurchaseOrderInfos.get(0)).getNotificationNo() != null) {
                BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(((PayPurchaseOrderInfo)payPurchaseOrderInfos.get(0)).getNotificationNo());
                operNo = billNotificationInfo.getOperNo();
            }
            log.debug("\u67e5\u627e\u8fd0\u8425\u65b9 orgID" + operNo + "roleID:" + YYF_JSZZ);
            this.getReceiver(menList, operNo, YYF_JSZZ);
        }
        if (null == menList || menList.size() == 0) {
            log.debug("\u83b7\u53d6\u5230\u7684\u7528\u6237UserID\u4e3a\u7a7a");
        }
        log.debug(JSON.toJSONString((Object)("\u8fd4\u56de\u7684\u89d2\u8272\u4fe1\u606f\u4e3a:" + JSON.toJSONString(menList))));
        return menList;
    }

    public void getReceiver(List<MemDetailInfoBO> menList, Long OrgId, Long roleId) {
        try {
            SelectAlreadyAndNorUsersReqBO reqBO = new SelectAlreadyAndNorUsersReqBO();
            reqBO.setOrgId(OrgId);
            reqBO.setRoleId(roleId);
            log.debug("\u67e5\u8be2\u7528\u6237\u5217\u8868\u5165\u53c2:" + JSON.toJSONString((Object)reqBO));
            HasUserListBO hasUserListBO = this.selectAlreadyUser.selectAlreadyDistributeUser(reqBO);
            log.debug("\u67e5\u8be2\u7528\u6237\u5217\u8868\u5165\u53c2:" + JSON.toJSONString((Object)hasUserListBO));
            List userBOS = hasUserListBO.getAllUser();
            for (UserBO userBO : userBOS) {
                menList.add(this.doGetMemInfo(userBO.getUserId()));
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5c97\u4f4d\u4fe1\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u5c97\u4f4d\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
    }

    @PostMapping(value={"doGetMemInfo"})
    public MemDetailInfoBO doGetMemInfo(@RequestBody Long userId) {
        UmcMemDetailQueryAbilityReqBO umcMemDetailQueryAbilityReqBO = new UmcMemDetailQueryAbilityReqBO();
        umcMemDetailQueryAbilityReqBO.setUserIdWeb(userId);
        log.debug("\u4f1a\u5458\u8be6\u60c5\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcMemDetailQueryAbilityReqBO));
        UmcMemDetailQueryAbilityRspBO umcMemDetailQueryAbilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(umcMemDetailQueryAbilityReqBO);
        log.debug("\u4f1a\u5458\u8be6\u60c5\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcMemDetailQueryAbilityRspBO));
        MemDetailInfoBO memDetailInfoBO = new MemDetailInfoBO();
        memDetailInfoBO.setRegEmail(umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getRegEmail());
        memDetailInfoBO.setRegMobile(umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getRegMobile());
        memDetailInfoBO.setUserId(userId);
        log.debug("\u67e5\u627e\u5230\u7684\u4fe1\u606f\u4e3a:\u90ae\u7bb1:" + memDetailInfoBO.getRegEmail() + "\u7535\u8bdd" + memDetailInfoBO.getRegMobile());
        return memDetailInfoBO;
    }

    private void getSupplierRoleListInfo(Long SUPPLIER_NO, Long supplierOrderAdminRoleId, List<MemDetailInfoBO> menList) {
        try {
            log.debug("\u8fdb\u5165\u67e5\u8be2\u4f9b\u5e94\u5546\u670d\u52a1 SUPPLIER_NO\uff1a" + SUPPLIER_NO);
            UmcQrySupplierInfoDetailAbilityReqBO supplierInfoDetail = new UmcQrySupplierInfoDetailAbilityReqBO();
            supplierInfoDetail.setSupplierId(SUPPLIER_NO);
            log.debug("\u67e5\u8be2\u4f9b\u5e94\u5546\u5165\u53c2\uff1a" + JSON.toJSONString((Object)supplierInfoDetail));
            UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = new UmcQrySupplierInfoDetailAbilityRspBO();
            umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(supplierInfoDetail);
            if (!"0000".equals(umcQrySupplierInfoDetailAbilityRspBO.getRespCode())) {
                log.debug("\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\uff1a[{}]\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)SUPPLIER_NO, (Object)umcQrySupplierInfoDetailAbilityRspBO.getRespDesc());
                throw new BusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u670d\u52a1\u4f9b\u5e94\u5546\u7684\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
            }
            log.debug("\u67e5\u8be2\u4f1a\u5458\u670d\u52a1\uff1a\u4f9b\u5e94\u5546\u8be6\u60c5\u51fa\u53c2\uff1a{}", JSON.toJSON((Object)umcQrySupplierInfoDetailAbilityRspBO));
            log.debug("\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784");
            UmcQrySupMemAbilityPageReqBO umcQrySupMem = new UmcQrySupMemAbilityPageReqBO();
            umcQrySupMem.setOrgId(umcQrySupplierInfoDetailAbilityRspBO.getOrgCode());
            UmcRspPageBO umcSupMemberInfoUmcBO = this.umcQrySupMemByPageAbilityService.qrySupplierMem(umcQrySupMem);
            if (!"0000".equals(umcSupMemberInfoUmcBO.getRespCode())) {
                log.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\uff1a[{}]\u7684\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)umcQrySupplierInfoDetailAbilityRspBO.getOrgCode(), (Object)umcSupMemberInfoUmcBO.getRespDesc());
                throw new BusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u670d\u52a1\u67e5\u8be2\u4f9b\u5e94\u5546\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
            }
            log.debug("\u6839\u636eroleID\u67e5\u627e\u7b26\u5408\u7684UserID");
            if (CollectionUtils.isNotEmpty((Collection)umcSupMemberInfoUmcBO.getRows())) {
                log.debug("\u5f00\u59cb\u67e5\u627e\u4f9b\u5e94\u5546_\u7ed3\u7b97\u7ba1\u7406\u5458");
                List rows = umcSupMemberInfoUmcBO.getRows();
                rows.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UmcSupMemberInfoBO>(Comparator.comparing(UmcSupMemberInfoBO::getUserId))), ArrayList::new)).forEach(umc -> {
                    if (CollectionUtils.isNotEmpty((Collection)umc.getUmcRoleBOS())) {
                        umc.getUmcRoleBOS().forEach(role -> {
                            log.debug("\u67e5\u627e\u5230\u8be5\u5c97\u4f4d\u4fe1\u606f\uff1a" + role.getRoleId());
                            if (supplierOrderAdminRoleId.equals(role.getRoleId())) {
                                log.debug("\u67e5\u8be2\u5230\u9002\u5408\u7684\u89d2\u8272" + umc.getUserId());
                                menList.add(this.doGetMemInfo(umc.getUserId()));
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fa7\u89d2\u8272\u4fe1\u606f\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
    }
}

