/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.tydic.payment.pay.ability.ChinaBankRealPayAbilityService;
import com.tydic.payment.pay.ability.PayProRealPayAbilityService;
import com.tydic.payment.pay.ability.bo.ChinaBankRealPayAbilityReqBo;
import com.tydic.payment.pay.ability.bo.ChinaBankRealPayAbilityRspBo;
import com.tydic.payment.pay.ability.bo.PayProRealPayAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProRealPayAbilityServiceRspBo;
import com.tydic.pfscext.api.pay.ApplyConfirmStatusService;
import com.tydic.pfscext.api.pay.bo.ConfirmStatusReqBO;
import com.tydic.pfscext.api.pay.bo.ConfirmStatusRsqBO;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.pay.ApplyConfirmStatusService"})
public class ApplyConfirmStatusServiceImpl
implements ApplyConfirmStatusService {
    private static final Logger log = LoggerFactory.getLogger(ApplyConfirmStatusServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(ApplyConfirmStatusServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private ChinaBankRealPayAbilityService chinaBankRealPayAbilityService;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PayProRealPayAbilityService payProRealPayAbilityService;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private BillSNService billSNService;
    private static final String SUBMITTED = "SUBMITTED";
    private static final String success = "success";
    @Value(value="${PAY_RESULT_CALL_BACK:http://}")
    private String PAY_RESULT_CALL_BACK;

    @PostMapping(value={"ConfirmStatusZH"})
    public ConfirmStatusRsqBO ConfirmStatusZH() {
        logger.info("\u5f00\u59cb\u6267\u884c\u4e2d\u884c\u786e\u8ba4\u4ed8\u6b3e\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1============================================");
        ConfirmStatusRsqBO confirmStatusRsqBO = new ConfirmStatusRsqBO();
        String payMathodList = PayMethod.ZH_BF.getCode();
        String timeFlag = "1";
        List<PaymentFlowInfo> paymentFlowInfos = this.paymentFlowInfoMapper.getListByConfirmStatusExceed(payMathodList, timeFlag, null);
        if (CollectionUtils.isEmpty(paymentFlowInfos)) {
            return confirmStatusRsqBO;
        }
        ArrayList<String> successPayNos = new ArrayList<String>();
        ArrayList<String> outOrderIds = new ArrayList<String>();
        try {
            paymentFlowInfos.forEach(flowInfo -> {
                ChinaBankRealPayAbilityReqBo chinaBankRealPayAbilityReqBo = new ChinaBankRealPayAbilityReqBo();
                chinaBankRealPayAbilityReqBo.setBusiCode(flowInfo.getBusiCode());
                chinaBankRealPayAbilityReqBo.setMerchantId(flowInfo.getMerchantId().toString());
                chinaBankRealPayAbilityReqBo.setPayMethod(PayMethod.ZH_SF.getCode());
                chinaBankRealPayAbilityReqBo.setOutOrderId(flowInfo.getOutOrderId());
                BigDecimal refundAmtB = flowInfo.getOrderAmt().multiply(new BigDecimal(100));
                chinaBankRealPayAbilityReqBo.setTotalFee(refundAmtB.setScale(0, 1).toString());
                logger.info("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u4e2d\u884c\u4fdd\u4ed8\u670d\u52a1\uff0c\u5165\u53c2" + chinaBankRealPayAbilityReqBo);
                ChinaBankRealPayAbilityRspBo chinaBankRealPayAbilityRspBo = this.chinaBankRealPayAbilityService.realPay(chinaBankRealPayAbilityReqBo);
                if (null != chinaBankRealPayAbilityRspBo && success.equals(chinaBankRealPayAbilityRspBo.getRespCode())) {
                    outOrderIds.add(flowInfo.getOutOrderId());
                    String[] split = flowInfo.getOutOrderId().split("-");
                    successPayNos.add(split[1]);
                }
            });
        }
        catch (Exception e) {
            if (!CollectionUtils.isEmpty(successPayNos) && !CollectionUtils.isEmpty(outOrderIds)) {
                DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                def.setPropagationBehavior(3);
                TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
                try {
                    this.updatePayMethod(successPayNos, outOrderIds, PayMethod.ZH_SF.getCode(), confirmStatusRsqBO);
                }
                catch (Exception ex) {
                    this.dataSourceTransactionManager.rollback(status);
                }
            }
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        if (!CollectionUtils.isEmpty(successPayNos) && !CollectionUtils.isEmpty(outOrderIds)) {
            this.updatePayMethod(successPayNos, outOrderIds, PayMethod.ZH_SF.getCode(), confirmStatusRsqBO);
        }
        return confirmStatusRsqBO;
    }

    @PostMapping(value={"ConfirmStatusCQT"})
    public ConfirmStatusRsqBO ConfirmStatusCQT(@RequestBody ConfirmStatusReqBO reqBO) {
        logger.info("\u5f00\u59cb\u6267\u884c\u8d22\u4f01\u901a\u53d1\u8d77\u4e8c\u6b21\u4ed8\u6b3e============================================");
        ConfirmStatusRsqBO confirmStatusRsqBO = new ConfirmStatusRsqBO();
        String payMathodList = PayMethod.ZHCQT.getCode();
        List<PaymentFlowInfo> paymentFlowInfos = this.paymentFlowInfoMapper.getListByConfirmStatusExceed(payMathodList, reqBO.getTimeFlag(), reqBO.getApplyNo());
        OrgMerchantConfigPO orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(reqBO.getOrgId());
        if (null == orgMerchantConfigPO) {
            if (log.isInfoEnabled()) {
                log.info("\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
            }
            return confirmStatusRsqBO;
        }
        if (CollectionUtils.isEmpty(paymentFlowInfos)) {
            if (log.isInfoEnabled()) {
                log.info("\u67e5\u4e0d\u5230\u5bf9\u5e94\u6d41\u6c34");
            }
            return confirmStatusRsqBO;
        }
        PaymentFlowInfo paymentFlowInfo = paymentFlowInfos.get(0);
        PayProRealPayAbilityServiceReqBo payProRealPayAbilityServiceReqBo = new PayProRealPayAbilityServiceReqBo();
        payProRealPayAbilityServiceReqBo.setBusiCode(paymentFlowInfo.getBusiCode());
        payProRealPayAbilityServiceReqBo.setMerchantId(orgMerchantConfigPO.getMerchantId().toString());
        payProRealPayAbilityServiceReqBo.setPayMethod(PayMethod.ZHCQT_SF.getCode());
        payProRealPayAbilityServiceReqBo.setOriOutOrderId(paymentFlowInfo.getOutOrderId());
        payProRealPayAbilityServiceReqBo.setNotifyUrl(paymentFlowInfo.getAsynUrl());
        Long payno = this.billSNService.getSn(BillType.PAY_APPLICATION);
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("PAYMENT-").append(payno);
        payProRealPayAbilityServiceReqBo.setOutOrderId(payOrderNo.toString());
        logger.info("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u8d22\u4f01\u901a\u5b9e\u4ed8\u670d\u52a1\uff0c\u5165\u53c2" + payProRealPayAbilityServiceReqBo);
        PayProRealPayAbilityServiceRspBo payProRealPayAbilityServiceRspBo = this.payProRealPayAbilityService.dealRealPay(payProRealPayAbilityServiceReqBo);
        logger.info("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u8d22\u4f01\u901a\u5b9e\u4ed8\u670d\u52a1\uff0c\u51fa\u53c2" + payProRealPayAbilityServiceRspBo);
        if (null == payProRealPayAbilityServiceRspBo || !SUBMITTED.equals(payProRealPayAbilityServiceRspBo.getRealPayStatus())) {
            throw new PfscExtBusinessException("18000", payProRealPayAbilityServiceRspBo.getRespDesc());
        }
        PaymentFlowInfo paymentFlowInfo1 = new PaymentFlowInfo();
        paymentFlowInfo1.setOutOrderId(paymentFlowInfo.getOutOrderId());
        paymentFlowInfo1.setExtJson(payOrderNo.toString());
        paymentFlowInfo1.setMerchantId(Long.parseLong(payProRealPayAbilityServiceReqBo.getMerchantId()));
        this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo1);
        return confirmStatusRsqBO;
    }

    private void updatePayMethod(List<String> applyNos, List<String> outOrderIds, String code, ConfirmStatusRsqBO confirmStatusRsqBO) {
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setOutOrderIds(outOrderIds);
        paymentFlowInfo.setPayType(code);
        this.paymentFlowInfoMapper.updateBatchByOutOrderId(paymentFlowInfo);
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayNos(applyNos);
        applyPayInfoPO.setPayMathod(code);
        int i = this.applyPayInfoMapper.updateStatusBatch(applyPayInfoPO);
        confirmStatusRsqBO.setRespDesc("\u6210\u529f\u6761\u6570+ " + i);
    }
}

