/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.reverse.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.pfscext.api.busi.bo.FscRefundOrderOperRspBO;
import com.tydic.pfscext.api.busi.bo.PaymentFlowInfoExtJsonBO;
import com.tydic.pfscext.api.reverse.RefundOrderOperService;
import com.tydic.pfscext.api.reverse.bo.ChangeReceiptMatchReqBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.reverse.RefundOrderOperService"})
public class RefundOrderOperServiceImpl
implements RefundOrderOperService {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderOperServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(RefundOrderOperServiceImpl.class);
    private static final String SUBMIT = "SUBMIT";
    private static final String CANCEL = "CANCEL";
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Value(value="${REFUND_RESULT_CALL_BACK:http://}")
    private String REFUND_RESULT_CALL_BACK;
    private static final String PART_REFUND = "06";
    private static final String REFUNDING = "01";
    private static final String REFUNDED = "02";
    private static final String PAY_SUBMITTED = "SUBMITTED";
    private static final String PAY_SUCCESS = "SUCCESS";

    @PostMapping(value={"makeRefund"})
    public FscRefundOrderOperRspBO makeRefund(@RequestBody ChangeReceiptMatchReqBO reqBO) {
        log.debug("\u9000\u6b3e\u63a5\u53e3====" + reqBO.toString());
        FscRefundOrderOperRspBO rspBO = new FscRefundOrderOperRspBO();
        if (SUBMIT.equals(reqBO.getOperType())) {
            String flowFlag = FlowFlag.ORDER_REIMBURSE.getCode();
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            if (StringUtils.hasText((String)reqBO.getParentOrderId())) {
                payableDetailPO.setOrderId(Long.valueOf(reqBO.getParentOrderId()));
            }
            payableDetailPO.setPurchaseOrderCode(reqBO.getOrderCode());
            payableDetailPO.setPaymentType(reqBO.getPaymentType());
            if (null != reqBO.getBusiModel()) {
                payableDetailPO.setBusiModel(Integer.valueOf(reqBO.getBusiModel()));
            }
            log.debug("\u5e94\u4ed8\u8bb0\u5f5511111====" + payableDetailPO.toString());
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListAndApplyDetail(payableDetailPO);
            log.debug("\u5e94\u4ed8\u8bb0\u5f552222=====" + payableDetailPOS.toString());
            if (REFUNDING.equals(reqBO.getPaymentType())) {
                log.debug("\u9884\u4ed8\u6b3e");
                rspBO = this.getRefundPayableDetailPOS(reqBO.getOrderAmt(), payableDetailPOS, reqBO, flowFlag);
            } else if ("03".equals(reqBO.getPaymentType())) {
                log.debug("\u8d26\u671f");
                rspBO = this.getRefundPayableDetailPOS2(reqBO.getOrderAmt(), payableDetailPOS, reqBO, flowFlag);
            }
        }
        return rspBO;
    }

    @PostMapping(value={"makeRefund2"})
    public FscRefundOrderOperRspBO makeRefund2(@RequestBody ChangeReceiptMatchReqBO reqBO) {
        FscRefundOrderOperRspBO rspBO = new FscRefundOrderOperRspBO();
        PayableDetailPO payableDetailPO = new PayableDetailPO();
        payableDetailPO.setSendGoodsNo(reqBO.getSendGoodsNo());
        if (reqBO.getOrderId() != null) {
            payableDetailPO.setOrderId(Long.parseLong(reqBO.getOrderId()));
        }
        payableDetailPO.setPurchaseOrderCode(reqBO.getOrderCode());
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListAndApplyDetail2(payableDetailPO);
        if (CollectionUtils.isEmpty(payableDetailPOS)) {
            throw new PfscExtBusinessException("18000", "\u8be5\u8ba2\u5355\u672a\u751f\u6210\u5e94\u4ed8\u5355\uff0c\u65e0\u6cd5\u53d1\u8d77\u9000\u6b3e");
        }
        for (PayableDetailPO ppo : payableDetailPOS) {
            OrgMerchantConfigPO orgMerchantConfigPO;
            if (ppo.getPayNo() == null) continue;
            Long receiptOrgId = ppo.getSupplierId();
            if (BusiModel.TRADE_MODEL.getCode().equals(ppo.getBusiModel())) {
                receiptOrgId = ppo.getOperatorId();
            }
            if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
                throw new PfscExtBusinessException("18000", "\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
            }
            String refundNo = this.billSNService.getSn(BillType.REFUND_APPLICATION).toString();
            String refundOrderNo = "REFUND-" + ppo.getPayNo() + "-" + refundNo;
            rspBO.setDealResult(REFUNDED);
            PayableDetailPO payableDetailPO2 = new PayableDetailPO();
            BeanUtils.copyProperties((Object)ppo, (Object)payableDetailPO2);
            payableDetailPO2.setRefundAmt(reqBO.getOrderAmt());
            this.createPaymentFlow2(payableDetailPO2, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode(), reqBO.getOutRefundOrderSn(), reqBO.getOrderAmt(), new Date());
            PayProRefundAbilityRspBo refundRsp = this.createRefundOrder(payableDetailPO2, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode());
            if (PAY_SUBMITTED.equals(refundRsp.getResultCode())) {
                rspBO.setDealResult(REFUNDING);
            }
            if (!PAY_SUCCESS.equals(refundRsp.getResultCode())) continue;
            PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
            paymentFlowInfo.setOutOrderId(refundOrderNo);
            paymentFlowInfo.setPayTime(new Date());
            paymentFlowInfo.setPaymentStatus(PAY_SUCCESS);
            paymentFlowInfo.setPaymentFlowId(refundRsp.getRefundTransId());
            this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
        }
        if (!StringUtils.hasText((String)rspBO.getDealResult())) {
            rspBO.setDealResult(REFUNDED);
        }
        return rspBO;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    public void createPaymentFlow(PayableDetailPO po, ChangeReceiptMatchReqBO reqBO) {
        PayableDetailPO newPO = new PayableDetailPO();
        BeanUtils.copyProperties((Object)po, (Object)newPO);
        String snNo = this.getPayInfoId("SQ");
        newPO.setPayableNo(snNo);
        newPO.setPayableAmt(reqBO.getPayOrderAmt().multiply(new BigDecimal(-1)).setScale(2, 4));
        newPO.setPayableType(Integer.valueOf(PayableType.SHYF.getCode()));
        newPO.setPendingAmt(BigDecimal.ZERO);
        newPO.setPaidAmt(BigDecimal.ZERO);
        newPO.setPurchaseOrderCode(reqBO.getOrderCode());
        newPO.setCreateDate(new Date());
        log.debug("\u751f\u6210\u552e\u540e\u5e94\u4ed8====" + newPO.toString());
        this.payableDetailMapper.insert(newPO);
    }

    public void createPaymentFlow2(PayableDetailPO payableDetailPO, ChangeReceiptMatchReqBO reqBO, String refundOrderNo, String busiCode, String outRefundOrderSn, BigDecimal canRefundAmt, Date date) {
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        if (null != date) {
            paymentFlowInfo.setPayTime(date);
        } else {
            paymentFlowInfo.setPayTime(new Date());
        }
        paymentFlowInfo.setAsynUrl(this.REFUND_RESULT_CALL_BACK);
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("PAYMENT-").append(null != payableDetailPO.getPayNo() ? payableDetailPO.getPayNo() : "");
        PaymentFlowInfo paymentPO = this.paymentFlowInfoMapper.selectByOutOrderId(payOrderNo.toString());
        if (null != paymentPO) {
            paymentFlowInfo.setPayType(paymentPO.getPayType());
            paymentFlowInfo.setPayName(paymentPO.getRecName());
            paymentFlowInfo.setRecName(paymentPO.getPayName());
            paymentFlowInfo.setOrderCode(paymentPO.getOrderCode());
            paymentFlowInfo.setOrgId(paymentPO.getOrgId());
            paymentFlowInfo.setPayOrgNo(paymentPO.getRecOrgNo());
            paymentFlowInfo.setPayAcctNo(paymentPO.getRecAcctNo());
            paymentFlowInfo.setPayAcctName(paymentPO.getRecAcctName());
            paymentFlowInfo.setRecOrgNo(paymentPO.getPayOrgNo());
            paymentFlowInfo.setRecAcctNo(paymentPO.getPayAcctNo());
            paymentFlowInfo.setRecAcctName(paymentPO.getPayAcctName());
            paymentFlowInfo.setPayChannel(paymentPO.getPayChannel());
        }
        paymentFlowInfo.setOrderCode(reqBO.getOrderCode());
        paymentFlowInfo.setOutOrderId(refundOrderNo);
        paymentFlowInfo.setReturnOutOrderId(payOrderNo.toString());
        paymentFlowInfo.setOrderAmt(reqBO.getOrderAmt());
        paymentFlowInfo.setOrderDesc(FlowFlag.ORDER_REIMBURSE.getDescr());
        paymentFlowInfo.setCreateUserId(reqBO.getOperatorId());
        paymentFlowInfo.setCreateUserName(reqBO.getOperatorName());
        paymentFlowInfo.setFlowFlag(FlowFlag.ORDER_REIMBURSE.getCode());
        paymentFlowInfo.setCreateTime(new Date());
        paymentFlowInfo.setClientIp(reqBO.getIpAddress());
        paymentFlowInfo.setBusiCode(busiCode);
        PaymentFlowInfoExtJsonBO paymentFlowInfoExtJsonBO = new PaymentFlowInfoExtJsonBO();
        paymentFlowInfoExtJsonBO.setOutRefundOrderSn(outRefundOrderSn);
        paymentFlowInfoExtJsonBO.setRefundAmt(canRefundAmt);
        paymentFlowInfo.setExtJson(JSON.toJSONString((Object)paymentFlowInfoExtJsonBO));
        try {
            paymentFlowInfo.setFlowType(Integer.parseInt(reqBO.getFlowType()));
        }
        catch (NumberFormatException e) {
            paymentFlowInfo.setFlowType(0);
            log.error("\u7528\u6237\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        log.debug("\u751f\u6210\u6d41\u6c34\u5165\u53c2\uff1a" + paymentFlowInfo.toString());
        this.paymentFlowInfoMapper.insert(paymentFlowInfo);
    }

    private PayProRefundAbilityRspBo createRefundOrder(PayableDetailPO payableDetailPO, ChangeReceiptMatchReqBO reqBO, String refundOrderNo, String busiCode) {
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("PAYMENT-").append(payableDetailPO.getPayNo());
        payProRefundAbilityReqBo.setRefundOutOrderId(refundOrderNo);
        payProRefundAbilityReqBo.setOriOutOrderId(payOrderNo.toString());
        payProRefundAbilityReqBo.setBusiCode(busiCode);
        BigDecimal refundAmtB = payableDetailPO.getRefundAmt().multiply(new BigDecimal(100));
        payProRefundAbilityReqBo.setRefundFee(refundAmtB.setScale(0, 1).toString());
        payProRefundAbilityReqBo.setNotifyUrl(this.REFUND_RESULT_CALL_BACK);
        payProRefundAbilityReqBo.setCreateOperId(String.valueOf(reqBO.getOperatorId()));
        payProRefundAbilityReqBo.setCreateOperIdName(reqBO.getOperatorName());
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(payableDetailPO.getPayNo());
        if (null == applyDetails || applyDetails.size() == 0) {
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u3010" + payableDetailPO.getPayableNo() + "\u3011\u672a\u67e5\u627e\u5230\u4ed8\u6b3e\u7533\u8bf7\u6210\u529f\u8bb0\u5f55\uff01");
        }
        BigDecimal paymentAmt = BigDecimal.ZERO;
        for (ApplyDetail applyDetail : applyDetails) {
            paymentAmt = paymentAmt.add(applyDetail.getAmt());
        }
        if (payableDetailPO.getRefundAmt().compareTo(paymentAmt) < 0) {
            payProRefundAbilityReqBo.setOrderType(PART_REFUND);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!"0000".equals(payProRefundAbilityRspBo.getRespCode())) {
            log.error("\u521b\u5efa\u9000\u6b3e\u8ba2\u5355[" + payOrderNo.toString() + "]\u5931\u8d25,\uff1a" + payProRefundAbilityRspBo.getRespDesc());
            this.savelog("CreateRefundOrderService-1", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        } else {
            this.savelog("CreateRefundOrderService-2", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        return payProRefundAbilityRspBo;
    }

    private FscRefundOrderOperRspBO getRefundPayableDetailPOS(BigDecimal refundAmtSum, List<PayableDetailPO> payableDetailPOS, ChangeReceiptMatchReqBO reqBO, String flowFlag) {
        FscRefundOrderOperRspBO rspBO = new FscRefundOrderOperRspBO();
        log.debug("\u5e94\u4ed8\u8bb0\u5f552====" + payableDetailPOS.toString());
        log.debug("refundAmtSum===" + refundAmtSum);
        ArrayList refundPayableDetailPOS = new ArrayList();
        Boolean flag = false;
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            if (payableDetailPO.getPendingAmt().compareTo(BigDecimal.ZERO) > 0) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u3010" + payableDetailPO.getPayableNo() + "\u3011\u5904\u4e8e\u4ed8\u6b3e\u4e2d\u72b6\u6001\uff0c\u8bf7\u5f85\u5e94\u4ed8\u5355\u4ed8\u6b3e\u5b8c\u6210\uff0c\u518d\u8fdb\u884c\u9000\u6b3e");
            }
            if (!PayableType.INSPECTION.getCode().equals(payableDetailPO.getPayableType().toString()) && !PayableType.SFYF.getCode().equals(payableDetailPO.getPayableType().toString()) && !PayableType.YFYSYF.getCode().equals(payableDetailPO.getPayableType().toString())) continue;
            flag = true;
        }
        if (!flag.booleanValue()) {
            log.debug("\u65e0\u9a8c\u6536\u5e94\u4ed8===");
            for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                OrgMerchantConfigPO orgMerchantConfigPO;
                ApplyPayInfoPO applyInfo = this.applyPayInfoMapper.getModelById(payableDetailPO.getPayNo());
                String refundNo = this.billSNService.getSn(BillType.REFUND_APPLICATION).toString();
                String refundOrderNo = "REFUND-" + refundNo;
                Long receiptOrgId = payableDetailPOS.get(0).getSupplierId();
                if (BusiModel.TRADE_MODEL.getCode().equals(payableDetailPOS.get(0).getBusiModel().toString())) {
                    receiptOrgId = payableDetailPOS.get(0).getOperatorId();
                }
                if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
                    throw new PfscExtBusinessException("18000", "\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
                }
                boolean falgOne = PayMethod.ZHCQT.getCode().equals(applyInfo.getPayMathod());
                boolean falgTwo = PayMethod.ZH_BF.getCode().equals(applyInfo.getPayMathod()) || PayMethod.ZHCQT_SF.getCode().equals(applyInfo.getPayMathod()) || PayMethod.ZH_SF.getCode().equals(applyInfo.getPayMathod());
                boolean falgThree = PayMethod.XXZF.getCode().equals(applyInfo.getPayMathod());
                if (falgOne || falgTwo || falgThree) {
                    LOGGER.info("\u7ebf\u4e0b\u9000\u6b3e\u8bb0\u5f55\uff1a" + reqBO.getOutRefundOrderSn());
                    this.createPaymentFlow2(payableDetailPO, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode(), reqBO.getOutRefundOrderSn(), reqBO.getOrderAmt(), new Date());
                    continue;
                }
                if (!PayableType.YFYF.getCode().equals(payableDetailPO.getPayableType().toString()) && !PayableType.RYYF.getCode().equals(payableDetailPO.getPayableType().toString())) continue;
                log.debug("\u9884\u4ed8/\u5197\u4f59\u7269\u8d44\u5e94\u4ed8");
                rspBO = this.checkPayableStatus(payableDetailPO, reqBO);
                return rspBO;
            }
        } else {
            log.debug("\u6709\u9a8c\u6536\u5e94\u4ed8222222");
            BigDecimal total = BigDecimal.ZERO;
            for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                total = total.add(payableDetailPO.getPayableAmt());
            }
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            PayableDetailPO ysyf = new PayableDetailPO();
            Integer ysSuccess = 0;
            BigDecimal ysk = BigDecimal.ZERO;
            BigDecimal yfk = BigDecimal.ZERO;
            for (PayableDetailPO payableDetailPO2 : payableDetailPOS) {
                if (PayableType.INSPECTION.getCode().equals(payableDetailPO2.getPayableType().toString()) || PayableType.YFYSYF.getCode().equals(payableDetailPO2.getPayableType().toString())) {
                    ysk = payableDetailPO2.getPayableAmt();
                    BeanUtils.copyProperties((Object)payableDetailPO2, (Object)ysyf);
                    if (PayableStatus.SUCCESS.getCode().equals(payableDetailPO2.getPayableStatus())) {
                        ysSuccess = 1;
                    }
                }
                if (!PayableType.YFYF.getCode().equals(payableDetailPO2.getPayableType().toString())) continue;
                yfk = payableDetailPO2.getPayableAmt();
                BeanUtils.copyProperties((Object)payableDetailPO2, (Object)payableDetailPO);
            }
            if (ysSuccess == 0) {
                log.debug("\u9a8c\u6536\u5e94\u4ed8-\u672a\u4ed8\u6b3e=====");
                for (PayableDetailPO payableDetailPO2 : payableDetailPOS) {
                    PayableDetailPO po;
                    OrgMerchantConfigPO orgMerchantConfigPO;
                    Long receiptOrgId = payableDetailPO2.getSupplierId();
                    if (BusiModel.TRADE_MODEL.getCode().equals(payableDetailPO2.getBusiModel().toString())) {
                        receiptOrgId = payableDetailPO2.getOperatorId();
                    }
                    if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
                        rspBO.setRespCode("18000");
                        rspBO.setRespDesc("\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f!");
                        return rspBO;
                    }
                    rspBO.setDealResult(REFUNDED);
                    String refundNo = this.billSNService.getSn(BillType.REFUND_APPLICATION).toString();
                    String refundOrderNo = "REFUND-" + refundNo;
                    LOGGER.info("\u751f\u6210\u6d41\u6c34\u7684\u5916\u90e8\u8ba2\u5355\u53f7\uff1a" + reqBO.getOutRefundOrderSn());
                    if (!PayableType.INSPECTION.getCode().equals(payableDetailPO2.getPayableType().toString()) && !PayableType.YFYSYF.getCode().equals(payableDetailPO2.getPayableType().toString()) || !PayableStatus.PENDING.getCode().equals(payableDetailPO2.getPayableStatus())) continue;
                    if ((refundAmtSum = refundAmtSum.subtract(payableDetailPO2.getPayableAmt())).compareTo(BigDecimal.ZERO) == 0) {
                        po = new PayableDetailPO();
                        po.setPayableNo(payableDetailPO2.getPayableNo());
                        po.setPayableAmt(BigDecimal.ZERO);
                        po.setPayableStatus(PayableStatus.TERMINATION.getCode());
                        po.setOrderAmt(payableDetailPO2.getOrderAmt().subtract(reqBO.getOrderAmt()));
                        this.updateRefundPayable(po);
                        continue;
                    }
                    if (refundAmtSum.compareTo(BigDecimal.ZERO) < 0) {
                        payableDetailPO2.setRefundAmt(refundAmtSum.abs());
                        po = new PayableDetailPO();
                        po.setPayableNo(payableDetailPO2.getPayableNo());
                        po.setPayableAmt(payableDetailPO2.getRefundAmt());
                        po.setOrderAmt(payableDetailPO2.getOrderAmt().subtract(reqBO.getOrderAmt()));
                        this.updateRefundPayable(po);
                    } else {
                        ApplyPayInfoPO applyInfo = this.applyPayInfoMapper.getModelById(payableDetailPO.getPayNo());
                        boolean falgOne = PayMethod.ZHCQT.getCode().equals(applyInfo.getPayMathod());
                        boolean falgTwo = PayMethod.ZH_BF.getCode().equals(applyInfo.getPayMathod()) || PayMethod.ZHCQT_SF.getCode().equals(applyInfo.getPayMathod()) || PayMethod.ZH_SF.getCode().equals(applyInfo.getPayMathod());
                        boolean falgThree = PayMethod.XXZF.getCode().equals(applyInfo.getPayMathod());
                        if (falgOne || falgTwo || falgThree) {
                            LOGGER.info("\u7ebf\u4e0b\u9000\u6b3e\u8bb0\u5f55\uff1a" + reqBO.getOutRefundOrderSn());
                            this.createPaymentFlow2(payableDetailPO2, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode(), reqBO.getOutRefundOrderSn(), refundAmtSum, new Date());
                            continue;
                        }
                        payableDetailPO.setRefundAmt(refundAmtSum);
                        this.createPaymentFlow2(payableDetailPO, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode(), reqBO.getOutRefundOrderSn(), payableDetailPO.getRefundAmt(), null);
                        PayProRefundAbilityRspBo refundRsp = this.createRefundOrder(payableDetailPO, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode());
                        if (PAY_SUBMITTED.equals(refundRsp.getResultCode())) {
                            rspBO.setDealResult(REFUNDING);
                        }
                        if (PAY_SUCCESS.equals(refundRsp.getResultCode())) {
                            PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                            paymentFlowInfo.setOutOrderId(refundOrderNo);
                            paymentFlowInfo.setPayTime(new Date());
                            paymentFlowInfo.setPaymentStatus(PAY_SUCCESS);
                            paymentFlowInfo.setPaymentFlowId(refundRsp.getRefundTransId());
                            this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
                            PayableDetailPO po2 = new PayableDetailPO();
                            po2.setPayableNo(payableDetailPO2.getPayableNo());
                            po2.setPayableAmt(BigDecimal.ZERO);
                            po2.setPayableStatus(PayableStatus.TERMINATION.getCode());
                            po2.setOrderAmt(payableDetailPO2.getOrderAmt().subtract(reqBO.getOrderAmt()));
                            this.updateRefundPayable(po2);
                        } else if ("214007".equals(refundRsp.getRespCode())) {
                            PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                            paymentFlowInfo.setOutOrderId(refundOrderNo);
                            paymentFlowInfo.setPayTime(new Date());
                            paymentFlowInfo.setPaymentStatus(refundRsp.getResultCode());
                            paymentFlowInfo.setPaymentFlowId(refundRsp.getRefundTransId());
                            this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
                            PayableDetailPO po3 = new PayableDetailPO();
                            po3.setPayableNo(payableDetailPO2.getPayableNo());
                            po3.setPayableAmt(BigDecimal.ZERO);
                            po3.setPayableStatus(PayableStatus.TERMINATION.getCode());
                            this.updateRefundPayable(po3);
                        } else {
                            throw new PfscExtBusinessException("18000", refundRsp.getRespDesc());
                        }
                        if (!StringUtils.hasText((String)rspBO.getDealResult())) {
                            rspBO.setDealResult(REFUNDED);
                        }
                    }
                    break;
                }
            } else {
                Boolean isOff;
                log.debug("\u9a8c\u6536\u5e94\u4ed8-\u5df2\u4ed8\u6b3e=====");
                BigDecimal canRefundAmt = reqBO.getOrderAmt().subtract(ysk);
                log.debug("\u8ba2\u5355\u63a8\u9001\u9000\u6b3e\u91d1\u989d\uff1a" + reqBO.getOrderAmt() + ",\u9a8c\u6536\u6b3e\u91d1\u989d\uff1a" + ysk + "\uff0c\u5269\u4f59\u9000\u6b3e\u91d1\u989d\uff1a" + canRefundAmt);
                if (canRefundAmt.compareTo(BigDecimal.ZERO) > 0) {
                    log.debug("\u9000\u6b3e\u91d1\u989d-\u9a8c\u6536\u6b3e\u5e94\u4ed8\u91d1\u989d > 0");
                    reqBO.setOrderAmt(ysyf.getPayableAmt());
                    isOff = this.isOff(ysyf, reqBO);
                    if (!isOff.booleanValue()) {
                        reqBO.setOrderAmt(ysyf.getPayableAmt());
                        rspBO = this.checkOk(ysyf, reqBO);
                    }
                    reqBO.setOrderAmt(canRefundAmt);
                    Boolean isOff2 = this.isOff(payableDetailPO, reqBO);
                    if (!isOff2.booleanValue()) {
                        rspBO = this.checkOk(payableDetailPO, reqBO);
                    }
                } else {
                    if (canRefundAmt.compareTo(BigDecimal.ZERO) == 0) {
                        log.debug("\u9000\u6b3e\u91d1\u989d-\u9a8c\u6536\u6b3e\u5e94\u4ed8\u91d1\u989d = 0");
                        reqBO.setOrderAmt(ysyf.getPayableAmt());
                        isOff = this.isOff(ysyf, reqBO);
                        if (!isOff.booleanValue()) {
                            rspBO = this.checkOk(ysyf, reqBO);
                        }
                    }
                    if (canRefundAmt.compareTo(BigDecimal.ZERO) < 0) {
                        log.debug("\u9000\u6b3e\u91d1\u989d-\u9a8c\u6536\u6b3e\u5e94\u4ed8\u91d1\u989d < 0");
                        isOff = this.isOff(ysyf, reqBO);
                        if (!isOff.booleanValue()) {
                            rspBO = this.checkOk(ysyf, reqBO);
                        }
                    }
                }
            }
        }
        return rspBO;
    }

    private Boolean isOff(PayableDetailPO payableDetailPO, ChangeReceiptMatchReqBO reqBO) {
        OrgMerchantConfigPO orgMerchantConfigPO;
        ApplyPayInfoPO applyInfo = this.applyPayInfoMapper.getModelById(payableDetailPO.getPayNo());
        String refundNo = this.billSNService.getSn(BillType.REFUND_APPLICATION).toString();
        String refundOrderNo = "REFUND-" + refundNo;
        Long receiptOrgId = payableDetailPO.getSupplierId();
        if (BusiModel.TRADE_MODEL.getCode().equals(payableDetailPO.getBusiModel().toString())) {
            receiptOrgId = payableDetailPO.getOperatorId();
        }
        if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
            throw new PfscExtBusinessException("18000", "\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
        }
        boolean falgOne = PayMethod.ZHCQT.getCode().equals(applyInfo.getPayMathod());
        boolean falgTwo = PayMethod.ZH_BF.getCode().equals(applyInfo.getPayMathod()) || PayMethod.ZHCQT_SF.getCode().equals(applyInfo.getPayMathod()) || PayMethod.ZH_SF.getCode().equals(applyInfo.getPayMathod());
        boolean falgThree = PayMethod.XXZF.getCode().equals(applyInfo.getPayMathod());
        if (falgOne || falgTwo || falgThree) {
            LOGGER.info("\u7ebf\u4e0b\u9000\u6b3e\u8bb0\u5f55\uff1a" + reqBO.getOutRefundOrderSn());
            this.createPaymentFlow2(payableDetailPO, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode(), reqBO.getOutRefundOrderSn(), reqBO.getOrderAmt(), new Date());
            return true;
        }
        return false;
    }

    private FscRefundOrderOperRspBO getRefundPayableDetailPOS2(BigDecimal refundAmtSum, List<PayableDetailPO> payableDetailPOS, ChangeReceiptMatchReqBO reqBO, String flowFlag) {
        log.debug("\u8d26\u671f\u5e94\u4ed8=====" + payableDetailPOS.toString());
        FscRefundOrderOperRspBO rspBO = new FscRefundOrderOperRspBO();
        for (PayableDetailPO po : payableDetailPOS) {
            if (po.getPendingAmt().compareTo(BigDecimal.ZERO) > 0) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u3010" + po.getPayableNo() + "\u3011\u5904\u4e8e\u4ed8\u6b3e\u4e2d\u72b6\u6001\uff0c\u8bf7\u5f85\u5e94\u4ed8\u5355\u4ed8\u6b3e\u5b8c\u6210\uff0c\u518d\u8fdb\u884c\u9000\u6b3e");
            }
            if (!PayableType.EXPIRE.getCode().equals(po.getPayableType().toString())) continue;
            rspBO = this.checkPayableStatus(po, reqBO);
            return rspBO;
        }
        return rspBO;
    }

    private FscRefundOrderOperRspBO checkPayableStatus(PayableDetailPO po, ChangeReceiptMatchReqBO reqBO) {
        FscRefundOrderOperRspBO rspBO = new FscRefundOrderOperRspBO();
        if (po.getPendingAmt().compareTo(BigDecimal.ZERO) > 0) {
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u3010" + po.getPayableNo() + "\u3011\u5904\u4e8e\u4ed8\u6b3e\u4e2d\u72b6\u6001\uff0c\u8bf7\u5f85\u5e94\u4ed8\u5355\u4ed8\u6b3e\u5b8c\u6210\uff0c\u518d\u8fdb\u884c\u9000\u6b3e");
        }
        if (PayableStatus.SUCCESS.getCode().equals(po.getPayableStatus())) {
            if (StringUtils.hasText((String)po.getPayNo())) {
                Boolean isOff = this.isOff(po, reqBO);
                if (!isOff.booleanValue()) {
                    rspBO = this.checkOk(po, reqBO);
                    return rspBO;
                }
            } else {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u3010" + po.getPayableNo() + "\u3011\u672a\u53d1\u8d77\u4ed8\u6b3e\u7533\u8bf7\uff01");
            }
        }
        if (PayableStatus.PAYING.getCode().equals(po.getPayableStatus())) {
            BigDecimal noPay = po.getPayableAmt().subtract(po.getPaidAmt());
            BigDecimal canRefundAmt = reqBO.getOrderAmt().subtract(noPay);
            PayableDetailPO detailPO = new PayableDetailPO();
            detailPO.setPayableNo(po.getPayableNo());
            detailPO.setPayableAmt(po.getPayableAmt().subtract(reqBO.getOrderAmt()));
            detailPO.setOrderAmt(po.getOrderAmt().subtract(reqBO.getOrderAmt()));
            if (canRefundAmt.compareTo(BigDecimal.ZERO) > 0) {
                detailPO.setPayableStatus(PayableStatus.TERMINATION.getCode());
                reqBO.setOrderAmt(canRefundAmt);
                Boolean isOff = this.isOff(po, reqBO);
                if (!isOff.booleanValue()) {
                    rspBO = this.checkOk(po, reqBO);
                    return rspBO;
                }
            }
            this.updateRefundPayable(detailPO);
        }
        if (PayableStatus.PENDING.getCode().equals(po.getPayableStatus())) {
            PayableDetailPO detailPO = new PayableDetailPO();
            detailPO.setPayableNo(po.getPayableNo());
            detailPO.setPayableAmt(po.getPayableAmt().subtract(reqBO.getOrderAmt()));
            detailPO.setOrderAmt(po.getOrderAmt().subtract(reqBO.getOrderAmt()));
            this.updateRefundPayable(detailPO);
            return rspBO;
        }
        return rspBO;
    }

    private FscRefundOrderOperRspBO checkOk(PayableDetailPO po, ChangeReceiptMatchReqBO reqBO) {
        OrgMerchantConfigPO orgMerchantConfigPO;
        FscRefundOrderOperRspBO rspBO = new FscRefundOrderOperRspBO();
        Long receiptOrgId = po.getSupplierId();
        if (BusiModel.TRADE_MODEL.getCode().equals(po.getBusiModel().toString())) {
            receiptOrgId = po.getOperatorId();
        }
        if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f!");
            return rspBO;
        }
        rspBO.setDealResult(REFUNDED);
        String refundNo = this.billSNService.getSn(BillType.REFUND_APPLICATION).toString();
        String refundOrderNo = "REFUND-" + refundNo;
        LOGGER.info("\u751f\u6210\u6d41\u6c34\u7684\u5916\u90e8\u8ba2\u5355\u53f7\uff1a" + reqBO.getOutRefundOrderSn());
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("PAYMENT-").append(po.getPayNo());
        PaymentFlowInfo record = new PaymentFlowInfo();
        record.setOutOrderId(payOrderNo.toString());
        record.setPaymentStatus(PAY_SUCCESS);
        log.debug("paymentFlowInfoMapper.select\u5165\u53c2===" + record.toString());
        PaymentFlowInfo flowInfo = this.paymentFlowInfoMapper.select(record);
        if (flowInfo != null && flowInfo.getOrderAmt() != null) {
            po.setRefundAmt(reqBO.getOrderAmt());
            this.createPaymentFlow2(po, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode(), reqBO.getOutRefundOrderSn(), reqBO.getOrderAmt(), null);
            PayProRefundAbilityRspBo refundRsp = this.createRefundOrder(po, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode());
            if (PAY_SUBMITTED.equals(refundRsp.getResultCode())) {
                rspBO.setDealResult(REFUNDING);
            }
            if (PAY_SUCCESS.equals(refundRsp.getResultCode())) {
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                paymentFlowInfo.setOutOrderId(refundOrderNo);
                paymentFlowInfo.setPayTime(new Date());
                paymentFlowInfo.setPaymentStatus(PAY_SUCCESS);
                paymentFlowInfo.setPaymentFlowId(refundRsp.getRefundTransId());
                this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u3010" + po.getPayableNo() + "\u3011\u672a\u67e5\u627e\u5230\u4ed8\u6b3e\u6d41\u6c34\uff01");
        }
        if (!StringUtils.hasText((String)rspBO.getDealResult())) {
            rspBO.setDealResult(REFUNDED);
            return rspBO;
        }
        return rspBO;
    }

    private void updateRefundPayable(PayableDetailPO needRefundPayableDetailPO) {
        int result = this.payableDetailMapper.updateSelective(needRefundPayableDetailPO);
        if (result < 1) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u3010" + needRefundPayableDetailPO.getPayableNo() + "\u3011\u66f4\u65b0\u5931\u8d25");
        }
    }

    @PostMapping(value={"refund"})
    public FscRefundOrderOperRspBO refund(@RequestBody ChangeReceiptMatchReqBO reqBO) {
        FscRefundOrderOperRspBO rspBO = new FscRefundOrderOperRspBO();
        if (!StringUtils.hasText((String)reqBO.getPayableNo())) {
            rspBO.setRespDesc("\u5e94\u4ed8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getOrderAmt()) {
            rspBO.setRespDesc("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String payableNo = reqBO.getPayableNo();
        PayableDetailPO payableDetailPOS = this.payableDetailMapper.getModelById(payableNo);
        if (PayableStatus.SUCCESS.getCode().equals(payableDetailPOS.getPayableStatus())) {
            StringBuffer payOrderNo = new StringBuffer();
            payOrderNo.append("PAYMENT-").append(null != payableDetailPOS.getApplyNo() ? payableDetailPOS.getApplyNo() : "");
            PaymentFlowInfo paymentPO = this.paymentFlowInfoMapper.selectByOutOrderId(payOrderNo.toString());
            reqBO.setOperatorId(paymentPO.getCreateUserId());
            reqBO.setOperatorName(paymentPO.getCreateUserName());
            String refundNo = this.billSNService.getSn(BillType.REFUND_APPLICATION).toString();
            String refundOrderNo = "REFUND-" + refundNo;
            String busiCode = paymentPO.getBusiCode();
            reqBO.setOutRefundOrderSn(paymentPO.getOutOrderId());
            this.createPaymentFlow2(payableDetailPOS, reqBO, refundOrderNo, busiCode, reqBO.getOutRefundOrderSn(), reqBO.getOrderAmt(), null);
            PayProRefundAbilityRspBo refundRsp = this.createRefundOrder(payableDetailPOS, reqBO, refundOrderNo, busiCode);
            rspBO.setRespCode(refundRsp.getRespCode());
            rspBO.setRespDesc(refundRsp.getRespDesc());
        }
        return rspBO;
    }

    private String getPayInfoId(String prefix) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String maxNum = this.payableDetailMapper.selectMaxPayNoNum(prefix + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u5355\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }
}

