/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.tydic.pfscext.api.busi.bo.BusiNotificationReqBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationRspBO;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoDetailBO;
import com.tydic.pfscext.api.trade.ExpetionBillNoTficationService;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfoExt;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.CreateEntryInfoService;
import com.tydic.pfscext.service.atom.PayableService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.ExpetionBillNoTficationService"})
public class ExpetionBillNoTficationServiceImpl
implements ExpetionBillNoTficationService {
    private static final Logger logger = LoggerFactory.getLogger(ExpetionBillNoTficationServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private PayableService payableService;
    @Autowired
    private CreateEntryInfoService createEntryInfoService;

    @PostMapping(value={"addExpetionBill"})
    public BusiNotificationRspBO addExpetionBill(@RequestBody BusiNotificationReqBO reqBO) {
        BusiNotificationRspBO busiNotificationRspBO = new BusiNotificationRspBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (reqBO == null) {
            busiNotificationRspBO.setRespCode("18000");
            busiNotificationRspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return busiNotificationRspBO;
        }
        if (reqBO.getOrderCodes().size() == 0) {
            busiNotificationRspBO.setRespCode("18000");
            busiNotificationRspBO.setRespDesc("\u6ca1\u6709\u9009\u62e9\u8ba2\u5355");
            return busiNotificationRspBO;
        }
        if (reqBO.getSource() == null) {
            busiNotificationRspBO.setRespCode("18000");
            busiNotificationRspBO.setRespDesc("\u6765\u6e90\u4e0d\u80fd\u4e0d\u80fd\u4e3a\u7a7a");
            return busiNotificationRspBO;
        }
        try {
            PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
            payPurchaseOrderInfoVO.setOrderCodes(reqBO.getOrderCodes());
            List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListExtException(payPurchaseOrderInfoVO);
            if (payPurchaseOrderInfoPOs != null && payPurchaseOrderInfoPOs.size() > 0) {
                BigDecimal amt = new BigDecimal("0");
                int count = 0;
                for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoPOs) {
                    amt = amt.add(payPurchaseOrderInfo.getOrderAmt());
                    if (!"01".equals(payPurchaseOrderInfo.getPayType())) continue;
                    ++count;
                }
                if (count != 0 && count != payPurchaseOrderInfoPOs.size()) {
                    busiNotificationRspBO.setRespCode("18000");
                    busiNotificationRspBO.setRespDesc("\u8d26\u671f\u652f\u4ed8\u7684\u8ba2\u5355\u4e0d\u80fd\u548c\u5176\u4ed6\u4ed8\u6b3e\u65b9\u5f0f\u7684\u8ba2\u5355\u4e00\u8d77\u63d0\u4ea4\u5f00\u7968\u901a\u77e5\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    return busiNotificationRspBO;
                }
                String notifyNo = this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION);
                BillNotificationInfoExt notifyInfo = new BillNotificationInfoExt();
                notifyInfo.setNotificationNo(notifyNo);
                notifyInfo.setAmt(amt);
                notifyInfo.setApplyDate(new Date());
                notifyInfo.setOperNo(payPurchaseOrderInfoPOs.get(0).getOperUnitNo());
                notifyInfo.setSource(String.valueOf(reqBO.getSource()));
                notifyInfo.setSupplierNo(payPurchaseOrderInfoPOs.get(0).getSupplierNo());
                notifyInfo.setSupplierName(payPurchaseOrderInfoPOs.get(0).getSupplierName());
                notifyInfo.setUserId(reqBO.getUserId());
                notifyInfo.setPurchaseSaleType(payPurchaseOrderInfoPOs.get(0).getPurchaseSaleType());
                notifyInfo.setStartOrgId(String.valueOf(reqBO.getOrgId()));
                notifyInfo.setIsPay(1);
                notifyInfo.setDrawerId(reqBO.getUserId());
                notifyInfo.setDrawerName(reqBO.getName());
                notifyInfo.setBillNotificationType(1);
                notifyInfo.setInvoiceStatus("03");
                int insert = this.billNotificationInfoMapper.insert(notifyInfo);
                if (insert > 0) {
                    PayPurchaseOrderInfo payOrderInfo = new PayPurchaseOrderInfo();
                    payOrderInfo.setNotificationNo(notifyNo);
                    payOrderInfo.setOrderStatus(OrderStatus.RECEIVE_BILL.getCode());
                    payOrderInfo.setOrderCodes(reqBO.getOrderCodes());
                    this.payPurchaseOrderInfoMapper.updateBySaleCodes(payOrderInfo);
                    PayItemInfo item = new PayItemInfo();
                    item.setNotificationNo(notifyNo);
                    item.setOrderCodes(reqBO.getOrderCodes());
                    item.setItemStatus(OrderStatus.RECEIVE_BILL.getCode());
                    this.payItemInfoMapper.updateByOrderCodes(item);
                }
                String busiModel = "1";
                if ("01".equals(payPurchaseOrderInfoPOs.get(0).getPayType())) {
                    logger.debug("\u51c6\u5907\u4ea7\u751f\u5e94\u4ed8\u6b3e\u5355,\u901a\u77e5\u5355\u53f7=" + notifyNo);
                    List<PayPurchaseOrderInfoDetailBO> payPurchaseOrderInfoDetailBOs = this.payPurchaseOrderInfoMapper.getListByNo(notifyNo);
                    if (payPurchaseOrderInfoDetailBOs != null && payPurchaseOrderInfoDetailBOs.size() > 0) {
                        busiModel = payPurchaseOrderInfoDetailBOs.get(0).getBusiModel();
                    }
                }
                BigDecimal writeOffAmt = BigDecimal.ZERO;
                Long companyId = reqBO.getCompanyId();
                List<PayableDetailPO> payLs = this.payableService.createPayableBill(notifyNo, companyId, reqBO.getIsProfessionalOrgExt(), busiModel);
                if (payLs.size() > 0) {
                    writeOffAmt = payLs.get(0).getNeedAgainstAmt();
                }
            }
            busiNotificationRspBO.setRespCode("0000");
            busiNotificationRspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u751f\u4ea7\u5f00\u7968\u901a\u77e5\u5355\u5931\u8d25\uff1a", (Throwable)e);
            busiNotificationRspBO.setRespCode("18000");
            busiNotificationRspBO.setRespDesc("\u751f\u4ea7\u5f00\u7968\u901a\u77e5\u5355\u5931\u8d25");
            return busiNotificationRspBO;
        }
        return busiNotificationRspBO;
    }
}

