/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.busi.VerifySaleOrderInfoService;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoAwaitReqBO;
import com.tydic.pfscext.api.busi.bo.SaleOrderVerifyReqBO;
import com.tydic.pfscext.api.busi.bo.VerifyPurchaseOrderRspBO;
import com.tydic.pfscext.api.trade.MakeBillApplyInfoMsgService;
import com.tydic.pfscext.api.zm.bo.MakeBillApplyInfoMsgReqBO;
import com.tydic.pfscext.api.zm.bo.MakeBillApplyInfoMsgRspBO;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.vo.SaleOrderInfoQueryVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.MakeBillApplyInfoMsgService"})
public class MakeBillApplyInfoMsgServiceImpl
implements MakeBillApplyInfoMsgService {
    private static final Logger log = LoggerFactory.getLogger(MakeBillApplyInfoMsgServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private VerifySaleOrderInfoService verifySaleOrderInfoService;
    @Resource(name="fscMakeApplyMsgProvider")
    private ProxyMessageProducer proxyMessageProducer;
    private final String SEND_SUCCESS = "SEND_OK";
    @Value(value="${FSC_MAKE_APPLY_TOPIC:FSC_MAKE_APPLY_TOPIC}")
    private String makeApplyTopic;
    @Value(value="${FSC_MAKE_APPLY_TAG:*}")
    private String tag;

    @PostMapping(value={"makeBillApplyInfoMsg"})
    public MakeBillApplyInfoMsgRspBO makeBillApplyInfoMsg(@RequestBody MakeBillApplyInfoMsgReqBO reqBO) {
        if (reqBO.getQueryPayPurchaseOrderInfoAwaitReqBO() == null && CollectionUtils.isEmpty((Collection)reqBO.getOrderIdList())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getGroupWay())) {
            throw new PfscExtBusinessException("0001", "\u5206\u7ec4\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfo() || !StringUtils.hasText((String)reqBO.getInvoiceInfo().getInvoiceTitle())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (null == reqBO.getMailAddrInfo() || !StringUtils.hasText((String)reqBO.getMailAddrInfo().getName())) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        log.info("\u5f00\u7968\u7533\u8bf7\u53d1\u8d77-\u6d88\u606f\u751f\u4ea7\u8005\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        MakeBillApplyInfoMsgRspBO rspBO = new MakeBillApplyInfoMsgRspBO();
        SaleOrderVerifyReqBO saleOrderVerifyReqBO = new SaleOrderVerifyReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderVerifyReqBO);
        VerifyPurchaseOrderRspBO verifyPurchaseOrderRspBO = this.verifySaleOrderInfoService.saleOrderAwaitVerify(saleOrderVerifyReqBO);
        if ("0000" != verifyPurchaseOrderRspBO.getRespCode()) {
            throw new PfscExtBusinessException("18000", verifyPurchaseOrderRspBO.getRespDesc());
        }
        List<Long> orderIdList = this.queryApplyOrderIds(reqBO);
        reqBO.setOrderIds(orderIdList);
        reqBO.setQueryPayPurchaseOrderInfoAwaitReqBO(null);
        HashMap<String, MakeBillApplyInfoMsgReqBO> map = new HashMap<String, MakeBillApplyInfoMsgReqBO>();
        map.put("makeApply", reqBO);
        ProxyMessage proxyMessage = new ProxyMessage(this.makeApplyTopic, this.tag, JSON.toJSONString(map));
        ProxySendResult sendResult = this.proxyMessageProducer.send(proxyMessage);
        if ("SEND_OK".equals(sendResult.getStatus())) {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setOrderStatus(OrderStatus.SENDING.getCode());
            saleOrderInfoVO.setOrderIdList(orderIdList);
            this.saleOrderInfoMapper.updateStatusBatchByOrderIds(saleOrderInfoVO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }

    private List<Long> queryApplyOrderIds(MakeBillApplyInfoMsgReqBO reqBO) {
        List<Long> orderIdList = new LinkedList<Long>();
        QueryPayPurchaseOrderInfoAwaitReqBO queryReqBO = reqBO.getQueryPayPurchaseOrderInfoAwaitReqBO();
        if ("1".equals(reqBO.getIsSelectOrder()) && !CollectionUtils.isEmpty((Collection)reqBO.getOrderIdList())) {
            for (String id : reqBO.getOrderIdList()) {
                orderIdList.add(Long.valueOf(id));
            }
        } else {
            SaleOrderInfoQueryVO vo = new SaleOrderInfoQueryVO();
            BeanUtils.copyProperties((Object)queryReqBO, (Object)vo);
            Long excludeOrg = null;
            if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                vo.setOperUnitNo(reqBO.getCompanyId());
                vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)queryReqBO.getPurchaseNo())) {
                    vo.setPurchaseNo(Long.valueOf(queryReqBO.getPurchaseNo()));
                } else {
                    excludeOrg = reqBO.getCompanyId();
                }
                vo.setExcludeOrg(excludeOrg);
            } else if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
                vo.setPurchaseNo(reqBO.getCompanyId());
                vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
            } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
                vo.setSupplierNo(reqBO.getSupId());
            }
            if ("1".equals(queryReqBO.getIsActivity())) {
                vo.setOrderCategory("1");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)queryReqBO.getActivityId())) {
                    vo.setActivityId(Long.valueOf(queryReqBO.getActivityId()));
                }
            } else {
                vo.setIsNotActivity("0");
            }
            vo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            vo.setReconciliationStatus(ReconciliationStatus.AGREEMENT.getCode());
            orderIdList = this.saleOrderInfoMapper.getOrderIdListByCondition(vo);
        }
        return orderIdList;
    }
}

