/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.tydic.payment.pay.ability.PayProBillDetailListQryAbilityService;
import com.tydic.payment.pay.ability.bo.PayProBillDetailListQryAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProBillDetailListQryAbilityRspBo;
import com.tydic.payment.pay.common.base.bo.PayProPageDataBo;
import com.tydic.payment.pay.common.base.bo.PayProPageRspBo;
import com.tydic.pfscext.api.busi.BusiCheckBillCompareService;
import com.tydic.pfscext.api.busi.bo.BusiCheckBillCompareReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCheckBillCompareRspBO;
import com.tydic.pfscext.api.trade.PayCheckBillService;
import com.tydic.pfscext.api.trade.bo.PayCheckBillReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillCheckDetailMapper;
import com.tydic.pfscext.dao.BillCheckResultMapper;
import com.tydic.pfscext.dao.FscCheckDataMapper;
import com.tydic.pfscext.dao.PayCheckDataMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.po.BillCheckDetailPO;
import com.tydic.pfscext.dao.po.BillCheckResultPO;
import com.tydic.pfscext.dao.po.FscCheckDataPO;
import com.tydic.pfscext.dao.po.PayCheckDataPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.enums.PayFlowPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.DateUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.PayCheckBillService"})
public class PayCheckBillServiceImpl
implements PayCheckBillService {
    private static final Logger log = LoggerFactory.getLogger(PayCheckBillServiceImpl.class);
    @Autowired
    private PayCheckDataMapper payCheckDataMapper;
    @Autowired
    private BillCheckDetailMapper billCheckDetailMapper;
    @Autowired
    private BillCheckResultMapper billCheckResultMapper;
    @Autowired
    private FscCheckDataMapper fscCheckDataMapper;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PayProBillDetailListQryAbilityService payProBillDetailListQryAbilityService;
    @Autowired
    private BusiCheckBillCompareService busiCheckBillCompareService;

    @PostMapping(value={"checkBill"})
    public PfscExtRspBaseBO checkBill(@RequestBody PayCheckBillReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u5728\u7ebf\u652f\u4ed8\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        Long billDate = Long.valueOf(LocalDate.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        if (reqBO.getBillDate() != null) {
            billDate = reqBO.getBillDate();
        }
        log.info("\u5f53\u524d\u5728\u7ebf\u652f\u4ed8\u5bf9\u8d26\u7684\u5bf9\u8d26\u65e5\u671f\u4e3a\uff1a" + billDate);
        this.deleteBillDateByBillDate(billDate);
        this.syncPayBillData(billDate);
        this.syncFscBillData(billDate);
        this.compareBillData(billDate);
        pfscExtRspBaseBO.setRespCode("0000");
        pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        return pfscExtRspBaseBO;
    }

    private void deleteBillDateByBillDate(Long billDate) {
        PayCheckDataPO payCheckDataPO = new PayCheckDataPO();
        payCheckDataPO.setBillDate(billDate);
        this.payCheckDataMapper.deleteByBillDate(payCheckDataPO);
        BillCheckDetailPO billCheckDetailPO = new BillCheckDetailPO();
        billCheckDetailPO.setBillDate(billDate);
        this.billCheckDetailMapper.deleteByBillDate(billCheckDetailPO);
        BillCheckResultPO billCheckResultPO = new BillCheckResultPO();
        billCheckResultPO.setBillDate(billDate);
        this.billCheckResultMapper.deleteByBillDate(billCheckResultPO);
        FscCheckDataPO fscCheckDataPO = new FscCheckDataPO();
        fscCheckDataPO.setBillDate(billDate);
        this.fscCheckDataMapper.deleteByBillDate(fscCheckDataPO);
    }

    private void syncFscBillData(Long billDate) {
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setBillDate(billDate.toString());
        ArrayList<String> payTypeList = new ArrayList<String>();
        payTypeList.add(PayFlowPayType.PAY_TYPE_7.getCode());
        payTypeList.add(PayFlowPayType.PAY_TYPE_30.getCode());
        payTypeList.add(PayFlowPayType.PAY_TYPE_200.getCode());
        payTypeList.add(PayFlowPayType.PAY_TYPE_201.getCode());
        paymentFlowInfo.setPayTypeList(payTypeList);
        paymentFlowInfo.setPaymentStatus("SUCCESS");
        List<PaymentFlowInfo> paymentFlowInfoList = this.paymentFlowInfoMapper.qryPaymentList(paymentFlowInfo);
        if (!CollectionUtils.isEmpty(paymentFlowInfoList)) {
            ArrayList<FscCheckDataPO> fscCheckDataPOS = new ArrayList<FscCheckDataPO>(paymentFlowInfoList.size());
            for (PaymentFlowInfo po : paymentFlowInfoList) {
                FscCheckDataPO fscCheckDataPO = new FscCheckDataPO();
                BeanUtils.copyProperties((Object)po, (Object)fscCheckDataPO);
                fscCheckDataPO.setPayAmt(po.getOrderAmt());
                fscCheckDataPO.setBillDate(billDate);
                fscCheckDataPOS.add(fscCheckDataPO);
            }
            this.fscCheckDataMapper.insertBatch(fscCheckDataPOS);
        }
    }

    private void syncPayBillData(Long billDate) {
        List payDataList;
        PayProPageDataBo payData;
        PayProBillDetailListQryAbilityReqBo payBillListQryReqBO = new PayProBillDetailListQryAbilityReqBo();
        payBillListQryReqBO.setStartDate(billDate);
        payBillListQryReqBO.setEndDate(billDate);
        payBillListQryReqBO.setPageNo(Integer.valueOf(-1));
        payBillListQryReqBO.setPageSize(Integer.valueOf(-1));
        PayProPageRspBo payBillListQryRspBO = this.payProBillDetailListQryAbilityService.qryDetailList(payBillListQryReqBO);
        if (payBillListQryRspBO != null && "0000".equals(payBillListQryRspBO.getRespCode()) && payBillListQryRspBO.getData() != null && (payData = payBillListQryRspBO.getData()) != null && !CollectionUtils.isEmpty((Collection)(payDataList = payData.getRows()))) {
            ArrayList<PayCheckDataPO> payCheckDataPOS = new ArrayList<PayCheckDataPO>(payDataList.size());
            for (PayProBillDetailListQryAbilityRspBo payBO : payDataList) {
                PayCheckDataPO payCheckDataPO = new PayCheckDataPO();
                payCheckDataPO.setBillDate(billDate);
                payCheckDataPO.setTransId(payBO.getTransactionId());
                payCheckDataPO.setOutOrderId(payBO.getPayOutOrderId());
                payCheckDataPO.setRefundOutOrderId(payBO.getRefundOutOrderId());
                payCheckDataPO.setPayFee(payBO.getPayCenterFee());
                payCheckDataPO.setPayChannel(payBO.getPaymentInsId());
                payCheckDataPO.setPayChannelName(payBO.getPaymentInsName());
                payCheckDataPO.setPayMethod(payBO.getPayMethod());
                payCheckDataPO.setPayMethodName(payBO.getPayMethodName());
                if ("01".equals(payBO.getOrderType())) {
                    payCheckDataPO.setPayStatus("A10");
                    payCheckDataPO.setPayStatusName("\u5df2\u652f\u4ed8");
                } else if ("02".equals(payBO.getOrderType())) {
                    payCheckDataPO.setPayStatus("B10");
                    payCheckDataPO.setPayStatusName("\u5df2\u9000\u6b3e");
                }
                payCheckDataPO.setOrderType(payBO.getOrderType());
                payCheckDataPO.setPayTime(DateUtil.strToDateyyyyMMddHHmmss(payBO.getTradeTime()));
                payCheckDataPO.setMerchantId(payBO.getMerchantId());
                payCheckDataPO.setMerchantName(payBO.getMerchantName());
                payCheckDataPOS.add(payCheckDataPO);
            }
            this.payCheckDataMapper.insertBatch(payCheckDataPOS);
        }
    }

    private void compareBillData(Long billDate) {
        BusiCheckBillCompareReqBO busiCheckBillCompareReqBO = new BusiCheckBillCompareReqBO();
        busiCheckBillCompareReqBO.setBillDate(billDate);
        BusiCheckBillCompareRspBO busiCheckBillCompareRspBO = this.busiCheckBillCompareService.dealCheckBillData(busiCheckBillCompareReqBO);
        if (!"0000".equals(busiCheckBillCompareRspBO.getRespCode())) {
            throw new PfscExtBusinessException(busiCheckBillCompareRspBO.getRespCode(), "\u8d26\u5355\u6bd4\u5bf9\u5904\u7406\u5f02\u5e38\uff1a" + busiCheckBillCompareRspBO.getRespDesc());
        }
    }
}

