/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoRspBO;
import com.tydic.pfscext.api.trade.QueryPurchasePaySaleOrderInfoService;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SaleOrderPayStatus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.QueryPurchasePaySaleOrderInfoService"})
public class QueryPurchasePaySaleOrderInfoServiceImpl
implements QueryPurchasePaySaleOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(QueryPurchasePaySaleOrderInfoServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPurchasePaySaleOrderInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    @PostMapping(value={"query"})
    public BusiQuerySaleOrderInfoRspBO query(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u9500\u552e\u8ba2\u5355\u5217\u8868\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        LOGGER.info("SettleModel\uff1a" + reqBO.getSettleModel());
        if (saleOrderInfoVO.getApplyNo() == null || "".equals(saleOrderInfoVO.getApplyNo())) {
            saleOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
            LOGGER.info("SettleModel\uff1a" + reqBO.getSettleModel());
            if (null != reqBO.getSettleModel() && "purchaser".equals(reqBO.getSettleModel())) {
                saleOrderInfoVO.setPurchaserId(reqBO.getUserId());
            }
            if (!"0".equals(reqBO.getIsProfessionalOrgExt())) {
                saleOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
            }
        }
        saleOrderInfoVO.setOrderBy("t.ORDER_ID DESC,t.INSPECTION_ID DESC");
        if (reqBO.getOrderCategory() != null && "0".equals(reqBO.getOrderCategory())) {
            saleOrderInfoVO.setBusiModel("0");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageJoin2(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQuerySaleOrderInfoOrderRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoOrderRspBO>();
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            SaleItemInfoVO vo = new SaleItemInfoVO();
            vo.setInspectionId(saleOrderInfo.getInspectionId());
            List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
            ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                item.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleItemInfo.getItemStatus())));
                itemList.add(item);
            }
            BusiQuerySaleOrderInfoOrderRspBO order = new BusiQuerySaleOrderInfoOrderRspBO();
            BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
            order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
            order.setInspectionId(String.valueOf(saleOrderInfo.getInspectionId()));
            order.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
            order.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)saleOrderInfo.getSource())));
            order.setItemInfos(itemList);
            if (saleOrderInfo.getPayType() != null && !"".equals(saleOrderInfo.getPayType())) {
                order.setPayTypeStr(SaleOrderPayType.getInstance(saleOrderInfo.getPayType()).getDescr());
            }
            if (saleOrderInfo.getPayStatus() != null && !"".equals(saleOrderInfo.getPayStatus())) {
                order.setPayStatusStr(SaleOrderPayStatus.getInstance(saleOrderInfo.getPayStatus()).getDescr());
            }
            try {
                order.setPurchaseProjectName(this.organizationInfoService.queryProjectName(saleOrderInfo.getPurchaseProjectId()).getAccountName());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
            orderList.add(order);
        }
        BusiQuerySaleOrderInfoRspBO rspBO = new BusiQuerySaleOrderInfoRspBO();
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        saleOrderInfoVO.setReconciliationStatus("1");
        SaleOrderInfo saleOrderInfoSame = this.saleOrderInfoMapper.getListPageJoin2Sum(saleOrderInfoVO);
        if (saleOrderInfoSame != null) {
            rspBO.setReconOkCount(saleOrderInfoSame.getOrderCount());
        }
        saleOrderInfoVO.setReconciliationStatus("2");
        SaleOrderInfo saleOrderInfoDiff = this.saleOrderInfoMapper.getListPageJoin2Sum(saleOrderInfoVO);
        if (saleOrderInfoDiff != null) {
            rspBO.setReconDiffCount(saleOrderInfoDiff.getOrderCount());
        }
        saleOrderInfoVO.setReconciliationStatus("0");
        SaleOrderInfo saleOrderInfoFail = this.saleOrderInfoMapper.getListPageJoin2Sum(saleOrderInfoVO);
        if (saleOrderInfoFail != null) {
            rspBO.setReconFailCount(saleOrderInfoFail.getOrderCount());
        }
        return rspBO;
    }

    @PostMapping(value={"updateSaleOrderInfo"})
    public PfscExtRspBaseBO updateSaleOrderInfo(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u9500\u552e\u8ba2\u5355\u5217\u8868\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInspectionId() == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u9a8c\u6536\u5355id\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setInspectionId(reqBO.getInspectionId());
            saleOrderInfo.setOrderStatus(reqBO.getOrderStatus().toString());
            if ("98".equals(saleOrderInfo.getOrderStatus())) {
                saleOrderInfo.setHangDate(new Date());
            } else if ("00".equals(saleOrderInfo.getOrderStatus())) {
                saleOrderInfo.setHangDate(null);
            }
            this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfo);
        }
        catch (Exception e) {
            LOGGER.error("\u6302\u8d77\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u6302\u8d77\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }
}

