/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.tydic.pfscext.api.deal.bo.SaleInvoiceInfoBO;
import com.tydic.pfscext.api.trade.SaleInvoiceInfoService;
import com.tydic.pfscext.api.trade.bo.SaleInvoiceDetailBO;
import com.tydic.pfscext.api.trade.bo.SaleInvoiceInfoRspBO;
import com.tydic.pfscext.api.trade.bo.SaleInvoiceInfoServiceRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.SaleInvoiceInfoService"})
public class SaleInvoiceInfoServiceImpl
implements SaleInvoiceInfoService {
    private static final Logger logger = LoggerFactory.getLogger(SaleInvoiceInfoServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    @PostMapping(value={"qrySaleInvoiceInfoDetail"})
    public SaleInvoiceInfoServiceRspBO qrySaleInvoiceInfoDetail(@RequestBody SaleInvoiceInfoBO saleInvoiceInfoBO) {
        if (saleInvoiceInfoBO.getApplyNo() == null) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleInvoiceInfoServiceRspBO rspBO = new SaleInvoiceInfoServiceRspBO();
        ArrayList<SaleInvoiceInfoRspBO> saleInvoiceInfoRspBOS = new ArrayList<SaleInvoiceInfoRspBO>();
        try {
            SaleInvoiceInfo queryBO = new SaleInvoiceInfo();
            queryBO.setApplyNo(saleInvoiceInfoBO.getApplyNo());
            queryBO.setInvoiceCode(saleInvoiceInfoBO.getInvoiceCode());
            queryBO.setInvoiceNo(saleInvoiceInfoBO.getInvoiceNo());
            List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectByApplyNoByModel(queryBO);
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(saleInvoiceInfoBO.getApplyNo());
            if (saleInvoiceInfos != null && saleInvoiceInfos.size() > 0) {
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                    List<SaleInvoiceDetail> saleInvoiceDetails;
                    SaleInvoiceInfoRspBO saleInvoiceInfoRspBO = new SaleInvoiceInfoRspBO();
                    if (billApplyInfo != null) {
                        BeanUtils.copyProperties((Object)billApplyInfo, (Object)saleInvoiceInfoRspBO);
                        saleInvoiceInfoRspBO.setAddress(billApplyInfo.getAddrDesc());
                    }
                    BeanUtils.copyProperties((Object)saleInvoiceInfo, (Object)saleInvoiceInfoRspBO);
                    if (billApplyInfo != null) {
                        saleInvoiceInfoRspBO.setInvoiceType(StringUtils.isBlank((CharSequence)billApplyInfo.getInvoiceType()) ? saleInvoiceInfos.get(0).getInvoiceType() : Integer.valueOf(billApplyInfo.getInvoiceType()));
                    }
                    if (saleInvoiceInfoRspBO.getInvoiceStatus() != null) {
                        saleInvoiceInfoRspBO.setInvoiceStatusStr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfoRspBO.getInvoiceStatus()).getDescr());
                    }
                    if (saleInvoiceInfoRspBO.getInvoiceType() != null) {
                        saleInvoiceInfoRspBO.setInvoiceTypeStr(InvoiceType.getInstance(saleInvoiceInfoRspBO.getInvoiceType()).getDescr());
                    }
                    if ((saleInvoiceDetails = this.saleInvoiceDetailMapper.selectByInvoiceNo(saleInvoiceInfoRspBO.getInvoiceNo())) != null) {
                        ArrayList<SaleInvoiceDetailBO> saleInvoiceDetailBOs = new ArrayList<SaleInvoiceDetailBO>();
                        for (SaleInvoiceDetail saleInvoiceDetail : saleInvoiceDetails) {
                            SaleInvoiceDetailBO saleInvoiceDetailBO = new SaleInvoiceDetailBO();
                            BeanUtils.copyProperties((Object)saleInvoiceDetail, (Object)saleInvoiceDetailBO);
                            saleInvoiceDetailBOs.add(saleInvoiceDetailBO);
                        }
                        saleInvoiceInfoRspBO.setSaleInvoiceDetailBOs(saleInvoiceDetailBOs);
                    }
                    saleInvoiceInfoRspBOS.add(saleInvoiceInfoRspBO);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25");
        }
        rspBO.setRows(saleInvoiceInfoRspBOS);
        return rspBO;
    }
}

