/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.zm.ChangeOfReceiptService;
import com.tydic.pfscext.api.zm.ChangeReceiptMatchService;
import com.tydic.pfscext.api.zm.bo.ChangeOfReceiptBO;
import com.tydic.pfscext.api.zm.bo.ChangeReceiptServiceReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Transactional(rollbackFor={Exception.class})
@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.zm.ChangeOfReceiptService"})
public class ChangeOfReceiptServiceImpl
implements ChangeOfReceiptService {
    private static final Logger log = LoggerFactory.getLogger(ChangeOfReceiptServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeOfReceiptServiceImpl.class);
    @Autowired
    private ChangeReceiptMatchService changeReceiptMatchService;

    @PostMapping(value={"changeOfReceipt"})
    public PfscExtRspBaseBO changeOfReceipt(@RequestBody ChangeReceiptServiceReqBO changeReceiptServiceReqBO) {
        LOGGER.debug("\u5f02\u5e38\u8ba2\u5355\u53d8\u66f4\u5165\u53c2\uff1a" + JSON.toJSON((Object)changeReceiptServiceReqBO.toString()));
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        this.check(changeReceiptServiceReqBO);
        try {
            for (ChangeOfReceiptBO changeOfReceiptBO : changeReceiptServiceReqBO.getChangeOfReceiptBOS()) {
                pfscExtRspBaseBO = this.changeReceiptMatchService.change(changeOfReceiptBO);
            }
            pfscExtRspBaseBO.setRespCode("0000");
            pfscExtRspBaseBO.setRespDesc("\u5f02\u5e38\u8ba2\u5355\u53d8\u66f4\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            pfscExtRspBaseBO.setRespCode("18000");
            pfscExtRspBaseBO.setRespDesc(e.getMessage());
        }
        return pfscExtRspBaseBO;
    }

    private void check(ChangeReceiptServiceReqBO changeReceiptServiceReqBO) {
        if (changeReceiptServiceReqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List changeOfReceiptBOList = changeReceiptServiceReqBO.getChangeOfReceiptBOS();
        if (CollectionUtils.isEmpty((Collection)changeOfReceiptBOList)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f02\u5e38\u53d8\u66f4\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ChangeOfReceiptBO changeOfReceiptBO : changeOfReceiptBOList) {
            if (null == changeOfReceiptBO && "".equals(changeOfReceiptBO)) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changeOfReceiptBO.getChangeDate() || "".equals(changeOfReceiptBO.getChangeDate())) {
                throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changeOfReceiptBO.getPurchearNowOrderAmt() || "".equals(changeOfReceiptBO.getPurchearNowOrderAmt())) {
                throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changeOfReceiptBO.getOrderCode() || "".equals(changeOfReceiptBO.getOrderCode())) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changeOfReceiptBO.getPurchearOriginalOrderAmt() || "".equals(changeOfReceiptBO.getPurchearOriginalOrderAmt())) {
                throw new PfscExtBusinessException("18000", "\u539f\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changeOfReceiptBO.getSaleNowOrderAmt() || "".equals(changeOfReceiptBO.getSaleNowOrderAmt())) {
                throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changeOfReceiptBO.getSaleOriginalOrderAmt() || "".equals(changeOfReceiptBO.getSaleOriginalOrderAmt())) {
                throw new PfscExtBusinessException("18000", "\u539f\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (changeOfReceiptBO.getPurchearNowOrderAmt().compareTo(BigDecimal.ZERO) == -1) {
                throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            if (changeOfReceiptBO.getPurchearOriginalOrderAmt().compareTo(BigDecimal.ZERO) == -1 || changeOfReceiptBO.getPurchearOriginalOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new PfscExtBusinessException("18000", "\u539f\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            if (changeOfReceiptBO.getSaleNowOrderAmt().compareTo(BigDecimal.ZERO) == -1) {
                throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            if (changeOfReceiptBO.getSaleOriginalOrderAmt().compareTo(BigDecimal.ZERO) == -1 || changeOfReceiptBO.getSaleOriginalOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new PfscExtBusinessException("18000", "\u539f\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            if (null == changeOfReceiptBO.getChangOfReceiptItemBOS() || changeOfReceiptBO.getChangOfReceiptItemBOS().equals("")) {
                throw new PfscExtBusinessException("18000", "\u5546\u54c1\u53d8\u66f4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)changeOfReceiptBO.getBusiModel())) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u4e1a\u52a1\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.hasText((String)changeOfReceiptBO.getPaymentType())) continue;
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

