/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.pagehelper.util.StringUtil;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.pfscext.api.busi.FscCreatePayableNoService;
import com.tydic.pfscext.api.busi.bo.FscRefundOrderOperRspBO;
import com.tydic.pfscext.api.reverse.RefundOrderOperService;
import com.tydic.pfscext.api.reverse.bo.ChangeReceiptMatchReqBO;
import com.tydic.pfscext.api.zm.ChangeReceiptMatchService;
import com.tydic.pfscext.api.zm.bo.ChangOfReceiptItemBO;
import com.tydic.pfscext.api.zm.bo.ChangeOfReceiptBO;
import com.tydic.pfscext.api.zm.bo.SendGoodsNoBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.ChangeOrderInfoMapper;
import com.tydic.pfscext.dao.ChangeOrderItemInfoMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleItemServfeeInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderServfeeInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.ChangeOrderInfoPO;
import com.tydic.pfscext.dao.po.ChangeOrderItemInfoPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.ApplyPayInfoVO;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.zm.ChangeReceiptMatchService"})
public class ChangeReceiptMatchServiceImpl
implements ChangeReceiptMatchService {
    private static final Logger log = LoggerFactory.getLogger(ChangeReceiptMatchServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeReceiptMatchServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private RefundOrderOperService refundOrderOperService;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private ChangeOrderInfoMapper changeOrderInfoMapper;
    @Autowired
    private ChangeOrderItemInfoMapper changeOrderItemInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Value(value="${REFUND_RESULT_CALL_BACK:http://}")
    private String REFUND_RESULT_CALL_BACK;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private FscCreatePayableNoService fscCreatePayableNoService;
    @Autowired
    private BillSNService billSNService;
    private static final String PART_REFUND = "06";
    private static final String REFUNDING = "01";
    private static final String REFUNDED = "02";
    private static final String PAY_SUBMITTED = "SUBMITTED";
    private static final String PAY_SUCCESS = "SUCCESS";
    @Resource(name="frameOrderIdSeq")
    private OrderSequence frameOrderIdSeqSeqService;
    @Autowired
    private SaleOrderServfeeInfoMapper saleOrderServfeeInfoMapper;
    @Autowired
    private SaleItemServfeeInfoMapper saleItemServfeeInfoMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"change"})
    public PfscExtRspBaseBO change(@RequestBody ChangeOfReceiptBO changeOfReceiptBO) {
        LOGGER.info("\u5f02\u5e38\u53d8\u66f4\u5165\u53c2\u6253\u5370\uff1a" + JSON.toJSONString((Object)changeOfReceiptBO));
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        this.check(changeOfReceiptBO);
        LOGGER.debug("\u8ba2\u5355\u4fa7\u6570\u636e\u5f00\u59cb\u5165\u5e93=====");
        this.addChangeOrder(changeOfReceiptBO);
        LOGGER.debug("\u8ba2\u5355\u4fa7\u6570\u636e\u5165\u5e93\u5b8c\u6210=====");
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setSaleOrderCode(changeOfReceiptBO.getOrderCode());
        saleOrderInfo.setInspectionId(changeOfReceiptBO.getInspectionId());
        SaleOrderInfo saleOrderInfo1 = this.querySaleOrder(saleOrderInfo);
        if (null != saleOrderInfo1) {
            LOGGER.debug("\u9500\u552e\u8ba2\u5355====" + saleOrderInfo1.toString());
            if (saleOrderInfo1.getOrderAmt().compareTo(changeOfReceiptBO.getSaleOriginalOrderAmt()) != 0) {
                throw new PfscExtBusinessException("18000", "\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
        }
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo.setPurchaseOrderCode(changeOfReceiptBO.getOrderCode());
        payPurchaseOrderInfo.setInspectionId(changeOfReceiptBO.getInspectionId());
        PayPurchaseOrderInfo payPurchaseOrderInfo1 = this.queryPayPurchhaserOrder(payPurchaseOrderInfo);
        if (null != payPurchaseOrderInfo1) {
            LOGGER.debug("\u91c7\u8d2d\u8ba2\u5355====" + payPurchaseOrderInfo1.toString());
            if (payPurchaseOrderInfo1.getOrderAmt().compareTo(changeOfReceiptBO.getPurchearOriginalOrderAmt()) != 0) {
                throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u4e0d\u5b58\u5728\u8be5\u91c7\u8d2d\u8ba2\u5355");
        }
        changeOfReceiptBO.setInspectionId(payPurchaseOrderInfo1.getInspectionId());
        this.updatePurchear(changeOfReceiptBO);
        this.updateSale(changeOfReceiptBO);
        ChangeReceiptMatchReqBO reqBO = new ChangeReceiptMatchReqBO();
        BeanUtils.copyProperties((Object)changeOfReceiptBO, (Object)reqBO);
        this.accountPay(reqBO);
        this.saveServiceFee(changeOfReceiptBO);
        LOGGER.debug("\u5f02\u5e38\u53d8\u66f4\u5b8c\u6210=====");
        return pfscExtRspBaseBO;
    }

    private void check(ChangeOfReceiptBO changeOfReceiptBO) {
        if (null == changeOfReceiptBO && "".equals(changeOfReceiptBO)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getChangeDate() || "".equals(changeOfReceiptBO.getChangeDate())) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getOrderCode() || "".equals(changeOfReceiptBO.getOrderCode())) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getPurchearNowOrderAmt() || "".equals(changeOfReceiptBO.getPurchearNowOrderAmt())) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getPurchearOriginalOrderAmt() || "".equals(changeOfReceiptBO.getPurchearOriginalOrderAmt())) {
            throw new PfscExtBusinessException("18000", "\u539f\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getSaleNowOrderAmt() || "".equals(changeOfReceiptBO.getSaleNowOrderAmt())) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getSaleOriginalOrderAmt() || "".equals(changeOfReceiptBO.getSaleOriginalOrderAmt())) {
            throw new PfscExtBusinessException("18000", "\u539f\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (changeOfReceiptBO.getPurchearNowOrderAmt().compareTo(BigDecimal.ZERO) == -1) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (changeOfReceiptBO.getPurchearOriginalOrderAmt().compareTo(BigDecimal.ZERO) == -1 || changeOfReceiptBO.getPurchearOriginalOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
            throw new PfscExtBusinessException("18000", "\u539f\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (changeOfReceiptBO.getSaleNowOrderAmt().compareTo(BigDecimal.ZERO) == -1) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (changeOfReceiptBO.getSaleOriginalOrderAmt().compareTo(BigDecimal.ZERO) == -1 || changeOfReceiptBO.getSaleOriginalOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
            throw new PfscExtBusinessException("18000", "\u539f\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (null == changeOfReceiptBO.getChangOfReceiptItemBOS() || changeOfReceiptBO.getChangOfReceiptItemBOS().equals("")) {
            throw new PfscExtBusinessException("18000", "\u5546\u54c1\u53d8\u66f4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)changeOfReceiptBO.getBusiModel())) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u4e1a\u52a1\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)changeOfReceiptBO.getPaymentType())) {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void addChangeOrder(ChangeOfReceiptBO changeOfReceiptBO) {
        List sendGoodsNoBOList;
        ChangeOrderInfoPO record = new ChangeOrderInfoPO();
        BeanUtils.copyProperties((Object)changeOfReceiptBO, (Object)record);
        if (null != changeOfReceiptBO.getOrderCode() && !"".equals(changeOfReceiptBO.getOrderCode())) {
            record.setSaleOrderCode(changeOfReceiptBO.getOrderCode());
        }
        if (null != changeOfReceiptBO.getParentOrderId() && !"".equals(changeOfReceiptBO.getParentOrderId())) {
            record.setOrderId(Long.valueOf(changeOfReceiptBO.getParentOrderId()));
        }
        if (null != changeOfReceiptBO.getOrderAmt()) {
            record.setOrderAmt(changeOfReceiptBO.getOrderAmt());
        }
        if ((sendGoodsNoBOList = changeOfReceiptBO.getSendGoodsNoBOList()) != null) {
            String sendGoodsNoBOListJson = JSONObject.toJSONString((Object)sendGoodsNoBOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            record.setSendGoodsNo(sendGoodsNoBOListJson);
        }
        record.setUpdateType("1");
        this.changeOrderInfoMapper.insertSelective(record);
        List changOfReceiptItemBOS = changeOfReceiptBO.getChangOfReceiptItemBOS();
        if (changOfReceiptItemBOS != null && changOfReceiptItemBOS.size() > 0) {
            for (ChangOfReceiptItemBO cib : changOfReceiptItemBOS) {
                ChangeOrderItemInfoPO changeOrderItemInfoPO = new ChangeOrderItemInfoPO();
                BeanUtils.copyProperties((Object)cib, (Object)changeOrderItemInfoPO);
                changeOrderItemInfoPO.setSaleOrderCode(cib.getOrderCode());
                log.error("\u7236\u8ba2\u5355\u7684\u503c=" + changeOfReceiptBO.getParentOrderId());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)changeOfReceiptBO.getParentOrderId())) {
                    changeOrderItemInfoPO.setOrderId(Long.parseLong(changeOfReceiptBO.getParentOrderId()));
                }
                if (StringUtil.isNotEmpty((String)cib.getSaleOrderItemNo())) {
                    changeOrderItemInfoPO.setItemNo(Long.parseLong(cib.getSaleOrderItemNo()));
                }
                this.changeOrderItemInfoMapper.insertSelective(changeOrderItemInfoPO);
            }
        }
    }

    private void updateSale(ChangeOfReceiptBO changeOfReceiptBO) {
        SaleOrderInfo saleOrderInfo1 = new SaleOrderInfo();
        saleOrderInfo1.setOrderAmt(changeOfReceiptBO.getSaleNowOrderAmt());
        saleOrderInfo1.setSaleOrderCode(changeOfReceiptBO.getOrderCode());
        saleOrderInfo1.setRemark(changeOfReceiptBO.getRemark());
        if (null != changeOfReceiptBO.getInspectionId()) {
            saleOrderInfo1.setInspectionId((long)changeOfReceiptBO.getInspectionId());
        }
        LOGGER.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355====" + saleOrderInfo1.toString());
        this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfo1);
        for (ChangOfReceiptItemBO changOfReceiptItemBO : changeOfReceiptBO.getChangOfReceiptItemBOS()) {
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setItemNo(Long.valueOf(changOfReceiptItemBO.getSaleOrderItemNo()));
            saleItemInfo.setSaleOrderCode(changOfReceiptItemBO.getOrderCode());
            saleItemInfo.setInspectionId((long)changeOfReceiptBO.getInspectionId());
            SaleItemInfo saleItemInfo1 = this.saleItemInfoMapper.getModelBy(saleItemInfo);
            LOGGER.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355====" + saleOrderInfo1.toString());
            if (changOfReceiptItemBO.getSaleAmt().compareTo(BigDecimal.ZERO) == -1 && saleItemInfo1.getAmount().compareTo(changOfReceiptItemBO.getSaleAmt().abs()) == -1) {
                throw new PfscExtBusinessException("18000", "\u660e\u7ec6ID\u4e3a" + changOfReceiptItemBO.getSaleOrderItemNo() + "\u7684\u539f\u6709\u91d1\u989d\u5c0f\u4e8e\u53d8\u66f4\u91d1\u989d");
            }
            if (changOfReceiptItemBO.getSaleNum() < 0L && saleItemInfo1.getQuantity().compareTo(new BigDecimal(changOfReceiptItemBO.getSaleNum()).abs()) == -1) {
                throw new PfscExtBusinessException("18000", "\u660e\u7ec6ID\u4e3a" + changOfReceiptItemBO.getSaleOrderItemNo() + "\u7684\u5546\u54c1\u539f\u6709\u6570\u91cf\u5c0f\u4e8e\u53d8\u66f4\u6570\u91cf");
            }
            BigDecimal taxAmt = BigDecimal.ZERO;
            BigDecimal unTaxAmt = BigDecimal.ZERO;
            BigDecimal aount = BigDecimal.ZERO;
            BigDecimal quantity = BigDecimal.ZERO;
            quantity = saleItemInfo1.getQuantity().add(BigDecimal.valueOf(changOfReceiptItemBO.getSaleNum()));
            aount = saleItemInfo1.getAmount().subtract(changOfReceiptItemBO.getSaleAmt());
            taxAmt = aount.divide(BigDecimal.ONE.add(saleItemInfo1.getTaxRate()), 5, 4).multiply(saleItemInfo1.getTaxRate()).setScale(2, 4);
            unTaxAmt = aount.subtract(taxAmt);
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setSeq(saleItemInfo1.getSeq());
            saleItemInfoVO.setAmount(aount);
            saleItemInfoVO.setQuantity(quantity);
            saleItemInfoVO.setTaxAmt(taxAmt);
            saleItemInfoVO.setUntaxAmt(unTaxAmt);
            this.saleItemInfoMapper.updateRefundLock(saleItemInfoVO);
        }
    }

    private void updatePurchear(ChangeOfReceiptBO changeOfReceiptBO) {
        PayPurchaseOrderInfo payPurchaseOrderInfo1 = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo1.setOrderAmt(changeOfReceiptBO.getPurchearNowOrderAmt());
        payPurchaseOrderInfo1.setInspectionId(changeOfReceiptBO.getInspectionId());
        payPurchaseOrderInfo1.setRemark(changeOfReceiptBO.getRemark());
        LOGGER.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355=======" + payPurchaseOrderInfo1.toString());
        this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo1);
        for (ChangOfReceiptItemBO changOfReceiptItemBO : changeOfReceiptBO.getChangOfReceiptItemBOS()) {
            PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
            payItemInfoVO.setItemNo(Long.valueOf(changOfReceiptItemBO.getPurchearItemNo()));
            payItemInfoVO.setPurchaseOrderCode(changOfReceiptItemBO.getOrderCode());
            payItemInfoVO.setInspectionId(changeOfReceiptBO.getInspectionId());
            List<PayItemInfo> payItemInfos = this.payItemInfoMapper.selectBy(payItemInfoVO);
            LOGGER.debug("\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5=======" + payItemInfos.toString());
            if (changOfReceiptItemBO.getPurchearAmt().compareTo(BigDecimal.ZERO) == -1 && payItemInfos.get(0).getAmount().compareTo(changOfReceiptItemBO.getPurchearAmt().abs()) == -1) {
                throw new PfscExtBusinessException("18000", "\u660e\u7ec6ID\u4e3a" + changOfReceiptItemBO.getPurchearItemNo() + "\u7684\u539f\u6709\u91d1\u989d\u5c0f\u4e8e\u53d8\u66f4\u91d1\u989d");
            }
            if (changOfReceiptItemBO.getPurchearNum() < 0L && payItemInfos.get(0).getQuantity().compareTo(new BigDecimal(changOfReceiptItemBO.getPurchearNum()).abs()) == -1) {
                throw new PfscExtBusinessException("18000", "\u660e\u7ec6ID\u4e3a" + changOfReceiptItemBO.getPurchearItemNo() + "\u5546\u54c1\u539f\u6709\u6570\u91cf\u5c0f\u4e8e\u53d8\u66f4\u6570\u91cf");
            }
            BigDecimal taxAmt = BigDecimal.ZERO;
            BigDecimal unTaxAmt = BigDecimal.ZERO;
            BigDecimal aount = BigDecimal.ZERO;
            BigDecimal quantity = BigDecimal.ZERO;
            quantity = payItemInfos.get(0).getQuantity().add(BigDecimal.valueOf(changOfReceiptItemBO.getPurchearNum()));
            aount = payItemInfos.get(0).getAmount().subtract(changOfReceiptItemBO.getPurchearAmt());
            taxAmt = aount.divide(BigDecimal.ONE.add(payItemInfos.get(0).getTaxRate()), 5, 4).multiply(payItemInfos.get(0).getTaxRate()).setScale(2, 4);
            unTaxAmt = aount.subtract(taxAmt);
            PayItemInfo payItemInfo = new PayItemInfo();
            payItemInfo.setItemNo(payItemInfos.get(0).getItemNo());
            payItemInfo.setAmount(aount);
            payItemInfo.setQuantity(quantity);
            payItemInfo.setTaxAmt(taxAmt);
            payItemInfo.setUntaxAmt(unTaxAmt);
            payItemInfo.setInspectionId(changeOfReceiptBO.getInspectionId());
            LOGGER.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\u5165\u53c2=====" + payItemInfo.toString());
            this.payItemInfoMapper.updateByPrimaryKeySelective(payItemInfo);
        }
    }

    private PayPurchaseOrderInfo queryPayPurchhaserOrder(PayPurchaseOrderInfo payPurchaseOrderInfo) {
        PayPurchaseOrderInfo payPurchaseOrderInfo1 = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
        if (null == payPurchaseOrderInfo1) {
            throw new PfscExtBusinessException("18000", "\u4e0d\u5b58\u5728\u8be5\u91c7\u8d2d\u8ba2\u5355");
        }
        return payPurchaseOrderInfo1;
    }

    private SaleOrderInfo querySaleOrder(SaleOrderInfo saleOrderInfo) {
        SaleOrderInfo saleOrderInfo1 = this.saleOrderInfoMapper.getModelBy2(saleOrderInfo);
        if (null == saleOrderInfo1) {
            throw new PfscExtBusinessException("18000", "\u4e0d\u5b58\u5728\u8be5\u9500\u552e\u8ba2\u5355");
        }
        return saleOrderInfo1;
    }

    private BillNotificationInfo queryBillNotification(String notificationNo) {
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
        return billNotificationInfo;
    }

    private BillApplyInfo queryBillApply(String applyNo) {
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        return billApplyInfo;
    }

    public PfscExtRspBaseBO accountPay(ChangeReceiptMatchReqBO reqBO) {
        log.debug("\u5f00\u542f\u9006\u5411\u6d41\u7a0b======" + reqBO.toString());
        PfscExtRspBaseBO rspBaseBO = new PfscExtRspBaseBO();
        BigDecimal cgBalance = reqBO.getPurchearOriginalOrderAmt().subtract(reqBO.getPurchearOriginalOrderAmt());
        BigDecimal xsBalance = reqBO.getSaleNowOrderAmt().subtract(reqBO.getSaleNowOrderAmt());
        log.debug("\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u53d8\u66f4\u5dee\u989d:" + cgBalance);
        log.debug("\u9500\u552e\u8ba2\u5355\u91d1\u989d\u53d8\u66f4\u5dee\u989d:" + xsBalance);
        String billNotificationStatus = null;
        String billStatus = null;
        BigDecimal newAmt = BigDecimal.ZERO;
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setSaleOrderCode(reqBO.getOrderCode());
        saleOrderInfo.setInspectionId(reqBO.getInspectionId());
        SaleOrderInfo saleOrderInfo1 = this.querySaleOrder(saleOrderInfo);
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo.setPurchaseOrderCode(reqBO.getOrderCode());
        payPurchaseOrderInfo.setInspectionId(reqBO.getInspectionId());
        PayPurchaseOrderInfo payPurchaseOrderInfo1 = this.queryPayPurchhaserOrder(payPurchaseOrderInfo);
        String applyNo = saleOrderInfo1.getApplyNo();
        String notificationNo = payPurchaseOrderInfo1.getNotificationNo();
        String payOrderStatus = payPurchaseOrderInfo1.getOrderStatus();
        String saleOrderStatus = saleOrderInfo1.getOrderStatus();
        PayableDetailPO po = new PayableDetailPO();
        if (StringUtils.hasText((String)notificationNo)) {
            log.debug("\u5f00\u7968\u901a\u77e5\u5355=====" + notificationNo);
            BillNotificationInfo billNotificationInfo = this.queryBillNotification(notificationNo);
            log.debug("\u5f00\u7968\u901a\u77e5\u5355=====" + billNotificationInfo.toString());
            billNotificationStatus = billNotificationInfo.getInvoiceStatus();
            newAmt = billNotificationInfo.getAmt().subtract(reqBO.getPayOrderAmt());
            log.debug("\u5f00\u7968\u901a\u77e5\u91d1\u989d-\u8ba2\u5355orderAmt=" + newAmt);
            po.setNotificationNo(notificationNo);
        }
        if (StringUtils.hasText((String)applyNo)) {
            log.debug("\u5f00\u7968\u7533\u8bf7\u5355=====" + applyNo);
            BillApplyInfo billApplyInfo = this.queryBillApply(applyNo);
            log.debug("\u5f00\u7968\u7533\u8bf7\u5355=====" + billApplyInfo.toString());
            billStatus = billApplyInfo.getBillStatus();
            newAmt = billApplyInfo.getAmt().subtract(reqBO.getOrderAmt());
            log.debug("\u5f00\u7968\u7533\u8bf7\u91d1\u989d-\u8ba2\u5355orderAmt=" + newAmt);
            po.setApplyNo(applyNo);
        }
        if (StringUtils.hasText((String)reqBO.getParentOrderId())) {
            po.setOrderId(Long.valueOf(reqBO.getParentOrderId()));
        }
        po.setPurchaseOrderCode(reqBO.getOrderCode());
        po.setPaymentType(reqBO.getPaymentType());
        if (null != reqBO.getBusiModel()) {
            po.setBusiModel(Integer.valueOf(reqBO.getBusiModel()));
        }
        log.debug("\u5e94\u4ed8\u8bb0\u5f55=====" + po.toString());
        List<PayableDetailPO> payablePO = this.payableDetailMapper.getListAndApplyDetail(po);
        log.debug("\u5e94\u4ed8\u8bb0\u5f55=====" + payablePO.toString());
        ArrayList<PayableDetailPO> fscNotificationPayable = new ArrayList<PayableDetailPO>();
        ArrayList<PayableDetailPO> fscApplyPayable = new ArrayList<PayableDetailPO>();
        ArrayList<PayableDetailPO> orderPayable = new ArrayList<PayableDetailPO>();
        for (PayableDetailPO detailPO : payablePO) {
            if (StringUtils.hasText((String)detailPO.getNotificationNo())) {
                fscNotificationPayable.add(detailPO);
                continue;
            }
            if (StringUtils.hasText((String)detailPO.getApplyNo())) {
                fscApplyPayable.add(detailPO);
                continue;
            }
            orderPayable.add(detailPO);
        }
        log.debug("\u5f00\u7968\u901a\u77e5\u5355\u5e94\u4ed8\uff1a" + ((Object)fscNotificationPayable).toString());
        log.debug("\u5f00\u7968\u7533\u8bf7\u5e94\u4ed8\uff1a" + ((Object)fscApplyPayable).toString());
        log.debug("\u8ba2\u5355\u63a8\u9001\u5e94\u4ed8\uff1a" + ((Object)orderPayable).toString());
        if (BusiModel.TRADE_MODEL.getCode().equals(reqBO.getBusiModel())) {
            if (REFUNDING.equals(reqBO.getPaymentType())) {
                log.debug("\u8d38\u6613\u6a21\u5f0f-\u9884\u4ed8\u6b3e===");
                if (orderPayable.size() > 0 && "18000".equals((rspBaseBO = this.advanceCharge(reqBO)).getRespCode())) {
                    return rspBaseBO;
                }
                this.uodateBillApply(reqBO, billStatus, applyNo, saleOrderStatus, newAmt);
                this.updateBillNotification(reqBO, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
            } else if (REFUNDED.equals(reqBO.getPaymentType())) {
                log.debug("\u8d38\u6613\u6a21\u5f0f-\u534f\u8bae\u7ea6\u675f===");
                this.uodateBillApply(reqBO, billStatus, applyNo, saleOrderStatus, newAmt);
                this.updateBillNotification(reqBO, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
                this.updatePayableDetailCGForFrame(reqBO);
            } else {
                log.debug("\u8d38\u6613\u6a21\u5f0f-\u8d26\u671f===");
                if (orderPayable.size() > 0 && "18000".equals((rspBaseBO = this.advanceCharge(reqBO)).getRespCode())) {
                    return rspBaseBO;
                }
                if ("1".equals(saleOrderInfo1.getOrderCategory()) && "18000".equals((rspBaseBO = this.updatePayableDetail(reqBO, fscApplyPayable, FlowFlag.RETURN_GOODS_REFUND.getCode())).getRespCode())) {
                    return rspBaseBO;
                }
            }
            if (fscNotificationPayable.size() > 0) {
                this.updatePayableDetail(reqBO, fscNotificationPayable, FlowFlag.PAYABLE_REIMBURSE.getCode());
            }
            this.uodateBillApply(reqBO, billStatus, applyNo, saleOrderStatus, newAmt);
            this.updateBillNotification(reqBO, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
        } else if (REFUNDING.equals(reqBO.getPaymentType())) {
            log.debug("\u64ae\u5408\u6a21\u5f0f-\u9884\u4ed8\u6b3e===");
            if (orderPayable.size() > 0 && "18000".equals((rspBaseBO = this.advanceCharge(reqBO)).getRespCode())) {
                return rspBaseBO;
            }
            this.updateBillNotification(reqBO, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
            this.uodateBillApply(reqBO, billStatus, applyNo, saleOrderStatus, newAmt);
        } else if (REFUNDED.equals(reqBO.getPaymentType())) {
            log.debug("\u64ae\u5408\u6a21\u5f0f-\u534f\u8bae\u7ea6\u675f===");
            this.updateBillNotification(reqBO, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
            this.updatePayableDetailCGForFrame(reqBO);
        } else {
            log.debug("\u64ae\u5408\u6a21\u5f0f-\u8d26\u671f===");
            if (fscNotificationPayable.size() > 0 && "18000".equals((rspBaseBO = this.updatePayableDetail(reqBO, fscNotificationPayable, FlowFlag.PAYABLE_REIMBURSE.getCode())).getRespCode())) {
                return rspBaseBO;
            }
            this.updateBillNotification(reqBO, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
            this.uodateBillApply(reqBO, billStatus, applyNo, saleOrderStatus, newAmt);
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u9006\u5411\u6d41\u7a0b\u53d8\u66f4\u6210\u529f\uff01");
        return rspBaseBO;
    }

    private void updatePayableDetailCGForFrame(ChangeReceiptMatchReqBO reqBO) {
        log.error("\u5165\u53c2==" + JSON.toJSONString((Object)reqBO));
        List sendGoodsNoBOList = reqBO.getSendGoodsNoBOList();
        if (CollectionUtils.isEmpty((Collection)sendGoodsNoBOList)) {
            throw new PfscExtBusinessException("18000", "\u65e0\u53d1\u8d27\u5355\u53f7\u4fe1\u606f\uff01");
        }
        BigDecimal orderAmtAll = new BigDecimal(0);
        for (SendGoodsNoBO sgn : sendGoodsNoBOList) {
            PayableDetailPO payableDetailPO1;
            BigDecimal divide2;
            BigDecimal add;
            String sendGoodsNo = sgn.getSendGoodsNo();
            BigDecimal orderAmt = sgn.getOrderAmt();
            orderAmtAll = add = orderAmtAll.add(orderAmt);
            Object payableAmt = null;
            BigDecimal orderAmtDH = new BigDecimal(0);
            BigDecimal orderAmtYS = new BigDecimal(0);
            BigDecimal divide = new BigDecimal(0);
            divide = reqBO.getWarrantyRatio() == null ? new BigDecimal(0) : (divide2 = reqBO.getWarrantyRatio().divide(new BigDecimal(100), 2, 4));
            BigDecimal multiply = orderAmt.abs().multiply(divide);
            PayableDetailPO payableDetailPODH = new PayableDetailPO();
            PayableDetailPO payableDetailPOYS = new PayableDetailPO();
            PayableDetailPO payableDetailPOZB = new PayableDetailPO();
            PayableDetailPO payableDetailPOYF = new PayableDetailPO();
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            payableDetailPO.setSendGoodsNo(sendGoodsNo);
            payableDetailPOYS.setSendGoodsNo(sendGoodsNo);
            payableDetailPODH.setSendGoodsNo(sendGoodsNo);
            List<PayableDetailPO> list = this.payableDetailMapper.getList(payableDetailPO);
            ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
            applyPayInfoVO.setSendGoodsNo(sendGoodsNo);
            applyPayInfoVO.setSupplierId(null);
            List<ApplyPayInfoVO> applyPayInfoVOs = this.applyPayInfoMapper.selectListPayableDetail(applyPayInfoVO);
            ApplyPayInfoVO applyPayInfoVOByOrderCode = new ApplyPayInfoVO();
            applyPayInfoVOByOrderCode.setPurchaseOrderCode(reqBO.getOrderCode());
            applyPayInfoVOByOrderCode.setPaytableType(Integer.parseInt(PayableType.YFYF.getCode()));
            List<ApplyPayInfoVO> applyPayList = this.applyPayInfoMapper.selectListPayableDetail(applyPayInfoVOByOrderCode);
            applyPayInfoVOs.addAll(applyPayList);
            HashMap<Integer, ApplyPayInfoVO> map = new HashMap<Integer, ApplyPayInfoVO>();
            if (applyPayInfoVOs != null && applyPayInfoVOs.size() > 0) {
                for (ApplyPayInfoVO applyPayInfo : applyPayInfoVOs) {
                    map.put(applyPayInfo.getPaytableType(), applyPayInfo);
                }
            }
            BigDecimal ZBPableAmt = new BigDecimal("0");
            PayableDetailPO payableByOrderCode = new PayableDetailPO();
            payableByOrderCode.setPurchaseOrderCode(reqBO.getOrderCode());
            payableByOrderCode.setPayableType(Integer.parseInt(PayableType.YFYF.getCode()));
            List<PayableDetailPO> yfPayableList = this.payableDetailMapper.getList(payableByOrderCode);
            log.info("\u67e5\u8be2\u9884\u4ed8\u5e94\u4ed8\u8bb0\u5f55\u7ed3\u679c:" + JSON.toJSONString(yfPayableList));
            list.addAll(yfPayableList);
            if (list != null && list.size() > 0) {
                for (PayableDetailPO ppo : list) {
                    if (ppo.getPayableType().equals(2)) {
                        BeanUtils.copyProperties((Object)ppo, (Object)payableDetailPODH);
                        continue;
                    }
                    if (ppo.getPayableType().equals(3)) {
                        BeanUtils.copyProperties((Object)ppo, (Object)payableDetailPOYS);
                        continue;
                    }
                    if (ppo.getPayableType().equals(4)) {
                        BeanUtils.copyProperties((Object)ppo, (Object)payableDetailPOZB);
                        ZBPableAmt = ppo.getPayableAmt();
                        continue;
                    }
                    if (!ppo.getPayableType().equals(10)) continue;
                    BeanUtils.copyProperties((Object)ppo, (Object)payableDetailPOYF);
                }
            }
            if (payableDetailPODH.getPayableStatus() != null) {
                if (payableDetailPODH.getPayableStatus().equals(REFUNDING)) {
                    BigDecimal orderAmtDH2;
                    orderAmtDH = orderAmtDH2 = payableDetailPODH.getPayableAmt();
                } else if (payableDetailPODH.getPayableStatus().equals(REFUNDED)) {
                    throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d\uff0c\u4e0d\u80fd\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7");
                }
            }
            if (payableDetailPOYS.getPayableStatus() != null) {
                if (payableDetailPOYS.getPayableStatus().equals(REFUNDING)) {
                    BigDecimal orderAmtYS2;
                    orderAmtYS = orderAmtYS2 = payableDetailPOYS.getPayableAmt();
                } else if (payableDetailPOYS.getPayableStatus().equals(REFUNDED)) {
                    throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d\uff0c\u4e0d\u80fd\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7");
                }
            }
            log.error("\u552e\u540e\u91d1\u989d==" + orderAmt);
            log.error("\u5230\u8d27\u672a\u4ed8\u91d1\u989d==" + orderAmtDH);
            log.error("\u9a8c\u6536\u672a\u4ed8\u91d1\u989d==" + orderAmtYS);
            log.error("\u552e\u540e\u91d1\u989d*\u8d28\u4fdd\u91d1\u6bd4\u4f8b==" + multiply);
            BigDecimal trueAmt = orderAmt.subtract(orderAmtDH).subtract(orderAmtYS).subtract(multiply);
            log.error("\u5b9e\u9645\u9000\u6b3e\u91d1\u989d==" + trueAmt);
            ArrayList<PayableDetailPO> payableDetailPOs = new ArrayList<PayableDetailPO>();
            if (PayableStatus.PENDING.getCode().equals(payableDetailPOZB.getPayableStatus())) {
                PayableDetailPO payableDetailPO3 = new PayableDetailPO();
                payableDetailPO3.setSendGoodsNo(sendGoodsNo);
                payableDetailPO3.setPayableType(4);
                payableDetailPO3.setPayableAmt(ZBPableAmt.subtract(multiply));
                this.payableDetailMapper.updateSelectiveBySendGoodsNo(payableDetailPO3);
            } else if (PayableStatus.SUCCESS.getCode().equals(payableDetailPOZB.getPayableStatus())) {
                payableDetailPOZB.setRefundAmt(multiply);
                payableDetailPOs.add(payableDetailPOZB);
            }
            if (trueAmt.compareTo(BigDecimal.ZERO) == 1 || trueAmt.compareTo(BigDecimal.ZERO) == 0) {
                log.error("\u9000\u6b3e\u64cd\u4f5c\u5f00\u59cb");
                ArrayList<PayableDetailPO> truePayableDetailPOs = new ArrayList<PayableDetailPO>();
                truePayableDetailPOs.add(payableDetailPODH);
                truePayableDetailPOs.add(payableDetailPOYS);
                truePayableDetailPOs.add(payableDetailPOYF);
                for (PayableDetailPO payableDetailPO2 : truePayableDetailPOs) {
                    if (PayableStatus.PENDING.getCode().equals(payableDetailPO2.getPayableStatus())) {
                        payableDetailPO1 = new PayableDetailPO();
                        payableDetailPO1.setSendGoodsNo(payableDetailPO2.getSendGoodsNo());
                        payableDetailPO1.setPayableType(payableDetailPO2.getPayableType());
                        payableDetailPO1.setPayableAmt(new BigDecimal(0));
                        payableDetailPO1.setPayableStatus(PayableStatus.TERMINATION.getCode());
                        this.payableDetailMapper.updateSelectiveBySendGoodsNo(payableDetailPO1);
                        continue;
                    }
                    if (!PayableStatus.SUCCESS.getCode().equals(payableDetailPO2.getPayableStatus()) || trueAmt.compareTo(BigDecimal.ZERO) != 1) continue;
                    if ((trueAmt = trueAmt.subtract(payableDetailPO2.getPayableAmt())).compareTo(BigDecimal.ZERO) >= 0) {
                        payableDetailPO2.setRefundAmt(payableDetailPO2.getPayableAmt());
                    } else {
                        payableDetailPO2.setRefundAmt(payableDetailPO2.getPayableAmt().add(trueAmt));
                    }
                    payableDetailPOs.add(payableDetailPO2);
                }
                if (payableDetailPOs.size() <= 0) continue;
                Long recOrgNo = 0L;
                for (PayableDetailPO payableDetail : payableDetailPOs) {
                    boolean falg = PayMethod.ZH_BF.getCode().equals(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayMathod()) || PayMethod.ZHCQT_SF.getCode().equals(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayMathod()) || PayMethod.ZH_SF.getCode().equals(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayMathod()) || PayMethod.XXZF.getCode().equals(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayChannel());
                    PaymentFlowInfo record = new PaymentFlowInfo();
                    String refundNo = this.billSNService.getSn(BillType.REFUND_APPLICATION).toString();
                    String refundOrderNo = "REFUND-" + payableDetail.getPayableNo() + "-" + refundNo;
                    record.setOutOrderId(refundOrderNo);
                    record.setReturnOutOrderId("PAYMENT-" + payableDetail.getPayNo());
                    record.setPayTime(new Date());
                    record.setOrderCode(reqBO.getOrderCode());
                    record.setCreateUserId(reqBO.getOperatorId());
                    record.setCreateUserName(reqBO.getOperatorName());
                    record.setOrderDesc(FlowFlag.RETURN_GOODS_REFUND.getDescr());
                    record.setFlowFlag(FlowFlag.RETURN_GOODS_REFUND.getCode());
                    record.setPayName(reqBO.getRecName());
                    record.setRecName(reqBO.getPayName());
                    record.setOrderAmt(payableDetail.getRefundAmt());
                    record.setCreateTime(new Date());
                    record.setCreateTime(new Date());
                    log.error("\u7ebf\u4e0a\u7ebf\u4e0b\u9000\u6b3e\u5224\u65ad");
                    if (falg) {
                        record.setPayChannel(PayChannel.OFFLINE.getCode());
                        record.setPayType(PayChannel.OFFLINE.getCode());
                    } else {
                        OrgMerchantConfigPO orgMerchantConfigPO;
                        Long receiptOrgId = payableDetail.getSupplierId();
                        if (BusiModel.TRADE_MODEL.getCode().equals(payableDetail.getBusiModel())) {
                            receiptOrgId = payableDetail.getOperatorId();
                        }
                        if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
                            throw new PfscExtBusinessException("18000", "\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
                        }
                        payableDetail.setPayNo(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayno());
                        PayProRefundAbilityRspBo refundRsp = this.createRefundOrder(payableDetail, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode());
                        log.error("\u652f\u4ed8\u4e2d\u5fc3\u8fd4\u56de\u7ed3\u679c1" + refundRsp.getResultCode());
                        record.setPayTime(new Date());
                        record.setPaymentStatus(PAY_SUCCESS);
                        record.setPaymentFlowId(refundRsp.getRefundTransId());
                    }
                    PaymentFlowInfo paymentFlowInfoOri = this.paymentFlowInfoMapper.selectByOutOrderId("PAYMENT-" + payableDetail.getPayNo());
                    if (paymentFlowInfoOri != null) {
                        record.setPayChannel(paymentFlowInfoOri.getPayChannel());
                        record.setPayType(paymentFlowInfoOri.getPayType());
                        record.setRecOrgNo(paymentFlowInfoOri.getPayOrgNo());
                        record.setPayOrgNo(paymentFlowInfoOri.getRecOrgNo());
                    }
                    if (!StringUtils.isEmpty((Object)reqBO.getFlowType())) {
                        record.setFlowType(Integer.parseInt(reqBO.getFlowType()));
                    }
                    log.debug("\u751f\u6210\u6d41\u6c34\u5165\u53c2\uff1a" + record.toString());
                    this.paymentFlowInfoMapper.insert(record);
                }
                continue;
            }
            log.debug("\u76f4\u63a5\u6263\u9664\u5e94\u4ed8");
            BigDecimal newOrderAmtDH = new BigDecimal(0);
            BigDecimal newOrderAmtYS = new BigDecimal(0);
            BigDecimal bigDecimal = orderAmt.subtract(multiply).subtract(orderAmtYS);
            payableDetailPO1 = new PayableDetailPO();
            payableDetailPO1.setPayableStatus(PayableStatus.TERMINATION.getCode());
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                newOrderAmtYS = bigDecimal.abs();
                payableDetailPO1.setPayableStatus(PayableStatus.PENDING.getCode());
            }
            payableDetailPO1.setSendGoodsNo(payableDetailPOYS.getSendGoodsNo());
            payableDetailPO1.setPayableType(payableDetailPOYS.getPayableType());
            payableDetailPO1.setPayableAmt(newOrderAmtYS);
            payableDetailPO1.setPendingAmt(new BigDecimal(0));
            this.payableDetailMapper.updateSelectiveBySendGoodsNo(payableDetailPO1);
            if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal subtract2 = orderAmt.subtract(multiply).subtract(orderAmtYS).subtract(orderAmtDH);
            PayableDetailPO payableDetailPO2 = new PayableDetailPO();
            payableDetailPO1.setPayableStatus(PayableStatus.TERMINATION.getCode());
            if (subtract2.compareTo(BigDecimal.ZERO) < 0) {
                newOrderAmtDH = subtract2.abs();
                payableDetailPO2.setPayableStatus(PayableStatus.PENDING.getCode());
            }
            payableDetailPO2.setSendGoodsNo(payableDetailPODH.getSendGoodsNo());
            payableDetailPO2.setPayableType(payableDetailPODH.getPayableType());
            payableDetailPO2.setPayableAmt(newOrderAmtDH);
            payableDetailPO2.setPendingAmt(new BigDecimal(0));
            this.payableDetailMapper.updateSelectiveBySendGoodsNo(payableDetailPO2);
        }
    }

    private PayProRefundAbilityRspBo createRefundOrder(PayableDetailPO payableDetailPO, ChangeReceiptMatchReqBO reqBO, String refundOrderNo, String busiCode) {
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("PAYMENT-").append(payableDetailPO.getPayNo());
        payProRefundAbilityReqBo.setRefundOutOrderId(refundOrderNo);
        payProRefundAbilityReqBo.setOriOutOrderId(payOrderNo.toString());
        payProRefundAbilityReqBo.setBusiCode(busiCode);
        BigDecimal refundAmtB = payableDetailPO.getRefundAmt().multiply(new BigDecimal(100));
        payProRefundAbilityReqBo.setRefundFee(refundAmtB.setScale(0, 5).abs().toString());
        payProRefundAbilityReqBo.setNotifyUrl(this.REFUND_RESULT_CALL_BACK);
        payProRefundAbilityReqBo.setCreateOperId(String.valueOf(reqBO.getOperatorId()));
        payProRefundAbilityReqBo.setCreateOperIdName(reqBO.getOperatorName());
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableListByPayno(payableDetailPO.getPayableNo());
        if (null == applyDetails || applyDetails.size() == 0) {
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u3010" + payableDetailPO.getPayableNo() + "\u3011\u672a\u67e5\u627e\u5230\u4ed8\u6b3e\u7533\u8bf7\u6210\u529f\u8bb0\u5f55\uff01");
        }
        BigDecimal paymentAmt = BigDecimal.ZERO;
        for (ApplyDetail applyDetail : applyDetails) {
            paymentAmt = paymentAmt.add(applyDetail.getAmt());
        }
        if (payableDetailPO.getRefundAmt().compareTo(paymentAmt) < 0) {
            payProRefundAbilityReqBo.setOrderType(PART_REFUND);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!"0000".equals(payProRefundAbilityRspBo.getRespCode())) {
            log.error("\u521b\u5efa\u9000\u6b3e\u8ba2\u5355[" + payOrderNo.toString() + "]\u5931\u8d25,\uff1a" + payProRefundAbilityRspBo.getRespDesc());
            this.savelog("CreateRefundOrderService-1", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", payProRefundAbilityRspBo.getRespDesc());
        }
        this.savelog("CreateRefundOrderService-2", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return payProRefundAbilityRspBo;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private void uodateBillApply(ChangeReceiptMatchReqBO reqBO, String billStatus, String applyNo, String saleOrderStatus, BigDecimal newAmt) {
        log.debug("\u5f00\u7968\u7533\u8bf7\u53d8\u66f4===billStatus\uff1a" + billStatus + "\uff0capplyNo\uff1a" + applyNo + "\uff0csaleOrderStatus\uff1a" + saleOrderStatus + ",\u66f4\u65b0\u91d1\u989d\uff1a" + newAmt);
        try {
            if (null == applyNo || "".equals(applyNo)) {
                if (OrderStatus.AFTER_SALE.getCode().equals(saleOrderStatus)) {
                    SaleOrderInfo saleOrderInfo1 = new SaleOrderInfo();
                    saleOrderInfo1.setSaleOrderCode(reqBO.getOrderCode());
                    saleOrderInfo1.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                    if (null != reqBO.getInspectionId()) {
                        saleOrderInfo1.setInspectionId((long)reqBO.getInspectionId());
                    }
                    log.debug("\u552e\u540e\u4e2d\u53d8\u66f4\u8ba2\u5355\u72b6\u60011===" + saleOrderInfo1.toString());
                    this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfo1);
                }
            } else if (OrderStatus.APPLIED.getCode().equals(saleOrderStatus) && BillStatus.GUAQI_APPLY.getCode().equals(billStatus)) {
                log.debug("\u8ba2\u5355\u72b6\u6001\uff1a" + OrderStatus.APPLIED.getDescr() + ",\u5f00\u7968\u7533\u8bf7\u5355\u72b6\u6001\uff1a" + BillStatus.GUAQI_APPLY.getDescr());
                BillApplyInfo record = new BillApplyInfo();
                record.setBillStatus(BillStatus.NO_APPLY.getCode());
                record.setApplyNo(applyNo);
                record.setAmt(newAmt);
                log.debug("\u53d8\u66f4\u5f00\u7968\u7533\u8bf7\u72b6\u60012===" + record.toString());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(record);
            } else if (OrderStatus.SEND_BILL.getCode().equals(saleOrderStatus) && BillStatus.SEND_BILL.getCode().equals(billStatus)) {
                log.debug("\u8ba2\u5355\u72b6\u6001\uff1a" + OrderStatus.SEND_BILL.getDescr() + ",\u5f00\u7968\u7533\u8bf7\u5355\u72b6\u6001\uff1a" + BillStatus.SEND_BILL.getDescr());
                BillApplyInfo record = new BillApplyInfo();
                record.setRedMarkRefund(1);
                record.setApplyNo(applyNo);
                record.setRemark("\u9000\u7968\u7ea2\u51b2");
                log.debug("\u53d8\u66f4\u5f00\u7968\u7533\u8bf7\u72b6\u60013===" + record.toString());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(record);
            } else if (OrderStatus.RECEIVE_BILL.getCode().equals(saleOrderStatus) && BillStatus.SIGNED_IN.getCode().equals(billStatus)) {
                log.debug("\u8ba2\u5355\u72b6\u6001\uff1a" + OrderStatus.RECEIVE_BILL.getDescr() + ",\u5f00\u7968\u7533\u8bf7\u5355\u72b6\u6001\uff1a" + BillStatus.SIGNED_IN.getDescr());
                BillApplyInfo record = new BillApplyInfo();
                record.setRedMarkRefund(1);
                record.setApplyNo(applyNo);
                record.setRemark("\u9000\u7968\u7ea2\u51b2");
                log.debug("\u53d8\u66f4\u5f00\u7968\u7533\u8bf7\u72b6\u60014===" + record.toString());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(record);
            }
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\uff1a" + reqBO.getOrderCode() + "\u53d8\u66f4\u5f00\u7968\u7533\u8bf7\u5f02\u5e38\uff01");
        }
    }

    private PfscExtRspBaseBO updatePayableDetail(ChangeReceiptMatchReqBO reqBO, List<PayableDetailPO> payableDetailPO, String flowFlag) {
        PfscExtRspBaseBO rspBaseBO = new PfscExtRspBaseBO();
        log.debug("\u5e94\u4ed8\u53d8\u66f4====s" + reqBO.toString());
        log.debug("\u5e94\u4ed8\u8bb0\u5f55=====" + payableDetailPO.toString());
        for (PayableDetailPO po : payableDetailPO) {
            if (new BigDecimal("0").compareTo(po.getPendingAmt()) != 0) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d\uff0c\u4e0d\u80fd\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7");
            }
            PayableDetailPO po1 = new PayableDetailPO();
            po1.setPayableNo(po.getPayableNo());
            BigDecimal noAmt = po.getPayableAmt().subtract(po.getPaidAmt()).subtract(po.getPendingAmt());
            if (PayableType.APPLY.getCode().equals(po.getPayableType().toString())) {
                if (PayableStatus.PAYING.getCode().equals(po.getPayableStatus()) || PayableStatus.PENDING.getCode().equals(po.getPayableStatus())) {
                    po1.setPayableAmt(po.getPayableAmt().subtract(reqBO.getOrderAmt()));
                    po1.setOrderAmt(po.getOrderAmt().subtract(reqBO.getOrderAmt()));
                }
                PaymentFlowInfo record = new PaymentFlowInfo();
                if (noAmt.compareTo(reqBO.getOrderAmt()) < 0) {
                    po1.setPayableStatus(PayableStatus.TERMINATION.getCode());
                    String refundOrderNo = "REFUND-" + po.getApplyNo();
                    record.setOutOrderId(refundOrderNo);
                    record.setReturnOutOrderId(refundOrderNo);
                    record.setPayTime(new Date());
                    record.setOrderCode(reqBO.getOrderCode());
                    record.setOrderAmt(reqBO.getOrderAmt());
                    record.setCreateUserId(reqBO.getOperatorId());
                    record.setCreateUserName(reqBO.getOperatorName());
                    record.setOrderDesc(FlowFlag.RETURN_GOODS_REFUND.getDescr());
                    record.setPayName(reqBO.getRecName());
                    record.setRecName(reqBO.getPayName());
                    record.setFlowFlag(REFUNDED);
                    record.setPayChannel(PayChannel.OFFLINE.getCode());
                    record.setPayType(PayChannel.OFFLINE.getCode());
                }
                this.paymentFlowInfoMapper.insertSelective(record);
            }
            if (PayableType.NOTIFICATION.getCode().equals(po.getPayableType().toString())) {
                if (new BigDecimal("0").compareTo(po.getPendingAmt()) != 0) {
                    throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d\uff0c\u4e0d\u80fd\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7");
                }
                ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
                applyPayInfoVO.setNotificationNo(po.getNotificationNo());
                List<ApplyPayInfoVO> applyPayInfoVOs = this.applyPayInfoMapper.selectListPayableDetail(applyPayInfoVO);
                BigDecimal olineAmt = new BigDecimal("0");
                for (ApplyPayInfoVO applyPayInfo : applyPayInfoVOs) {
                    boolean falg = PayMethod.ZH_BF.getCode().equals(applyPayInfo.getPayMathod()) || PayMethod.ZHCQT_SF.getCode().equals(applyPayInfo.getPayMathod()) || PayMethod.ZH_SF.getCode().equals(applyPayInfo.getPayMathod()) || PayMethod.XXZF.getCode().equals(applyPayInfo.getPayChannel());
                    if (falg) continue;
                    olineAmt = olineAmt.add(applyPayInfo.getPayAmt());
                }
                if (PayableStatus.PENDING.getCode().equals(po.getPayableStatus()) || PayableStatus.PAYING.getCode().equals(po.getPayableStatus())) {
                    po1.setPayableAmt(po.getPayableAmt().subtract(reqBO.getPayOrderAmt()));
                    po1.setOrderAmt(po.getOrderAmt().subtract(reqBO.getPayOrderAmt()));
                }
                if (noAmt.compareTo(reqBO.getPayOrderAmt()) < 0) {
                    po1.setPayableStatus(PayableStatus.TERMINATION.getCode());
                    BigDecimal mulpAmt = reqBO.getPayOrderAmt().subtract(noAmt);
                    PayableDetailPO newPO = new PayableDetailPO();
                    BeanUtils.copyProperties((Object)po, (Object)newPO);
                    String snNo = this.fscCreatePayableNoService.createPayableNo("SH");
                    newPO.setPayableNo(snNo);
                    newPO.setPayableType(Integer.valueOf(PayableType.SHYF.getCode()));
                    newPO.setPendingAmt(BigDecimal.ZERO);
                    newPO.setPaidAmt(BigDecimal.ZERO);
                    newPO.setPurchaseOrderCode(reqBO.getOrderCode());
                    newPO.setCreateDate(new Date());
                    newPO.setPayableStatus(PayableStatus.PENDING.getCode());
                    log.debug("\u771f\u6b63\u9000\u6b3e\u91d1\u989d\uff1a" + mulpAmt);
                    if (mulpAmt.compareTo(olineAmt) >= 0) {
                        newPO.setPayableAmt(olineAmt);
                        PaymentFlowInfo record = new PaymentFlowInfo();
                        String refundOrderNo = "REFUND-" + po.getPayNo();
                        record.setOutOrderId(refundOrderNo);
                        record.setReturnOutOrderId(refundOrderNo);
                        record.setPayTime(new Date());
                        record.setOrderCode(reqBO.getOrderCode());
                        record.setOrderAmt(reqBO.getOrderAmt());
                        record.setCreateUserId(reqBO.getOperatorId());
                        record.setCreateUserName(reqBO.getOperatorName());
                        record.setOrderDesc(FlowFlag.RETURN_GOODS_REFUND.getDescr());
                        record.setPayName(reqBO.getRecName());
                        record.setRecName(reqBO.getPayName());
                        record.setFlowFlag(REFUNDED);
                        record.setPayChannel(PayChannel.OFFLINE.getCode());
                        record.setPayType(PayChannel.OFFLINE.getCode());
                        record.setOrderAmt(mulpAmt.subtract(olineAmt));
                        this.paymentFlowInfoMapper.insertSelective(record);
                    } else {
                        newPO.setPayableAmt(mulpAmt);
                    }
                    log.debug("\u751f\u6210\u552e\u540e\u5e94\u4ed8====" + newPO.toString());
                    this.payableDetailMapper.insert(newPO);
                }
            }
            if (noAmt.compareTo(reqBO.getOrderAmt()) == 0) {
                po1.setPayableStatus(PayableStatus.TERMINATION.getCode());
            }
            if (!PayableStatus.PAYING.getCode().equals(po.getPayableStatus()) && !PayableStatus.PENDING.getCode().equals(po.getPayableStatus())) continue;
            this.payableDetailMapper.updateByPayableNo(po1);
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u5e94\u4ed8\u8bb0\u5f55\u53d8\u66f4\u6210\u529f\uff01");
        return rspBaseBO;
    }

    private void updateBillNotification(ChangeReceiptMatchReqBO reqBO, String invoiceStatus, String notificationNo, String payOrderStatus, BigDecimal newAmt) {
        log.debug("\u5f00\u7968\u901a\u77e5\u5355\u53d8\u66f4====notificationNo\uff1a" + notificationNo + "\uff0cinvoiceStatus\uff1a" + invoiceStatus + "\uff0cpayOrderStatus\uff1a" + payOrderStatus + "\uff0c\u66f4\u65b0\u91d1\u989d\uff1a" + newAmt);
        try {
            if (null == notificationNo || "".equals(notificationNo)) {
                if (OrderStatus.HANGING.getCode().equals(payOrderStatus)) {
                    PayPurchaseOrderInfo orderRecord = new PayPurchaseOrderInfo();
                    orderRecord.setPurchaseOrderCode(reqBO.getOrderCode());
                    orderRecord.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                    if (null != reqBO.getInspectionId()) {
                        orderRecord.setInspectionId((long)reqBO.getInspectionId());
                    }
                    this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(orderRecord);
                }
            } else {
                BillNotificationInfo billRecord = new BillNotificationInfo();
                billRecord.setNotificationNo(notificationNo);
                if (OrderStatus.APPLIED.getCode().equals(payOrderStatus) && NotificationInvoiceStatus.HANGING.getCode().equals(invoiceStatus)) {
                    billRecord.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
                    billRecord.setAmt(newAmt);
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(billRecord);
                } else if (OrderStatus.SEND_BILL.getCode().equals(payOrderStatus) && NotificationInvoiceStatus.HAS_MAKE.getCode().equals(invoiceStatus)) {
                    billRecord.setRedMarkRefund(1);
                    billRecord.setRemark("\u9000\u7968\u7ea2\u51b2\u6807\u8bb0");
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(billRecord);
                } else if (OrderStatus.RECEIVE_BILL.getCode().equals(payOrderStatus) && NotificationInvoiceStatus.RECEIVED.getCode().equals(invoiceStatus)) {
                    billRecord.setRedMarkRefund(1);
                    billRecord.setRemark("\u9000\u7968\u7ea2\u51b2\u6807\u8bb0");
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(billRecord);
                }
            }
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\uff1a" + reqBO.getOrderCode() + "\u53d8\u66f4\u5f00\u7968\u901a\u77e5\u8bb0\u5f55\u5f02\u5e38\uff01");
        }
    }

    private PfscExtRspBaseBO advanceCharge(ChangeReceiptMatchReqBO reqBO) {
        PfscExtRspBaseBO rspBaseBO = new PfscExtRspBaseBO();
        log.debug("\u9884\u4ed8\u6b3e\u652f\u4ed8-\u5165\u53c2====" + reqBO.toString());
        reqBO.setOperType("SUBMIT");
        FscRefundOrderOperRspBO rspBO = this.refundOrderOperService.makeRefund(reqBO);
        rspBaseBO.setRespCode(rspBO.getRespCode());
        rspBaseBO.setRespDesc(rspBO.getRespDesc());
        return rspBaseBO;
    }

    public static void main(String[] args) {
        String a = "YF202101190009";
        String b = a.replaceAll("[^0-9]", "");
        System.out.print(b);
        BigDecimal bigDecimal = new BigDecimal(0);
        bigDecimal = new BigDecimal(0.2);
        System.out.print(bigDecimal);
    }

    private String getPayInfoId(String prefix) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String maxNum = this.payableDetailMapper.selectMaxPayNoNum(prefix + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u5355\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }

    public void createPaymentFlow(PayableDetailPO detailPO, ChangeReceiptMatchReqBO reqBO) {
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("REFUND-").append(detailPO.getApplyNo());
        PaymentFlowInfo record = new PaymentFlowInfo();
        record.setOutOrderId(payOrderNo.toString());
        record.setPayTime(new Date());
        record.setOrderCode(reqBO.getOrderCode());
        record.setPayName(reqBO.getPayName());
        record.setRecName(reqBO.getRecName());
        record.setCreateUserId(reqBO.getOperatorId());
        record.setCreateUserName(reqBO.getOperatorName());
        record.setOrderAmt(reqBO.getOrderAmt());
        record.setCreateTime(new Date());
        record.setFlowFlag(FlowFlag.RETURN_GOODS_REFUND.getCode());
        record.setOrderDesc(FlowFlag.RETURN_GOODS_REFUND.getDescr());
        record.setPayChannel(PayChannel.OFFLINE.getCode());
        record.setPayType(PayMethod.XXZF.getCode());
        this.paymentFlowInfoMapper.insertSelective(record);
    }

    private void updateRefundPayable(PayableDetailPO needRefundPayableDetailPO) {
        int result = this.payableDetailMapper.updateSelective(needRefundPayableDetailPO);
        if (result < 1) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u3010" + needRefundPayableDetailPO.getPayableNo() + "\u3011\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void saveServiceFee(ChangeOfReceiptBO changeOfReceiptBO) {
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setSaleOrderCode(changeOfReceiptBO.getOrderCode());
        SaleOrderInfo saleOrderInfoResult = this.saleOrderServfeeInfoMapper.getCommDealFeeByOrderCode(saleOrderInfo);
        if (saleOrderInfoResult != null) {
            SaleOrderInfo saleOrderInfoNew = new SaleOrderInfo();
            BeanUtils.copyProperties((Object)saleOrderInfoResult, (Object)saleOrderInfoNew);
            Long inspectionID = 0L;
            saleOrderInfoNew.setCreateTime(new Date());
            try {
                inspectionID = this.frameOrderIdSeqSeqService.nextId();
            }
            catch (Exception e) {
                LOGGER.error("\u9500\u552e\u8ba2\u5355\u6210\u4ea4\u670d\u52a1\u8d39\u5f02\u5e38\u53d8\u66f4\u6dfb\u52a0\u5931\u8d25:" + e.toString());
            }
            BigDecimal changeFeeTotal = BigDecimal.ZERO;
            ArrayList<SaleItemInfo> saleItemInfos = new ArrayList<SaleItemInfo>();
            for (ChangOfReceiptItemBO changOfReceiptItemBO : changeOfReceiptBO.getChangOfReceiptItemBOS()) {
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setItemNo(Long.valueOf(changOfReceiptItemBO.getSaleOrderItemNo()));
                saleItemInfo.setSaleOrderCode(changOfReceiptItemBO.getOrderCode());
                saleItemInfo.setInspectionId((long)saleOrderInfoResult.getInspectionId());
                SaleItemInfo saleItemInfoOld = this.saleItemServfeeInfoMapper.getModelBy(saleItemInfo);
                if (saleItemInfoOld == null) continue;
                SaleItemInfo saleItemInfoNew = new SaleItemInfo();
                BeanUtils.copyProperties((Object)saleItemInfoOld, (Object)saleItemInfoNew);
                saleItemInfoNew.setSeq(null);
                saleItemInfoNew.setInspectionId(inspectionID);
                saleItemInfoNew.setQuantity(new BigDecimal(changOfReceiptItemBO.getSaleNum()));
                saleItemInfoNew.setAmount(changOfReceiptItemBO.getPurchearAmt().negate());
                BigDecimal taxAmt = saleItemInfoNew.getAmount().divide(BigDecimal.ONE.add(new BigDecimal(saleItemInfoNew.getTaxRate().toString())), 5, 4).multiply(new BigDecimal(saleItemInfoNew.getTaxRate().toString())).setScale(2, 4);
                saleItemInfoNew.setUntaxAmt(saleItemInfoNew.getAmount().subtract(taxAmt));
                saleItemInfoNew.setTaxAmt(taxAmt);
                changeFeeTotal = changeFeeTotal.add(saleItemInfoNew.getQuantity().multiply(saleItemInfoOld.getCommDealServiceFee()));
                saleItemInfos.add(saleItemInfoNew);
            }
            if (!CollectionUtils.isEmpty(saleItemInfos)) {
                this.saleItemServfeeInfoMapper.insertBatch(saleItemInfos);
            }
            saleOrderInfoNew.setInspectionId(inspectionID);
            saleOrderInfoNew.setOrderAmt(changeOfReceiptBO.getPayOrderAmt().negate());
            saleOrderInfoNew.setOrderDealServiceFee(changeFeeTotal);
            saleOrderInfoNew.setRecvDate(null);
            this.saleOrderServfeeInfoMapper.insert(saleOrderInfoNew);
        }
    }
}

