/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.controller.rest.dataimport;

import com.tydic.pfscext.api.busi.InsertPayInvoiceInfoBusiService;
import com.tydic.pfscext.api.busi.bo.InsertPayInvoiceInfoReqBO;
import com.tydic.pfscext.api.busi.bo.InsertPayInvoiceInfoRspBO;
import com.tydic.pfscext.api.busi.bo.PayInvoiceInfoBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.controller.utils.FscExcelUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FscImportInvoiceInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscImportInvoiceInfoService.class);
    private static final Integer NUMBER_OF_SHEETS = 2;
    @Autowired
    private InsertPayInvoiceInfoBusiService insertPayInvoiceInfoBusiService;

    public PfscExtRspBaseBO importData(@RequestParam(value="file") MultipartFile file) {
        PfscExtRspBaseBO rspInfo = new PfscExtRspBaseBO();
        if (file == null) {
            rspInfo.setRespCode("18000");
            rspInfo.setRespDesc("\u65e0\u6cd5\u5f97\u5230\u6587\u4ef6\u6570\u636e,\u8bf7\u5c1d\u8bd5\u7528POST\u65b9\u5f0f\u63d0\u4ea4\u8bf7\u6c42");
            return rspInfo;
        }
        return this.uploadExcel(file);
    }

    private PfscExtRspBaseBO uploadExcel(MultipartFile file) {
        PfscExtRspBaseBO rspInfo = new PfscExtRspBaseBO();
        try {
            Workbook wb = FscExcelUtils.createWorkbook(file);
            LOGGER.debug("\u83b7\u53d6Excel sheet\u9875\u7684\u6570\u91cf" + wb.getNumberOfSheets());
            if (wb.getNumberOfSheets() != NUMBER_OF_SHEETS.intValue()) {
                rspInfo.setRespCode("18000");
                rspInfo.setRespDesc("\u6570\u636eExcel\u6587\u4ef6" + file.getOriginalFilename() + "\u672a\u5305\u542b\u9884\u671f\u76842\u4e2asheet\u9875");
                return rspInfo;
            }
            HashMap<String, List<PayInvoiceInfoBO>> resultMap = new HashMap<String, List<PayInvoiceInfoBO>>(16);
            LinkedList<PayInvoiceInfoBO> payInvoiceInfoBOList = new LinkedList<PayInvoiceInfoBO>();
            Sheet sheet = wb.getSheetAt(1);
            for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                List<PayInvoiceInfoBO> infoBoList;
                BigDecimal taxAmt;
                BigDecimal notTaxAmt;
                BigDecimal amt;
                Row row = sheet.getRow(rowNum);
                LOGGER.debug("\u6821\u9a8cExcel\u4e2d\u6570\u636e\u662f\u5426\u4e3a\u7a7a");
                String validateData = this.validateDataEmpty(row, rowNum);
                if (StringUtils.hasText((String)validateData)) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc(validateData);
                    return rspInfo;
                }
                LOGGER.debug("\u5c06Excel\u4e2d\u7684\u6570\u636e\u548c\u5f00\u7968\u901a\u77e5\u8868\u7684\u6570\u636e\u6dfb\u52a0\u5230list");
                PayInvoiceInfoBO insertBO = new PayInvoiceInfoBO();
                String value = FscExcelUtils.getValue(row.getCell(1));
                if ("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968".equals(value)) {
                    insertBO.setInvoiceType(Integer.valueOf(2));
                } else if ("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968".equals(value)) {
                    insertBO.setInvoiceType(Integer.valueOf(1));
                } else {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u53d1\u7968\u7c7b\u578b\u4e0d\u6b63\u786e");
                    return rspInfo;
                }
                try {
                    amt = new BigDecimal(FscExcelUtils.getValue(row.getCell(5)));
                }
                catch (Exception e) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u6b63\u786e!");
                    return rspInfo;
                }
                try {
                    notTaxAmt = new BigDecimal(FscExcelUtils.getValue(row.getCell(6)));
                }
                catch (Exception e) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u6b63\u786e!");
                    return rspInfo;
                }
                try {
                    taxAmt = new BigDecimal(FscExcelUtils.getValue(row.getCell(7)));
                }
                catch (Exception e) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u7a0e\u989d\u4e0d\u6b63\u786e!");
                    return rspInfo;
                }
                insertBO.setAmt(amt);
                insertBO.setNotTaxAmt(notTaxAmt);
                insertBO.setTaxAmt(taxAmt);
                LOGGER.debug("\u6821\u9a8c\u91d1\u989d(\u4e0d\u542b\u7a0e)+\u7a0e\u989d=\u4ef7\u7a0e\u5408\u8ba1");
                if (amt.compareTo(notTaxAmt.add(taxAmt)) != 0) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u7b49\u4e8e\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0e\u7a0e\u989d\u4e4b\u548c!");
                    return rspInfo;
                }
                insertBO.setInvoiceCode(FscExcelUtils.getValue(row.getCell(2)));
                insertBO.setInvoiceNo(FscExcelUtils.getValue(row.getCell(3)));
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    sdf.setLenient(false);
                    Date parse = sdf.parse(FscExcelUtils.getValue(row.getCell(4)));
                    insertBO.setInvoiceDate(parse);
                }
                catch (Exception e) {
                    rspInfo.setRespCode("18000");
                    rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
                    return rspInfo;
                }
                insertBO.setNotificationNo(FscExcelUtils.getValue(row.getCell(0)));
                if (!resultMap.containsKey(FscExcelUtils.getValue(row.getCell(0)))) {
                    infoBoList = new LinkedList<PayInvoiceInfoBO>();
                    infoBoList.add(insertBO);
                    resultMap.put(FscExcelUtils.getValue(row.getCell(0)), infoBoList);
                } else {
                    infoBoList = (List)resultMap.get(FscExcelUtils.getValue(row.getCell(0)));
                    for (PayInvoiceInfoBO payInvoiceInfoBO : infoBoList) {
                        if (!payInvoiceInfoBO.getInvoiceNo().equals(FscExcelUtils.getValue(row.getCell(3)))) continue;
                        rspInfo.setRespCode("18000");
                        rspInfo.setRespDesc("\u7b2c" + (rowNum + 1) + "\u884c\u53d1\u7968\u53f7\u7801\u91cd\u590d!");
                        return rspInfo;
                    }
                    infoBoList.add(insertBO);
                }
                payInvoiceInfoBOList.add(insertBO);
            }
            InsertPayInvoiceInfoReqBO insertPayInvoiceInfoReqBO = new InsertPayInvoiceInfoReqBO();
            insertPayInvoiceInfoReqBO.setListReqBO(payInvoiceInfoBOList);
            InsertPayInvoiceInfoRspBO insert = this.insertPayInvoiceInfoBusiService.insert(insertPayInvoiceInfoReqBO);
            if (insert == null || !"0000".equals(insert.getRespCode())) {
                rspInfo.setRespCode("18000");
                if (null != insert && StringUtils.hasText((String)insert.getRespDesc())) {
                    rspInfo.setRespDesc(insert.getRespDesc());
                } else {
                    rspInfo.setRespDesc("\u5931\u8d25");
                }
                return rspInfo;
            }
            if (null == rspInfo.getRespCode()) {
                rspInfo.setRespCode("0000");
                rspInfo.setRespDesc("\u5bfc\u5165\u6210\u529f");
            }
            return rspInfo;
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            rspInfo.setRespCode("18000");
            rspInfo.setRespDesc("\u5bfc\u5165\u5931\u8d25");
            return rspInfo;
        }
    }

    private String validateDataEmpty(Row row, int rowNum) {
        if (row == null) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)FscExcelUtils.getValue(row.getCell(0)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u5f00\u7968\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)FscExcelUtils.getValue(row.getCell(1)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)FscExcelUtils.getValue(row.getCell(2)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)FscExcelUtils.getValue(row.getCell(3)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)FscExcelUtils.getValue(row.getCell(4)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)FscExcelUtils.getValue(row.getCell(5)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)FscExcelUtils.getValue(row.getCell(6)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((Object)FscExcelUtils.getValue(row.getCell(7)))) {
            return "\u7b2c" + (rowNum + 1) + "\u884c\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        return null;
    }
}

