/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiTransferApplyPayService;
import com.tydic.pfscext.external.api.bo.BusiTransferApplyPayReqBO;
import com.tydic.pfscext.external.api.bo.BusiTransferApplyPayRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.JsonUtils;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiTransferApplyPayServiceImpl
implements BusiTransferApplyPayService {
    private static final Logger log = LoggerFactory.getLogger(BusiTransferApplyPayServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BusiTransferApplyPayRspBO transferApplyPay(BusiTransferApplyPayReqBO reqBO) {
        HttpRetBean httpRetBean;
        if (log.isDebugEnabled()) {
            log.debug("\u4ed8\u6b3e\u5ba1\u6279\u5355\u53f7\u8fde\u63a5\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b \u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (reqBO.getSeqid() == null || !StringUtils.hasText((String)reqBO.getSeqid())) {
            log.error("\u552f\u4e00\u6807\u5fd7\uff08\u7269\u8d28\u6c47\u603b\u7f16\u53f7\uff09\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u552f\u4e00\u6807\u5fd7\uff08\u7269\u8d28\u6c47\u603b\u7f16\u53f7\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSsdw() == null || !StringUtils.hasText((String)reqBO.getSsdw())) {
            log.error("\u6240\u5c5e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u6240\u5c5e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getYhdm() == null) {
            log.error("\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFlowid() == null) {
            log.error("\u6d41\u7a0bId\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u6d41\u7a0bId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getItems().isEmpty()) {
            log.error("\u8bf7\u6c42Item\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u8bf7\u6c42Item\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        log.info("\u8bf7\u6c42\u62a5\u6587\u4e3a\uff1a" + reqStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_APPLYPAY_SEND_YUANGUANG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            log.error("\u4ed8\u6b3e\u5ba1\u6279\u5355\u8fde\u63a5\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf \u5931\u8d25,\u6c47\u603b\u5355\u7f16\u53f7\u4e3a:" + reqBO.getSeqid(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u4ed8\u6b3e\u5ba1\u6279\u5355\u8fde\u63a5\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf \u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u4ed8\u6b3e\u5ba1\u6279\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_APPLYPAY_SEND_YUANGUANG_URL") + "]");
            throw new RuntimeException("\u4ed8\u6b3e\u5ba1\u6279\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        log.info("\u4ed8\u6b3e\u5ba1\u6279\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u6210\u529f\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u4ed8\u6b3e\u5ba1\u6279\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u4ed8\u6b3e\u5ba1\u6279\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        BusiTransferApplyPayRspBO rspBO = new BusiTransferApplyPayRspBO();
        this.resolveRsp(returnString, rspBO);
        return rspBO;
    }

    private void resolveRsp(String returnString, BusiTransferApplyPayRspBO rspBO) {
        JSONObject rspJsonObject;
        log.debug("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u4ed8\u6b3e\u5ba1\u6279\u5355\u53f7\u8c03\u7528\u8fdc\u5149\u8d22\u52a1\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519, json:" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        rspBO.setSeqId(rspJsonObject.getString("seqid"));
        rspBO.setFinanceNo(rspJsonObject.getString("cwdjid"));
        rspBO.setResponeCode(rspJsonObject.getString("rspcode"));
        rspBO.setRspMsg(rspJsonObject.getString("rspmsg"));
    }
}

