/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiGetReconciliationDataService;
import com.tydic.pfscext.external.api.bo.BusiGetReconciliationDataRspVO;
import com.tydic.pfscext.external.api.bo.BusiGetReconciliationDataServiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetReconciliationDataServiceRspBO;
import com.tydic.pfscext.external.api.bo.PayReconciliationDetailVO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiGetReconciliationDataServiceImpl
implements BusiGetReconciliationDataService {
    private static final Logger log = LoggerFactory.getLogger(BusiGetReconciliationDataServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BusiGetReconciliationDataServiceRspBO getReconciliationData(BusiGetReconciliationDataServiceReqBO reqBO) {
        HttpRetBean httpRetBean;
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getStartDate() || reqBO.getStartDate().isEmpty()) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getEndDate() || reqBO.getEndDate().isEmpty()) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiGetReconciliationDataServiceRspBO rspBO = new BusiGetReconciliationDataServiceRspBO();
        ArrayList<BusiGetReconciliationDataRspVO> list = new ArrayList<BusiGetReconciliationDataRspVO>();
        rspBO.setDataList(list);
        String startDate = reqBO.getStartDate();
        String endDate = reqBO.getEndDate();
        String reqStr = this.initReqStr(reqBO);
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
        log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u670d\u52a1\u5b9e\u73b0\u7c7b--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u62a5\u6587:" + reqEsbStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_RECONCILITION_QUERY_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u5931\u8d25,\u5f00\u59cb\u65e5\u671f\u4e3a" + startDate + "\u7ed3\u675f\u65e5\u671f\u4e3a" + endDate + "\u4f9b\u5e94\u5546Id\u4e3a\uff1a" + reqBO.getSupplierId(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_RECONCILITION_QUERY_JD_URL") + "]");
            throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        log.info("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        BusiGetReconciliationDataRspVO rspVO = new BusiGetReconciliationDataRspVO();
        rspVO.setSupplierNo(reqBO.getSupplierId().toString());
        rspVO.setSupplierCode(hsn);
        this.resolveRsp(returnString, rspBO, rspVO);
        return rspBO;
    }

    @Override
    public BusiGetReconciliationDataServiceRspBO getJDOrderDetailData(BusiGetReconciliationDataServiceReqBO reqBO) {
        JSONObject rspJsonObject;
        HttpRetBean httpRetBean;
        BusiGetReconciliationDataServiceRspBO busiGetReconciliationDataServiceRspBO = new BusiGetReconciliationDataServiceRspBO();
        ArrayList<BusiGetReconciliationDataRspVO> dataList = new ArrayList<BusiGetReconciliationDataRspVO>();
        StringBuffer sb = new StringBuffer();
        String reqStr = sb.append("{").append("\"orderId\":").append("\"" + reqBO.getOrderId() + "\",").append("}").toString();
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
        log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u670d\u52a1\u5b9e\u73b0\u7c7b--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u62a5\u6587:" + reqEsbStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_RECONCILITION_QUERY_JD_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u5931\u8d25,\u5f00\u59cb\u65e5\u671f\u4e3a" + reqBO.getSupplierId(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_RECONCILITION_QUERY_JD_URL") + "]");
            throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        log.info("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        log.debug("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = (String)rspJsonObject.get((Object)"resultCode");
        Boolean success = (Boolean)rspJsonObject.get((Object)"success");
        if (null == resultCode) {
            log.error("\u4eac\u4e1c\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
            throw new PfscExternalBusinessException("18000", "\u4eac\u4e1c\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
        }
        if (success.equals(true) || "9000".equals(resultCode)) {
            BusiGetReconciliationDataRspVO busiGetReconciliationDataRspVO = new BusiGetReconciliationDataRspVO();
            ArrayList<PayReconciliationDetailVO> ordersList = new ArrayList<PayReconciliationDetailVO>();
            PayReconciliationDetailVO payReconciliationDetailVO = new PayReconciliationDetailVO();
            JSONObject jsonObject = null;
            try {
                jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            }
            catch (Exception e) {
                log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef", (Throwable)e);
                throw new PfscExternalBusinessException("18000", "\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
            }
            JSONObject js = (JSONObject)jsonObject.get((Object)"orderDetail ");
            String billNo = js.getString("billNo");
            String orderNo = js.getString("orderNo");
            BigDecimal orderAmount = js.getBigDecimal("orderAmount");
            payReconciliationDetailVO.setOrderId(orderNo);
            payReconciliationDetailVO.setOrderPrice(orderAmount);
            ordersList.add(payReconciliationDetailVO);
            busiGetReconciliationDataRspVO.setOrders(ordersList);
            busiGetReconciliationDataRspVO.setBillNo(billNo);
            dataList.add(busiGetReconciliationDataRspVO);
            busiGetReconciliationDataServiceRspBO.setDataList(dataList);
        }
        return busiGetReconciliationDataServiceRspBO;
    }

    @Override
    public BusiGetReconciliationDataServiceRspBO getJDOrderListDataByBillId(BusiGetReconciliationDataServiceReqBO reqBO) {
        return null;
    }

    private String initReqStr(BusiGetReconciliationDataServiceReqBO reqBO) {
        String StartDates = reqBO.getStartDate().trim();
        String EndDates = reqBO.getEndDate().trim();
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"startDate\":").append("\"" + StartDates + "\",").append("\"endDate\":").append("\"" + EndDates + "\",").append("\"purchaseNo\":").append("\"" + reqBO.getPurchaseNo() + "\",").append("}");
        return sb.toString();
    }

    private void resolveRsp(String returnString, BusiGetReconciliationDataServiceRspBO rspBO, BusiGetReconciliationDataRspVO rspVO) {
        ArrayList<PayReconciliationDetailVO> ordersList;
        BusiGetReconciliationDataRspVO rspVO1;
        JSONObject rspJsonObject;
        String supInfo = rspVO.getSupplierNo() + "(" + rspVO.getSupplierCode() + ")";
        log.debug("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519,sup=" + supInfo + " json:" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = (String)rspJsonObject.get((Object)"resultCode");
        Boolean success = (Boolean)rspJsonObject.get((Object)"success");
        if (null == resultCode) {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode,sup=" + supInfo);
            throw new PfscExternalBusinessException("18000", "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
        }
        if (success.equals(true) || resultCode.equals("0000")) {
            JSONObject jsonObject = null;
            try {
                jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            }
            catch (Exception e) {
                log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef,sup=" + supInfo, (Throwable)e);
                throw new PfscExternalBusinessException("18000", "\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
            }
            rspVO1 = new BusiGetReconciliationDataRspVO();
            rspVO1.setSupplierNo(rspVO.getSupplierNo());
            rspVO1.setSupplierCode(rspVO.getSupplierCode());
            Long total = jsonObject.getLong("total");
            if (total.equals(0)) {
                log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5bf9\u8d26\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u65e0\u6cd5\u62ff\u5230\u6709\u6548\u7684\u6570\u636e," + returnString);
            }
            rspVO1.setTotal(total);
            ordersList = new ArrayList<PayReconciliationDetailVO>();
            JSONArray jarr = jsonObject.getJSONArray("orders");
            for (Object obj : jarr) {
                JSONObject o = (JSONObject)obj;
                PayReconciliationDetailVO payReconciliationDetailVO = new PayReconciliationDetailVO();
                payReconciliationDetailVO.setOrderId(o.getString("orderId"));
                BigDecimal orderPrices = new BigDecimal(o.getDouble("orderPrice"));
                payReconciliationDetailVO.setOrderPrice(orderPrices);
                ordersList.add(payReconciliationDetailVO);
            }
        } else {
            log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode,sup=" + supInfo);
            throw new PfscExternalBusinessException("18000", "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
        }
        rspVO1.setOrders(ordersList);
        rspBO.getDataList().add(rspVO1);
    }
}

