/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.FscDelMsgPushBusiService;
import com.tydic.pfscext.external.api.bo.BusiDelMsgReqBO;
import com.tydic.pfscext.external.api.bo.BusiDelMsgRspBO;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscDelMsgPushBusiServiceImpl
implements FscDelMsgPushBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscDelMsgPushBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private Environment prop;

    @Override
    public BusiDelMsgRspBO delMsgPush(BusiDelMsgReqBO busiDelMsgReqBO) {
        BusiDelMsgRspBO rspBO;
        try {
            String reqStr = this.initPostStr(busiDelMsgReqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_DELETE_MSG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u5220\u9664\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_DELETE_MSG_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u8c03\u7528ESB\u5220\u9664\u63a8\u9001\u6d88\u606f\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528ESB\u8ba2\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new RuntimeException("\u8c03\u7528ESB\u5220\u9664\u63a8\u9001\u6d88\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(BusiDelMsgReqBO busiDelMsgReqBO) {
        String reqStr = JSONObject.toJSONString((Object)busiDelMsgReqBO);
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + busiDelMsgReqBO.getSupplierId());
        String esbReqParam = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u5220\u9664\u63a8\u9001\u6d88\u606fESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private BusiDelMsgRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u5220\u9664\u63a8\u9001\u6d88\u606fESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        BusiDelMsgRspBO rspBO = new BusiDelMsgRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            rspBO.setRespDesc("\u63a8\u9001\u6d88\u606f\u5220\u9664\u6210\u529f!");
            rspBO.setRespDesc("0000");
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        rspBO.setSuccess(jsonObject.getBoolean("success"));
        return rspBO;
    }
}

