/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.ability.FscBillApplyAutoConfirmTaskService;
import com.tydic.pfscext.api.ability.bo.FscBillApplyAutoConfirmTaskRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillApplyAutoConfirmTaskService.class)
public class FscBillApplyAutoConfirmTaskServiceImpl
implements FscBillApplyAutoConfirmTaskService {
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Value(value="#{AUTO_COMFIRM_DAYS)")
    private Integer autoComnfimDays;

    @Transactional(rollbackFor={Exception.class})
    public FscBillApplyAutoConfirmTaskRspBO dealAutoConfirm(FscBillApplyAutoConfirmTaskRspBO fscBillApplyAutoConfirmTaskRspBO) {
        FscBillApplyAutoConfirmTaskRspBO rspBO = new FscBillApplyAutoConfirmTaskRspBO();
        if (fscBillApplyAutoConfirmTaskRspBO == null) {
            rspBO.setRespCode("0001");
        }
        Date currentDate = new Date();
        BillApplyInfo info = new BillApplyInfo();
        info.setBillStatus("005");
        List<BillApplyInfo> applyInfos = this.billApplyInfoMapper.getListByStatus(info);
        for (BillApplyInfo applyInfo : applyInfos) {
            Date applyDate = applyInfo.getApplyDate();
            Date date = this.addDays(applyDate, this.autoComnfimDays);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String applyDateFormat = format.format(date);
            String currentDateFormat = format.format(currentDate);
            if (!currentDateFormat.equals(applyDateFormat)) continue;
            applyInfo.setBillStatus("06");
            int result = this.billApplyInfoMapper.updateByPrimaryKey(applyInfo);
            if (result > 0) {
                rspBO.setRespCode("0000");
                continue;
            }
            rspBO.setRespCode("0100");
        }
        return rspBO;
    }

    public Date addDays(Date currentDate, Integer addDays) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(currentDate);
        ((Calendar)calendar).add(5, addDays);
        return calendar.getTime();
    }
}

