/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryReceiptInfoService;
import com.tydic.pfscext.api.busi.bo.BusiReceiptInfoRspBO;
import com.tydic.pfscext.api.busi.bo.QueryReceiptInfoReqBO;
import com.tydic.pfscext.api.busi.bo.ReceiptInfoBO;
import com.tydic.pfscext.dao.EntryInfoMapper;
import com.tydic.pfscext.dao.ReceiptInfoMapper;
import com.tydic.pfscext.dao.po.EntryInfoPO;
import com.tydic.pfscext.dao.po.ReceiptInfoPO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=QueryReceiptInfoService.class)
public class QueryReceiptInfoServiceImpl
implements QueryReceiptInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryReceiptInfoServiceImpl.class);
    @Autowired
    private ReceiptInfoMapper receiptInfoMapper;
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public BusiReceiptInfoRspBO<ReceiptInfoBO> queryListPage(QueryReceiptInfoReqBO queryReceiptInfoReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u5e93\u8be6\u60c5\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + queryReceiptInfoReqBO.toString());
        }
        if (queryReceiptInfoReqBO.getEntryNo() == null || StringUtils.isEmpty((CharSequence)queryReceiptInfoReqBO.getEntryNo())) {
            throw new PfscExtBusinessException("18000", "\u5165\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = "t.ENTRY_DATE DESC";
        BusiReceiptInfoRspBO rspPageBO = new BusiReceiptInfoRspBO();
        ReceiptInfoPO receiptInfoPO = new ReceiptInfoPO();
        BeanUtils.copyProperties((Object)queryReceiptInfoReqBO, (Object)receiptInfoPO);
        Page page = new Page(queryReceiptInfoReqBO.getPageNo().intValue(), queryReceiptInfoReqBO.getPageSize().intValue());
        EntryInfoPO entryInfoPO = new EntryInfoPO();
        entryInfoPO.setEntryNo(queryReceiptInfoReqBO.getEntryNo());
        try {
            entryInfoPO = this.entryInfoMapper.getModelBy(entryInfoPO);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5165\u5e93\u5355\u53f7\u67e5\u8be2\u5165\u5e93\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + queryReceiptInfoReqBO.getEntryNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u5165\u5e93\u5355\u53f7\u67e5\u8be2\u5165\u5e93\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        rspPageBO.setEntryDate(entryInfoPO.getEntryDate());
        rspPageBO.setNotificationNo(entryInfoPO.getNotificationNo());
        rspPageBO.setTotalNotTaxAmt(entryInfoPO.getNotTaxAmt());
        rspPageBO.setTaxAmt(entryInfoPO.getTax());
        rspPageBO.setTotalAmt(entryInfoPO.getAmt());
        rspPageBO.setEntryNo(entryInfoPO.getEntryNo());
        String purchaseName = this.organizationInfoService.querySupplierName(entryInfoPO.getPurchaseId());
        logger.info("\u4f9b\u5e94\u5546ID\u4e3a\uff1a" + entryInfoPO.getPurchaseId() + "\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\u540d\u79f0\u4e3a\uff1a" + purchaseName);
        rspPageBO.setPurchaseName(purchaseName);
        List<ReceiptInfoPO> receiptInfoBOs = null;
        try {
            receiptInfoBOs = this.receiptInfoMapper.getListPage(receiptInfoPO, (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u5355\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25\uff0c\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + queryReceiptInfoReqBO.getEntryNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u5355\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25");
        }
        if (null == receiptInfoBOs || receiptInfoBOs.isEmpty()) {
            logger.error("\u627e\u4e0d\u5230\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u8be6\u60c5\u8bb0\u5f55\uff0c\u5165\u5e93\u5355\u53f7\u4e3a\uff1a" + queryReceiptInfoReqBO.getEntryNo());
            return rspPageBO;
        }
        logger.info("\u6210\u529f\u67e5\u8be2\u5230\u5165\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u5165\u5e93\u5355\u8be6\u60c5\uff0ccount=" + receiptInfoBOs.size() + "\u5177\u4f53\u7684\u5165\u5e93\u5355\u8be6\u60c5\u4e3a\uff1a" + receiptInfoBOs.toString());
        ArrayList<ReceiptInfoBO> list = new ArrayList<ReceiptInfoBO>();
        for (ReceiptInfoPO po : receiptInfoBOs) {
            ReceiptInfoBO bo = new ReceiptInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            list.add(bo);
        }
        rspPageBO.setRows(list);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

