/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiExportRecAmtConfirmService;
import com.tydic.pfscext.api.busi.bo.BusiExportHeadRecAmtConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportRecAmtConfirmReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportRecAmtConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportRowRecAmtConfirmRspBO;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.RecAmtConfirmMapper;
import com.tydic.pfscext.dao.RecvAmtDetailMapper;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.RecAmtConfirm;
import com.tydic.pfscext.dao.po.RecvAmtDetail;
import com.tydic.pfscext.dao.vo.AdvanceReceive4PdfVO;
import com.tydic.pfscext.dao.vo.RecvAmtDetailVO;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.ReceiveType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.AmountUtils;
import com.tydic.pfscext.utils.BeanUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportRecAmtConfirmServiceImpl
implements BusiExportRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportRecAmtConfirmServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;

    public BusiExportRecAmtConfirmRspBO exportRecAmtConfirm(BusiExportRecAmtConfirmReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5bfc\u51fa\u6536\u6b3e\u5355\u670d\u52a1\uff08\u4e3aBusiExportRecAmtConfirmController\u63d0\u4f9b\u6570\u636e\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDocNum() == null) {
            throw new PfscExtBusinessException("0001", "\u5355\u636e\u7f16\u53f7[docNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiExportRecAmtConfirmRspBO rspBO = new BusiExportRecAmtConfirmRspBO();
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BusiExportHeadRecAmtConfirmRspBO head = new BusiExportHeadRecAmtConfirmRspBO();
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.selectByPrimaryKey(reqBO.getDocNum());
        org.springframework.beans.BeanUtils.copyProperties((Object)recAmtConfirm, (Object)head);
        head.setCreateDateString(simpleDateFormat1.format(recAmtConfirm.getCreateDate()));
        head.setSumAmtString(AmountUtils.format(recAmtConfirm.getSumAmt()));
        head.setSumAmtUpper(AmountUtils.upper(recAmtConfirm.getSumAmt()));
        String orgName = this.organizationInfoService.queryOrgName(recAmtConfirm.getOrgId());
        head.setOrgName(orgName);
        BeanUtils.null2DefaultValue(head);
        rspBO.setHead(head);
        ArrayList<BusiExportRowRecAmtConfirmRspBO> rows = new ArrayList<BusiExportRowRecAmtConfirmRspBO>();
        rspBO.setRows(rows);
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(recAmtConfirm.getSource())) {
            AdvanceReceive advanceReceive = new AdvanceReceive();
            advanceReceive.setDocNum(reqBO.getDocNum());
            List<AdvanceReceive4PdfVO> voList = this.advanceReceiveMapper.select4PdfByCondition(advanceReceive);
            for (AdvanceReceive4PdfVO vo : voList) {
                BusiExportRowRecAmtConfirmRspBO row = new BusiExportRowRecAmtConfirmRspBO();
                org.springframework.beans.BeanUtils.copyProperties((Object)vo, (Object)row);
                row.setTranAmtString(AmountUtils.format(vo.getTranAmt()));
                row.setBillAmtString(AmountUtils.format(vo.getBillAmt()));
                row.setPostDateString(simpleDateFormat2.format(vo.getPostDate()));
                AdvanceReceive advanceReceivePo = new AdvanceReceive();
                org.springframework.beans.BeanUtils.copyProperties((Object)vo, (Object)advanceReceivePo);
                orgName = this.organizationInfoService.obtainOrgNameByAdvanceReceive(advanceReceivePo);
                row.setPayOrgName(orgName);
                orgName = this.organizationInfoService.queryOrgName(vo.getRecOrgId());
                row.setRecOrgName(orgName);
                row.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(vo.getRecType())));
                BeanUtils.null2DefaultValue(row);
                rows.add(row);
            }
        } else {
            AdvanceReceive advanceReceive = new AdvanceReceive();
            advanceReceive.setDocNum(reqBO.getDocNum());
            List<AdvanceReceive4PdfVO> voList = this.advanceReceiveMapper.select4PdfByConditionDlzq(advanceReceive);
            for (AdvanceReceive4PdfVO vo : voList) {
                RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
                recvAmtDetailVO.setDocNum(reqBO.getDocNum());
                recvAmtDetailVO.setAdvRecvSeq(vo.getSeq());
                RecvAmtDetail recvAmtDetail = this.recvAmtDetailMapper.selectSum(recvAmtDetailVO);
                BusiExportRowRecAmtConfirmRspBO row = new BusiExportRowRecAmtConfirmRspBO();
                org.springframework.beans.BeanUtils.copyProperties((Object)vo, (Object)row);
                row.setTranAmtString(AmountUtils.format(recvAmtDetail.getAmount()));
                row.setBillAmtString(AmountUtils.format(vo.getBillAmt()));
                row.setPostDateString(simpleDateFormat2.format(vo.getPostDate()));
                AdvanceReceive po = new AdvanceReceive();
                org.springframework.beans.BeanUtils.copyProperties((Object)vo, (Object)po);
                orgName = this.organizationInfoService.obtainOrgNameByAdvanceReceive(po);
                row.setPayOrgName(orgName);
                orgName = this.organizationInfoService.queryOrgName(vo.getRecOrgId());
                row.setRecOrgName(orgName);
                row.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(vo.getRecType())));
                BeanUtils.null2DefaultValue(row);
                rows.add(row);
            }
        }
        return rspBO;
    }
}

