/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscPayableOrderCreateService;
import com.tydic.pfscext.api.busi.bo.FscPayableOrderCreateReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayableOrderCreateRspBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayConfigDetailMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.PayAbleDateUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayableOrderCreateService.class)
public class FscPayableOrderCreateServiceImpl
implements FscPayableOrderCreateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscPayableOrderCreateServiceImpl.class);
    private static final String YFDH_CG = "YFDH-CG-";
    private static final String YFDH_DH = "YFDH-DH-";
    private static final String YFDH_YS = "YFDH-YS-";
    private static final String YFDH_BJ = "YFDH-BJ-";
    private static final String YFDH_GZ = "YFDH-GZ-";
    private static final String YFDH_SQ = "YFDH-SQ-";
    private static final String YFDH_WZ = "YFDH-WZ-";
    private static final String YFDH_ZH = "YFDH-ZH-";
    private static final String YFDH_RZ = "YFDH-RZ-";
    private static final String YFDH_DJ = "YFDH-DJ-";
    private static final String YFDH_BZ = "YFDH-BZ-";
    private static final String YFDH_GB = "YFDH-GB-";
    private static final String YFDH_YZ = "YFDH-YZ-";
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayConfigDetailMapper payConfigDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayAbleDateUtil payAbleDateUtil;

    public FscPayableOrderCreateRspBO createPayableOrder(FscPayableOrderCreateReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u751f\u6210\u5e94\u4ed8\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPayableType() == null || "".equals(reqBO.getPayableType())) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscPayableOrderCreateRspBO rspBO = new FscPayableOrderCreateRspBO();
        Map<String, Integer> payAbleDateMap = this.payAbleDateUtil.getDateMap();
        if (PayableType.EXPIRE.getCode().equals(reqBO.getPayableType())) {
            if (reqBO.getNotificationNos() == null || reqBO.getNotificationNos().size() == 0) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<BillNotificationInfo> bills = this.billNotificationInfoMapper.selectBatchNotifyNo(reqBO.getNotificationNos());
            LOGGER.debug("\u5e10\u671f\u652f\u4ed8\u8d26\u5355\uff1a" + bills.toString());
            Boolean isAllSuccess = true;
            ArrayList<String> failureBills = new ArrayList<String>();
            for (BillNotificationInfo bill : bills) {
                PayableDetailPO payableDetailPO = new PayableDetailPO();
                try {
                    String payAbleNo = this.getPayInfoId(reqBO.getPayableType());
                    BigDecimal defaultValue = new BigDecimal("0");
                    payableDetailPO.setPaidAmt(defaultValue);
                    payableDetailPO.setPendingAmt(defaultValue);
                    payableDetailPO.setNeedAgainstAmt(defaultValue);
                    payableDetailPO.setOverduePenalty(defaultValue);
                    payableDetailPO.setEffectiveStatus(1);
                    payableDetailPO.setOperatorId(bill.getOperNo());
                    payableDetailPO.setPayableNo(payAbleNo);
                    payableDetailPO.setPayableAmt(bill.getAmt());
                    payableDetailPO.setOrderAmt(bill.getAmt());
                    payableDetailPO.setSupplierId(bill.getSupplierNo());
                    payableDetailPO.setPurchaseNo(bill.getOperNo());
                    payableDetailPO.setNotificationNo(bill.getNotificationNo());
                    payableDetailPO.setRecOrgId(bill.getSupplierNo());
                    payableDetailPO.setPayOrgId(bill.getOperNo());
                    payableDetailPO.setPurchaseName(bill.getOperName());
                    payableDetailPO.setPayableType(Integer.valueOf(reqBO.getPayableType()));
                    Integer leastPayAbleDays = this.payPurchaseOrderInfoMapper.selectLeastDaysByNotificationNo(bill.getNotificationNo());
                    Date now = new Date();
                    Date paidDate = new Date(now.getTime() + (long)(leastPayAbleDays * 24 * 60 * 60 * 1000));
                    payableDetailPO.setPaidDate(paidDate);
                    payableDetailPO.setPayType(PayablePayType.PAY.getCode());
                    payableDetailPO.setPayableStatus(PayableStatus.PENDING.getCode());
                    payableDetailPO.setMobile(bill.getMobile());
                    LOGGER.debug("\u5e94\u4ed8\u5355\uff1a" + payableDetailPO.toString());
                    this.payableDetailMapper.insert(payableDetailPO);
                }
                catch (Exception e) {
                    isAllSuccess = false;
                    failureBills.add(bill.getNotificationNo());
                    LOGGER.error("\u901a\u77e5\u5355[ " + bill.getNotificationNo() + " ]\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25\uff1a" + e);
                }
            }
            if (isAllSuccess.booleanValue()) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u5f00\u7968\u901a\u77e5\u5355\u53f7" + ((Object)failureBills).toString() + "\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25");
                LOGGER.error("\u5f00\u7968\u901a\u77e5\u5355\u53f7" + ((Object)failureBills).toString() + "\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25");
            }
        } else {
            if (reqBO.getPurchaseNo() == null) {
                throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getOperatorId() == null) {
                throw new PfscExtBusinessException("18000", "\u8fd0\u8425\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getSupplierId() == null) {
                throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getRecOrgId() == null) {
                throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getPayOrgId() == null) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BigDecimal payAbleAmt = new BigDecimal("0");
            if (PayableType.ACCOUNT_VERIFICATION.getCode().equals(reqBO.getPayableType())) {
                if (reqBO.getMobile() == null) {
                    throw new PfscExtBusinessException("18000", "\u8d26\u6237\u9a8c\u771f\u65f6\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
                }
                int range = new Random().nextInt(11);
                payAbleAmt = payAbleAmt.add(new BigDecimal(range));
            } else {
                payAbleAmt = payAbleAmt.add(reqBO.getPayableAmt());
            }
            try {
                PayableDetailPO payableDetailPO = new PayableDetailPO();
                String payAbleNo = this.getPayInfoId(reqBO.getPayableType());
                LOGGER.debug("\u5e94\u4ed8\u7f16\u53f7\uff1a" + payAbleNo);
                rspBO.setPayableNo(payAbleNo);
                BigDecimal defaultValue = new BigDecimal("0");
                payableDetailPO.setPaidAmt(defaultValue);
                payableDetailPO.setPendingAmt(defaultValue);
                payableDetailPO.setNeedAgainstAmt(defaultValue);
                payableDetailPO.setOverduePenalty(defaultValue);
                payableDetailPO.setEffectiveStatus(1);
                payableDetailPO.setPayableNo(payAbleNo);
                payableDetailPO.setPayableAmt(payAbleAmt);
                payableDetailPO.setOrderAmt(payAbleAmt);
                payableDetailPO.setSupplierId(reqBO.getSupplierId());
                payableDetailPO.setOperatorId(reqBO.getOperatorId());
                payableDetailPO.setPurchaseNo(reqBO.getPurchaseNo());
                payableDetailPO.setRecOrgId(reqBO.getRecOrgId());
                payableDetailPO.setPayOrgId(reqBO.getPayOrgId());
                payableDetailPO.setPayableType(Integer.valueOf(reqBO.getPayableType()));
                Integer payableDate = payAbleDateMap.get(reqBO.getPayableType());
                Date now = new Date();
                Date paidDate = new Date(now.getTime() + (long)(payableDate * 24 * 60 * 60 * 1000));
                payableDetailPO.setPaidDate(paidDate);
                payableDetailPO.setPayType(PayablePayType.PAY.getCode());
                payableDetailPO.setPayableStatus(PayableStatus.PENDING.getCode());
                if (reqBO.getMobile() != null) {
                    payableDetailPO.setMobile(reqBO.getMobile());
                }
                LOGGER.debug("\u5e94\u4ed8\u5355\uff1a" + payableDetailPO.toString());
                this.payableDetailMapper.insert(payableDetailPO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            }
            catch (Exception e) {
                LOGGER.error("\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25\uff1a" + e);
                throw new PfscExtBusinessException("18000", "\u751f\u6210\u5e94\u4ed8\u5355\u5931\u8d25\uff1a" + e);
            }
        }
        return rspBO;
    }

    private String getPayInfoId(String payableType) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String prefix = YFDH_CG;
            if (PayableType.NOTIFICATION.getDescr().equals(payableType)) {
                prefix = YFDH_CG;
            }
            if (PayableType.AOG.getCode().equals(payableType)) {
                prefix = YFDH_DH;
            }
            if (PayableType.INSPECTION.getCode().equals(payableType)) {
                prefix = YFDH_YS;
            }
            if (PayableType.QUALITY_GUARANTEE_DEPOSIT.getCode().equals(payableType)) {
                prefix = YFDH_BJ;
            }
            if (PayableType.EXPIRE.getCode().equals(payableType)) {
                prefix = YFDH_GZ;
            }
            if (PayableType.APPLY.getCode().equals(payableType)) {
                prefix = YFDH_SQ;
            }
            if (PayableType.RYWZ.getCode().equals(payableType)) {
                prefix = YFDH_WZ;
            }
            if (PayableType.LAGGED.getCode().equals(payableType)) {
                prefix = YFDH_ZH;
            }
            if (PayableType.PLAT_USE_FEE.getCode().equals(payableType)) {
                prefix = YFDH_RZ;
            }
            if (PayableType.USER_LEVEL_ANNUAL_FEE.getCode().equals(payableType)) {
                prefix = YFDH_DJ;
            }
            if (PayableType.MAERGIN.getCode().equals(payableType)) {
                prefix = YFDH_BZ;
            }
            if (PayableType.PURCHASE_BID.getCode().equals(payableType)) {
                prefix = YFDH_GB;
            }
            if (PayableType.ACCOUNT_VERIFICATION.getCode().equals(payableType)) {
                prefix = YFDH_YZ;
            }
            String maxNum = this.payableDetailMapper.selectMaxPayAbleNoNum(prefix + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }
}

