/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.QueryApplyPayInfoByIdService;
import com.tydic.pfscext.api.busi.bo.ApplyPayInfoBO;
import com.tydic.pfscext.api.busi.bo.QueryApplyPayInfoByIdReqBO;
import com.tydic.pfscext.api.busi.bo.QueryApplyPayInfoByIdRspBO;
import com.tydic.pfscext.api.busi.vo.ApplyDetailVO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PsPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrderService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.bo.ReceiveDetailBO;
import com.tydic.pfscext.service.atom.bo.SaleOrderBO;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=QueryApplyPayInfoByIdService.class)
public class QueryApplyPayInfoByIdServiceImpl
implements QueryApplyPayInfoByIdService {
    private static final Logger logger = LoggerFactory.getLogger(QueryApplyPayInfoByIdServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private OrderService orderService;

    public QueryApplyPayInfoByIdRspBO queryById(QueryApplyPayInfoByIdReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (reqBO.getId() == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryApplyPayInfoByIdRspBO queryApplyPayInfoByIdRspBO = new QueryApplyPayInfoByIdRspBO();
        ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(reqBO.getId());
        if (applyPayInfoPO == null) {
            throw new PfscExtBusinessException("18001", "\u4ed8\u6b3e\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        ApplyPayInfoBO applyPayInfoBO = new ApplyPayInfoBO();
        BeanUtils.copyProperties((Object)applyPayInfoPO, (Object)applyPayInfoBO);
        PayResultStatus payResultEnum = PayResultStatus.getInstance(applyPayInfoBO.getPayStatus());
        applyPayInfoBO.setPayStatusStr(this.enumsService.getDescr(payResultEnum));
        OrderSource orderSourceEnum = OrderSource.getInstance((String)applyPayInfoBO.getSource());
        applyPayInfoBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
        String supplierStr = this.organizationInfoService.querySupplierName(applyPayInfoBO.getSupplierId());
        applyPayInfoBO.setSupplierStr(supplierStr);
        applyPayInfoBO.setSupplierName(supplierStr);
        PsPayType psPayTypeEnum = PsPayType.getInstance(applyPayInfoBO.getPayMathod());
        applyPayInfoBO.setPayMathodStr(this.enumsService.getDescr(psPayTypeEnum));
        queryApplyPayInfoByIdRspBO.setApplyPayInfoBO(applyPayInfoBO);
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(reqBO.getId());
        if (CollectionUtils.isEmpty(applyDetails)) {
            throw new PfscExtBusinessException("18001", "\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        LinkedList<ApplyDetailVO> rows = new LinkedList<ApplyDetailVO>();
        for (ApplyDetail singleDetail : applyDetails) {
            PayableDetailPO singlePayable = this.payableDetailMapper.getModelById(singleDetail.getPayableNo());
            if (singlePayable == null) {
                throw new PfscExtBusinessException("18001", "\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6\u4e0d\u5b58\u5728");
            }
            String payType = singlePayable.getPayType();
            ApplyDetailVO payableDetailBO = new ApplyDetailVO();
            BeanUtils.copyProperties((Object)singleDetail, (Object)payableDetailBO);
            BeanUtils.copyProperties((Object)singlePayable, (Object)payableDetailBO);
            PayResultStatus payResultStatus = PayResultStatus.getInstance(payableDetailBO.getStatus());
            payableDetailBO.setPayResultStatusStr(this.enumsService.getDescr(payResultStatus));
            OrderSource orderSourceEnum2 = OrderSource.getInstance((String)payableDetailBO.getSource());
            payableDetailBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum2));
            String supplierStr2 = this.organizationInfoService.querySupplierName(payableDetailBO.getSupplierId());
            payableDetailBO.setSupplierStr(supplierStr2);
            String orgNameStr = this.organizationInfoService.queryOrgName(payableDetailBO.getOperatorId());
            payableDetailBO.setOperatorStr(orgNameStr);
            SaleOrderBO saleOrderBO = this.orderService.obtainSaleOrder(singlePayable.getOrderId());
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setSource(singlePayable.getSource());
            saleOrderInfoVO.setOrderId(saleOrderBO.getSaleOrderId());
            saleOrderInfoVO.setSaleOrderCode(saleOrderBO.getSaleOrderCode());
            Map<String, ReceiveDetailBO> receiveDetail = this.orderService.obtainReceiveDetail(saleOrderInfoVO);
            rows.add(payableDetailBO);
        }
        queryApplyPayInfoByIdRspBO.setRows(rows);
        return queryApplyPayInfoByIdRspBO;
    }
}

