/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryBillApplyForMailService;
import com.tydic.pfscext.api.busi.bo.InvoiceMailDetailListRspBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailReqBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailRspBO;
import com.tydic.pfscext.api.busi.bo.QueryExpressTraceReqBO;
import com.tydic.pfscext.api.busi.bo.QueryExpressTraceRspBO;
import com.tydic.pfscext.api.busi.vo.BusiApplyMailVO;
import com.tydic.pfscext.api.busi.vo.InvoiceForMailVO;
import com.tydic.pfscext.api.busi.vo.PurchaseNoListVO;
import com.tydic.pfscext.base.PfscExtReqPageBaseBO;
import com.tydic.pfscext.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfscext.dao.po.SaleInvoiceMailInfo;
import com.tydic.pfscext.enums.InvoiceMailSentStatus;
import com.tydic.pfscext.enums.InvoiceMailSentStatusCustom;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.JDAssignStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiEMSExpressService;
import com.tydic.pfscext.external.api.BusiJdExpressService;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.JdExpressTokenService;
import com.tydic.pfscext.utils.FscStringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=QueryBillApplyForMailService.class)
public class QueryBillApplyForMailServiceImpl
implements QueryBillApplyForMailService {
    private static final Logger logger = LoggerFactory.getLogger(QueryBillApplyForMailServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BusiEMSExpressService busiEMSExpressService;

    public QueryBillApplyForMailRspBO queryInvoiceForMail(QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f85\u90ae\u5bc4\u53d1\u7968\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        QueryBillApplyForMailRspBO rspPageBO = new QueryBillApplyForMailRspBO();
        String orderBy = FscStringUtils.obtainOrderBy((PfscExtReqPageBaseBO)reqBO, "d_bill_apply_info c", null);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        reqBO.setInvoceNameLike(reqBO.getInvoceName());
        reqBO.setInvoceName(null);
        reqBO.setCompanyId(null);
        List<PurchaseNoListVO> purchaseNoListVOs = this.saleInvoiceMailInfoMapper.queryToMailListPage(reqBO, (Page<Map<String, Object>>)page, orderBy);
        reqBO.setInvoceNameLike(null);
        reqBO.setInvoceName(null);
        reqBO.setReceiverLike(null);
        reqBO.setReceiver(null);
        ArrayList<BusiApplyMailVO> keyFields = new ArrayList<BusiApplyMailVO>();
        reqBO.setKeyFields(keyFields);
        for (PurchaseNoListVO purchaseNoListVO : purchaseNoListVOs) {
            BusiApplyMailVO keyField = new BusiApplyMailVO();
            keyFields.add(keyField);
            keyField.setInvoceName(purchaseNoListVO.getInvoceName());
            keyField.setName(purchaseNoListVO.getName());
        }
        orderBy = " a.INVOICE_NO asc";
        List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.queryToMailInvoice(reqBO, orderBy);
        for (PurchaseNoListVO purchaseNoListVO : purchaseNoListVOs) {
            ArrayList<InvoiceForMailVO> invoices = new ArrayList<InvoiceForMailVO>();
            Iterator<InvoiceForMailVO> iterator = invoiceForMailVOs.iterator();
            while (iterator.hasNext()) {
                InvoiceForMailVO invoice = iterator.next();
                if (!purchaseNoListVO.getInvoceName().equals(invoice.getInvoceName()) || !purchaseNoListVO.getName().equals(invoice.getName())) continue;
                invoices.add(invoice);
                iterator.remove();
            }
            if (!invoices.isEmpty()) {
                InvoiceForMailVO firstInvoice = (InvoiceForMailVO)invoices.get(0);
                purchaseNoListVO.setMobile(firstInvoice.getMobile());
                purchaseNoListVO.setMobile(firstInvoice.getMobile());
                purchaseNoListVO.setPurchaseName(firstInvoice.getPurchaseName());
                purchaseNoListVO.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(firstInvoice.getInvoiceType()))));
                purchaseNoListVO.setDetailAddress(QueryBillApplyForMailServiceImpl.getDetailAddress(firstInvoice));
                purchaseNoListVO.setAddress(QueryBillApplyForMailServiceImpl.getDetailAddress(firstInvoice));
                purchaseNoListVO.setReceiver(firstInvoice.getName());
            }
            purchaseNoListVO.setCount(Integer.valueOf(invoices.size()));
            purchaseNoListVO.setInvoiceForMailList(invoices);
        }
        rspPageBO.setRows(purchaseNoListVOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }

    public InvoiceMailDetailListRspBO queryNoMailDetailList(QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f85\u90ae\u5bc4\u53d1\u7968\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        InvoiceMailDetailListRspBO rspPageBO = new InvoiceMailDetailListRspBO();
        try {
            reqBO.setInvoceName(reqBO.getInvoceName());
            reqBO.setReceiver(reqBO.getName());
            reqBO.setCompanyId(null);
            String orderBy = " a.INVOICE_NO asc";
            List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.queryToMailInvoice(reqBO, orderBy);
            rspPageBO.setRows(invoiceForMailVOs);
            rspPageBO.setRespCode("0000");
            rspPageBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            rspPageBO.setRespCode("18000");
            rspPageBO.setRespDesc("\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5\u5931\u8d25");
            logger.debug("\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5\u5931\u8d25", (Throwable)e);
        }
        return rspPageBO;
    }

    public QueryBillApplyForMailRspBO queryInvoiceSent(QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5df2\u90ae\u5bc4\u53d1\u7968\u5217\u8868\u670d\u52a1 \u5165\u53c2\uff1a" + reqBO);
        }
        QueryBillApplyForMailRspBO rspPageBO = new QueryBillApplyForMailRspBO();
        String orderBy = StringUtils.hasText((String)reqBO.getOrderBy()) ? reqBO.getOrderBy() : " b.MAIL_TICKET_NO asc";
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        reqBO.setInvoceNameLike(reqBO.getInvoceName());
        reqBO.setInvoceName(null);
        List<SaleInvoiceMailInfo> mails = this.saleInvoiceMailInfoMapper.queryMailedListPage(reqBO, InvoiceMailSentStatusCustom.DONE.getCode(), (Page<Map<String, Object>>)page, orderBy);
        QueryBillApplyForMailReqBO reqBO2 = new QueryBillApplyForMailReqBO();
        reqBO2.setOrderBy(" a.MAIL_TICKET_NO asc,a.ORDER_ID asc");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<PurchaseNoListVO> purchaseNoListVOs = new ArrayList<PurchaseNoListVO>();
        for (SaleInvoiceMailInfo mail : mails) {
            PurchaseNoListVO vo = new PurchaseNoListVO();
            BeanUtils.copyProperties((Object)mail, (Object)vo);
            purchaseNoListVOs.add(vo);
            reqBO2.setExpressNo(mail.getMailTicketNo());
            List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.getHasMailInvoiceList(reqBO2);
            for (InvoiceForMailVO invoiceForMailVO : invoiceForMailVOs) {
                invoiceForMailVO.setInvoiceDateString(dateFormat.format(invoiceForMailVO.getInvoiceDate()));
            }
            if (invoiceForMailVOs != null && invoiceForMailVOs.size() > 0) {
                vo.setPurchaseName(invoiceForMailVOs.get(0).getPurchaseName());
            }
            vo.setName(vo.getReceiver());
            vo.setMobile(vo.getTel());
            vo.setDetailAddress(vo.getAddress());
            vo.setJdAssignStatusDescr(this.enumsService.getDescr(JDAssignStatus.getInstance(vo.getJdAssignStatus())));
            vo.setMailStatusDescr(this.enumsService.getDescr(InvoiceMailSentStatus.getInstance(vo.getMailStatus())));
            vo.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(mail.getInvoiceType()))));
            vo.setCreateDateString(dateFormat.format(vo.getCreateDate()));
            vo.setCount(Integer.valueOf(invoiceForMailVOs.size()));
            vo.setInvoiceForMailList(invoiceForMailVOs);
        }
        rspPageBO.setRows(purchaseNoListVOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }

    public InvoiceMailDetailListRspBO queryInvoiceMailDetailList(QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5df2\u90ae\u5bc4\u53d1\u7968\u8be6\u60c5\u5217\u8868\u670d\u52a1 \u5165\u53c2\uff1a" + reqBO);
        }
        InvoiceMailDetailListRspBO rspPageBO = new InvoiceMailDetailListRspBO();
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            reqBO.setOrderBy(" a.MAIL_TICKET_NO asc,a.ORDER_ID asc");
            List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.getHasMailInvoiceList(reqBO);
            for (InvoiceForMailVO invoiceForMailVO : invoiceForMailVOs) {
                invoiceForMailVO.setInvoiceDateString(dateFormat.format(invoiceForMailVO.getInvoiceDate()));
            }
            rspPageBO.setRows(invoiceForMailVOs);
            rspPageBO.setRespCode("0000");
            rspPageBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            rspPageBO.setRespCode("18000");
            rspPageBO.setRespDesc("\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5\u5931\u8d25");
            logger.debug("\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5\u5931\u8d25", (Throwable)e);
        }
        return rspPageBO;
    }

    public QueryExpressTraceRspBO queryExpressTrace(QueryExpressTraceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u7269\u6d41\u4fe1\u606f\u670d\u52a1 \u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5-\u4e13\u4e1a\u516c\u53f8[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getLogisticsCenterId() == null) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5-\u7269\u6d41\u4e2d\u5fc3id[LogisticsCenterId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        QueryExpressTraceRspBO rspBO = new QueryExpressTraceRspBO();
        return rspBO;
    }

    static String getDetailAddress(InvoiceForMailVO invoiceForMailVO) {
        String detailAddress = "";
        if (null != invoiceForMailVO) {
            if (StringUtils.hasText((String)invoiceForMailVO.getAddress())) {
                detailAddress = invoiceForMailVO.getAddress();
            } else {
                String province = FscStringUtils.valueOf(invoiceForMailVO.getProvince());
                String city = FscStringUtils.valueOf(invoiceForMailVO.getCity());
                String county = FscStringUtils.valueOf(invoiceForMailVO.getCounty());
                String town = FscStringUtils.valueOf(invoiceForMailVO.getTown());
                String addrDesc = FscStringUtils.valueOf(invoiceForMailVO.getAddrDesc());
                detailAddress = FscStringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
            }
        }
        return detailAddress;
    }
}

