/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfscext.api.deal.CreatePayOrderInfoForMonthService;
import com.tydic.pfscext.api.deal.bo.CreatePayOrderInfoForMonthReqBO;
import com.tydic.pfscext.api.deal.bo.CreatePayOrderInfoForMonthRspBO;
import com.tydic.pfscext.dao.BusiErrorLogMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BusiErrorLog;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.PayOrderInfoType;
import com.tydic.pfscext.enums.PayOrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.DatesUtils;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=CreatePayOrderInfoForMonthService.class)
public class CreatePayOrderInfoForMonthServiceImpl
implements CreatePayOrderInfoForMonthService {
    private static final Logger logger = LoggerFactory.getLogger(CreatePayOrderInfoForMonthServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Resource(name="dealServiceFeeSeq")
    private OrderSequence dealServiceFeeSeqService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private BusiErrorLogMapper busiErrorLogMapper;
    @Autowired
    DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    TransactionDefinition transactionDefinition;

    public CreatePayOrderInfoForMonthRspBO add(CreatePayOrderInfoForMonthReqBO reqBO) {
        logger.debug("\u65b0\u589e\u6708\u5ea6\u6210\u4ea4\u670d\u52a1\u8d39\u7684\u7f34\u8d39\u5355\u670d\u52a1\u5165\u53c2CreatePayOrderInfoForMonthReqBO\uff1a" + reqBO.toString());
        CreatePayOrderInfoForMonthRspBO rspBO = new CreatePayOrderInfoForMonthRspBO();
        try {
            logger.debug("\u67e5\u8be2\u672a\u5904\u7406\u7684\u8ba2\u5355\u4fe1\u606f\u5f00\u59cb ");
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setOrderDateEnd(DatesUtils.getFirstDayOfMonth());
            saleOrderInfoVO.setIsPayFlag("0");
            List<SaleOrderInfo> list = this.saleOrderInfoMapper.getOrderInfoForPay(saleOrderInfoVO);
            logger.debug("\u8ba2\u5355\u67e5\u8be2\u7ed3\u679c:" + list.toString());
            HashMap map = new HashMap();
            HashMap<Long, BigDecimal> mapOrderServiceFee = new HashMap<Long, BigDecimal>();
            if (!list.isEmpty()) {
                for (SaleOrderInfo saleOrderInfo : list) {
                    if (map.containsKey(saleOrderInfo.getSupplierNo())) {
                        ((List)map.get(saleOrderInfo.getSupplierNo())).add(saleOrderInfo);
                    } else {
                        ArrayList<SaleOrderInfo> listFormap = new ArrayList<SaleOrderInfo>();
                        listFormap.add(saleOrderInfo);
                        map.put(saleOrderInfo.getSupplierNo(), listFormap);
                    }
                    if (!mapOrderServiceFee.containsKey(saleOrderInfo.getSupplierNo())) {
                        mapOrderServiceFee.put(saleOrderInfo.getSupplierNo(), saleOrderInfo.getOrderDealServiceFee());
                        continue;
                    }
                    BigDecimal bigDecimal = (BigDecimal)mapOrderServiceFee.get(saleOrderInfo.getSupplierNo());
                    bigDecimal = bigDecimal.add(saleOrderInfo.getOrderDealServiceFee());
                    mapOrderServiceFee.put(saleOrderInfo.getSupplierNo(), bigDecimal);
                }
            }
            if (!map.isEmpty()) {
                SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
                SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
                for (Long supplierNo : map.keySet()) {
                    String supCode;
                    StringBuffer payOrderCode;
                    Long payOrderId;
                    PayOrderInfoPO payOrderInfoPO;
                    List listSaleOrder;
                    block12: {
                        listSaleOrder = (List)map.get(supplierNo);
                        payOrderInfoPO = new PayOrderInfoPO();
                        payOrderId = this.dealServiceFeeSeqService.nextId();
                        payOrderInfoPO.setPayOrderId(payOrderId);
                        payOrderCode = new StringBuffer("pesappYDCJFWF-");
                        supCode = "";
                        try {
                            UmcQrySupplierInfoDetailAbilityReqBO supInfo = new UmcQrySupplierInfoDetailAbilityReqBO();
                            supInfo.setSupplierId(supplierNo);
                            supInfo.setQryType(Integer.valueOf(1));
                            UmcQrySupplierInfoDetailAbilityRspBO rspInfoBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(supInfo);
                            if (!"0000".equals(rspInfoBO.getRespCode())) break block12;
                            supCode = rspInfoBO.getSupplierCode();
                        }
                        catch (Exception e) {
                            logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u7f16\u53f7\u5931\u8d25:" + e.toString());
                            BusiErrorLog busiErrorLog = new BusiErrorLog();
                            busiErrorLog.setBusiName("\u65b0\u589e\u6708\u5e95\u6210\u4ea4\u670d\u52a1\u8d39\u67e5\u8be2\u4f9b\u5e94\u5546\u7f16\u7801");
                            busiErrorLog.setBusiDataName("supplierCode");
                            busiErrorLog.setBusiDataId(String.valueOf(supplierNo));
                            busiErrorLog.setRemark(e.toString().substring(0, 200));
                            this.addBusiErrorLog(busiErrorLog);
                            continue;
                        }
                    }
                    if (null == supCode || "".equals(supCode)) {
                        logger.error("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a:" + ((SaleOrderInfo)listSaleOrder.get(0)).getSupplierNo());
                        BusiErrorLog busiErrorLog = new BusiErrorLog();
                        busiErrorLog.setBusiName("\u65b0\u589e\u6708\u5e95\u6210\u4ea4\u670d\u52a1\u8d39\u67e5\u8be2\u4f9b\u5e94\u5546\u7f16\u7801");
                        busiErrorLog.setBusiDataName("supplierCode");
                        busiErrorLog.setBusiDataId(String.valueOf(supplierNo));
                        busiErrorLog.setRemark("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
                        this.addBusiErrorLog(busiErrorLog);
                        continue;
                    }
                    payOrderCode.append(supCode).append(yearFormat.format(((SaleOrderInfo)listSaleOrder.get(0)).getOrderDate())).append(monthFormat.format(((SaleOrderInfo)listSaleOrder.get(0)).getOrderDate()));
                    payOrderInfoPO.setPayOrderCode(payOrderCode.toString());
                    payOrderInfoPO.setPayOrderType(PayOrderInfoType.MONTH_SERVICE_FEE.getCode());
                    payOrderInfoPO.setCreateTime(new Date());
                    payOrderInfoPO.setOrderCount(Long.valueOf(listSaleOrder.size()));
                    payOrderInfoPO.setDocumentAmount((BigDecimal)mapOrderServiceFee.get(supplierNo));
                    payOrderInfoPO.setActualAmount((BigDecimal)mapOrderServiceFee.get(supplierNo));
                    payOrderInfoPO.setDeductionAmount(BigDecimal.ZERO);
                    payOrderInfoPO.setSupplierId(supplierNo);
                    payOrderInfoPO.setSupplierName(((SaleOrderInfo)listSaleOrder.get(0)).getSupplierName());
                    payOrderInfoPO.setPayOrderStatus(PayOrderStatus.PROCESSING.getCode());
                    payOrderInfoPO.setPayOrderYear(yearFormat.format(((SaleOrderInfo)listSaleOrder.get(0)).getOrderDate()));
                    payOrderInfoPO.setPayOrderMonth(monthFormat.format(((SaleOrderInfo)listSaleOrder.get(0)).getOrderDate()));
                    this.payOrderInfoMapper.insert(payOrderInfoPO);
                    this.updateOrderInfoTOPay(listSaleOrder, payOrderId, payOrderCode.toString());
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6210\u4ea4\u670d\u52a1\u8d39\u7f34\u8d39\u5355\u5931\u8d25:" + e.toString());
            BusiErrorLog busiErrorLog = new BusiErrorLog();
            busiErrorLog.setBusiName("\u65b0\u589e\u6708\u5ea6\u6210\u4ea4\u670d\u52a1\u8d39\u5931\u8d25");
            busiErrorLog.setRemark(e.toString().substring(0, 200));
            this.addBusiErrorLog(busiErrorLog);
        }
        return rspBO;
    }

    private void updateOrderInfoTOPay(List<SaleOrderInfo> list, Long payOrderId, String payOrderCode) {
        if (!list.isEmpty()) {
            try {
                this.saleOrderInfoMapper.updatePayOrderInfo(list, payOrderId, payOrderCode, "1", null);
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u8ba2\u5355\u6570\u636e\u5931\u8d25");
            }
        }
    }

    private void addBusiErrorLog(BusiErrorLog busiErrorLog) {
        TransactionStatus transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
        try {
            logger.error("\u6dfb\u52a0\u4e1a\u52a1\u5931\u8d25\u8bb0\u5f55\u5f00\u59cb");
            this.busiErrorLogMapper.insert(busiErrorLog);
            this.dataSourceTransactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u4e1a\u52a1\u5931\u8d25\u8bb0\u5f55\u5931\u8d25:" + e.toString());
            this.dataSourceTransactionManager.rollback(transactionStatus);
        }
    }
}

