/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.pfscext.api.pay.PayReturnInfoService;
import com.tydic.pfscext.api.pay.bo.PayReturnInfoReqBO;
import com.tydic.pfscext.api.pay.bo.PayReturnInfoRspBO;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.PayOrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Date;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=PayReturnInfoService.class)
public class PayReturnInfoServiceImpl
implements PayReturnInfoService {
    private static final Logger logger = LoggerFactory.getLogger(PayReturnInfoServiceImpl.class);
    private String publicKey;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;

    public PayReturnInfoRspBO payReturnInfo(PayReturnInfoReqBO reqBO) {
        PayReturnInfoRspBO rspBO = new PayReturnInfoRspBO();
        if (null == reqBO.getBusiCode()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u7cfb\u7edf\u7f16\u7801[busiCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContent()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u52a0\u5bc6\u5185\u5bb9[content]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String content = reqBO.getContent();
            String retStr = PayCenterUtils.deCode((String)content, (String)this.publicKey);
            this.savelog("PayReturnInfoService", reqBO.toString(), retStr);
            JSONObject jsonObject = JSONObject.fromObject((Object)retStr);
            if (null != jsonObject) {
                String outOrderId = jsonObject.getString("outOrderId");
                String resultCode = jsonObject.getString("resultCode");
                String resultMsg = jsonObject.getString("resultMsg");
                String payMethod = jsonObject.getString("payMethod");
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                paymentFlowInfo.setOutOrderId(outOrderId);
                paymentFlowInfo.setPaymentStatus(resultCode);
                paymentFlowInfo.setOrderRemark(resultMsg);
                paymentFlowInfo.setResultJson(retStr);
                this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
                if ("SUCCESS".equals(resultCode)) {
                    if (outOrderId.startsWith("SERVICE")) {
                        PayOrderInfoPO po = new PayOrderInfoPO();
                        BeanUtils.copyProperties((Object)reqBO, (Object)po);
                        po.setPayOrderId(Long.valueOf(outOrderId.substring(12)));
                        po.setPayOrderStatus(PayOrderStatus.PAY_TO_CONFIRM.getCode());
                        logger.error("PayOrderInfoServiceImpl\u5165\u53c2\uff1a" + po.toString());
                        this.payOrderInfoMapper.updateByPrimaryKeySelective(po);
                    }
                    if (outOrderId.startsWith("PAYMENT")) {
                        String payno = outOrderId.substring(8);
                        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
                        applyPayInfoPO.setPayno(payno);
                        applyPayInfoPO.setPayStatus(ApplyPayStatus.SUCCESS_PIDNG.getCode());
                        applyPayInfoPO.setPayMathod(payMethod);
                        this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                    }
                }
            }
            rspBO.setResultCode("SUCCESS");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25,\uff1a" + e);
            this.savelog("PayReturnInfoService", reqBO.toString(), reqBO.getContent());
            throw new PfscExtBusinessException("18000", "\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25:" + e);
        }
        return rspBO;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

