/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.impl.OrderSequenceImpl;
import com.tydic.pfscext.config.FscProperties;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class FscSequenceConfig {
    private FscProperties fscProperties;
    private ApplicationContext context;
    private DruidDataSource dataSource;

    public FscSequenceConfig(FscProperties fscProperties, ApplicationContext context) {
        this.fscProperties = fscProperties;
        this.context = context;
        this.dataSource = (DruidDataSource)context.getBean(DataSource.class);
    }

    @Bean
    public OrderSequence generalSequence() {
        return new OrderSequenceImpl(this.fscProperties.getGeneralSequenceName(), this.dataSource);
    }

    @Bean(value={"biTxnSeq"})
    public OrderSequence biTxnSeq() {
        return new OrderSequenceImpl("BI_TXN", this.dataSource);
    }

    @Bean(value={"acctTransInfoSeq"})
    public OrderSequence acctTransInfoSeq() {
        return new OrderSequenceImpl("ACCT", this.dataSource);
    }

    @Bean(value={"pinganReq"})
    public OrderSequence pinganReq() {
        return new OrderSequenceImpl("PINGAN_REQ", this.dataSource);
    }

    @Bean(value={"recAmtConfirmReq"})
    public OrderSequence recAmtConfirmReq() {
        return new OrderSequenceImpl("D_REC_AMT_CONFIRM_DOCNUM", this.dataSource);
    }

    @Bean(value={"advanceReveiveReq"})
    public OrderSequence advanceReveiveReq() {
        return new OrderSequenceImpl("D_ADVANCE_RECEIVE_SEQ", this.dataSource);
    }

    @Bean(value={"invoiceApplication"})
    public OrderSequence invoiceApplicationReq() {
        return new OrderSequenceImpl("INVOICE_APPLICATION", this.dataSource);
    }

    @Bean(value={"payApplicationSeq"})
    public OrderSequence payApplicationSeq() {
        return new OrderSequenceImpl("FKSQ", this.dataSource);
    }

    @Bean(value={"materialSeq"})
    public OrderSequence materialSeq() {
        return new OrderSequenceImpl("MATERIAL_COLLECT", this.dataSource);
    }

    @Bean(value={"invoiceNotificationSeq"})
    public OrderSequence invoiceNotificationSeq() {
        return new OrderSequenceImpl("INVOICE_NOTIFICATION_SEQ", this.dataSource);
    }

    @Bean(value={"payableSeq"})
    public OrderSequence payableSeq() {
        return new OrderSequenceImpl("PAYABLE", this.dataSource);
    }

    @Bean(value={"recvableSeq"})
    public OrderSequence recvableSeq() {
        return new OrderSequenceImpl("RECVABLE", this.dataSource);
    }

    @Bean(value={"purchaseStorageSeq"})
    public OrderSequence purchaseStorageSeq() {
        return new OrderSequenceImpl("PURCHASE_STORAGE", this.dataSource);
    }

    @Bean(value={"stockOutSeq"})
    public OrderSequence stockOutSeq() {
        return new OrderSequenceImpl("STOCK_OUT", this.dataSource);
    }

    @Bean(value={"orderIdSeq"})
    public OrderSequence orderIdSeq() {
        return new OrderSequenceImpl("ORDER_ID", this.dataSource);
    }

    @Bean(value={"publicSeqNoService"})
    public OrderSequence publicSeqNoService() {
        return new OrderSequenceImpl("PUBLIC", this.dataSource);
    }

    @Bean(value={"publicSeqNoService2"})
    public OrderSequence publicSeqNoService2() {
        return new OrderSequenceImpl("PUBLIC2", this.dataSource);
    }

    @Bean(value={"billNotificationBatchNoSeq"})
    public OrderSequence billNotificationBatchNoSeq() {
        return new OrderSequenceImpl("BILL_NOTIFICATION_BATCHNO_SEQ", this.dataSource);
    }

    @Bean(value={"advanceReceiveSeq"})
    public OrderSequence advanceReceiveSeq() {
        return new OrderSequenceImpl("ADVANCE_RECEIVE_SEQ", this.dataSource);
    }

    @Bean(value={"returnRegisterSeq"})
    public OrderSequence returnRegisterSeq() {
        return new OrderSequenceImpl("RETURN_SEQ", this.dataSource);
    }

    @Bean(value={"dealServiceFeeSeq"})
    public OrderSequence dealServiceFeeSeq() {
        return new OrderSequenceImpl("DEAL_SERVICE_FEE", this.dataSource);
    }

    @Bean(value={"frameOrderIdSeq"})
    public OrderSequence frameOrderIdSeq() {
        return new OrderSequenceImpl("FRAME_ORDER_ID", this.dataSource);
    }

    @Bean(value={"logisticsCenterIdSeq"})
    public OrderSequence logisticsCenterIdSeq() {
        return new OrderSequenceImpl("LOGISTICS_CENTER_ID", this.dataSource);
    }

    @Bean(value={"versionSeq"})
    public OrderSequence versionSeq() {
        return new OrderSequenceImpl("RECONCILIATION_VERSION", this.dataSource);
    }

    @Bean(value={"payOrderSeq"})
    public OrderSequence payOrderSeq() {
        return new OrderSequenceImpl("PAY_ORDER_SEQ", this.dataSource);
    }
}

