/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.BusiCancelExpressService;
import com.tydic.pfscext.api.busi.bo.BusiCancelExpressReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCancelExpressRspBO;
import com.tydic.pfscext.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfscext.dao.po.SaleInvoiceMailInfo;
import com.tydic.pfscext.enums.InvoiceMailSentStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiCancelExpressService.class)
public class BusiCancelExpressServiceImpl
implements BusiCancelExpressService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelExpressServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;

    public BusiCancelExpressRspBO cancelExpress(BusiCancelExpressReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u90ae\u5bc4\u53d1\u7968\u670d\u52a1(\u4e13\u4e1a\u516c\u53f8) \u5165\u53c2\uff1a" + reqBO);
        }
        BusiCancelExpressRspBO rspBO = new BusiCancelExpressRspBO();
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getExpressNo() == null) {
            throw new PfscExtBusinessException("0001", "\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String eachExpressNo : reqBO.getExpressNo()) {
            List<SaleInvoiceMailInfo> expressInfos = this.saleInvoiceMailInfoMapper.selectByExpressNo(eachExpressNo);
            if (expressInfos.isEmpty()) {
                throw new PfscExtBusinessException("18001", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u5f55\u5165\u4e0d\u6b63\u786e");
            }
            SaleInvoiceMailInfo firstExpressInfo = expressInfos.get(0);
            if (!InvoiceMailSentStatus.NOT_SENT.getCode().equals(firstExpressInfo.getMailStatus())) {
                throw new PfscExtBusinessException("18000", "\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u72b6\u6001\u4e3a" + InvoiceMailSentStatus.getInstance(firstExpressInfo.getMailStatus().toString()).getDescr() + "\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            rspBO = this.processCancelExpress(eachExpressNo, firstExpressInfo, rspBO);
        }
        rspBO.setEffectRecord(Integer.valueOf(reqBO.getExpressNo().size()));
        return rspBO;
    }

    private BusiCancelExpressRspBO processCancelExpress(String eachExpressNo, SaleInvoiceMailInfo firstExpressInfo, BusiCancelExpressRspBO rspBO) {
        logger.debug("\u53d6\u6d88\u90ae\u5bc4-\u5feb\u9012\u5355\u53f7:" + eachExpressNo + "\u6b63\u5728\u53d6\u6d88");
        return rspBO;
    }
}

