/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQuerySaleOrderInfoByItemsService;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoByItemsReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoByItemsRspBO;
import com.tydic.pfscext.api.busi.vo.SaleItemInfoExt;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=BusiQuerySaleOrderInfoByItemsService.class)
public class BusiQuerySaleOrderInfoByItemsServiceImpl
implements BusiQuerySaleOrderInfoByItemsService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQuerySaleOrderInfoByItemsServiceImpl.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public BusiQuerySaleOrderInfoByItemsRspBO querySaleOrderInfoByItemsList(BusiQuerySaleOrderInfoByItemsReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u7533\u8bf7\u5f00\u7968\u62c6\u5206\u5546\u54c1\u660e\u7ec6\u5165\u53c2reqBO:" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List inspectionIds = reqBO.getInspectionIds();
        if (CollectionUtils.isEmpty((Collection)inspectionIds)) {
            throw new PfscExtBusinessException("18000", "\u8bf7\u9009\u62e9\u9a8c\u6536\u5355\u4e0d\u4e3a\u7a7a\u7684\u8ba2\u5355\u6570\u636e");
        }
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setSkuName(reqBO.getSkuName());
        saleItemInfoVO.setTaxRate(reqBO.getTaxRate());
        saleItemInfoVO.setSaleOrderCode(reqBO.getSaleOrderCode());
        saleItemInfoVO.setApplyAmountMin(reqBO.getApplyAmountMin());
        saleItemInfoVO.setApplyAmountMax(reqBO.getApplyAmountMax());
        saleItemInfoVO.setOrderDateBegin(reqBO.getOrderDateBegin());
        saleItemInfoVO.setOrderDateEnd(reqBO.getOrderDateEnd());
        saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        saleItemInfoVO.setInspectionIdList(inspectionIds);
        saleItemInfoVO.setOrderAmtMin(reqBO.getOrderAmtMin());
        saleItemInfoVO.setOrderAmtMax(reqBO.getOrderAmtMax());
        saleItemInfoVO.setOrderBy(" o.ORDER_ID, o.INSPECTION_ID DESC");
        ArrayList<SaleItemInfoExt> rows = new ArrayList<SaleItemInfoExt>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleItemInfoVO> dataList = this.saleItemInfoMapper.querySaleJoinOrderItemsPage(saleItemInfoVO, (Page<Map<String, Object>>)page);
        for (SaleItemInfoVO saleVO : dataList) {
            SaleItemInfoExt saleExtBO = new SaleItemInfoExt();
            BeanUtils.copyProperties((Object)saleVO, (Object)saleExtBO);
            saleExtBO.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleVO.getItemStatus())));
            rows.add(saleExtBO);
        }
        BusiQuerySaleOrderInfoByItemsRspBO rspPageBO = new BusiQuerySaleOrderInfoByItemsRspBO();
        rspPageBO.setRespCode("0000");
        rspPageBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspPageBO.setRows(rows);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

