/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscCancelPayApplyOrderService;
import com.tydic.pfscext.api.busi.bo.FscCancelPayApplyOrderReqBO;
import com.tydic.pfscext.api.busi.bo.FscCancelPayApplyOrderRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscCancelPayApplyOrderService.class)
public class FscCancelPayApplyOrderServiceImpl
implements FscCancelPayApplyOrderService {
    private static final Logger logger = LoggerFactory.getLogger(FscCancelPayApplyOrderServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;

    public FscCancelPayApplyOrderRspBO cancelPayOrder(FscCancelPayApplyOrderReqBO reqBO) {
        FscCancelPayApplyOrderRspBO rspBO = new FscCancelPayApplyOrderRspBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u4ed8\u6b3e\u7533\u8bf7\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List payNos = reqBO.getPayNos();
        if (payNos == null || payNos.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4ed8\u6b3e\u7533\u8bf7\u5355\u3010PayNos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> payAbleNos = new ArrayList<String>();
        PayableDetailVO payableDetailVO = new PayableDetailVO();
        Iterator iterator = payNos.iterator();
        while (iterator.hasNext()) {
            String payNo;
            String applyNo = payNo = (String)iterator.next();
            List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(applyNo);
            for (ApplyDetail applyDetail : applyDetails) {
                String payableNo = applyDetail.getPayableNo();
                payAbleNos.add(payableNo);
            }
            payableDetailVO.setPayableNos(payAbleNos);
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectList(payableDetailVO);
            for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                if (payableDetailPO.getPayableStatus().equals(PayableStatus.PAYING.getCode())) {
                    PayableDetailPO payableDetailPO1 = new PayableDetailPO();
                    payableDetailPO1.setApplyNo(payableDetailPO.getPayableNo());
                    payableDetailPO1.setPayableStatus(PayableStatus.PENDING.getCode());
                    this.payableDetailMapper.updateById(payableDetailPO1);
                    ApplyDetail applyDetail = new ApplyDetail();
                    applyDetail.setApplyNo(payNo);
                    applyDetail.setStatus(ApplyPayStatus.CANCEL_ORDER_STATUS.getCode());
                    this.applyDetailMapper.updateByApplyNo(applyDetail);
                    ApplyPayInfoPO applyPayInfoPo = new ApplyPayInfoPO();
                    applyPayInfoPo.setPayno(payNo);
                    applyPayInfoPo.setPayStatus(ApplyPayStatus.CANCEL_ORDER_STATUS.getCode());
                    this.applyPayInfoMapper.updateStatus(applyPayInfoPo);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    continue;
                }
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u72b6\u6001\u5fc5\u987b\u4e3a\u4ed8\u6b3e\u4e2d");
            }
        }
        return rspBO;
    }
}

