/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.pfscext.api.busi.FscPayApplyOrderMakeInvoiceConfirmService;
import com.tydic.pfscext.api.busi.bo.FscPayApplyOrderMakeInvoiceConfirmReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayApplyOrderMakeInvoiceConfirmRspBO;
import com.tydic.pfscext.api.deal.bo.SaleInvoiceInfoBO;
import com.tydic.pfscext.api.deal.bo.SaleInvoiceMailInfoBO;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayApplyOrderMakeInvoiceConfirmService.class)
public class FscPayApplyOrderMakeInvoiceConfirmServiceImpl
implements FscPayApplyOrderMakeInvoiceConfirmService {
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    private static final String OPER_TYPE_CONFIRM = "confirm";
    private static final String OPER_TYPE_CANCEL = "cancel";

    public FscPayApplyOrderMakeInvoiceConfirmRspBO makeInvoceConfirm(FscPayApplyOrderMakeInvoiceConfirmReqBO reqBO) {
        this.initParam(reqBO);
        if (OPER_TYPE_CONFIRM.equals(reqBO.getOperType())) {
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setApplyNo(reqBO.getApplyNo());
            billApplyInfo.setBillStatus(BillStatus.SENDING_BILL.getCode());
            SaleInvoiceInfoBO invoiceInfo = reqBO.getInvoiceInfo();
            billApplyInfo.setInvoiceType(reqBO.getInvoiceType().toString());
            billApplyInfo.setInvoceName(invoiceInfo.getInvoceName());
            billApplyInfo.setTaxNo(invoiceInfo.getTaxNo());
            billApplyInfo.setAddr(invoiceInfo.getAddress());
            billApplyInfo.setPhone(invoiceInfo.getPhone());
            billApplyInfo.setBankName(invoiceInfo.getBankName());
            billApplyInfo.setBankAcctNo(invoiceInfo.getBankAcctNo());
            SaleInvoiceMailInfoBO mailAddrInfo = reqBO.getMailAddrInfo();
            if (InvoiceClasses.PAPER_INVOICE.getCode().equals(reqBO.getInvoiceClasses())) {
                billApplyInfo.setName(mailAddrInfo.getReceiver());
                billApplyInfo.setProvince(mailAddrInfo.getProvince());
                billApplyInfo.setCity(mailAddrInfo.getCity());
                billApplyInfo.setCounty(mailAddrInfo.getCounty());
                billApplyInfo.setTown(mailAddrInfo.getTown());
                billApplyInfo.setProvId(mailAddrInfo.getProvId());
                billApplyInfo.setCityId(mailAddrInfo.getCityId());
                billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
                billApplyInfo.setTownId(mailAddrInfo.getTownId());
                billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
                billApplyInfo.setMobile(mailAddrInfo.getTel());
                billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
                billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
                billApplyInfo.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
            } else {
                billApplyInfo.setReceiveInvoicePhone(reqBO.getReceiveInvoicePhone());
                billApplyInfo.setReceiveInvoiceEmail(reqBO.getReceiveInvoiceEmail());
                billApplyInfo.setInvoiceClasses(InvoiceClasses.ELECTRONIC_INVOICE.getCode());
            }
            this.billApplyInfoMapper.updateByPrimaryKey(billApplyInfo);
        }
        if (OPER_TYPE_CANCEL.equals(reqBO.getOperType())) {
            int i = this.applyPayInfoMapper.updateByBillApplyNo(reqBO.getApplyNo());
            if (i < 0) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u4ed8\u6b3e\u5355\u72b6\u6001\u5931\u8d25");
            }
            this.billApplyInfoMapper.deleteByPrimaryKey(reqBO.getApplyNo());
        }
        FscPayApplyOrderMakeInvoiceConfirmRspBO fscPayApplyOrderMakeInvoiceConfirmRspBO = new FscPayApplyOrderMakeInvoiceConfirmRspBO();
        return fscPayApplyOrderMakeInvoiceConfirmRspBO;
    }

    private void initParam(FscPayApplyOrderMakeInvoiceConfirmReqBO reqBO) {
        if (!OPER_TYPE_CANCEL.equals(reqBO.getOperType()) && !OPER_TYPE_CONFIRM.equals(reqBO.getOperType())) {
            throw new PfscExtBusinessException("18000", "\u975e\u6cd5\u64cd\u4f5c");
        }
        if (null == reqBO) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperType())) {
            throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceInfo() || null == reqBO.getInvoiceInfo().getInvoceName()) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == reqBO.getMailAddrInfo() || null == reqBO.getMailAddrInfo().getCompany()) {
            throw new PfscExtBusinessException("18000", "\u516c\u53f8\u540d\u79f0\u672a\u7a7a");
        }
        if (null == reqBO.getMailAddrInfo() || null == reqBO.getMailAddrInfo().getName()) {
            throw new PfscExtBusinessException("18000", "\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        }
    }
}

